/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogEventsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetLogEventsResponse.Builder, GetLogEventsResponse> {
    private static final SdkField<List<OutputLogEvent>> EVENTS_FIELD = SdkField
            .<List<OutputLogEvent>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(GetLogEventsResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputLogEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputLogEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_FORWARD_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextForwardToken").getter(getter(GetLogEventsResponse::nextForwardToken))
            .setter(setter(Builder::nextForwardToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextForwardToken").build()).build();

    private static final SdkField<String> NEXT_BACKWARD_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextBackwardToken").getter(getter(GetLogEventsResponse::nextBackwardToken))
            .setter(setter(Builder::nextBackwardToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextBackwardToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            NEXT_FORWARD_TOKEN_FIELD, NEXT_BACKWARD_TOKEN_FIELD));

    private final List<OutputLogEvent> events;

    private final String nextForwardToken;

    private final String nextBackwardToken;

    private GetLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextForwardToken = builder.nextForwardToken;
        this.nextBackwardToken = builder.nextBackwardToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The events.
     */
    public final List<OutputLogEvent> events() {
        return events;
    }

    /**
     * <p>
     * The token for the next set of items in the forward direction. The token expires after 24 hours. If you have
     * reached the end of the stream, it returns the same token you passed in.
     * </p>
     * 
     * @return The token for the next set of items in the forward direction. The token expires after 24 hours. If you
     *         have reached the end of the stream, it returns the same token you passed in.
     */
    public final String nextForwardToken() {
        return nextForwardToken;
    }

    /**
     * <p>
     * The token for the next set of items in the backward direction. The token expires after 24 hours. This token is
     * not null. If you have reached the end of the stream, it returns the same token you passed in.
     * </p>
     * 
     * @return The token for the next set of items in the backward direction. The token expires after 24 hours. This
     *         token is not null. If you have reached the end of the stream, it returns the same token you passed in.
     */
    public final String nextBackwardToken() {
        return nextBackwardToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextForwardToken());
        hashCode = 31 * hashCode + Objects.hashCode(nextBackwardToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResponse)) {
            return false;
        }
        GetLogEventsResponse other = (GetLogEventsResponse) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(nextForwardToken(), other.nextForwardToken())
                && Objects.equals(nextBackwardToken(), other.nextBackwardToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogEventsResponse").add("Events", hasEvents() ? events() : null)
                .add("NextForwardToken", nextForwardToken()).add("NextBackwardToken", nextBackwardToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "nextForwardToken":
            return Optional.ofNullable(clazz.cast(nextForwardToken()));
        case "nextBackwardToken":
            return Optional.ofNullable(clazz.cast(nextBackwardToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogEventsResponse, T> g) {
        return obj -> g.apply((GetLogEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLogEventsResponse> {
        /**
         * <p>
         * The events.
         * </p>
         * 
         * @param events
         *        The events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<OutputLogEvent> events);

        /**
         * <p>
         * The events.
         * </p>
         * 
         * @param events
         *        The events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(OutputLogEvent... events);

        /**
         * <p>
         * The events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #events(List<OutputLogEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<OutputLogEvent>)
         */
        Builder events(Consumer<OutputLogEvent.Builder>... events);

        /**
         * <p>
         * The token for the next set of items in the forward direction. The token expires after 24 hours. If you have
         * reached the end of the stream, it returns the same token you passed in.
         * </p>
         * 
         * @param nextForwardToken
         *        The token for the next set of items in the forward direction. The token expires after 24 hours. If you
         *        have reached the end of the stream, it returns the same token you passed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextForwardToken(String nextForwardToken);

        /**
         * <p>
         * The token for the next set of items in the backward direction. The token expires after 24 hours. This token
         * is not null. If you have reached the end of the stream, it returns the same token you passed in.
         * </p>
         * 
         * @param nextBackwardToken
         *        The token for the next set of items in the backward direction. The token expires after 24 hours. This
         *        token is not null. If you have reached the end of the stream, it returns the same token you passed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextBackwardToken(String nextBackwardToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<OutputLogEvent> events = DefaultSdkAutoConstructList.getInstance();

        private String nextForwardToken;

        private String nextBackwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsResponse model) {
            super(model);
            events(model.events);
            nextForwardToken(model.nextForwardToken);
            nextBackwardToken(model.nextBackwardToken);
        }

        public final List<OutputLogEvent.Builder> getEvents() {
            List<OutputLogEvent.Builder> result = OutputLogEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<OutputLogEvent.BuilderImpl> events) {
            this.events = OutputLogEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(OutputLogEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<OutputLogEvent.Builder>... events) {
            events(Stream.of(events).map(c -> OutputLogEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextForwardToken() {
            return nextForwardToken;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        public final String getNextBackwardToken() {
            return nextBackwardToken;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        @Override
        public GetLogEventsResponse build() {
            return new GetLogEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
