/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogGroupFieldsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<GetLogGroupFieldsRequest.Builder, GetLogGroupFieldsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(GetLogGroupFieldsRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Long> TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("time")
            .getter(getter(GetLogGroupFieldsRequest::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()).build();

    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(GetLogGroupFieldsRequest::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            TIME_FIELD, LOG_GROUP_IDENTIFIER_FIELD));

    private final String logGroupName;

    private final Long time;

    private final String logGroupIdentifier;

    private GetLogGroupFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.time = builder.time;
        this.logGroupIdentifier = builder.logGroupIdentifier;
    }

    /**
     * <p>
     * The name of the log group to search.
     * </p>
     * <note>
     * <p>
     * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     * </p>
     * </note>
     * 
     * @return The name of the log group to search.</p> <note>
     *         <p>
     *         You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     *         </p>
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The time to set as the center of the query. If you specify <code>time</code>, the 8 minutes before and 8 minutes
     * after this time are searched. If you omit <code>time</code>, the most recent 15 minutes up to the current time
     * are searched.
     * </p>
     * <p>
     * The <code>time</code> value is specified as epoch time, which is the number of seconds since
     * <code>January 1, 1970, 00:00:00 UTC</code>.
     * </p>
     * 
     * @return The time to set as the center of the query. If you specify <code>time</code>, the 8 minutes before and 8
     *         minutes after this time are searched. If you omit <code>time</code>, the most recent 15 minutes up to the
     *         current time are searched.</p>
     *         <p>
     *         The <code>time</code> value is specified as epoch time, which is the number of seconds since
     *         <code>January 1, 1970, 00:00:00 UTC</code>.
     */
    public final Long time() {
        return time;
    }

    /**
     * <p>
     * Specify either the name or ARN of the log group to view. If the log group is in a source account and you are
     * using a monitoring account, you must specify the ARN.
     * </p>
     * <note>
     * <p>
     * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     * </p>
     * </note>
     * 
     * @return Specify either the name or ARN of the log group to view. If the log group is in a source account and you
     *         are using a monitoring account, you must specify the ARN.</p> <note>
     *         <p>
     *         You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     *         </p>
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogGroupFieldsRequest)) {
            return false;
        }
        GetLogGroupFieldsRequest other = (GetLogGroupFieldsRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(time(), other.time())
                && Objects.equals(logGroupIdentifier(), other.logGroupIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogGroupFieldsRequest").add("LogGroupName", logGroupName()).add("Time", time())
                .add("LogGroupIdentifier", logGroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "time":
            return Optional.ofNullable(clazz.cast(time()));
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogGroupFieldsRequest, T> g) {
        return obj -> g.apply((GetLogGroupFieldsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLogGroupFieldsRequest> {
        /**
         * <p>
         * The name of the log group to search.
         * </p>
         * <note>
         * <p>
         * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         * </p>
         * </note>
         * 
         * @param logGroupName
         *        The name of the log group to search.</p> <note>
         *        <p>
         *        You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The time to set as the center of the query. If you specify <code>time</code>, the 8 minutes before and 8
         * minutes after this time are searched. If you omit <code>time</code>, the most recent 15 minutes up to the
         * current time are searched.
         * </p>
         * <p>
         * The <code>time</code> value is specified as epoch time, which is the number of seconds since
         * <code>January 1, 1970, 00:00:00 UTC</code>.
         * </p>
         * 
         * @param time
         *        The time to set as the center of the query. If you specify <code>time</code>, the 8 minutes before and
         *        8 minutes after this time are searched. If you omit <code>time</code>, the most recent 15 minutes up
         *        to the current time are searched.</p>
         *        <p>
         *        The <code>time</code> value is specified as epoch time, which is the number of seconds since
         *        <code>January 1, 1970, 00:00:00 UTC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Long time);

        /**
         * <p>
         * Specify either the name or ARN of the log group to view. If the log group is in a source account and you are
         * using a monitoring account, you must specify the ARN.
         * </p>
         * <note>
         * <p>
         * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         * </p>
         * </note>
         * 
         * @param logGroupIdentifier
         *        Specify either the name or ARN of the log group to view. If the log group is in a source account and
         *        you are using a monitoring account, you must specify the ARN.</p> <note>
         *        <p>
         *        You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private Long time;

        private String logGroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogGroupFieldsRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            time(model.time);
            logGroupIdentifier(model.logGroupIdentifier);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Long getTime() {
            return time;
        }

        public final void setTime(Long time) {
            this.time = time;
        }

        @Override
        public final Builder time(Long time) {
            this.time = time;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogGroupFieldsRequest build() {
            return new GetLogGroupFieldsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
