/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnomalyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<UpdateAnomalyRequest.Builder, UpdateAnomalyRequest> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyId").getter(getter(UpdateAnomalyRequest::anomalyId)).setter(setter(Builder::anomalyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyId").build()).build();

    private static final SdkField<String> PATTERN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patternId").getter(getter(UpdateAnomalyRequest::patternId)).setter(setter(Builder::patternId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternId").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyDetectorArn").getter(getter(UpdateAnomalyRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build())
            .build();

    private static final SdkField<String> SUPPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suppressionType").getter(getter(UpdateAnomalyRequest::suppressionTypeAsString))
            .setter(setter(Builder::suppressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionType").build()).build();

    private static final SdkField<SuppressionPeriod> SUPPRESSION_PERIOD_FIELD = SdkField
            .<SuppressionPeriod> builder(MarshallingType.SDK_POJO).memberName("suppressionPeriod")
            .getter(getter(UpdateAnomalyRequest::suppressionPeriod)).setter(setter(Builder::suppressionPeriod))
            .constructor(SuppressionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD,
            PATTERN_ID_FIELD, ANOMALY_DETECTOR_ARN_FIELD, SUPPRESSION_TYPE_FIELD, SUPPRESSION_PERIOD_FIELD));

    private final String anomalyId;

    private final String patternId;

    private final String anomalyDetectorArn;

    private final String suppressionType;

    private final SuppressionPeriod suppressionPeriod;

    private UpdateAnomalyRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyId = builder.anomalyId;
        this.patternId = builder.patternId;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.suppressionType = builder.suppressionType;
        this.suppressionPeriod = builder.suppressionPeriod;
    }

    /**
     * <p>
     * If you are suppressing or unsuppressing an anomaly, specify its unique ID here. You can find anomaly IDs by using
     * the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html">
     * ListAnomalies</a> operation.
     * </p>
     * 
     * @return If you are suppressing or unsuppressing an anomaly, specify its unique ID here. You can find anomaly IDs
     *         by using the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html"
     *         >ListAnomalies</a> operation.
     */
    public final String anomalyId() {
        return anomalyId;
    }

    /**
     * <p>
     * If you are suppressing or unsuppressing an pattern, specify its unique ID here. You can find pattern IDs by using
     * the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html">
     * ListAnomalies</a> operation.
     * </p>
     * 
     * @return If you are suppressing or unsuppressing an pattern, specify its unique ID here. You can find pattern IDs
     *         by using the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html"
     *         >ListAnomalies</a> operation.
     */
    public final String patternId() {
        return patternId;
    }

    /**
     * <p>
     * The ARN of the anomaly detector that this operation is to act on.
     * </p>
     * 
     * @return The ARN of the anomaly detector that this operation is to act on.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * Use this to specify whether the suppression to be temporary or infinite. If you specify <code>LIMITED</code>, you
     * must also specify a <code>suppressionPeriod</code>. If you specify <code>INFINITE</code>, any value for
     * <code>suppressionPeriod</code> is ignored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #suppressionType}
     * will return {@link SuppressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #suppressionTypeAsString}.
     * </p>
     * 
     * @return Use this to specify whether the suppression to be temporary or infinite. If you specify
     *         <code>LIMITED</code>, you must also specify a <code>suppressionPeriod</code>. If you specify
     *         <code>INFINITE</code>, any value for <code>suppressionPeriod</code> is ignored.
     * @see SuppressionType
     */
    public final SuppressionType suppressionType() {
        return SuppressionType.fromValue(suppressionType);
    }

    /**
     * <p>
     * Use this to specify whether the suppression to be temporary or infinite. If you specify <code>LIMITED</code>, you
     * must also specify a <code>suppressionPeriod</code>. If you specify <code>INFINITE</code>, any value for
     * <code>suppressionPeriod</code> is ignored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #suppressionType}
     * will return {@link SuppressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #suppressionTypeAsString}.
     * </p>
     * 
     * @return Use this to specify whether the suppression to be temporary or infinite. If you specify
     *         <code>LIMITED</code>, you must also specify a <code>suppressionPeriod</code>. If you specify
     *         <code>INFINITE</code>, any value for <code>suppressionPeriod</code> is ignored.
     * @see SuppressionType
     */
    public final String suppressionTypeAsString() {
        return suppressionType;
    }

    /**
     * <p>
     * If you are temporarily suppressing an anomaly or pattern, use this structure to specify how long the suppression
     * is to last.
     * </p>
     * 
     * @return If you are temporarily suppressing an anomaly or pattern, use this structure to specify how long the
     *         suppression is to last.
     */
    public final SuppressionPeriod suppressionPeriod() {
        return suppressionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(patternId());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(suppressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(suppressionPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalyRequest)) {
            return false;
        }
        UpdateAnomalyRequest other = (UpdateAnomalyRequest) obj;
        return Objects.equals(anomalyId(), other.anomalyId()) && Objects.equals(patternId(), other.patternId())
                && Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(suppressionTypeAsString(), other.suppressionTypeAsString())
                && Objects.equals(suppressionPeriod(), other.suppressionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnomalyRequest").add("AnomalyId", anomalyId()).add("PatternId", patternId())
                .add("AnomalyDetectorArn", anomalyDetectorArn()).add("SuppressionType", suppressionTypeAsString())
                .add("SuppressionPeriod", suppressionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyId":
            return Optional.ofNullable(clazz.cast(anomalyId()));
        case "patternId":
            return Optional.ofNullable(clazz.cast(patternId()));
        case "anomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "suppressionType":
            return Optional.ofNullable(clazz.cast(suppressionTypeAsString()));
        case "suppressionPeriod":
            return Optional.ofNullable(clazz.cast(suppressionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalyRequest, T> g) {
        return obj -> g.apply((UpdateAnomalyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAnomalyRequest> {
        /**
         * <p>
         * If you are suppressing or unsuppressing an anomaly, specify its unique ID here. You can find anomaly IDs by
         * using the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html"
         * >ListAnomalies</a> operation.
         * </p>
         * 
         * @param anomalyId
         *        If you are suppressing or unsuppressing an anomaly, specify its unique ID here. You can find anomaly
         *        IDs by using the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html"
         *        >ListAnomalies</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyId(String anomalyId);

        /**
         * <p>
         * If you are suppressing or unsuppressing an pattern, specify its unique ID here. You can find pattern IDs by
         * using the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html"
         * >ListAnomalies</a> operation.
         * </p>
         * 
         * @param patternId
         *        If you are suppressing or unsuppressing an pattern, specify its unique ID here. You can find pattern
         *        IDs by using the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListAnomalies.html"
         *        >ListAnomalies</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternId(String patternId);

        /**
         * <p>
         * The ARN of the anomaly detector that this operation is to act on.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the anomaly detector that this operation is to act on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * Use this to specify whether the suppression to be temporary or infinite. If you specify <code>LIMITED</code>,
         * you must also specify a <code>suppressionPeriod</code>. If you specify <code>INFINITE</code>, any value for
         * <code>suppressionPeriod</code> is ignored.
         * </p>
         * 
         * @param suppressionType
         *        Use this to specify whether the suppression to be temporary or infinite. If you specify
         *        <code>LIMITED</code>, you must also specify a <code>suppressionPeriod</code>. If you specify
         *        <code>INFINITE</code>, any value for <code>suppressionPeriod</code> is ignored.
         * @see SuppressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionType
         */
        Builder suppressionType(String suppressionType);

        /**
         * <p>
         * Use this to specify whether the suppression to be temporary or infinite. If you specify <code>LIMITED</code>,
         * you must also specify a <code>suppressionPeriod</code>. If you specify <code>INFINITE</code>, any value for
         * <code>suppressionPeriod</code> is ignored.
         * </p>
         * 
         * @param suppressionType
         *        Use this to specify whether the suppression to be temporary or infinite. If you specify
         *        <code>LIMITED</code>, you must also specify a <code>suppressionPeriod</code>. If you specify
         *        <code>INFINITE</code>, any value for <code>suppressionPeriod</code> is ignored.
         * @see SuppressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionType
         */
        Builder suppressionType(SuppressionType suppressionType);

        /**
         * <p>
         * If you are temporarily suppressing an anomaly or pattern, use this structure to specify how long the
         * suppression is to last.
         * </p>
         * 
         * @param suppressionPeriod
         *        If you are temporarily suppressing an anomaly or pattern, use this structure to specify how long the
         *        suppression is to last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressionPeriod(SuppressionPeriod suppressionPeriod);

        /**
         * <p>
         * If you are temporarily suppressing an anomaly or pattern, use this structure to specify how long the
         * suppression is to last.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuppressionPeriod.Builder} avoiding the
         * need to create one manually via {@link SuppressionPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuppressionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #suppressionPeriod(SuppressionPeriod)}.
         * 
         * @param suppressionPeriod
         *        a consumer that will call methods on {@link SuppressionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressionPeriod(SuppressionPeriod)
         */
        default Builder suppressionPeriod(Consumer<SuppressionPeriod.Builder> suppressionPeriod) {
            return suppressionPeriod(SuppressionPeriod.builder().applyMutation(suppressionPeriod).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String anomalyId;

        private String patternId;

        private String anomalyDetectorArn;

        private String suppressionType;

        private SuppressionPeriod suppressionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalyRequest model) {
            super(model);
            anomalyId(model.anomalyId);
            patternId(model.patternId);
            anomalyDetectorArn(model.anomalyDetectorArn);
            suppressionType(model.suppressionType);
            suppressionPeriod(model.suppressionPeriod);
        }

        public final String getAnomalyId() {
            return anomalyId;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        @Override
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final String getPatternId() {
            return patternId;
        }

        public final void setPatternId(String patternId) {
            this.patternId = patternId;
        }

        @Override
        public final Builder patternId(String patternId) {
            this.patternId = patternId;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getSuppressionType() {
            return suppressionType;
        }

        public final void setSuppressionType(String suppressionType) {
            this.suppressionType = suppressionType;
        }

        @Override
        public final Builder suppressionType(String suppressionType) {
            this.suppressionType = suppressionType;
            return this;
        }

        @Override
        public final Builder suppressionType(SuppressionType suppressionType) {
            this.suppressionType(suppressionType == null ? null : suppressionType.toString());
            return this;
        }

        public final SuppressionPeriod.Builder getSuppressionPeriod() {
            return suppressionPeriod != null ? suppressionPeriod.toBuilder() : null;
        }

        public final void setSuppressionPeriod(SuppressionPeriod.BuilderImpl suppressionPeriod) {
            this.suppressionPeriod = suppressionPeriod != null ? suppressionPeriod.build() : null;
        }

        @Override
        public final Builder suppressionPeriod(SuppressionPeriod suppressionPeriod) {
            this.suppressionPeriod = suppressionPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalyRequest build() {
            return new UpdateAnomalyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
