/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.Anomaly;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse;

public class ListAnomaliesIterable
implements SdkIterable<ListAnomaliesResponse> {
    private final CloudWatchLogsClient client;
    private final ListAnomaliesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomaliesIterable(CloudWatchLogsClient client, ListAnomaliesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnomaliesResponseFetcher();
    }

    public Iterator<ListAnomaliesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Anomaly> anomalies() {
        Function<ListAnomaliesResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalies() != null) {
                return response.anomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnomaliesResponseFetcher
    implements SyncPageFetcher<ListAnomaliesResponse> {
        private ListAnomaliesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomaliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomaliesResponse nextPage(ListAnomaliesResponse previousPage) {
            if (previousPage == null) {
                return ListAnomaliesIterable.this.client.listAnomalies(ListAnomaliesIterable.this.firstRequest);
            }
            return ListAnomaliesIterable.this.client.listAnomalies((ListAnomaliesRequest)((Object)ListAnomaliesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

