/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricFilterRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutMetricFilterRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(PutMetricFilterRequest.getter(PutMetricFilterRequest::logGroupName)).setter(PutMetricFilterRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterName").getter(PutMetricFilterRequest.getter(PutMetricFilterRequest::filterName)).setter(PutMetricFilterRequest.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(PutMetricFilterRequest.getter(PutMetricFilterRequest::filterPattern)).setter(PutMetricFilterRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<List<MetricTransformation>> METRIC_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricTransformations").getter(PutMetricFilterRequest.getter(PutMetricFilterRequest::metricTransformations)).setter(PutMetricFilterRequest.setter(Builder::metricTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, METRIC_TRANSFORMATIONS_FIELD));
    private final String logGroupName;
    private final String filterName;
    private final String filterPattern;
    private final List<MetricTransformation> metricTransformations;

    private PutMetricFilterRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String filterName() {
        return this.filterName;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final boolean hasMetricTransformations() {
        return this.metricTransformations != null && !(this.metricTransformations instanceof SdkAutoConstructList);
    }

    public final List<MetricTransformation> metricTransformations() {
        return this.metricTransformations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricTransformations() ? this.metricTransformations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricFilterRequest)) {
            return false;
        }
        PutMetricFilterRequest other = (PutMetricFilterRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && this.hasMetricTransformations() == other.hasMetricTransformations() && Objects.equals(this.metricTransformations(), other.metricTransformations());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetricFilterRequest").add("LogGroupName", (Object)this.logGroupName()).add("FilterName", (Object)this.filterName()).add("FilterPattern", (Object)this.filterPattern()).add("MetricTransformations", this.hasMetricTransformations() ? this.metricTransformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "metricTransformations": {
                return Optional.ofNullable(clazz.cast(this.metricTransformations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricFilterRequest, T> g) {
        return obj -> g.apply((PutMetricFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String filterName;
        private String filterPattern;
        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricFilterRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.filterName(model.filterName);
            this.filterPattern(model.filterPattern);
            this.metricTransformations(model.metricTransformations);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final List<MetricTransformation.Builder> getMetricTransformations() {
            List<MetricTransformation.Builder> result = MetricTransformationsCopier.copyToBuilder(this.metricTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation ... metricTransformations) {
            this.metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder> ... metricTransformations) {
            this.metricTransformations(Stream.of(metricTransformations).map(c -> (MetricTransformation)((MetricTransformation.Builder)MetricTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricFilterRequest build() {
            return new PutMetricFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetricFilterRequest> {
        public Builder logGroupName(String var1);

        public Builder filterName(String var1);

        public Builder filterPattern(String var1);

        public Builder metricTransformations(Collection<MetricTransformation> var1);

        public Builder metricTransformations(MetricTransformation ... var1);

        public Builder metricTransformations(Consumer<MetricTransformation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

