/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutLogEventsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutLogEventsResponse.Builder, PutLogEventsResponse> {
    private static final SdkField<String> NEXT_SEQUENCE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextSequenceToken").getter(getter(PutLogEventsResponse::nextSequenceToken))
            .setter(setter(Builder::nextSequenceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSequenceToken").build()).build();

    private static final SdkField<RejectedLogEventsInfo> REJECTED_LOG_EVENTS_INFO_FIELD = SdkField
            .<RejectedLogEventsInfo> builder(MarshallingType.SDK_POJO).memberName("rejectedLogEventsInfo")
            .getter(getter(PutLogEventsResponse::rejectedLogEventsInfo)).setter(setter(Builder::rejectedLogEventsInfo))
            .constructor(RejectedLogEventsInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectedLogEventsInfo").build())
            .build();

    private static final SdkField<RejectedEntityInfo> REJECTED_ENTITY_INFO_FIELD = SdkField
            .<RejectedEntityInfo> builder(MarshallingType.SDK_POJO).memberName("rejectedEntityInfo")
            .getter(getter(PutLogEventsResponse::rejectedEntityInfo)).setter(setter(Builder::rejectedEntityInfo))
            .constructor(RejectedEntityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectedEntityInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_SEQUENCE_TOKEN_FIELD,
            REJECTED_LOG_EVENTS_INFO_FIELD, REJECTED_ENTITY_INFO_FIELD));

    private final String nextSequenceToken;

    private final RejectedLogEventsInfo rejectedLogEventsInfo;

    private final RejectedEntityInfo rejectedEntityInfo;

    private PutLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextSequenceToken = builder.nextSequenceToken;
        this.rejectedLogEventsInfo = builder.rejectedLogEventsInfo;
        this.rejectedEntityInfo = builder.rejectedEntityInfo;
    }

    /**
     * <p>
     * The next sequence token.
     * </p>
     * <important>
     * <p>
     * This field has been deprecated.
     * </p>
     * <p>
     * The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code> actions are
     * always accepted even if the sequence token is not valid. You can use parallel <code>PutLogEvents</code> actions
     * on the same log stream and you do not need to wait for the response of a previous <code>PutLogEvents</code>
     * action to obtain the <code>nextSequenceToken</code> value.
     * </p>
     * </important>
     * 
     * @return The next sequence token.</p> <important>
     *         <p>
     *         This field has been deprecated.
     *         </p>
     *         <p>
     *         The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code> actions
     *         are always accepted even if the sequence token is not valid. You can use parallel
     *         <code>PutLogEvents</code> actions on the same log stream and you do not need to wait for the response of
     *         a previous <code>PutLogEvents</code> action to obtain the <code>nextSequenceToken</code> value.
     *         </p>
     */
    public final String nextSequenceToken() {
        return nextSequenceToken;
    }

    /**
     * <p>
     * The rejected events.
     * </p>
     * 
     * @return The rejected events.
     */
    public final RejectedLogEventsInfo rejectedLogEventsInfo() {
        return rejectedLogEventsInfo;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final RejectedEntityInfo rejectedEntityInfo() {
        return rejectedEntityInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextSequenceToken());
        hashCode = 31 * hashCode + Objects.hashCode(rejectedLogEventsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(rejectedEntityInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsResponse)) {
            return false;
        }
        PutLogEventsResponse other = (PutLogEventsResponse) obj;
        return Objects.equals(nextSequenceToken(), other.nextSequenceToken())
                && Objects.equals(rejectedLogEventsInfo(), other.rejectedLogEventsInfo())
                && Objects.equals(rejectedEntityInfo(), other.rejectedEntityInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutLogEventsResponse").add("NextSequenceToken", nextSequenceToken())
                .add("RejectedLogEventsInfo", rejectedLogEventsInfo()).add("RejectedEntityInfo", rejectedEntityInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextSequenceToken":
            return Optional.ofNullable(clazz.cast(nextSequenceToken()));
        case "rejectedLogEventsInfo":
            return Optional.ofNullable(clazz.cast(rejectedLogEventsInfo()));
        case "rejectedEntityInfo":
            return Optional.ofNullable(clazz.cast(rejectedEntityInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLogEventsResponse, T> g) {
        return obj -> g.apply((PutLogEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutLogEventsResponse> {
        /**
         * <p>
         * The next sequence token.
         * </p>
         * <important>
         * <p>
         * This field has been deprecated.
         * </p>
         * <p>
         * The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code> actions are
         * always accepted even if the sequence token is not valid. You can use parallel <code>PutLogEvents</code>
         * actions on the same log stream and you do not need to wait for the response of a previous
         * <code>PutLogEvents</code> action to obtain the <code>nextSequenceToken</code> value.
         * </p>
         * </important>
         * 
         * @param nextSequenceToken
         *        The next sequence token.</p> <important>
         *        <p>
         *        This field has been deprecated.
         *        </p>
         *        <p>
         *        The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code>
         *        actions are always accepted even if the sequence token is not valid. You can use parallel
         *        <code>PutLogEvents</code> actions on the same log stream and you do not need to wait for the response
         *        of a previous <code>PutLogEvents</code> action to obtain the <code>nextSequenceToken</code> value.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSequenceToken(String nextSequenceToken);

        /**
         * <p>
         * The rejected events.
         * </p>
         * 
         * @param rejectedLogEventsInfo
         *        The rejected events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo);

        /**
         * <p>
         * The rejected events.
         * </p>
         * This is a convenience method that creates an instance of the {@link RejectedLogEventsInfo.Builder} avoiding
         * the need to create one manually via {@link RejectedLogEventsInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RejectedLogEventsInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #rejectedLogEventsInfo(RejectedLogEventsInfo)}.
         * 
         * @param rejectedLogEventsInfo
         *        a consumer that will call methods on {@link RejectedLogEventsInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectedLogEventsInfo(RejectedLogEventsInfo)
         */
        default Builder rejectedLogEventsInfo(Consumer<RejectedLogEventsInfo.Builder> rejectedLogEventsInfo) {
            return rejectedLogEventsInfo(RejectedLogEventsInfo.builder().applyMutation(rejectedLogEventsInfo).build());
        }

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param rejectedEntityInfo
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedEntityInfo(RejectedEntityInfo rejectedEntityInfo);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience method that creates an instance of the {@link RejectedEntityInfo.Builder} avoiding the
         * need to create one manually via {@link RejectedEntityInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RejectedEntityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #rejectedEntityInfo(RejectedEntityInfo)}.
         * 
         * @param rejectedEntityInfo
         *        a consumer that will call methods on {@link RejectedEntityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectedEntityInfo(RejectedEntityInfo)
         */
        default Builder rejectedEntityInfo(Consumer<RejectedEntityInfo.Builder> rejectedEntityInfo) {
            return rejectedEntityInfo(RejectedEntityInfo.builder().applyMutation(rejectedEntityInfo).build());
        }
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String nextSequenceToken;

        private RejectedLogEventsInfo rejectedLogEventsInfo;

        private RejectedEntityInfo rejectedEntityInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsResponse model) {
            super(model);
            nextSequenceToken(model.nextSequenceToken);
            rejectedLogEventsInfo(model.rejectedLogEventsInfo);
            rejectedEntityInfo(model.rejectedEntityInfo);
        }

        public final String getNextSequenceToken() {
            return nextSequenceToken;
        }

        public final void setNextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
        }

        @Override
        public final Builder nextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
            return this;
        }

        public final RejectedLogEventsInfo.Builder getRejectedLogEventsInfo() {
            return rejectedLogEventsInfo != null ? rejectedLogEventsInfo.toBuilder() : null;
        }

        public final void setRejectedLogEventsInfo(RejectedLogEventsInfo.BuilderImpl rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo != null ? rejectedLogEventsInfo.build() : null;
        }

        @Override
        public final Builder rejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo;
            return this;
        }

        public final RejectedEntityInfo.Builder getRejectedEntityInfo() {
            return rejectedEntityInfo != null ? rejectedEntityInfo.toBuilder() : null;
        }

        public final void setRejectedEntityInfo(RejectedEntityInfo.BuilderImpl rejectedEntityInfo) {
            this.rejectedEntityInfo = rejectedEntityInfo != null ? rejectedEntityInfo.build() : null;
        }

        @Override
        public final Builder rejectedEntityInfo(RejectedEntityInfo rejectedEntityInfo) {
            this.rejectedEntityInfo = rejectedEntityInfo;
            return this;
        }

        @Override
        public PutLogEventsResponse build() {
            return new PutLogEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
