/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.AllowedFieldDelimitersCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.AllowedFieldsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplateDeliveryConfigValues;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationType;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputFormat;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputFormatsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.RecordField;
import software.amazon.awssdk.services.cloudwatchlogs.model.RecordFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationTemplate> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(ConfigurationTemplate.getter(ConfigurationTemplate::service)).setter(ConfigurationTemplate.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logType").getter(ConfigurationTemplate.getter(ConfigurationTemplate::logType)).setter(ConfigurationTemplate.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ConfigurationTemplate.getter(ConfigurationTemplate::resourceType)).setter(ConfigurationTemplate.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationType").getter(ConfigurationTemplate.getter(ConfigurationTemplate::deliveryDestinationTypeAsString)).setter(ConfigurationTemplate.setter(Builder::deliveryDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationType").build()}).build();
    private static final SdkField<ConfigurationTemplateDeliveryConfigValues> DEFAULT_DELIVERY_CONFIG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultDeliveryConfigValues").getter(ConfigurationTemplate.getter(ConfigurationTemplate::defaultDeliveryConfigValues)).setter(ConfigurationTemplate.setter(Builder::defaultDeliveryConfigValues)).constructor(ConfigurationTemplateDeliveryConfigValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDeliveryConfigValues").build()}).build();
    private static final SdkField<List<RecordField>> ALLOWED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedFields").getter(ConfigurationTemplate.getter(ConfigurationTemplate::allowedFields)).setter(ConfigurationTemplate.setter(Builder::allowedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_OUTPUT_FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedOutputFormats").getter(ConfigurationTemplate.getter(ConfigurationTemplate::allowedOutputFormatsAsStrings)).setter(ConfigurationTemplate.setter(Builder::allowedOutputFormatsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedOutputFormats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALLOWED_ACTION_FOR_ALLOW_VENDED_LOGS_DELIVERY_FOR_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allowedActionForAllowVendedLogsDeliveryForResource").getter(ConfigurationTemplate.getter(ConfigurationTemplate::allowedActionForAllowVendedLogsDeliveryForResource)).setter(ConfigurationTemplate.setter(Builder::allowedActionForAllowVendedLogsDeliveryForResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedActionForAllowVendedLogsDeliveryForResource").build()}).build();
    private static final SdkField<List<String>> ALLOWED_FIELD_DELIMITERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedFieldDelimiters").getter(ConfigurationTemplate.getter(ConfigurationTemplate::allowedFieldDelimiters)).setter(ConfigurationTemplate.setter(Builder::allowedFieldDelimiters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedFieldDelimiters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_SUFFIX_PATH_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedSuffixPathFields").getter(ConfigurationTemplate.getter(ConfigurationTemplate::allowedSuffixPathFields)).setter(ConfigurationTemplate.setter(Builder::allowedSuffixPathFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedSuffixPathFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, LOG_TYPE_FIELD, RESOURCE_TYPE_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, DEFAULT_DELIVERY_CONFIG_VALUES_FIELD, ALLOWED_FIELDS_FIELD, ALLOWED_OUTPUT_FORMATS_FIELD, ALLOWED_ACTION_FOR_ALLOW_VENDED_LOGS_DELIVERY_FOR_RESOURCE_FIELD, ALLOWED_FIELD_DELIMITERS_FIELD, ALLOWED_SUFFIX_PATH_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String service;
    private final String logType;
    private final String resourceType;
    private final String deliveryDestinationType;
    private final ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues;
    private final List<RecordField> allowedFields;
    private final List<String> allowedOutputFormats;
    private final String allowedActionForAllowVendedLogsDeliveryForResource;
    private final List<String> allowedFieldDelimiters;
    private final List<String> allowedSuffixPathFields;

    private ConfigurationTemplate(BuilderImpl builder) {
        this.service = builder.service;
        this.logType = builder.logType;
        this.resourceType = builder.resourceType;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.defaultDeliveryConfigValues = builder.defaultDeliveryConfigValues;
        this.allowedFields = builder.allowedFields;
        this.allowedOutputFormats = builder.allowedOutputFormats;
        this.allowedActionForAllowVendedLogsDeliveryForResource = builder.allowedActionForAllowVendedLogsDeliveryForResource;
        this.allowedFieldDelimiters = builder.allowedFieldDelimiters;
        this.allowedSuffixPathFields = builder.allowedSuffixPathFields;
    }

    public final String service() {
        return this.service;
    }

    public final String logType() {
        return this.logType;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(this.deliveryDestinationType);
    }

    public final String deliveryDestinationTypeAsString() {
        return this.deliveryDestinationType;
    }

    public final ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues() {
        return this.defaultDeliveryConfigValues;
    }

    public final boolean hasAllowedFields() {
        return this.allowedFields != null && !(this.allowedFields instanceof SdkAutoConstructList);
    }

    public final List<RecordField> allowedFields() {
        return this.allowedFields;
    }

    public final List<OutputFormat> allowedOutputFormats() {
        return OutputFormatsCopier.copyStringToEnum(this.allowedOutputFormats);
    }

    public final boolean hasAllowedOutputFormats() {
        return this.allowedOutputFormats != null && !(this.allowedOutputFormats instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOutputFormatsAsStrings() {
        return this.allowedOutputFormats;
    }

    public final String allowedActionForAllowVendedLogsDeliveryForResource() {
        return this.allowedActionForAllowVendedLogsDeliveryForResource;
    }

    public final boolean hasAllowedFieldDelimiters() {
        return this.allowedFieldDelimiters != null && !(this.allowedFieldDelimiters instanceof SdkAutoConstructList);
    }

    public final List<String> allowedFieldDelimiters() {
        return this.allowedFieldDelimiters;
    }

    public final boolean hasAllowedSuffixPathFields() {
        return this.allowedSuffixPathFields != null && !(this.allowedSuffixPathFields instanceof SdkAutoConstructList);
    }

    public final List<String> allowedSuffixPathFields() {
        return this.allowedSuffixPathFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.logType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDeliveryConfigValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedFields() ? this.allowedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOutputFormats() ? this.allowedOutputFormatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedActionForAllowVendedLogsDeliveryForResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedFieldDelimiters() ? this.allowedFieldDelimiters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedSuffixPathFields() ? this.allowedSuffixPathFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationTemplate)) {
            return false;
        }
        ConfigurationTemplate other = (ConfigurationTemplate)obj;
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.logType(), other.logType()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString()) && Objects.equals(this.defaultDeliveryConfigValues(), other.defaultDeliveryConfigValues()) && this.hasAllowedFields() == other.hasAllowedFields() && Objects.equals(this.allowedFields(), other.allowedFields()) && this.hasAllowedOutputFormats() == other.hasAllowedOutputFormats() && Objects.equals(this.allowedOutputFormatsAsStrings(), other.allowedOutputFormatsAsStrings()) && Objects.equals(this.allowedActionForAllowVendedLogsDeliveryForResource(), other.allowedActionForAllowVendedLogsDeliveryForResource()) && this.hasAllowedFieldDelimiters() == other.hasAllowedFieldDelimiters() && Objects.equals(this.allowedFieldDelimiters(), other.allowedFieldDelimiters()) && this.hasAllowedSuffixPathFields() == other.hasAllowedSuffixPathFields() && Objects.equals(this.allowedSuffixPathFields(), other.allowedSuffixPathFields());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationTemplate").add("Service", (Object)this.service()).add("LogType", (Object)this.logType()).add("ResourceType", (Object)this.resourceType()).add("DeliveryDestinationType", (Object)this.deliveryDestinationTypeAsString()).add("DefaultDeliveryConfigValues", (Object)this.defaultDeliveryConfigValues()).add("AllowedFields", this.hasAllowedFields() ? this.allowedFields() : null).add("AllowedOutputFormats", this.hasAllowedOutputFormats() ? this.allowedOutputFormatsAsStrings() : null).add("AllowedActionForAllowVendedLogsDeliveryForResource", (Object)this.allowedActionForAllowVendedLogsDeliveryForResource()).add("AllowedFieldDelimiters", this.hasAllowedFieldDelimiters() ? this.allowedFieldDelimiters() : null).add("AllowedSuffixPathFields", this.hasAllowedSuffixPathFields() ? this.allowedSuffixPathFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "logType": {
                return Optional.ofNullable(clazz.cast(this.logType()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "deliveryDestinationType": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationTypeAsString()));
            }
            case "defaultDeliveryConfigValues": {
                return Optional.ofNullable(clazz.cast(this.defaultDeliveryConfigValues()));
            }
            case "allowedFields": {
                return Optional.ofNullable(clazz.cast(this.allowedFields()));
            }
            case "allowedOutputFormats": {
                return Optional.ofNullable(clazz.cast(this.allowedOutputFormatsAsStrings()));
            }
            case "allowedActionForAllowVendedLogsDeliveryForResource": {
                return Optional.ofNullable(clazz.cast(this.allowedActionForAllowVendedLogsDeliveryForResource()));
            }
            case "allowedFieldDelimiters": {
                return Optional.ofNullable(clazz.cast(this.allowedFieldDelimiters()));
            }
            case "allowedSuffixPathFields": {
                return Optional.ofNullable(clazz.cast(this.allowedSuffixPathFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationTemplate, T> g) {
        return obj -> g.apply((ConfigurationTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String service;
        private String logType;
        private String resourceType;
        private String deliveryDestinationType;
        private ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues;
        private List<RecordField> allowedFields = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedOutputFormats = DefaultSdkAutoConstructList.getInstance();
        private String allowedActionForAllowVendedLogsDeliveryForResource;
        private List<String> allowedFieldDelimiters = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedSuffixPathFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationTemplate model) {
            this.service(model.service);
            this.logType(model.logType);
            this.resourceType(model.resourceType);
            this.deliveryDestinationType(model.deliveryDestinationType);
            this.defaultDeliveryConfigValues(model.defaultDeliveryConfigValues);
            this.allowedFields(model.allowedFields);
            this.allowedOutputFormatsWithStrings(model.allowedOutputFormats);
            this.allowedActionForAllowVendedLogsDeliveryForResource(model.allowedActionForAllowVendedLogsDeliveryForResource);
            this.allowedFieldDelimiters(model.allowedFieldDelimiters);
            this.allowedSuffixPathFields(model.allowedSuffixPathFields);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getLogType() {
            return this.logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return this.deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final ConfigurationTemplateDeliveryConfigValues.Builder getDefaultDeliveryConfigValues() {
            return this.defaultDeliveryConfigValues != null ? this.defaultDeliveryConfigValues.toBuilder() : null;
        }

        public final void setDefaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues.BuilderImpl defaultDeliveryConfigValues) {
            this.defaultDeliveryConfigValues = defaultDeliveryConfigValues != null ? defaultDeliveryConfigValues.build() : null;
        }

        @Override
        public final Builder defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues) {
            this.defaultDeliveryConfigValues = defaultDeliveryConfigValues;
            return this;
        }

        public final List<RecordField.Builder> getAllowedFields() {
            List<RecordField.Builder> result = AllowedFieldsCopier.copyToBuilder(this.allowedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedFields(Collection<RecordField.BuilderImpl> allowedFields) {
            this.allowedFields = AllowedFieldsCopier.copyFromBuilder(allowedFields);
        }

        @Override
        public final Builder allowedFields(Collection<RecordField> allowedFields) {
            this.allowedFields = AllowedFieldsCopier.copy(allowedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFields(RecordField ... allowedFields) {
            this.allowedFields(Arrays.asList(allowedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFields(Consumer<RecordField.Builder> ... allowedFields) {
            this.allowedFields(Stream.of(allowedFields).map(c -> (RecordField)((RecordField.Builder)RecordField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAllowedOutputFormats() {
            if (this.allowedOutputFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOutputFormats;
        }

        public final void setAllowedOutputFormats(Collection<String> allowedOutputFormats) {
            this.allowedOutputFormats = OutputFormatsCopier.copy(allowedOutputFormats);
        }

        @Override
        public final Builder allowedOutputFormatsWithStrings(Collection<String> allowedOutputFormats) {
            this.allowedOutputFormats = OutputFormatsCopier.copy(allowedOutputFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOutputFormatsWithStrings(String ... allowedOutputFormats) {
            this.allowedOutputFormatsWithStrings(Arrays.asList(allowedOutputFormats));
            return this;
        }

        @Override
        public final Builder allowedOutputFormats(Collection<OutputFormat> allowedOutputFormats) {
            this.allowedOutputFormats = OutputFormatsCopier.copyEnumToString(allowedOutputFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOutputFormats(OutputFormat ... allowedOutputFormats) {
            this.allowedOutputFormats(Arrays.asList(allowedOutputFormats));
            return this;
        }

        public final String getAllowedActionForAllowVendedLogsDeliveryForResource() {
            return this.allowedActionForAllowVendedLogsDeliveryForResource;
        }

        public final void setAllowedActionForAllowVendedLogsDeliveryForResource(String allowedActionForAllowVendedLogsDeliveryForResource) {
            this.allowedActionForAllowVendedLogsDeliveryForResource = allowedActionForAllowVendedLogsDeliveryForResource;
        }

        @Override
        public final Builder allowedActionForAllowVendedLogsDeliveryForResource(String allowedActionForAllowVendedLogsDeliveryForResource) {
            this.allowedActionForAllowVendedLogsDeliveryForResource = allowedActionForAllowVendedLogsDeliveryForResource;
            return this;
        }

        public final Collection<String> getAllowedFieldDelimiters() {
            if (this.allowedFieldDelimiters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedFieldDelimiters;
        }

        public final void setAllowedFieldDelimiters(Collection<String> allowedFieldDelimiters) {
            this.allowedFieldDelimiters = AllowedFieldDelimitersCopier.copy(allowedFieldDelimiters);
        }

        @Override
        public final Builder allowedFieldDelimiters(Collection<String> allowedFieldDelimiters) {
            this.allowedFieldDelimiters = AllowedFieldDelimitersCopier.copy(allowedFieldDelimiters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFieldDelimiters(String ... allowedFieldDelimiters) {
            this.allowedFieldDelimiters(Arrays.asList(allowedFieldDelimiters));
            return this;
        }

        public final Collection<String> getAllowedSuffixPathFields() {
            if (this.allowedSuffixPathFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedSuffixPathFields;
        }

        public final void setAllowedSuffixPathFields(Collection<String> allowedSuffixPathFields) {
            this.allowedSuffixPathFields = RecordFieldsCopier.copy(allowedSuffixPathFields);
        }

        @Override
        public final Builder allowedSuffixPathFields(Collection<String> allowedSuffixPathFields) {
            this.allowedSuffixPathFields = RecordFieldsCopier.copy(allowedSuffixPathFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedSuffixPathFields(String ... allowedSuffixPathFields) {
            this.allowedSuffixPathFields(Arrays.asList(allowedSuffixPathFields));
            return this;
        }

        public ConfigurationTemplate build() {
            return new ConfigurationTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationTemplate> {
        public Builder service(String var1);

        public Builder logType(String var1);

        public Builder resourceType(String var1);

        public Builder deliveryDestinationType(String var1);

        public Builder deliveryDestinationType(DeliveryDestinationType var1);

        public Builder defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues var1);

        default public Builder defaultDeliveryConfigValues(Consumer<ConfigurationTemplateDeliveryConfigValues.Builder> defaultDeliveryConfigValues) {
            return this.defaultDeliveryConfigValues((ConfigurationTemplateDeliveryConfigValues)((ConfigurationTemplateDeliveryConfigValues.Builder)ConfigurationTemplateDeliveryConfigValues.builder().applyMutation(defaultDeliveryConfigValues)).build());
        }

        public Builder allowedFields(Collection<RecordField> var1);

        public Builder allowedFields(RecordField ... var1);

        public Builder allowedFields(Consumer<RecordField.Builder> ... var1);

        public Builder allowedOutputFormatsWithStrings(Collection<String> var1);

        public Builder allowedOutputFormatsWithStrings(String ... var1);

        public Builder allowedOutputFormats(Collection<OutputFormat> var1);

        public Builder allowedOutputFormats(OutputFormat ... var1);

        public Builder allowedActionForAllowVendedLogsDeliveryForResource(String var1);

        public Builder allowedFieldDelimiters(Collection<String> var1);

        public Builder allowedFieldDelimiters(String ... var1);

        public Builder allowedSuffixPathFields(Collection<String> var1);

        public Builder allowedSuffixPathFields(String ... var1);
    }
}

