/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLogGroupsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeLogGroupsRequest.Builder, DescribeLogGroupsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIdentifiers")
            .getter(getter(DescribeLogGroupsRequest::accountIdentifiers))
            .setter(setter(Builder::accountIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupNamePrefix").getter(getter(DescribeLogGroupsRequest::logGroupNamePrefix))
            .setter(setter(Builder::logGroupNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNamePrefix").build())
            .build();

    private static final SdkField<String> LOG_GROUP_NAME_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupNamePattern").getter(getter(DescribeLogGroupsRequest::logGroupNamePattern))
            .setter(setter(Builder::logGroupNamePattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNamePattern").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeLogGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(DescribeLogGroupsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeLinkedAccounts").getter(getter(DescribeLogGroupsRequest::includeLinkedAccounts))
            .setter(setter(Builder::includeLinkedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeLinkedAccounts").build())
            .build();

    private static final SdkField<String> LOG_GROUP_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupClass").getter(getter(DescribeLogGroupsRequest::logGroupClassAsString))
            .setter(setter(Builder::logGroupClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDENTIFIERS_FIELD,
            LOG_GROUP_NAME_PREFIX_FIELD, LOG_GROUP_NAME_PATTERN_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD,
            INCLUDE_LINKED_ACCOUNTS_FIELD, LOG_GROUP_CLASS_FIELD));

    private final List<String> accountIdentifiers;

    private final String logGroupNamePrefix;

    private final String logGroupNamePattern;

    private final String nextToken;

    private final Integer limit;

    private final Boolean includeLinkedAccounts;

    private final String logGroupClass;

    private DescribeLogGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIdentifiers = builder.accountIdentifiers;
        this.logGroupNamePrefix = builder.logGroupNamePrefix;
        this.logGroupNamePattern = builder.logGroupNamePattern;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.includeLinkedAccounts = builder.includeLinkedAccounts;
        this.logGroupClass = builder.logGroupClass;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdentifiers() {
        return accountIdentifiers != null && !(accountIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When <code>includeLinkedAccounts</code> is set to <code>True</code>, use this parameter to specify the list of
     * accounts to search. You can specify as many as 20 account IDs in the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdentifiers} method.
     * </p>
     * 
     * @return When <code>includeLinkedAccounts</code> is set to <code>True</code>, use this parameter to specify the
     *         list of accounts to search. You can specify as many as 20 account IDs in the array.
     */
    public final List<String> accountIdentifiers() {
        return accountIdentifiers;
    }

    /**
     * <p>
     * The prefix to match.
     * </p>
     * <note>
     * <p>
     * <code>logGroupNamePrefix</code> and <code>logGroupNamePattern</code> are mutually exclusive. Only one of these
     * parameters can be passed.
     * </p>
     * </note>
     * 
     * @return The prefix to match.</p> <note>
     *         <p>
     *         <code>logGroupNamePrefix</code> and <code>logGroupNamePattern</code> are mutually exclusive. Only one of
     *         these parameters can be passed.
     *         </p>
     */
    public final String logGroupNamePrefix() {
        return logGroupNamePrefix;
    }

    /**
     * <p>
     * If you specify a string for this parameter, the operation returns only log groups that have names that match the
     * string based on a case-sensitive substring search. For example, if you specify <code>Foo</code>, log groups named
     * <code>FooBar</code>, <code>aws/Foo</code>, and <code>GroupFoo</code> would match, but <code>foo</code>,
     * <code>F/o/o</code> and <code>Froo</code> would not match.
     * </p>
     * <p>
     * If you specify <code>logGroupNamePattern</code> in your request, then only <code>arn</code>,
     * <code>creationTime</code>, and <code>logGroupName</code> are included in the response.
     * </p>
     * <note>
     * <p>
     * <code>logGroupNamePattern</code> and <code>logGroupNamePrefix</code> are mutually exclusive. Only one of these
     * parameters can be passed.
     * </p>
     * </note>
     * 
     * @return If you specify a string for this parameter, the operation returns only log groups that have names that
     *         match the string based on a case-sensitive substring search. For example, if you specify <code>Foo</code>
     *         , log groups named <code>FooBar</code>, <code>aws/Foo</code>, and <code>GroupFoo</code> would match, but
     *         <code>foo</code>, <code>F/o/o</code> and <code>Froo</code> would not match.</p>
     *         <p>
     *         If you specify <code>logGroupNamePattern</code> in your request, then only <code>arn</code>,
     *         <code>creationTime</code>, and <code>logGroupName</code> are included in the response.
     *         </p>
     *         <note>
     *         <p>
     *         <code>logGroupNamePattern</code> and <code>logGroupNamePrefix</code> are mutually exclusive. Only one of
     *         these parameters can be passed.
     *         </p>
     */
    public final String logGroupNamePattern() {
        return logGroupNamePattern;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If you are using a monitoring account, set this to <code>True</code> to have the operation return log groups in
     * the accounts listed in <code>accountIdentifiers</code>.
     * </p>
     * <p>
     * If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null value, the
     * operation returns all log groups in the monitoring account and all log groups in all source accounts that are
     * linked to the monitoring account.
     * </p>
     * 
     * @return If you are using a monitoring account, set this to <code>True</code> to have the operation return log
     *         groups in the accounts listed in <code>accountIdentifiers</code>.</p>
     *         <p>
     *         If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null value,
     *         the operation returns all log groups in the monitoring account and all log groups in all source accounts
     *         that are linked to the monitoring account.
     */
    public final Boolean includeLinkedAccounts() {
        return includeLinkedAccounts;
    }

    /**
     * <p>
     * Specifies the log group class for this log group. There are two classes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>Standard</code> log class supports all CloudWatch Logs features.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
     * costs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For details about the features supported by each class, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return Specifies the log group class for this log group. There are two classes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>Standard</code> log class supports all CloudWatch Logs features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
     *         lower costs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For details about the features supported by each class, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
     *         classes</a>
     * @see LogGroupClass
     */
    public final LogGroupClass logGroupClass() {
        return LogGroupClass.fromValue(logGroupClass);
    }

    /**
     * <p>
     * Specifies the log group class for this log group. There are two classes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>Standard</code> log class supports all CloudWatch Logs features.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
     * costs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For details about the features supported by each class, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return Specifies the log group class for this log group. There are two classes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>Standard</code> log class supports all CloudWatch Logs features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
     *         lower costs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For details about the features supported by each class, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
     *         classes</a>
     * @see LogGroupClass
     */
    public final String logGroupClassAsString() {
        return logGroupClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdentifiers() ? accountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logGroupNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupNamePattern());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(includeLinkedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsRequest)) {
            return false;
        }
        DescribeLogGroupsRequest other = (DescribeLogGroupsRequest) obj;
        return hasAccountIdentifiers() == other.hasAccountIdentifiers()
                && Objects.equals(accountIdentifiers(), other.accountIdentifiers())
                && Objects.equals(logGroupNamePrefix(), other.logGroupNamePrefix())
                && Objects.equals(logGroupNamePattern(), other.logGroupNamePattern())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit())
                && Objects.equals(includeLinkedAccounts(), other.includeLinkedAccounts())
                && Objects.equals(logGroupClassAsString(), other.logGroupClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLogGroupsRequest")
                .add("AccountIdentifiers", hasAccountIdentifiers() ? accountIdentifiers() : null)
                .add("LogGroupNamePrefix", logGroupNamePrefix()).add("LogGroupNamePattern", logGroupNamePattern())
                .add("NextToken", nextToken()).add("Limit", limit()).add("IncludeLinkedAccounts", includeLinkedAccounts())
                .add("LogGroupClass", logGroupClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIdentifiers":
            return Optional.ofNullable(clazz.cast(accountIdentifiers()));
        case "logGroupNamePrefix":
            return Optional.ofNullable(clazz.cast(logGroupNamePrefix()));
        case "logGroupNamePattern":
            return Optional.ofNullable(clazz.cast(logGroupNamePattern()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "includeLinkedAccounts":
            return Optional.ofNullable(clazz.cast(includeLinkedAccounts()));
        case "logGroupClass":
            return Optional.ofNullable(clazz.cast(logGroupClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogGroupsRequest, T> g) {
        return obj -> g.apply((DescribeLogGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLogGroupsRequest> {
        /**
         * <p>
         * When <code>includeLinkedAccounts</code> is set to <code>True</code>, use this parameter to specify the list
         * of accounts to search. You can specify as many as 20 account IDs in the array.
         * </p>
         * 
         * @param accountIdentifiers
         *        When <code>includeLinkedAccounts</code> is set to <code>True</code>, use this parameter to specify the
         *        list of accounts to search. You can specify as many as 20 account IDs in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifiers(Collection<String> accountIdentifiers);

        /**
         * <p>
         * When <code>includeLinkedAccounts</code> is set to <code>True</code>, use this parameter to specify the list
         * of accounts to search. You can specify as many as 20 account IDs in the array.
         * </p>
         * 
         * @param accountIdentifiers
         *        When <code>includeLinkedAccounts</code> is set to <code>True</code>, use this parameter to specify the
         *        list of accounts to search. You can specify as many as 20 account IDs in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifiers(String... accountIdentifiers);

        /**
         * <p>
         * The prefix to match.
         * </p>
         * <note>
         * <p>
         * <code>logGroupNamePrefix</code> and <code>logGroupNamePattern</code> are mutually exclusive. Only one of
         * these parameters can be passed.
         * </p>
         * </note>
         * 
         * @param logGroupNamePrefix
         *        The prefix to match.</p> <note>
         *        <p>
         *        <code>logGroupNamePrefix</code> and <code>logGroupNamePattern</code> are mutually exclusive. Only one
         *        of these parameters can be passed.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupNamePrefix(String logGroupNamePrefix);

        /**
         * <p>
         * If you specify a string for this parameter, the operation returns only log groups that have names that match
         * the string based on a case-sensitive substring search. For example, if you specify <code>Foo</code>, log
         * groups named <code>FooBar</code>, <code>aws/Foo</code>, and <code>GroupFoo</code> would match, but
         * <code>foo</code>, <code>F/o/o</code> and <code>Froo</code> would not match.
         * </p>
         * <p>
         * If you specify <code>logGroupNamePattern</code> in your request, then only <code>arn</code>,
         * <code>creationTime</code>, and <code>logGroupName</code> are included in the response.
         * </p>
         * <note>
         * <p>
         * <code>logGroupNamePattern</code> and <code>logGroupNamePrefix</code> are mutually exclusive. Only one of
         * these parameters can be passed.
         * </p>
         * </note>
         * 
         * @param logGroupNamePattern
         *        If you specify a string for this parameter, the operation returns only log groups that have names that
         *        match the string based on a case-sensitive substring search. For example, if you specify
         *        <code>Foo</code>, log groups named <code>FooBar</code>, <code>aws/Foo</code>, and
         *        <code>GroupFoo</code> would match, but <code>foo</code>, <code>F/o/o</code> and <code>Froo</code>
         *        would not match.</p>
         *        <p>
         *        If you specify <code>logGroupNamePattern</code> in your request, then only <code>arn</code>,
         *        <code>creationTime</code>, and <code>logGroupName</code> are included in the response.
         *        </p>
         *        <note>
         *        <p>
         *        <code>logGroupNamePattern</code> and <code>logGroupNamePrefix</code> are mutually exclusive. Only one
         *        of these parameters can be passed.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupNamePattern(String logGroupNamePattern);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If you are using a monitoring account, set this to <code>True</code> to have the operation return log groups
         * in the accounts listed in <code>accountIdentifiers</code>.
         * </p>
         * <p>
         * If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null value, the
         * operation returns all log groups in the monitoring account and all log groups in all source accounts that are
         * linked to the monitoring account.
         * </p>
         * 
         * @param includeLinkedAccounts
         *        If you are using a monitoring account, set this to <code>True</code> to have the operation return log
         *        groups in the accounts listed in <code>accountIdentifiers</code>.</p>
         *        <p>
         *        If this parameter is set to <code>true</code> and <code>accountIdentifiers</code> contains a null
         *        value, the operation returns all log groups in the monitoring account and all log groups in all source
         *        accounts that are linked to the monitoring account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeLinkedAccounts(Boolean includeLinkedAccounts);

        /**
         * <p>
         * Specifies the log group class for this log group. There are two classes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>Standard</code> log class supports all CloudWatch Logs features.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
         * costs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For details about the features supported by each class, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         * classes</a>
         * </p>
         * 
         * @param logGroupClass
         *        Specifies the log group class for this log group. There are two classes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>Standard</code> log class supports all CloudWatch Logs features.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
         *        lower costs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For details about the features supported by each class, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         *        classes</a>
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(String logGroupClass);

        /**
         * <p>
         * Specifies the log group class for this log group. There are two classes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>Standard</code> log class supports all CloudWatch Logs features.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
         * costs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For details about the features supported by each class, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         * classes</a>
         * </p>
         * 
         * @param logGroupClass
         *        Specifies the log group class for this log group. There are two classes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>Standard</code> log class supports all CloudWatch Logs features.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
         *        lower costs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For details about the features supported by each class, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         *        classes</a>
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(LogGroupClass logGroupClass);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private List<String> accountIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String logGroupNamePrefix;

        private String logGroupNamePattern;

        private String nextToken;

        private Integer limit;

        private Boolean includeLinkedAccounts;

        private String logGroupClass;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsRequest model) {
            super(model);
            accountIdentifiers(model.accountIdentifiers);
            logGroupNamePrefix(model.logGroupNamePrefix);
            logGroupNamePattern(model.logGroupNamePattern);
            nextToken(model.nextToken);
            limit(model.limit);
            includeLinkedAccounts(model.includeLinkedAccounts);
            logGroupClass(model.logGroupClass);
        }

        public final Collection<String> getAccountIdentifiers() {
            if (accountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdentifiers;
        }

        public final void setAccountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
        }

        @Override
        public final Builder accountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdentifiers(String... accountIdentifiers) {
            accountIdentifiers(Arrays.asList(accountIdentifiers));
            return this;
        }

        public final String getLogGroupNamePrefix() {
            return logGroupNamePrefix;
        }

        public final void setLogGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
        }

        @Override
        public final Builder logGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
            return this;
        }

        public final String getLogGroupNamePattern() {
            return logGroupNamePattern;
        }

        public final void setLogGroupNamePattern(String logGroupNamePattern) {
            this.logGroupNamePattern = logGroupNamePattern;
        }

        @Override
        public final Builder logGroupNamePattern(String logGroupNamePattern) {
            this.logGroupNamePattern = logGroupNamePattern;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Boolean getIncludeLinkedAccounts() {
            return includeLinkedAccounts;
        }

        public final void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
        }

        @Override
        public final Builder includeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        public final String getLogGroupClass() {
            return logGroupClass;
        }

        public final void setLogGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
        }

        @Override
        public final Builder logGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        @Override
        public final Builder logGroupClass(LogGroupClass logGroupClass) {
            this.logGroupClass(logGroupClass == null ? null : logGroupClass.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLogGroupsRequest build() {
            return new DescribeLogGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
