/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a valid record field header and whether it is mandatory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordField implements SdkPojo, Serializable, ToCopyableBuilder<RecordField.Builder, RecordField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RecordField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> MANDATORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("mandatory").getter(getter(RecordField::mandatory)).setter(setter(Builder::mandatory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mandatory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MANDATORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Boolean mandatory;

    private RecordField(BuilderImpl builder) {
        this.name = builder.name;
        this.mandatory = builder.mandatory;
    }

    /**
     * <p>
     * The name to use when specifying this record field in a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a> or <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a> operation.
     * </p>
     * 
     * @return The name to use when specifying this record field in a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     *         >CreateDelivery</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     *         >UpdateDeliveryConfiguration</a> operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If this is <code>true</code>, the record field must be present in the <code>recordFields</code> parameter
     * provided to a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a> or <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a> operation.
     * </p>
     * 
     * @return If this is <code>true</code>, the record field must be present in the <code>recordFields</code> parameter
     *         provided to a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     *         >CreateDelivery</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     *         >UpdateDeliveryConfiguration</a> operation.
     */
    public final Boolean mandatory() {
        return mandatory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(mandatory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordField)) {
            return false;
        }
        RecordField other = (RecordField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(mandatory(), other.mandatory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordField").add("Name", name()).add("Mandatory", mandatory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "mandatory":
            return Optional.ofNullable(clazz.cast(mandatory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordField, T> g) {
        return obj -> g.apply((RecordField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordField> {
        /**
         * <p>
         * The name to use when specifying this record field in a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> operation.
         * </p>
         * 
         * @param name
         *        The name to use when specifying this record field in a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         *        >UpdateDeliveryConfiguration</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If this is <code>true</code>, the record field must be present in the <code>recordFields</code> parameter
         * provided to a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> operation.
         * </p>
         * 
         * @param mandatory
         *        If this is <code>true</code>, the record field must be present in the <code>recordFields</code>
         *        parameter provided to a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         *        >UpdateDeliveryConfiguration</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mandatory(Boolean mandatory);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Boolean mandatory;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordField model) {
            name(model.name);
            mandatory(model.mandatory);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getMandatory() {
            return mandatory;
        }

        public final void setMandatory(Boolean mandatory) {
            this.mandatory = mandatory;
        }

        @Override
        public final Builder mandatory(Boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        @Override
        public RecordField build() {
            return new RecordField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
