/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object contains the log events and metadata for a Live Tail session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LiveTailSessionUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveTailSessionUpdate.Builder, LiveTailSessionUpdate>, StartLiveTailResponseStream {
    private static final SdkField<LiveTailSessionMetadata> SESSION_METADATA_FIELD = SdkField
            .<LiveTailSessionMetadata> builder(MarshallingType.SDK_POJO).memberName("sessionMetadata")
            .getter(getter(LiveTailSessionUpdate::sessionMetadata)).setter(setter(Builder::sessionMetadata))
            .constructor(LiveTailSessionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionMetadata").build()).build();

    private static final SdkField<List<LiveTailSessionLogEvent>> SESSION_RESULTS_FIELD = SdkField
            .<List<LiveTailSessionLogEvent>> builder(MarshallingType.LIST)
            .memberName("sessionResults")
            .getter(getter(LiveTailSessionUpdate::sessionResults))
            .setter(setter(Builder::sessionResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LiveTailSessionLogEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(LiveTailSessionLogEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_METADATA_FIELD,
            SESSION_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("sessionMetadata", SESSION_METADATA_FIELD);
                    put("sessionResults", SESSION_RESULTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final LiveTailSessionMetadata sessionMetadata;

    private final List<LiveTailSessionLogEvent> sessionResults;

    protected LiveTailSessionUpdate(BuilderImpl builder) {
        this.sessionMetadata = builder.sessionMetadata;
        this.sessionResults = builder.sessionResults;
    }

    /**
     * <p>
     * This object contains the session metadata for a Live Tail session.
     * </p>
     * 
     * @return This object contains the session metadata for a Live Tail session.
     */
    public final LiveTailSessionMetadata sessionMetadata() {
        return sessionMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionResults() {
        return sessionResults != null && !(sessionResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array, where each member of the array includes the information for one log event in the Live Tail session.
     * </p>
     * <p>
     * A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events matching
     * the request exceeds 500 per second, the log events are sampled down to 500 log events to be included in each
     * <code>sessionUpdate</code> structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionResults} method.
     * </p>
     * 
     * @return An array, where each member of the array includes the information for one log event in the Live Tail
     *         session.</p>
     *         <p>
     *         A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events
     *         matching the request exceeds 500 per second, the log events are sampled down to 500 log events to be
     *         included in each <code>sessionUpdate</code> structure.
     */
    public final List<LiveTailSessionLogEvent> sessionResults() {
        return sessionResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionResults() ? sessionResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveTailSessionUpdate)) {
            return false;
        }
        LiveTailSessionUpdate other = (LiveTailSessionUpdate) obj;
        return Objects.equals(sessionMetadata(), other.sessionMetadata()) && hasSessionResults() == other.hasSessionResults()
                && Objects.equals(sessionResults(), other.sessionResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveTailSessionUpdate").add("SessionMetadata", sessionMetadata())
                .add("SessionResults", hasSessionResults() ? sessionResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionMetadata":
            return Optional.ofNullable(clazz.cast(sessionMetadata()));
        case "sessionResults":
            return Optional.ofNullable(clazz.cast(sessionResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final LiveTailSessionUpdate copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LiveTailSessionUpdate, T> g) {
        return obj -> g.apply((LiveTailSessionUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link LiveTailSessionUpdate}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartLiveTailResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveTailSessionUpdate> {
        /**
         * <p>
         * This object contains the session metadata for a Live Tail session.
         * </p>
         * 
         * @param sessionMetadata
         *        This object contains the session metadata for a Live Tail session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionMetadata(LiveTailSessionMetadata sessionMetadata);

        /**
         * <p>
         * This object contains the session metadata for a Live Tail session.
         * </p>
         * This is a convenience method that creates an instance of the {@link LiveTailSessionMetadata.Builder} avoiding
         * the need to create one manually via {@link LiveTailSessionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LiveTailSessionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #sessionMetadata(LiveTailSessionMetadata)}.
         * 
         * @param sessionMetadata
         *        a consumer that will call methods on {@link LiveTailSessionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionMetadata(LiveTailSessionMetadata)
         */
        default Builder sessionMetadata(Consumer<LiveTailSessionMetadata.Builder> sessionMetadata) {
            return sessionMetadata(LiveTailSessionMetadata.builder().applyMutation(sessionMetadata).build());
        }

        /**
         * <p>
         * An array, where each member of the array includes the information for one log event in the Live Tail session.
         * </p>
         * <p>
         * A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events
         * matching the request exceeds 500 per second, the log events are sampled down to 500 log events to be included
         * in each <code>sessionUpdate</code> structure.
         * </p>
         * 
         * @param sessionResults
         *        An array, where each member of the array includes the information for one log event in the Live Tail
         *        session.</p>
         *        <p>
         *        A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events
         *        matching the request exceeds 500 per second, the log events are sampled down to 500 log events to be
         *        included in each <code>sessionUpdate</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionResults(Collection<LiveTailSessionLogEvent> sessionResults);

        /**
         * <p>
         * An array, where each member of the array includes the information for one log event in the Live Tail session.
         * </p>
         * <p>
         * A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events
         * matching the request exceeds 500 per second, the log events are sampled down to 500 log events to be included
         * in each <code>sessionUpdate</code> structure.
         * </p>
         * 
         * @param sessionResults
         *        An array, where each member of the array includes the information for one log event in the Live Tail
         *        session.</p>
         *        <p>
         *        A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events
         *        matching the request exceeds 500 per second, the log events are sampled down to 500 log events to be
         *        included in each <code>sessionUpdate</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionResults(LiveTailSessionLogEvent... sessionResults);

        /**
         * <p>
         * An array, where each member of the array includes the information for one log event in the Live Tail session.
         * </p>
         * <p>
         * A <code>sessionResults</code> array can include as many as 500 log events. If the number of log events
         * matching the request exceeds 500 per second, the log events are sampled down to 500 log events to be included
         * in each <code>sessionUpdate</code> structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionLogEvent.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionLogEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionLogEvent.Builder#build()} is
         * called immediately and its result is passed to {@link #sessionResults(List<LiveTailSessionLogEvent>)}.
         * 
         * @param sessionResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionLogEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionResults(java.util.Collection<LiveTailSessionLogEvent>)
         */
        Builder sessionResults(Consumer<LiveTailSessionLogEvent.Builder>... sessionResults);
    }

    protected static class BuilderImpl implements Builder {
        private LiveTailSessionMetadata sessionMetadata;

        private List<LiveTailSessionLogEvent> sessionResults = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(LiveTailSessionUpdate model) {
            sessionMetadata(model.sessionMetadata);
            sessionResults(model.sessionResults);
        }

        public final LiveTailSessionMetadata.Builder getSessionMetadata() {
            return sessionMetadata != null ? sessionMetadata.toBuilder() : null;
        }

        public final void setSessionMetadata(LiveTailSessionMetadata.BuilderImpl sessionMetadata) {
            this.sessionMetadata = sessionMetadata != null ? sessionMetadata.build() : null;
        }

        @Override
        public final Builder sessionMetadata(LiveTailSessionMetadata sessionMetadata) {
            this.sessionMetadata = sessionMetadata;
            return this;
        }

        public final List<LiveTailSessionLogEvent.Builder> getSessionResults() {
            List<LiveTailSessionLogEvent.Builder> result = LiveTailSessionResultsCopier.copyToBuilder(this.sessionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionResults(Collection<LiveTailSessionLogEvent.BuilderImpl> sessionResults) {
            this.sessionResults = LiveTailSessionResultsCopier.copyFromBuilder(sessionResults);
        }

        @Override
        public final Builder sessionResults(Collection<LiveTailSessionLogEvent> sessionResults) {
            this.sessionResults = LiveTailSessionResultsCopier.copy(sessionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionResults(LiveTailSessionLogEvent... sessionResults) {
            sessionResults(Arrays.asList(sessionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionResults(Consumer<LiveTailSessionLogEvent.Builder>... sessionResults) {
            sessionResults(Stream.of(sessionResults).map(c -> LiveTailSessionLogEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LiveTailSessionUpdate build() {
            return new LiveTailSessionUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
