/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one logs delivery destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliveryDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliveryDestinationConfiguration.Builder, DeliveryDestinationConfiguration> {
    private static final SdkField<String> DESTINATION_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationResourceArn").getter(getter(DeliveryDestinationConfiguration::destinationResourceArn))
            .setter(setter(Builder::destinationResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationResourceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DESTINATION_RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("destinationResourceArn", DESTINATION_RESOURCE_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String destinationResourceArn;

    private DeliveryDestinationConfiguration(BuilderImpl builder) {
        this.destinationResourceArn = builder.destinationResourceArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web
     * Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in
     * Firehose.
     * </p>
     * 
     * @return The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web
     *         Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in
     *         Firehose.
     */
    public final String destinationResourceArn() {
        return destinationResourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationResourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryDestinationConfiguration)) {
            return false;
        }
        DeliveryDestinationConfiguration other = (DeliveryDestinationConfiguration) obj;
        return Objects.equals(destinationResourceArn(), other.destinationResourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliveryDestinationConfiguration").add("DestinationResourceArn", destinationResourceArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationResourceArn":
            return Optional.ofNullable(clazz.cast(destinationResourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryDestinationConfiguration, T> g) {
        return obj -> g.apply((DeliveryDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliveryDestinationConfiguration> {
        /**
         * <p>
         * The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web
         * Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in
         * Firehose.
         * </p>
         * 
         * @param destinationResourceArn
         *        The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon
         *        Web Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery
         *        stream in Firehose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationResourceArn(String destinationResourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String destinationResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryDestinationConfiguration model) {
            destinationResourceArn(model.destinationResourceArn);
        }

        public final String getDestinationResourceArn() {
            return destinationResourceArn;
        }

        public final void setDestinationResourceArn(String destinationResourceArn) {
            this.destinationResourceArn = destinationResourceArn;
        }

        @Override
        public final Builder destinationResourceArn(String destinationResourceArn) {
            this.destinationResourceArn = destinationResourceArn;
            return this;
        }

        @Override
        public DeliveryDestinationConfiguration build() {
            return new DeliveryDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
