/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a log event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputLogEvent implements SdkPojo, Serializable, ToCopyableBuilder<OutputLogEvent.Builder, OutputLogEvent> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("timestamp")
            .getter(getter(OutputLogEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(OutputLogEvent::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Long> INGESTION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ingestionTime").getter(getter(OutputLogEvent::ingestionTime)).setter(setter(Builder::ingestionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            MESSAGE_FIELD, INGESTION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("timestamp", TIMESTAMP_FIELD);
                    put("message", MESSAGE_FIELD);
                    put("ingestionTime", INGESTION_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final String message;

    private final Long ingestionTime;

    private OutputLogEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.ingestionTime = builder.ingestionTime;
    }

    /**
     * <p>
     * The time the event occurred, expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>.
     * </p>
     * 
     * @return The time the event occurred, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The data contained in the log event.
     * </p>
     * 
     * @return The data contained in the log event.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The time the event was ingested, expressed as the number of milliseconds after
     * <code>Jan 1, 1970 00:00:00 UTC</code>.
     * </p>
     * 
     * @return The time the event was ingested, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>.
     */
    public final Long ingestionTime() {
        return ingestionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLogEvent)) {
            return false;
        }
        OutputLogEvent other = (OutputLogEvent) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(message(), other.message())
                && Objects.equals(ingestionTime(), other.ingestionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputLogEvent").add("Timestamp", timestamp()).add("Message", message())
                .add("IngestionTime", ingestionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ingestionTime":
            return Optional.ofNullable(clazz.cast(ingestionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OutputLogEvent, T> g) {
        return obj -> g.apply((OutputLogEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputLogEvent> {
        /**
         * <p>
         * The time the event occurred, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>.
         * </p>
         * 
         * @param timestamp
         *        The time the event occurred, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The data contained in the log event.
         * </p>
         * 
         * @param message
         *        The data contained in the log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time the event was ingested, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>.
         * </p>
         * 
         * @param ingestionTime
         *        The time the event was ingested, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionTime(Long ingestionTime);
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private String message;

        private Long ingestionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLogEvent model) {
            timestamp(model.timestamp);
            message(model.message);
            ingestionTime(model.ingestionTime);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getIngestionTime() {
            return ingestionTime;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        @Override
        public OutputLogEvent build() {
            return new OutputLogEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
