/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This processor converts a string field to uppercase.
 * </p>
 * <p>
 * For more information about this processor including examples, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-upperCaseString"
 * > upperCaseString</a> in the <i>CloudWatch Logs User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpperCaseString implements SdkPojo, Serializable, ToCopyableBuilder<UpperCaseString.Builder, UpperCaseString> {
    private static final SdkField<List<String>> WITH_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("withKeys")
            .getter(getter(UpperCaseString::withKeys))
            .setter(setter(Builder::withKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("withKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WITH_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("withKeys", WITH_KEYS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> withKeys;

    private UpperCaseString(BuilderImpl builder) {
        this.withKeys = builder.withKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the WithKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWithKeys() {
        return withKeys != null && !(withKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of containing the keys of the field to convert to uppercase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWithKeys} method.
     * </p>
     * 
     * @return The array of containing the keys of the field to convert to uppercase.
     */
    public final List<String> withKeys() {
        return withKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWithKeys() ? withKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpperCaseString)) {
            return false;
        }
        UpperCaseString other = (UpperCaseString) obj;
        return hasWithKeys() == other.hasWithKeys() && Objects.equals(withKeys(), other.withKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpperCaseString").add("WithKeys", hasWithKeys() ? withKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "withKeys":
            return Optional.ofNullable(clazz.cast(withKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpperCaseString, T> g) {
        return obj -> g.apply((UpperCaseString) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpperCaseString> {
        /**
         * <p>
         * The array of containing the keys of the field to convert to uppercase.
         * </p>
         * 
         * @param withKeys
         *        The array of containing the keys of the field to convert to uppercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withKeys(Collection<String> withKeys);

        /**
         * <p>
         * The array of containing the keys of the field to convert to uppercase.
         * </p>
         * 
         * @param withKeys
         *        The array of containing the keys of the field to convert to uppercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withKeys(String... withKeys);
    }

    static final class BuilderImpl implements Builder {
        private List<String> withKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpperCaseString model) {
            withKeys(model.withKeys);
        }

        public final Collection<String> getWithKeys() {
            if (withKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return withKeys;
        }

        public final void setWithKeys(Collection<String> withKeys) {
            this.withKeys = UpperCaseStringWithKeysCopier.copy(withKeys);
        }

        @Override
        public final Builder withKeys(Collection<String> withKeys) {
            this.withKeys = UpperCaseStringWithKeysCopier.copy(withKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withKeys(String... withKeys) {
            withKeys(Arrays.asList(withKeys));
            return this;
        }

        @Override
        public UpperCaseString build() {
            return new UpperCaseString(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
