/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseHandler;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeConfigurationTemplatesPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveriesPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveryDestinationsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliverySourcesPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeSubscriptionFiltersPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.FilterLogEventsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.GetLogEventsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.ListAnomaliesPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogAnomalyDetectorsPublisher;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogGroupsForQueryPublisher;

/**
 * Service client for accessing Amazon CloudWatch Logs asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * You can use Amazon CloudWatch Logs to monitor, store, and access your log files from EC2 instances, CloudTrail, and
 * other sources. You can then retrieve the associated log data from CloudWatch Logs using the CloudWatch console.
 * Alternatively, you can use CloudWatch Logs commands in the Amazon Web Services CLI, CloudWatch Logs API, or
 * CloudWatch Logs SDK.
 * </p>
 * <p>
 * You can use CloudWatch Logs to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Monitor logs from EC2 instances in real time</b>: You can use CloudWatch Logs to monitor applications and systems
 * using log data. For example, CloudWatch Logs can track the number of errors that occur in your application logs.
 * Then, it can send you a notification whenever the rate of errors exceeds a threshold that you specify. CloudWatch
 * Logs uses your log data for monitoring so no code changes are required. For example, you can monitor application logs
 * for specific literal terms (such as "NullReferenceException"). You can also count the number of occurrences of a
 * literal term at a particular position in log data (such as "404" status codes in an Apache access log). When the term
 * you are searching for is found, CloudWatch Logs reports the data to a CloudWatch metric that you specify.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Monitor CloudTrail logged events</b>: You can create alarms in CloudWatch and receive notifications of particular
 * API activity as captured by CloudTrail. You can use the notification to perform troubleshooting.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Archive log data</b>: You can use CloudWatch Logs to store your log data in highly durable storage. You can change
 * the log retention setting so that any log events earlier than this setting are automatically deleted. The CloudWatch
 * Logs agent helps to quickly send both rotated and non-rotated log data off of a host and into the log service. You
 * can then access the raw log data when you need it.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudWatchLogsAsyncClient extends AwsClient {
    String SERVICE_NAME = "logs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "logs";

    /**
     * <p>
     * Associates the specified KMS key with either one log group in the account, or with all stored CloudWatch Logs
     * query insights results in the account.
     * </p>
     * <p>
     * When you use <code>AssociateKmsKey</code>, you specify either the <code>logGroupName</code> parameter or the
     * <code>resourceIdentifier</code> parameter. You can't specify both of those parameters in the same operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>logGroupName</code> parameter to cause all log events stored in the log group to be encrypted
     * with that key. Only the log events ingested after the key is associated are encrypted with that key.
     * </p>
     * <p>
     * Associating a KMS key with a log group overrides any existing associations between the log group and a KMS key.
     * After a KMS key is associated with a log group, all newly ingested data for the log group is encrypted using the
     * KMS key. This association is stored as long as the data encrypted with the KMS key is still within CloudWatch
     * Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.
     * </p>
     * <p>
     * Associating a key with a log group does not cause the results of queries of that log group to be encrypted with
     * that key. To have query results encrypted with a KMS key, you must use an <code>AssociateKmsKey</code> operation
     * with the <code>resourceIdentifier</code> parameter that specifies a <code>query-result</code> resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the <code>resourceIdentifier</code> parameter with a <code>query-result</code> resource, to use that key
     * to encrypt the stored results of all future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in the account. The response from a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html"
     * >GetQueryResults</a> operation will still return the query results in plain text.
     * </p>
     * <p>
     * Even if you have not associated a key with your query results, the query results are encrypted when stored, using
     * the default CloudWatch Logs method.
     * </p>
     * <p>
     * If you run a query from a monitoring account that queries logs in a source account, the query results key from
     * the monitoring account, if any, is used.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If you delete the key that is used to encrypt log events or log group query results, then all the associated
     * stored log events or query results that were encrypted with that key will be unencryptable and unusable.
     * </p>
     * </important> <note>
     * <p>
     * CloudWatch Logs supports only symmetric KMS keys. Do not use an associate an asymmetric KMS key with your log
     * group or query results. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and
     * Asymmetric Keys</a>.
     * </p>
     * </note>
     * <p>
     * It can take up to 5 minutes for this operation to take effect.
     * </p>
     * <p>
     * If you attempt to associate a KMS key with a log group but the KMS key does not exist or the KMS key is disabled,
     * you receive an <code>InvalidParameterException</code> error.
     * </p>
     *
     * @param associateKmsKeyRequest
     * @return A Java Future containing the result of the AssociateKmsKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.AssociateKmsKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateKmsKeyResponse> associateKmsKey(AssociateKmsKeyRequest associateKmsKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified KMS key with either one log group in the account, or with all stored CloudWatch Logs
     * query insights results in the account.
     * </p>
     * <p>
     * When you use <code>AssociateKmsKey</code>, you specify either the <code>logGroupName</code> parameter or the
     * <code>resourceIdentifier</code> parameter. You can't specify both of those parameters in the same operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>logGroupName</code> parameter to cause all log events stored in the log group to be encrypted
     * with that key. Only the log events ingested after the key is associated are encrypted with that key.
     * </p>
     * <p>
     * Associating a KMS key with a log group overrides any existing associations between the log group and a KMS key.
     * After a KMS key is associated with a log group, all newly ingested data for the log group is encrypted using the
     * KMS key. This association is stored as long as the data encrypted with the KMS key is still within CloudWatch
     * Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.
     * </p>
     * <p>
     * Associating a key with a log group does not cause the results of queries of that log group to be encrypted with
     * that key. To have query results encrypted with a KMS key, you must use an <code>AssociateKmsKey</code> operation
     * with the <code>resourceIdentifier</code> parameter that specifies a <code>query-result</code> resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the <code>resourceIdentifier</code> parameter with a <code>query-result</code> resource, to use that key
     * to encrypt the stored results of all future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in the account. The response from a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html"
     * >GetQueryResults</a> operation will still return the query results in plain text.
     * </p>
     * <p>
     * Even if you have not associated a key with your query results, the query results are encrypted when stored, using
     * the default CloudWatch Logs method.
     * </p>
     * <p>
     * If you run a query from a monitoring account that queries logs in a source account, the query results key from
     * the monitoring account, if any, is used.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If you delete the key that is used to encrypt log events or log group query results, then all the associated
     * stored log events or query results that were encrypted with that key will be unencryptable and unusable.
     * </p>
     * </important> <note>
     * <p>
     * CloudWatch Logs supports only symmetric KMS keys. Do not use an associate an asymmetric KMS key with your log
     * group or query results. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and
     * Asymmetric Keys</a>.
     * </p>
     * </note>
     * <p>
     * It can take up to 5 minutes for this operation to take effect.
     * </p>
     * <p>
     * If you attempt to associate a KMS key with a log group but the KMS key does not exist or the KMS key is disabled,
     * you receive an <code>InvalidParameterException</code> error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateKmsKeyRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateKmsKeyRequest#builder()}
     * </p>
     *
     * @param associateKmsKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateKmsKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.AssociateKmsKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateKmsKeyResponse> associateKmsKey(
            Consumer<AssociateKmsKeyRequest.Builder> associateKmsKeyRequest) {
        return associateKmsKey(AssociateKmsKeyRequest.builder().applyMutation(associateKmsKeyRequest).build());
    }

    /**
     * <p>
     * Cancels the specified export task.
     * </p>
     * <p>
     * The task must be in the <code>PENDING</code> or <code>RUNNING</code> state.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified export task.
     * </p>
     * <p>
     * The task must be in the <code>PENDING</code> or <code>RUNNING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportTaskRequest#builder()}
     * </p>
     *
     * @param cancelExportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportTaskResponse> cancelExportTask(
            Consumer<CancelExportTaskRequest.Builder> cancelExportTaskRequest) {
        return cancelExportTask(CancelExportTaskRequest.builder().applyMutation(cancelExportTaskRequest).build());
    }

    /**
     * <p>
     * Creates a <i>delivery</i>. A delivery is a connection between a logical <i>delivery source</i> and a logical
     * <i>delivery destination</i> that you have already created.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source using this operation. These
     * services are listed as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * A delivery destination can represent a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in
     * Firehose.
     * </p>
     * <p>
     * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery destination</i>, which is a logical object that represents the actual delivery destination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * To update an existing delivery configuration, use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a>.
     * </p>
     *
     * @param createDeliveryRequest
     * @return A Java Future containing the result of the CreateDelivery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDeliveryResponse> createDelivery(CreateDeliveryRequest createDeliveryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>delivery</i>. A delivery is a connection between a logical <i>delivery source</i> and a logical
     * <i>delivery destination</i> that you have already created.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source using this operation. These
     * services are listed as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * A delivery destination can represent a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in
     * Firehose.
     * </p>
     * <p>
     * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery destination</i>, which is a logical object that represents the actual delivery destination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * To update an existing delivery configuration, use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeliveryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDeliveryRequest#builder()}
     * </p>
     *
     * @param createDeliveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDelivery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDeliveryResponse> createDelivery(Consumer<CreateDeliveryRequest.Builder> createDeliveryRequest) {
        return createDelivery(CreateDeliveryRequest.builder().applyMutation(createDeliveryRequest).build());
    }

    /**
     * <p>
     * Creates an export task so that you can efficiently export data from a log group to an Amazon S3 bucket. When you
     * perform a <code>CreateExportTask</code> operation, you must use credentials that have permission to write to the
     * S3 bucket that you specify as the destination.
     * </p>
     * <p>
     * Exporting log data to S3 buckets that are encrypted by KMS is supported. Exporting log data to Amazon S3 buckets
     * that have S3 Object Lock enabled with a retention period is also supported.
     * </p>
     * <p>
     * Exporting to S3 buckets that are encrypted with AES-256 is supported.
     * </p>
     * <p>
     * This is an asynchronous call. If all the required information is provided, this operation initiates an export
     * task and responds with the ID of the task. After the task has started, you can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html"
     * >DescribeExportTasks</a> to get the status of the export task. Each account can only have one active (
     * <code>RUNNING</code> or <code>PENDING</code>) export task at a time. To cancel an export task, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html"
     * >CancelExportTask</a>.
     * </p>
     * <p>
     * You can export logs from multiple log groups or multiple time ranges to the same S3 bucket. To separate log data
     * for each export task, specify a prefix to be used as the Amazon S3 key prefix for all exported objects.
     * </p>
     * <note>
     * <p>
     * Time-based sorting on chunks of log data inside an exported file is not guaranteed. You can sort the exported log
     * field data by using Linux utilities.
     * </p>
     * </note>
     *
     * @param createExportTaskRequest
     * @return A Java Future containing the result of the CreateExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExportTaskResponse> createExportTask(CreateExportTaskRequest createExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an export task so that you can efficiently export data from a log group to an Amazon S3 bucket. When you
     * perform a <code>CreateExportTask</code> operation, you must use credentials that have permission to write to the
     * S3 bucket that you specify as the destination.
     * </p>
     * <p>
     * Exporting log data to S3 buckets that are encrypted by KMS is supported. Exporting log data to Amazon S3 buckets
     * that have S3 Object Lock enabled with a retention period is also supported.
     * </p>
     * <p>
     * Exporting to S3 buckets that are encrypted with AES-256 is supported.
     * </p>
     * <p>
     * This is an asynchronous call. If all the required information is provided, this operation initiates an export
     * task and responds with the ID of the task. After the task has started, you can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html"
     * >DescribeExportTasks</a> to get the status of the export task. Each account can only have one active (
     * <code>RUNNING</code> or <code>PENDING</code>) export task at a time. To cancel an export task, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html"
     * >CancelExportTask</a>.
     * </p>
     * <p>
     * You can export logs from multiple log groups or multiple time ranges to the same S3 bucket. To separate log data
     * for each export task, specify a prefix to be used as the Amazon S3 key prefix for all exported objects.
     * </p>
     * <note>
     * <p>
     * Time-based sorting on chunks of log data inside an exported file is not guaranteed. You can sort the exported log
     * field data by using Linux utilities.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExportTaskRequest#builder()}
     * </p>
     *
     * @param createExportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExportTaskResponse> createExportTask(
            Consumer<CreateExportTaskRequest.Builder> createExportTaskRequest) {
        return createExportTask(CreateExportTaskRequest.builder().applyMutation(createExportTaskRequest).build());
    }

    /**
     * <p>
     * Creates an <i>anomaly detector</i> that regularly scans one or more log groups and look for patterns and
     * anomalies in the logs.
     * </p>
     * <p>
     * An anomaly detector can help surface issues by automatically discovering anomalies in your log event traffic. An
     * anomaly detector uses machine learning algorithms to scan log events and find <i>patterns</i>. A pattern is a
     * shared text structure that recurs among your log fields. Patterns provide a useful tool for analyzing large sets
     * of logs because a large number of log events can often be compressed into a few patterns.
     * </p>
     * <p>
     * The anomaly detector uses pattern recognition to find <code>anomalies</code>, which are unusual log events. It
     * uses the <code>evaluationFrequency</code> to compare current log events and patterns with trained baselines.
     * </p>
     * <p>
     * Fields within a pattern are called <i>tokens</i>. Fields that vary within a pattern, such as a request ID or
     * timestamp, are referred to as <i>dynamic tokens</i> and represented by <code>&lt;*&gt;</code>.
     * </p>
     * <p>
     * The following is an example of a pattern:
     * </p>
     * <p>
     * <code>[INFO] Request time: &lt;*&gt; ms</code>
     * </p>
     * <p>
     * This pattern represents log events like <code>[INFO] Request time: 327 ms</code> and other similar log events
     * that differ only by the number, in this csse 327. When the pattern is displayed, the different numbers are
     * replaced by <code>&lt;*&gt;</code>
     * </p>
     * <note>
     * <p>
     * Any parts of log events that are masked as sensitive data are not scanned for anomalies. For more information
     * about masking sensitive data, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Help protect
     * sensitive log data with masking</a>.
     * </p>
     * </note>
     *
     * @param createLogAnomalyDetectorRequest
     * @return A Java Future containing the result of the CreateLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLogAnomalyDetectorResponse> createLogAnomalyDetector(
            CreateLogAnomalyDetectorRequest createLogAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>anomaly detector</i> that regularly scans one or more log groups and look for patterns and
     * anomalies in the logs.
     * </p>
     * <p>
     * An anomaly detector can help surface issues by automatically discovering anomalies in your log event traffic. An
     * anomaly detector uses machine learning algorithms to scan log events and find <i>patterns</i>. A pattern is a
     * shared text structure that recurs among your log fields. Patterns provide a useful tool for analyzing large sets
     * of logs because a large number of log events can often be compressed into a few patterns.
     * </p>
     * <p>
     * The anomaly detector uses pattern recognition to find <code>anomalies</code>, which are unusual log events. It
     * uses the <code>evaluationFrequency</code> to compare current log events and patterns with trained baselines.
     * </p>
     * <p>
     * Fields within a pattern are called <i>tokens</i>. Fields that vary within a pattern, such as a request ID or
     * timestamp, are referred to as <i>dynamic tokens</i> and represented by <code>&lt;*&gt;</code>.
     * </p>
     * <p>
     * The following is an example of a pattern:
     * </p>
     * <p>
     * <code>[INFO] Request time: &lt;*&gt; ms</code>
     * </p>
     * <p>
     * This pattern represents log events like <code>[INFO] Request time: 327 ms</code> and other similar log events
     * that differ only by the number, in this csse 327. When the pattern is displayed, the different numbers are
     * replaced by <code>&lt;*&gt;</code>
     * </p>
     * <note>
     * <p>
     * Any parts of log events that are masked as sensitive data are not scanned for anomalies. For more information
     * about masking sensitive data, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Help protect
     * sensitive log data with masking</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLogAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param createLogAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLogAnomalyDetectorResponse> createLogAnomalyDetector(
            Consumer<CreateLogAnomalyDetectorRequest.Builder> createLogAnomalyDetectorRequest) {
        return createLogAnomalyDetector(CreateLogAnomalyDetectorRequest.builder().applyMutation(createLogAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Creates a log group with the specified name. You can create up to 1,000,000 log groups per Region per account.
     * </p>
     * <p>
     * You must use the following guidelines when naming a log group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Log group names must be unique within a Region for an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names can be between 1 and 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward
     * slash), '.' (period), and '#' (number sign)
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names can't start with the string <code>aws/</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you create a log group, by default the log events in the log group do not expire. To set a retention policy
     * so that events expire and are deleted after a specified time, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html"
     * >PutRetentionPolicy</a>.
     * </p>
     * <p>
     * If you associate an KMS key with the log group, ingested data is encrypted using the KMS key. This association is
     * stored as long as the data encrypted with the KMS key is still within CloudWatch Logs. This enables CloudWatch
     * Logs to decrypt this data whenever it is requested.
     * </p>
     * <p>
     * If you attempt to associate a KMS key with the log group but the KMS key does not exist or the KMS key is
     * disabled, you receive an <code>InvalidParameterException</code> error.
     * </p>
     * <important>
     * <p>
     * CloudWatch Logs supports only symmetric KMS keys. Do not associate an asymmetric KMS key with your log group. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and
     * Asymmetric Keys</a>.
     * </p>
     * </important>
     *
     * @param createLogGroupRequest
     * @return A Java Future containing the result of the CreateLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLogGroupResponse> createLogGroup(CreateLogGroupRequest createLogGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a log group with the specified name. You can create up to 1,000,000 log groups per Region per account.
     * </p>
     * <p>
     * You must use the following guidelines when naming a log group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Log group names must be unique within a Region for an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names can be between 1 and 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward
     * slash), '.' (period), and '#' (number sign)
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names can't start with the string <code>aws/</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you create a log group, by default the log events in the log group do not expire. To set a retention policy
     * so that events expire and are deleted after a specified time, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html"
     * >PutRetentionPolicy</a>.
     * </p>
     * <p>
     * If you associate an KMS key with the log group, ingested data is encrypted using the KMS key. This association is
     * stored as long as the data encrypted with the KMS key is still within CloudWatch Logs. This enables CloudWatch
     * Logs to decrypt this data whenever it is requested.
     * </p>
     * <p>
     * If you attempt to associate a KMS key with the log group but the KMS key does not exist or the KMS key is
     * disabled, you receive an <code>InvalidParameterException</code> error.
     * </p>
     * <important>
     * <p>
     * CloudWatch Logs supports only symmetric KMS keys. Do not associate an asymmetric KMS key with your log group. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and
     * Asymmetric Keys</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLogGroupRequest#builder()}
     * </p>
     *
     * @param createLogGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLogGroupResponse> createLogGroup(Consumer<CreateLogGroupRequest.Builder> createLogGroupRequest) {
        return createLogGroup(CreateLogGroupRequest.builder().applyMutation(createLogGroupRequest).build());
    }

    /**
     * <p>
     * Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a
     * single source, such as an application instance or a resource that is being monitored.
     * </p>
     * <p>
     * There is no limit on the number of log streams that you can create for a log group. There is a limit of 50 TPS on
     * <code>CreateLogStream</code> operations, after which transactions are throttled.
     * </p>
     * <p>
     * You must use the following guidelines when naming a log stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Log stream names must be unique within the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log stream names can be between 1 and 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Don't use ':' (colon) or '*' (asterisk) characters.
     * </p>
     * </li>
     * </ul>
     *
     * @param createLogStreamRequest
     * @return A Java Future containing the result of the CreateLogStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateLogStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLogStreamResponse> createLogStream(CreateLogStreamRequest createLogStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a
     * single source, such as an application instance or a resource that is being monitored.
     * </p>
     * <p>
     * There is no limit on the number of log streams that you can create for a log group. There is a limit of 50 TPS on
     * <code>CreateLogStream</code> operations, after which transactions are throttled.
     * </p>
     * <p>
     * You must use the following guidelines when naming a log stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Log stream names must be unique within the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log stream names can be between 1 and 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Don't use ':' (colon) or '*' (asterisk) characters.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogStreamRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLogStreamRequest#builder()}
     * </p>
     *
     * @param createLogStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLogStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.CreateLogStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLogStreamResponse> createLogStream(
            Consumer<CreateLogStreamRequest.Builder> createLogStreamRequest) {
        return createLogStream(CreateLogStreamRequest.builder().applyMutation(createLogStreamRequest).build());
    }

    /**
     * <p>
     * Deletes a CloudWatch Logs account policy. This stops the account-wide policy from applying to log groups in the
     * account. If you delete a data protection policy or subscription filter policy, any log-group level policies of
     * those types remain in effect.
     * </p>
     * <p>
     * To use this operation, you must be signed on with the correct permissions depending on the type of policy that
     * you are deleting.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To delete a data protection policy, you must have the <code>logs:DeleteDataProtectionPolicy</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a subscription filter policy, you must have the <code>logs:DeleteSubscriptionFilter</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a transformer policy, you must have the <code>logs:DeleteTransformer</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a field index policy, you must have the <code>logs:DeleteIndexPolicy</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you delete a field index policy, the indexing of the log events that happened before you deleted the policy
     * will still be used for up to 30 days to improve CloudWatch Logs Insights queries.
     * </p>
     *
     * @param deleteAccountPolicyRequest
     * @return A Java Future containing the result of the DeleteAccountPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteAccountPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteAccountPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountPolicyResponse> deleteAccountPolicy(
            DeleteAccountPolicyRequest deleteAccountPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CloudWatch Logs account policy. This stops the account-wide policy from applying to log groups in the
     * account. If you delete a data protection policy or subscription filter policy, any log-group level policies of
     * those types remain in effect.
     * </p>
     * <p>
     * To use this operation, you must be signed on with the correct permissions depending on the type of policy that
     * you are deleting.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To delete a data protection policy, you must have the <code>logs:DeleteDataProtectionPolicy</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a subscription filter policy, you must have the <code>logs:DeleteSubscriptionFilter</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a transformer policy, you must have the <code>logs:DeleteTransformer</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a field index policy, you must have the <code>logs:DeleteIndexPolicy</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you delete a field index policy, the indexing of the log events that happened before you deleted the policy
     * will still be used for up to 30 days to improve CloudWatch Logs Insights queries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccountPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccountPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAccountPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteAccountPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteAccountPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountPolicyResponse> deleteAccountPolicy(
            Consumer<DeleteAccountPolicyRequest.Builder> deleteAccountPolicyRequest) {
        return deleteAccountPolicy(DeleteAccountPolicyRequest.builder().applyMutation(deleteAccountPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the data protection policy from the specified log group.
     * </p>
     * <p>
     * For more information about data protection policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html"
     * >PutDataProtectionPolicy</a>.
     * </p>
     *
     * @param deleteDataProtectionPolicyRequest
     * @return A Java Future containing the result of the DeleteDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDataProtectionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataProtectionPolicyResponse> deleteDataProtectionPolicy(
            DeleteDataProtectionPolicyRequest deleteDataProtectionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the data protection policy from the specified log group.
     * </p>
     * <p>
     * For more information about data protection policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html"
     * >PutDataProtectionPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataProtectionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataProtectionPolicyRequest#builder()}
     * </p>
     *
     * @param deleteDataProtectionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDataProtectionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataProtectionPolicyResponse> deleteDataProtectionPolicy(
            Consumer<DeleteDataProtectionPolicyRequest.Builder> deleteDataProtectionPolicyRequest) {
        return deleteDataProtectionPolicy(DeleteDataProtectionPolicyRequest.builder()
                .applyMutation(deleteDataProtectionPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes s <i>delivery</i>. A delivery is a connection between a logical <i>delivery source</i> and a logical
     * <i>delivery destination</i>. Deleting a delivery only deletes the connection between the delivery source and
     * delivery destination. It does not delete the delivery destination or the delivery source.
     * </p>
     *
     * @param deleteDeliveryRequest
     * @return A Java Future containing the result of the DeleteDelivery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryResponse> deleteDelivery(DeleteDeliveryRequest deleteDeliveryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes s <i>delivery</i>. A delivery is a connection between a logical <i>delivery source</i> and a logical
     * <i>delivery destination</i>. Deleting a delivery only deletes the connection between the delivery source and
     * delivery destination. It does not delete the delivery destination or the delivery source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliveryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeliveryRequest#builder()}
     * </p>
     *
     * @param deleteDeliveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDelivery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryResponse> deleteDelivery(Consumer<DeleteDeliveryRequest.Builder> deleteDeliveryRequest) {
        return deleteDelivery(DeleteDeliveryRequest.builder().applyMutation(deleteDeliveryRequest).build());
    }

    /**
     * <p>
     * Deletes a <i>delivery destination</i>. A delivery is a connection between a logical <i>delivery source</i> and a
     * logical <i>delivery destination</i>.
     * </p>
     * <p>
     * You can't delete a delivery destination if any current deliveries are associated with it. To find whether any
     * deliveries are associated with this delivery destination, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation and check the <code>deliveryDestinationArn</code> field in the results.
     * </p>
     *
     * @param deleteDeliveryDestinationRequest
     * @return A Java Future containing the result of the DeleteDeliveryDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliveryDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryDestinationResponse> deleteDeliveryDestination(
            DeleteDeliveryDestinationRequest deleteDeliveryDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <i>delivery destination</i>. A delivery is a connection between a logical <i>delivery source</i> and a
     * logical <i>delivery destination</i>.
     * </p>
     * <p>
     * You can't delete a delivery destination if any current deliveries are associated with it. To find whether any
     * deliveries are associated with this delivery destination, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation and check the <code>deliveryDestinationArn</code> field in the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliveryDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDeliveryDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDeliveryDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDeliveryDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliveryDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryDestinationResponse> deleteDeliveryDestination(
            Consumer<DeleteDeliveryDestinationRequest.Builder> deleteDeliveryDestinationRequest) {
        return deleteDeliveryDestination(DeleteDeliveryDestinationRequest.builder()
                .applyMutation(deleteDeliveryDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a delivery destination policy. For more information about these policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a>.
     * </p>
     *
     * @param deleteDeliveryDestinationPolicyRequest
     * @return A Java Future containing the result of the DeleteDeliveryDestinationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryDestinationPolicyResponse> deleteDeliveryDestinationPolicy(
            DeleteDeliveryDestinationPolicyRequest deleteDeliveryDestinationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a delivery destination policy. For more information about these policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliveryDestinationPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDeliveryDestinationPolicyRequest#builder()}
     * </p>
     *
     * @param deleteDeliveryDestinationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteDeliveryDestinationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryDestinationPolicyResponse> deleteDeliveryDestinationPolicy(
            Consumer<DeleteDeliveryDestinationPolicyRequest.Builder> deleteDeliveryDestinationPolicyRequest) {
        return deleteDeliveryDestinationPolicy(DeleteDeliveryDestinationPolicyRequest.builder()
                .applyMutation(deleteDeliveryDestinationPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a <i>delivery source</i>. A delivery is a connection between a logical <i>delivery source</i> and a
     * logical <i>delivery destination</i>.
     * </p>
     * <p>
     * You can't delete a delivery source if any current deliveries are associated with it. To find whether any
     * deliveries are associated with this delivery source, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation and check the <code>deliverySourceName</code> field in the results.
     * </p>
     *
     * @param deleteDeliverySourceRequest
     * @return A Java Future containing the result of the DeleteDeliverySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeliverySourceResponse> deleteDeliverySource(
            DeleteDeliverySourceRequest deleteDeliverySourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <i>delivery source</i>. A delivery is a connection between a logical <i>delivery source</i> and a
     * logical <i>delivery destination</i>.
     * </p>
     * <p>
     * You can't delete a delivery source if any current deliveries are associated with it. To find whether any
     * deliveries are associated with this delivery source, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation and check the <code>deliverySourceName</code> field in the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliverySourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeliverySourceRequest#builder()}
     * </p>
     *
     * @param deleteDeliverySourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteDeliverySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeliverySourceResponse> deleteDeliverySource(
            Consumer<DeleteDeliverySourceRequest.Builder> deleteDeliverySourceRequest) {
        return deleteDeliverySource(DeleteDeliverySourceRequest.builder().applyMutation(deleteDeliverySourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This
     * operation does not delete the physical resource encapsulated by the destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDestination" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This
     * operation does not delete the physical resource encapsulated by the destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDestination" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(
            Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest) {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a log-group level field index policy that was applied to a single log group. The indexing of the log
     * events that happened before you delete the policy will still be used for as many as 30 days to improve CloudWatch
     * Logs Insights queries.
     * </p>
     * <p>
     * You can't use this operation to delete an account-level index policy. Instead, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteAccountPolicy.html"
     * >DeletAccountPolicy</a>.
     * </p>
     * <p>
     * If you delete a log-group level field index policy and there is an account-level field index policy, in a few
     * minutes the log group begins using that account-wide policy to index new incoming log events.
     * </p>
     *
     * @param deleteIndexPolicyRequest
     * @return A Java Future containing the result of the DeleteIndexPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteIndexPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteIndexPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexPolicyResponse> deleteIndexPolicy(DeleteIndexPolicyRequest deleteIndexPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a log-group level field index policy that was applied to a single log group. The indexing of the log
     * events that happened before you delete the policy will still be used for as many as 30 days to improve CloudWatch
     * Logs Insights queries.
     * </p>
     * <p>
     * You can't use this operation to delete an account-level index policy. Instead, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteAccountPolicy.html"
     * >DeletAccountPolicy</a>.
     * </p>
     * <p>
     * If you delete a log-group level field index policy and there is an account-level field index policy, in a few
     * minutes the log group begins using that account-wide policy to index new incoming log events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIndexPolicyRequest#builder()}
     * </p>
     *
     * @param deleteIndexPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIndexPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteIndexPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteIndexPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexPolicyResponse> deleteIndexPolicy(
            Consumer<DeleteIndexPolicyRequest.Builder> deleteIndexPolicyRequest) {
        return deleteIndexPolicy(DeleteIndexPolicyRequest.builder().applyMutation(deleteIndexPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified CloudWatch Logs anomaly detector.
     * </p>
     *
     * @param deleteLogAnomalyDetectorRequest
     * @return A Java Future containing the result of the DeleteLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLogAnomalyDetectorResponse> deleteLogAnomalyDetector(
            DeleteLogAnomalyDetectorRequest deleteLogAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified CloudWatch Logs anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLogAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLogAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param deleteLogAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLogAnomalyDetectorResponse> deleteLogAnomalyDetector(
            Consumer<DeleteLogAnomalyDetectorRequest.Builder> deleteLogAnomalyDetectorRequest) {
        return deleteLogAnomalyDetector(DeleteLogAnomalyDetectorRequest.builder().applyMutation(deleteLogAnomalyDetectorRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified log group and permanently deletes all the archived log events associated with the log
     * group.
     * </p>
     *
     * @param deleteLogGroupRequest
     * @return A Java Future containing the result of the DeleteLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLogGroupResponse> deleteLogGroup(DeleteLogGroupRequest deleteLogGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified log group and permanently deletes all the archived log events associated with the log
     * group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLogGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLogGroupRequest#builder()}
     * </p>
     *
     * @param deleteLogGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLogGroupResponse> deleteLogGroup(Consumer<DeleteLogGroupRequest.Builder> deleteLogGroupRequest) {
        return deleteLogGroup(DeleteLogGroupRequest.builder().applyMutation(deleteLogGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified log stream and permanently deletes all the archived log events associated with the log
     * stream.
     * </p>
     *
     * @param deleteLogStreamRequest
     * @return A Java Future containing the result of the DeleteLogStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteLogStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLogStreamResponse> deleteLogStream(DeleteLogStreamRequest deleteLogStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified log stream and permanently deletes all the archived log events associated with the log
     * stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLogStreamRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLogStreamRequest#builder()}
     * </p>
     *
     * @param deleteLogStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLogStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteLogStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLogStreamResponse> deleteLogStream(
            Consumer<DeleteLogStreamRequest.Builder> deleteLogStreamRequest) {
        return deleteLogStream(DeleteLogStreamRequest.builder().applyMutation(deleteLogStreamRequest).build());
    }

    /**
     * <p>
     * Deletes the specified metric filter.
     * </p>
     *
     * @param deleteMetricFilterRequest
     * @return A Java Future containing the result of the DeleteMetricFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMetricFilterResponse> deleteMetricFilter(DeleteMetricFilterRequest deleteMetricFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified metric filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMetricFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMetricFilterRequest#builder()}
     * </p>
     *
     * @param deleteMetricFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMetricFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMetricFilterResponse> deleteMetricFilter(
            Consumer<DeleteMetricFilterRequest.Builder> deleteMetricFilterRequest) {
        return deleteMetricFilter(DeleteMetricFilterRequest.builder().applyMutation(deleteMetricFilterRequest).build());
    }

    /**
     * <p>
     * Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved
     * CloudWatch Logs Insights query.
     * </p>
     * <p>
     * Each <code>DeleteQueryDefinition</code> operation can delete one query definition.
     * </p>
     * <p>
     * You must have the <code>logs:DeleteQueryDefinition</code> permission to be able to perform this operation.
     * </p>
     *
     * @param deleteQueryDefinitionRequest
     * @return A Java Future containing the result of the DeleteQueryDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteQueryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteQueryDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteQueryDefinitionResponse> deleteQueryDefinition(
            DeleteQueryDefinitionRequest deleteQueryDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved
     * CloudWatch Logs Insights query.
     * </p>
     * <p>
     * Each <code>DeleteQueryDefinition</code> operation can delete one query definition.
     * </p>
     * <p>
     * You must have the <code>logs:DeleteQueryDefinition</code> permission to be able to perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueryDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQueryDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteQueryDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteQueryDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteQueryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteQueryDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteQueryDefinitionResponse> deleteQueryDefinition(
            Consumer<DeleteQueryDefinitionRequest.Builder> deleteQueryDefinitionRequest) {
        return deleteQueryDefinition(DeleteQueryDefinitionRequest.builder().applyMutation(deleteQueryDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log
     * events to this account.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log
     * events to this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified retention policy.
     * </p>
     * <p>
     * Log events do not expire if they belong to log groups without a retention policy.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return A Java Future containing the result of the DeleteRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(
            DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified retention policy.
     * </p>
     * <p>
     * Log events do not expire if they belong to log groups without a retention policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetentionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(
            Consumer<DeleteRetentionPolicyRequest.Builder> deleteRetentionPolicyRequest) {
        return deleteRetentionPolicy(DeleteRetentionPolicyRequest.builder().applyMutation(deleteRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified subscription filter.
     * </p>
     *
     * @param deleteSubscriptionFilterRequest
     * @return A Java Future containing the result of the DeleteSubscriptionFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteSubscriptionFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionFilterResponse> deleteSubscriptionFilter(
            DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified subscription filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionFilterRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionFilterRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSubscriptionFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteSubscriptionFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionFilterResponse> deleteSubscriptionFilter(
            Consumer<DeleteSubscriptionFilterRequest.Builder> deleteSubscriptionFilterRequest) {
        return deleteSubscriptionFilter(DeleteSubscriptionFilterRequest.builder().applyMutation(deleteSubscriptionFilterRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the log transformer for the specified log group. As soon as you do this, the transformation of incoming
     * log events according to that transformer stops. If this account has an account-level transformer that applies to
     * this log group, the log group begins using that account-level transformer when this log-group level transformer
     * is deleted.
     * </p>
     * <p>
     * After you delete a transformer, be sure to edit any metric filters or subscription filters that relied on the
     * transformed versions of the log events.
     * </p>
     *
     * @param deleteTransformerRequest
     * @return A Java Future containing the result of the DeleteTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTransformerResponse> deleteTransformer(DeleteTransformerRequest deleteTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the log transformer for the specified log group. As soon as you do this, the transformation of incoming
     * log events according to that transformer stops. If this account has an account-level transformer that applies to
     * this log group, the log group begins using that account-level transformer when this log-group level transformer
     * is deleted.
     * </p>
     * <p>
     * After you delete a transformer, be sure to edit any metric filters or subscription filters that relied on the
     * transformed versions of the log events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTransformerRequest#builder()}
     * </p>
     *
     * @param deleteTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTransformerResponse> deleteTransformer(
            Consumer<DeleteTransformerRequest.Builder> deleteTransformerRequest) {
        return deleteTransformer(DeleteTransformerRequest.builder().applyMutation(deleteTransformerRequest).build());
    }

    /**
     * <p>
     * Returns a list of all CloudWatch Logs account policies in the account.
     * </p>
     *
     * @param describeAccountPoliciesRequest
     * @return A Java Future containing the result of the DescribeAccountPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeAccountPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeAccountPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountPoliciesResponse> describeAccountPolicies(
            DescribeAccountPoliciesRequest describeAccountPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all CloudWatch Logs account policies in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountPoliciesRequest#builder()}
     * </p>
     *
     * @param describeAccountPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAccountPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeAccountPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeAccountPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountPoliciesResponse> describeAccountPolicies(
            Consumer<DescribeAccountPoliciesRequest.Builder> describeAccountPoliciesRequest) {
        return describeAccountPolicies(DescribeAccountPoliciesRequest.builder().applyMutation(describeAccountPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Use this operation to return the valid and default values that are used when creating delivery sources, delivery
     * destinations, and deliveries. For more information about deliveries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     *
     * @param describeConfigurationTemplatesRequest
     * @return A Java Future containing the result of the DescribeConfigurationTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationTemplatesResponse> describeConfigurationTemplates(
            DescribeConfigurationTemplatesRequest describeConfigurationTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to return the valid and default values that are used when creating delivery sources, delivery
     * destinations, and deliveries. For more information about deliveries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeConfigurationTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationTemplatesResponse> describeConfigurationTemplates(
            Consumer<DescribeConfigurationTemplatesRequest.Builder> describeConfigurationTemplatesRequest) {
        return describeConfigurationTemplates(DescribeConfigurationTemplatesRequest.builder()
                .applyMutation(describeConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationTemplates(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeConfigurationTemplatesPublisher publisher = client.describeConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeConfigurationTemplatesPublisher publisher = client.describeConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationTemplates(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationTemplatesPublisher describeConfigurationTemplatesPaginator(
            DescribeConfigurationTemplatesRequest describeConfigurationTemplatesRequest) {
        return new DescribeConfigurationTemplatesPublisher(this, describeConfigurationTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationTemplates(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeConfigurationTemplatesPublisher publisher = client.describeConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeConfigurationTemplatesPublisher publisher = client.describeConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationTemplates(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationTemplatesPublisher describeConfigurationTemplatesPaginator(
            Consumer<DescribeConfigurationTemplatesRequest.Builder> describeConfigurationTemplatesRequest) {
        return describeConfigurationTemplatesPaginator(DescribeConfigurationTemplatesRequest.builder()
                .applyMutation(describeConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the deliveries that have been created in the account.
     * </p>
     * <p>
     * A <i>delivery</i> is a connection between a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html">
     * <i>delivery source</i> </a> and a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html">
     * <i>delivery destination</i> </a>.
     * </p>
     * <p>
     * A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The
     * destination can be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web Services services support being
     * configured as a delivery source. These services are listed in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>
     * </p>
     *
     * @param describeDeliveriesRequest
     * @return A Java Future containing the result of the DescribeDeliveries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeliveriesResponse> describeDeliveries(DescribeDeliveriesRequest describeDeliveriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the deliveries that have been created in the account.
     * </p>
     * <p>
     * A <i>delivery</i> is a connection between a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html">
     * <i>delivery source</i> </a> and a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html">
     * <i>delivery destination</i> </a>.
     * </p>
     * <p>
     * A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The
     * destination can be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web Services services support being
     * configured as a delivery source. These services are listed in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeliveriesRequest#builder()}
     * </p>
     *
     * @param describeDeliveriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDeliveries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeliveriesResponse> describeDeliveries(
            Consumer<DescribeDeliveriesRequest.Builder> describeDeliveriesRequest) {
        return describeDeliveries(DescribeDeliveriesRequest.builder().applyMutation(describeDeliveriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDeliveries(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveriesPublisher publisher = client.describeDeliveriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveriesPublisher publisher = client.describeDeliveriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDeliveries(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDeliveriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveries" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeliveriesPublisher describeDeliveriesPaginator(DescribeDeliveriesRequest describeDeliveriesRequest) {
        return new DescribeDeliveriesPublisher(this, describeDeliveriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDeliveries(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveriesPublisher publisher = client.describeDeliveriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveriesPublisher publisher = client.describeDeliveriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDeliveries(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeliveriesRequest#builder()}
     * </p>
     *
     * @param describeDeliveriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveries" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeliveriesPublisher describeDeliveriesPaginator(
            Consumer<DescribeDeliveriesRequest.Builder> describeDeliveriesRequest) {
        return describeDeliveriesPaginator(DescribeDeliveriesRequest.builder().applyMutation(describeDeliveriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the delivery destinations that have been created in the account.
     * </p>
     *
     * @param describeDeliveryDestinationsRequest
     * @return A Java Future containing the result of the DescribeDeliveryDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveryDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveryDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryDestinationsResponse> describeDeliveryDestinations(
            DescribeDeliveryDestinationsRequest describeDeliveryDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the delivery destinations that have been created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryDestinationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDeliveryDestinationsRequest#builder()}
     * </p>
     *
     * @param describeDeliveryDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeDeliveryDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveryDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveryDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryDestinationsResponse> describeDeliveryDestinations(
            Consumer<DescribeDeliveryDestinationsRequest.Builder> describeDeliveryDestinationsRequest) {
        return describeDeliveryDestinations(DescribeDeliveryDestinationsRequest.builder()
                .applyMutation(describeDeliveryDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDeliveryDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveryDestinationsPublisher publisher = client.describeDeliveryDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveryDestinationsPublisher publisher = client.describeDeliveryDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDeliveryDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDeliveryDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveryDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveryDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryDestinationsPublisher describeDeliveryDestinationsPaginator(
            DescribeDeliveryDestinationsRequest describeDeliveryDestinationsRequest) {
        return new DescribeDeliveryDestinationsPublisher(this, describeDeliveryDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDeliveryDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveryDestinationsPublisher publisher = client.describeDeliveryDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliveryDestinationsPublisher publisher = client.describeDeliveryDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDeliveryDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryDestinationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDeliveryDestinationsRequest#builder()}
     * </p>
     *
     * @param describeDeliveryDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliveryDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveryDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryDestinationsPublisher describeDeliveryDestinationsPaginator(
            Consumer<DescribeDeliveryDestinationsRequest.Builder> describeDeliveryDestinationsRequest) {
        return describeDeliveryDestinationsPaginator(DescribeDeliveryDestinationsRequest.builder()
                .applyMutation(describeDeliveryDestinationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the delivery sources that have been created in the account.
     * </p>
     *
     * @param describeDeliverySourcesRequest
     * @return A Java Future containing the result of the DescribeDeliverySources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliverySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliverySources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDeliverySourcesResponse> describeDeliverySources(
            DescribeDeliverySourcesRequest describeDeliverySourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the delivery sources that have been created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliverySourcesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeliverySourcesRequest#builder()}
     * </p>
     *
     * @param describeDeliverySourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDeliverySources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliverySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliverySources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDeliverySourcesResponse> describeDeliverySources(
            Consumer<DescribeDeliverySourcesRequest.Builder> describeDeliverySourcesRequest) {
        return describeDeliverySources(DescribeDeliverySourcesRequest.builder().applyMutation(describeDeliverySourcesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDeliverySources(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliverySourcesPublisher publisher = client.describeDeliverySourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliverySourcesPublisher publisher = client.describeDeliverySourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDeliverySources(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDeliverySourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliverySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliverySources" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDeliverySourcesPublisher describeDeliverySourcesPaginator(
            DescribeDeliverySourcesRequest describeDeliverySourcesRequest) {
        return new DescribeDeliverySourcesPublisher(this, describeDeliverySourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDeliverySources(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliverySourcesPublisher publisher = client.describeDeliverySourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDeliverySourcesPublisher publisher = client.describeDeliverySourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDeliverySources(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliverySourcesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeliverySourcesRequest#builder()}
     * </p>
     *
     * @param describeDeliverySourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDeliverySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliverySources" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDeliverySourcesPublisher describeDeliverySourcesPaginator(
            Consumer<DescribeDeliverySourcesRequest.Builder> describeDeliverySourcesRequest) {
        return describeDeliverySourcesPaginator(DescribeDeliverySourcesRequest.builder()
                .applyMutation(describeDeliverySourcesRequest).build());
    }

    /**
     * <p>
     * Lists all your destinations. The results are ASCII-sorted by destination name.
     * </p>
     *
     * @param describeDestinationsRequest
     * @return A Java Future containing the result of the DescribeDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDestinationsResponse> describeDestinations(
            DescribeDestinationsRequest describeDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all your destinations. The results are ASCII-sorted by destination name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDestinationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDestinationsRequest#builder()}
     * </p>
     *
     * @param describeDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDestinationsResponse> describeDestinations(
            Consumer<DescribeDestinationsRequest.Builder> describeDestinationsRequest) {
        return describeDestinations(DescribeDestinationsRequest.builder().applyMutation(describeDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists all your destinations. The results are ASCII-sorted by destination name.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDestinationsResponse> describeDestinations() {
        return describeDestinations(DescribeDestinationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher publisher = client.describeDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher publisher = client.describeDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDestinationsPublisher describeDestinationsPaginator() {
        return describeDestinationsPaginator(DescribeDestinationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher publisher = client.describeDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher publisher = client.describeDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDestinationsPublisher describeDestinationsPaginator(DescribeDestinationsRequest describeDestinationsRequest) {
        return new DescribeDestinationsPublisher(this, describeDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher publisher = client.describeDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeDestinationsPublisher publisher = client.describeDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDestinations(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDestinationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDestinationsRequest#builder()}
     * </p>
     *
     * @param describeDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDestinationsPublisher describeDestinationsPaginator(
            Consumer<DescribeDestinationsRequest.Builder> describeDestinationsRequest) {
        return describeDestinationsPaginator(DescribeDestinationsRequest.builder().applyMutation(describeDestinationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or
     * task status.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            DescribeExportTasksRequest describeExportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or
     * task status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) {
        return describeExportTasks(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest).build());
    }

    /**
     * <p>
     * Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or
     * task status.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks() {
        return describeExportTasks(DescribeExportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of field indexes listed in the field index policies of one or more log groups. For more
     * information about field index policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a>.
     * </p>
     *
     * @param describeFieldIndexesRequest
     * @return A Java Future containing the result of the DescribeFieldIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeFieldIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeFieldIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFieldIndexesResponse> describeFieldIndexes(
            DescribeFieldIndexesRequest describeFieldIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of field indexes listed in the field index policies of one or more log groups. For more
     * information about field index policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFieldIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFieldIndexesRequest#builder()}
     * </p>
     *
     * @param describeFieldIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeFieldIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeFieldIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeFieldIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFieldIndexesResponse> describeFieldIndexes(
            Consumer<DescribeFieldIndexesRequest.Builder> describeFieldIndexesRequest) {
        return describeFieldIndexes(DescribeFieldIndexesRequest.builder().applyMutation(describeFieldIndexesRequest).build());
    }

    /**
     * <p>
     * Returns the field index policies of one or more log groups. For more information about field index policies, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html">
     * PutIndexPolicy</a>.
     * </p>
     * <p>
     * If a specified log group has a log-group level index policy, that policy is returned by this operation.
     * </p>
     * <p>
     * If a specified log group doesn't have a log-group level index policy, but an account-wide index policy applies to
     * it, that account-wide policy is returned by this operation.
     * </p>
     * <p>
     * To find information about only account-level policies, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html"
     * >DescribeAccountPolicies</a> instead.
     * </p>
     *
     * @param describeIndexPoliciesRequest
     * @return A Java Future containing the result of the DescribeIndexPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeIndexPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeIndexPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIndexPoliciesResponse> describeIndexPolicies(
            DescribeIndexPoliciesRequest describeIndexPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the field index policies of one or more log groups. For more information about field index policies, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html">
     * PutIndexPolicy</a>.
     * </p>
     * <p>
     * If a specified log group has a log-group level index policy, that policy is returned by this operation.
     * </p>
     * <p>
     * If a specified log group doesn't have a log-group level index policy, but an account-wide index policy applies to
     * it, that account-wide policy is returned by this operation.
     * </p>
     * <p>
     * To find information about only account-level policies, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html"
     * >DescribeAccountPolicies</a> instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIndexPoliciesRequest#builder()}
     * </p>
     *
     * @param describeIndexPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeIndexPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeIndexPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeIndexPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIndexPoliciesResponse> describeIndexPolicies(
            Consumer<DescribeIndexPoliciesRequest.Builder> describeIndexPoliciesRequest) {
        return describeIndexPolicies(DescribeIndexPoliciesRequest.builder().applyMutation(describeIndexPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are
     * ASCII-sorted by log group name.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that control access to the <code>DescribeLogGroups</code> action by
     * using the <code>aws:ResourceTag/<i>key-name</i> </code> condition key. Other CloudWatch Logs actions do support
     * the use of the <code>aws:ResourceTag/<i>key-name</i> </code> condition key to control access. For more
     * information about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param describeLogGroupsRequest
     * @return A Java Future containing the result of the DescribeLogGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLogGroupsResponse> describeLogGroups(DescribeLogGroupsRequest describeLogGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are
     * ASCII-sorted by log group name.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that control access to the <code>DescribeLogGroups</code> action by
     * using the <code>aws:ResourceTag/<i>key-name</i> </code> condition key. Other CloudWatch Logs actions do support
     * the use of the <code>aws:ResourceTag/<i>key-name</i> </code> condition key to control access. For more
     * information about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLogGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeLogGroupsRequest#builder()}
     * </p>
     *
     * @param describeLogGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLogGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLogGroupsResponse> describeLogGroups(
            Consumer<DescribeLogGroupsRequest.Builder> describeLogGroupsRequest) {
        return describeLogGroups(DescribeLogGroupsRequest.builder().applyMutation(describeLogGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are
     * ASCII-sorted by log group name.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that control access to the <code>DescribeLogGroups</code> action by
     * using the <code>aws:ResourceTag/<i>key-name</i> </code> condition key. Other CloudWatch Logs actions do support
     * the use of the <code>aws:ResourceTag/<i>key-name</i> </code> condition key to control access. For more
     * information about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeLogGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLogGroupsResponse> describeLogGroups() {
        return describeLogGroups(DescribeLogGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLogGroups(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher publisher = client.describeLogGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher publisher = client.describeLogGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLogGroups(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLogGroupsPublisher describeLogGroupsPaginator() {
        return describeLogGroupsPaginator(DescribeLogGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLogGroups(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher publisher = client.describeLogGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher publisher = client.describeLogGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLogGroups(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLogGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLogGroupsPublisher describeLogGroupsPaginator(DescribeLogGroupsRequest describeLogGroupsRequest) {
        return new DescribeLogGroupsPublisher(this, describeLogGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLogGroups(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher publisher = client.describeLogGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsPublisher publisher = client.describeLogGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLogGroups(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLogGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeLogGroupsRequest#builder()}
     * </p>
     *
     * @param describeLogGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLogGroupsPublisher describeLogGroupsPaginator(
            Consumer<DescribeLogGroupsRequest.Builder> describeLogGroupsRequest) {
        return describeLogGroupsPaginator(DescribeLogGroupsRequest.builder().applyMutation(describeLogGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the log streams for the specified log group. You can list all the log streams or filter the results by
     * prefix. You can also control how the results are ordered.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <p>
     * This operation has a limit of five transactions per second, after which transactions are throttled.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param describeLogStreamsRequest
     * @return A Java Future containing the result of the DescribeLogStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLogStreamsResponse> describeLogStreams(DescribeLogStreamsRequest describeLogStreamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the log streams for the specified log group. You can list all the log streams or filter the results by
     * prefix. You can also control how the results are ordered.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <p>
     * This operation has a limit of five transactions per second, after which transactions are throttled.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLogStreamsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLogStreamsRequest#builder()}
     * </p>
     *
     * @param describeLogStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLogStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLogStreamsResponse> describeLogStreams(
            Consumer<DescribeLogStreamsRequest.Builder> describeLogStreamsRequest) {
        return describeLogStreams(DescribeLogStreamsRequest.builder().applyMutation(describeLogStreamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLogStreams(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsPublisher publisher = client.describeLogStreamsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsPublisher publisher = client.describeLogStreamsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLogStreams(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLogStreamsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLogStreamsPublisher describeLogStreamsPaginator(DescribeLogStreamsRequest describeLogStreamsRequest) {
        return new DescribeLogStreamsPublisher(this, describeLogStreamsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeLogStreams(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsPublisher publisher = client.describeLogStreamsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsPublisher publisher = client.describeLogStreamsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLogStreams(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLogStreamsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLogStreamsRequest#builder()}
     * </p>
     *
     * @param describeLogStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeLogStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLogStreamsPublisher describeLogStreamsPaginator(
            Consumer<DescribeLogStreamsRequest.Builder> describeLogStreamsRequest) {
        return describeLogStreamsPaginator(DescribeLogStreamsRequest.builder().applyMutation(describeLogStreamsRequest).build());
    }

    /**
     * <p>
     * Lists the specified metric filters. You can list all of the metric filters or filter the results by log name,
     * prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.
     * </p>
     *
     * @param describeMetricFiltersRequest
     * @return A Java Future containing the result of the DescribeMetricFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMetricFiltersResponse> describeMetricFilters(
            DescribeMetricFiltersRequest describeMetricFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified metric filters. You can list all of the metric filters or filter the results by log name,
     * prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetricFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMetricFiltersRequest#builder()}
     * </p>
     *
     * @param describeMetricFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMetricFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMetricFiltersResponse> describeMetricFilters(
            Consumer<DescribeMetricFiltersRequest.Builder> describeMetricFiltersRequest) {
        return describeMetricFilters(DescribeMetricFiltersRequest.builder().applyMutation(describeMetricFiltersRequest).build());
    }

    /**
     * <p>
     * Lists the specified metric filters. You can list all of the metric filters or filter the results by log name,
     * prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeMetricFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMetricFiltersResponse> describeMetricFilters() {
        return describeMetricFilters(DescribeMetricFiltersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetricFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher publisher = client.describeMetricFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher publisher = client.describeMetricFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetricFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMetricFiltersPublisher describeMetricFiltersPaginator() {
        return describeMetricFiltersPaginator(DescribeMetricFiltersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetricFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher publisher = client.describeMetricFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher publisher = client.describeMetricFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetricFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetricFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMetricFiltersPublisher describeMetricFiltersPaginator(
            DescribeMetricFiltersRequest describeMetricFiltersRequest) {
        return new DescribeMetricFiltersPublisher(this, describeMetricFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetricFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher publisher = client.describeMetricFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeMetricFiltersPublisher publisher = client.describeMetricFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetricFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetricFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMetricFiltersRequest#builder()}
     * </p>
     *
     * @param describeMetricFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMetricFiltersPublisher describeMetricFiltersPaginator(
            Consumer<DescribeMetricFiltersRequest.Builder> describeMetricFiltersRequest) {
        return describeMetricFiltersPaginator(DescribeMetricFiltersRequest.builder().applyMutation(describeMetricFiltersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of CloudWatch Logs Insights queries that are scheduled, running, or have been run recently in this
     * account. You can request all queries or limit it to queries of a specific log group or queries with a certain
     * status.
     * </p>
     *
     * @param describeQueriesRequest
     * @return A Java Future containing the result of the DescribeQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueriesResponse> describeQueries(DescribeQueriesRequest describeQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of CloudWatch Logs Insights queries that are scheduled, running, or have been run recently in this
     * account. You can request all queries or limit it to queries of a specific log group or queries with a certain
     * status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeQueriesRequest#builder()}
     * </p>
     *
     * @param describeQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueriesResponse> describeQueries(
            Consumer<DescribeQueriesRequest.Builder> describeQueriesRequest) {
        return describeQueries(DescribeQueriesRequest.builder().applyMutation(describeQueriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of CloudWatch Logs Insights queries that are scheduled, running, or have been run recently in this
     * account. You can request all queries or limit it to queries of a specific log group or queries with a certain
     * status.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueriesResponse> describeQueries() {
        return describeQueries(DescribeQueriesRequest.builder().build());
    }

    /**
     * <p>
     * This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions. You can
     * retrieve query definitions from the current account or from a source account that is linked to the current
     * account.
     * </p>
     * <p>
     * You can use the <code>queryDefinitionNamePrefix</code> parameter to limit the results to only the query
     * definitions that have names that start with a certain string.
     * </p>
     *
     * @param describeQueryDefinitionsRequest
     * @return A Java Future containing the result of the DescribeQueryDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeQueryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueryDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeQueryDefinitionsResponse> describeQueryDefinitions(
            DescribeQueryDefinitionsRequest describeQueryDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions. You can
     * retrieve query definitions from the current account or from a source account that is linked to the current
     * account.
     * </p>
     * <p>
     * You can use the <code>queryDefinitionNamePrefix</code> parameter to limit the results to only the query
     * definitions that have names that start with a certain string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueryDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeQueryDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeQueryDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeQueryDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeQueryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueryDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeQueryDefinitionsResponse> describeQueryDefinitions(
            Consumer<DescribeQueryDefinitionsRequest.Builder> describeQueryDefinitionsRequest) {
        return describeQueryDefinitions(DescribeQueryDefinitionsRequest.builder().applyMutation(describeQueryDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the resource policies in this account.
     * </p>
     *
     * @param describeResourcePoliciesRequest
     * @return A Java Future containing the result of the DescribeResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePoliciesResponse> describeResourcePolicies(
            DescribeResourcePoliciesRequest describeResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource policies in this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param describeResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePoliciesResponse> describeResourcePolicies(
            Consumer<DescribeResourcePoliciesRequest.Builder> describeResourcePoliciesRequest) {
        return describeResourcePolicies(DescribeResourcePoliciesRequest.builder().applyMutation(describeResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the resource policies in this account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePoliciesResponse> describeResourcePolicies() {
        return describeResourcePolicies(DescribeResourcePoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the subscription filters for the specified log group. You can list all the subscription filters or filter
     * the results by prefix. The results are ASCII-sorted by filter name.
     * </p>
     *
     * @param describeSubscriptionFiltersRequest
     * @return A Java Future containing the result of the DescribeSubscriptionFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeSubscriptionFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionFiltersResponse> describeSubscriptionFilters(
            DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the subscription filters for the specified log group. You can list all the subscription filters or filter
     * the results by prefix. The results are ASCII-sorted by filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscriptionFiltersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSubscriptionFiltersRequest#builder()}
     * </p>
     *
     * @param describeSubscriptionFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSubscriptionFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeSubscriptionFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionFiltersResponse> describeSubscriptionFilters(
            Consumer<DescribeSubscriptionFiltersRequest.Builder> describeSubscriptionFiltersRequest) {
        return describeSubscriptionFilters(DescribeSubscriptionFiltersRequest.builder()
                .applyMutation(describeSubscriptionFiltersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSubscriptionFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeSubscriptionFiltersPublisher publisher = client.describeSubscriptionFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeSubscriptionFiltersPublisher publisher = client.describeSubscriptionFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSubscriptionFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSubscriptionFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeSubscriptionFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSubscriptionFiltersPublisher describeSubscriptionFiltersPaginator(
            DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) {
        return new DescribeSubscriptionFiltersPublisher(this, describeSubscriptionFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSubscriptionFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeSubscriptionFiltersPublisher publisher = client.describeSubscriptionFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeSubscriptionFiltersPublisher publisher = client.describeSubscriptionFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSubscriptionFilters(software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscriptionFiltersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSubscriptionFiltersRequest#builder()}
     * </p>
     *
     * @param describeSubscriptionFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DescribeSubscriptionFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSubscriptionFiltersPublisher describeSubscriptionFiltersPaginator(
            Consumer<DescribeSubscriptionFiltersRequest.Builder> describeSubscriptionFiltersRequest) {
        return describeSubscriptionFiltersPaginator(DescribeSubscriptionFiltersRequest.builder()
                .applyMutation(describeSubscriptionFiltersRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified KMS key from the specified log group or from all CloudWatch Logs Insights query
     * results in the account.
     * </p>
     * <p>
     * When you use <code>DisassociateKmsKey</code>, you specify either the <code>logGroupName</code> parameter or the
     * <code>resourceIdentifier</code> parameter. You can't specify both of those parameters in the same operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>logGroupName</code> parameter to stop using the KMS key to encrypt future log events ingested
     * and stored in the log group. Instead, they will be encrypted with the default CloudWatch Logs method. The log
     * events that were ingested while the key was associated with the log group are still encrypted with that key.
     * Therefore, CloudWatch Logs will need permissions for the key whenever that data is accessed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the <code>resourceIdentifier</code> parameter with the <code>query-result</code> resource to stop using
     * the KMS key to encrypt the results of all future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in the account. They will instead be encrypted with the default CloudWatch Logs method. The results
     * from queries that ran while the key was associated with the account are still encrypted with that key. Therefore,
     * CloudWatch Logs will need permissions for the key whenever that data is accessed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It can take up to 5 minutes for this operation to take effect.
     * </p>
     *
     * @param disassociateKmsKeyRequest
     * @return A Java Future containing the result of the DisassociateKmsKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DisassociateKmsKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DisassociateKmsKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateKmsKeyResponse> disassociateKmsKey(DisassociateKmsKeyRequest disassociateKmsKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified KMS key from the specified log group or from all CloudWatch Logs Insights query
     * results in the account.
     * </p>
     * <p>
     * When you use <code>DisassociateKmsKey</code>, you specify either the <code>logGroupName</code> parameter or the
     * <code>resourceIdentifier</code> parameter. You can't specify both of those parameters in the same operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>logGroupName</code> parameter to stop using the KMS key to encrypt future log events ingested
     * and stored in the log group. Instead, they will be encrypted with the default CloudWatch Logs method. The log
     * events that were ingested while the key was associated with the log group are still encrypted with that key.
     * Therefore, CloudWatch Logs will need permissions for the key whenever that data is accessed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the <code>resourceIdentifier</code> parameter with the <code>query-result</code> resource to stop using
     * the KMS key to encrypt the results of all future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in the account. They will instead be encrypted with the default CloudWatch Logs method. The results
     * from queries that ran while the key was associated with the account are still encrypted with that key. Therefore,
     * CloudWatch Logs will need permissions for the key whenever that data is accessed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It can take up to 5 minutes for this operation to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateKmsKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateKmsKeyRequest#builder()}
     * </p>
     *
     * @param disassociateKmsKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateKmsKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.DisassociateKmsKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DisassociateKmsKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateKmsKeyResponse> disassociateKmsKey(
            Consumer<DisassociateKmsKeyRequest.Builder> disassociateKmsKeyRequest) {
        return disassociateKmsKey(DisassociateKmsKeyRequest.builder().applyMutation(disassociateKmsKeyRequest).build());
    }

    /**
     * <p>
     * Lists log events from the specified log group. You can list all the log events or filter the results using a
     * filter pattern, a time range, and the name of the log stream.
     * </p>
     * <p>
     * You must have the <code>logs:FilterLogEvents</code> permission to perform this operation.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <p>
     * By default, this operation returns as many log events as can fit in 1 MB (up to 10,000 log events) or all the
     * events found within the specified time range. If the results include a token, that means there are more log
     * events available. You can get additional results by specifying the token in a subsequent call. This operation can
     * return empty results while there are more log events available through the token.
     * </p>
     * <p>
     * The returned log events are sorted by event timestamp, the timestamp when the event was ingested by CloudWatch
     * Logs, and the ID of the <code>PutLogEvents</code> request.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param filterLogEventsRequest
     * @return A Java Future containing the result of the FilterLogEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.FilterLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FilterLogEventsResponse> filterLogEvents(FilterLogEventsRequest filterLogEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists log events from the specified log group. You can list all the log events or filter the results using a
     * filter pattern, a time range, and the name of the log stream.
     * </p>
     * <p>
     * You must have the <code>logs:FilterLogEvents</code> permission to perform this operation.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <p>
     * By default, this operation returns as many log events as can fit in 1 MB (up to 10,000 log events) or all the
     * events found within the specified time range. If the results include a token, that means there are more log
     * events available. You can get additional results by specifying the token in a subsequent call. This operation can
     * return empty results while there are more log events available through the token.
     * </p>
     * <p>
     * The returned log events are sorted by event timestamp, the timestamp when the event was ingested by CloudWatch
     * Logs, and the ID of the <code>PutLogEvents</code> request.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FilterLogEventsRequest.Builder} avoiding the need
     * to create one manually via {@link FilterLogEventsRequest#builder()}
     * </p>
     *
     * @param filterLogEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the FilterLogEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.FilterLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FilterLogEventsResponse> filterLogEvents(
            Consumer<FilterLogEventsRequest.Builder> filterLogEventsRequest) {
        return filterLogEvents(FilterLogEventsRequest.builder().applyMutation(filterLogEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #filterLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.FilterLogEventsPublisher publisher = client.filterLogEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.FilterLogEventsPublisher publisher = client.filterLogEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #filterLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param filterLogEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.FilterLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default FilterLogEventsPublisher filterLogEventsPaginator(FilterLogEventsRequest filterLogEventsRequest) {
        return new FilterLogEventsPublisher(this, filterLogEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #filterLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.FilterLogEventsPublisher publisher = client.filterLogEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.FilterLogEventsPublisher publisher = client.filterLogEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #filterLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FilterLogEventsRequest.Builder} avoiding the need
     * to create one manually via {@link FilterLogEventsRequest#builder()}
     * </p>
     *
     * @param filterLogEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.FilterLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default FilterLogEventsPublisher filterLogEventsPaginator(Consumer<FilterLogEventsRequest.Builder> filterLogEventsRequest) {
        return filterLogEventsPaginator(FilterLogEventsRequest.builder().applyMutation(filterLogEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about a log group data protection policy.
     * </p>
     *
     * @param getDataProtectionPolicyRequest
     * @return A Java Future containing the result of the GetDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataProtectionPolicyResponse> getDataProtectionPolicy(
            GetDataProtectionPolicyRequest getDataProtectionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a log group data protection policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataProtectionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataProtectionPolicyRequest#builder()}
     * </p>
     *
     * @param getDataProtectionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataProtectionPolicyResponse> getDataProtectionPolicy(
            Consumer<GetDataProtectionPolicyRequest.Builder> getDataProtectionPolicyRequest) {
        return getDataProtectionPolicy(GetDataProtectionPolicyRequest.builder().applyMutation(getDataProtectionPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns complete information about one logical <i>delivery</i>. A delivery is a connection between a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html">
     * <i>delivery source</i> </a> and a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html">
     * <i>delivery destination</i> </a>.
     * </p>
     * <p>
     * A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The
     * destination can be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web Services services support being
     * configured as a delivery source. These services are listed in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>
     * </p>
     * <p>
     * You need to specify the delivery <code>id</code> in this operation. You can find the IDs of the deliveries in
     * your account with the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation.
     * </p>
     *
     * @param getDeliveryRequest
     * @return A Java Future containing the result of the GetDelivery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeliveryResponse> getDelivery(GetDeliveryRequest getDeliveryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns complete information about one logical <i>delivery</i>. A delivery is a connection between a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html">
     * <i>delivery source</i> </a> and a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html">
     * <i>delivery destination</i> </a>.
     * </p>
     * <p>
     * A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The
     * destination can be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web Services services support being
     * configured as a delivery source. These services are listed in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>
     * </p>
     * <p>
     * You need to specify the delivery <code>id</code> in this operation. You can find the IDs of the deliveries in
     * your account with the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliveryRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeliveryRequest#builder()}
     * </p>
     *
     * @param getDeliveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDelivery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeliveryResponse> getDelivery(Consumer<GetDeliveryRequest.Builder> getDeliveryRequest) {
        return getDelivery(GetDeliveryRequest.builder().applyMutation(getDeliveryRequest).build());
    }

    /**
     * <p>
     * Retrieves complete information about one delivery destination.
     * </p>
     *
     * @param getDeliveryDestinationRequest
     * @return A Java Future containing the result of the GetDeliveryDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliveryDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeliveryDestinationResponse> getDeliveryDestination(
            GetDeliveryDestinationRequest getDeliveryDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves complete information about one delivery destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliveryDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeliveryDestinationRequest#builder()}
     * </p>
     *
     * @param getDeliveryDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDeliveryDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliveryDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeliveryDestinationResponse> getDeliveryDestination(
            Consumer<GetDeliveryDestinationRequest.Builder> getDeliveryDestinationRequest) {
        return getDeliveryDestination(GetDeliveryDestinationRequest.builder().applyMutation(getDeliveryDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the delivery destination policy assigned to the delivery destination that you specify. For more
     * information about delivery destinations and their policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a>.
     * </p>
     *
     * @param getDeliveryDestinationPolicyRequest
     * @return A Java Future containing the result of the GetDeliveryDestinationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliveryDestinationPolicyResponse> getDeliveryDestinationPolicy(
            GetDeliveryDestinationPolicyRequest getDeliveryDestinationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the delivery destination policy assigned to the delivery destination that you specify. For more
     * information about delivery destinations and their policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliveryDestinationPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliveryDestinationPolicyRequest#builder()}
     * </p>
     *
     * @param getDeliveryDestinationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetDeliveryDestinationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliveryDestinationPolicyResponse> getDeliveryDestinationPolicy(
            Consumer<GetDeliveryDestinationPolicyRequest.Builder> getDeliveryDestinationPolicyRequest) {
        return getDeliveryDestinationPolicy(GetDeliveryDestinationPolicyRequest.builder()
                .applyMutation(getDeliveryDestinationPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves complete information about one delivery source.
     * </p>
     *
     * @param getDeliverySourceRequest
     * @return A Java Future containing the result of the GetDeliverySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeliverySourceResponse> getDeliverySource(GetDeliverySourceRequest getDeliverySourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves complete information about one delivery source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverySourceRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeliverySourceRequest#builder()}
     * </p>
     *
     * @param getDeliverySourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeliverySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeliverySourceResponse> getDeliverySource(
            Consumer<GetDeliverySourceRequest.Builder> getDeliverySourceRequest) {
        return getDeliverySource(GetDeliverySourceRequest.builder().applyMutation(getDeliverySourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the log anomaly detector that you specify.
     * </p>
     *
     * @param getLogAnomalyDetectorRequest
     * @return A Java Future containing the result of the GetLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLogAnomalyDetectorResponse> getLogAnomalyDetector(
            GetLogAnomalyDetectorRequest getLogAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the log anomaly detector that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogAnomalyDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link GetLogAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param getLogAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLogAnomalyDetectorResponse> getLogAnomalyDetector(
            Consumer<GetLogAnomalyDetectorRequest.Builder> getLogAnomalyDetectorRequest) {
        return getLogAnomalyDetector(GetLogAnomalyDetectorRequest.builder().applyMutation(getLogAnomalyDetectorRequest).build());
    }

    /**
     * <p>
     * Lists log events from the specified log stream. You can list all of the log events or filter using a time range.
     * </p>
     * <p>
     * By default, this operation returns as many log events as can fit in a response size of 1MB (up to 10,000 log
     * events). You can get additional log events by specifying one of the tokens in a subsequent call. This operation
     * can return empty results while there are more log events available through the token.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     *
     * @param getLogEventsRequest
     * @return A Java Future containing the result of the GetLogEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLogEventsResponse> getLogEvents(GetLogEventsRequest getLogEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists log events from the specified log stream. You can list all of the log events or filter using a time range.
     * </p>
     * <p>
     * By default, this operation returns as many log events as can fit in a response size of 1MB (up to 10,000 log
     * events). You can get additional log events by specifying one of the tokens in a subsequent call. This operation
     * can return empty results while there are more log events available through the token.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogEventsRequest.Builder} avoiding the need to
     * create one manually via {@link GetLogEventsRequest#builder()}
     * </p>
     *
     * @param getLogEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLogEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLogEventsResponse> getLogEvents(Consumer<GetLogEventsRequest.Builder> getLogEventsRequest) {
        return getLogEvents(GetLogEventsRequest.builder().applyMutation(getLogEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.GetLogEventsPublisher publisher = client.getLogEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.GetLogEventsPublisher publisher = client.getLogEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest)} operation.</b>
     * </p>
     *
     * @param getLogEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLogEventsPublisher getLogEventsPaginator(GetLogEventsRequest getLogEventsRequest) {
        return new GetLogEventsPublisher(this, getLogEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.GetLogEventsPublisher publisher = client.getLogEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.GetLogEventsPublisher publisher = client.getLogEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLogEvents(software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogEventsRequest.Builder} avoiding the need to
     * create one manually via {@link GetLogEventsRequest#builder()}
     * </p>
     *
     * @param getLogEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLogEventsPublisher getLogEventsPaginator(Consumer<GetLogEventsRequest.Builder> getLogEventsRequest) {
        return getLogEventsPaginator(GetLogEventsRequest.builder().applyMutation(getLogEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the fields that are included in log events in the specified log group. Includes the percentage
     * of log events that contain each field. The search is limited to a time period that you specify.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must specify one of these parameters, but you can't specify both.
     * </p>
     * <p>
     * In the results, fields that start with <code>@</code> are fields generated by CloudWatch Logs. For example,
     * <code>@timestamp</code> is the timestamp of each log event. For more information about the fields that are
     * generated by CloudWatch logs, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html"
     * >Supported Logs and Discovered Fields</a>.
     * </p>
     * <p>
     * The response results are sorted by the frequency percentage, starting with the highest percentage.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param getLogGroupFieldsRequest
     * @return A Java Future containing the result of the GetLogGroupFields operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogGroupFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogGroupFields" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLogGroupFieldsResponse> getLogGroupFields(GetLogGroupFieldsRequest getLogGroupFieldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the fields that are included in log events in the specified log group. Includes the percentage
     * of log events that contain each field. The search is limited to a time period that you specify.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must specify one of these parameters, but you can't specify both.
     * </p>
     * <p>
     * In the results, fields that start with <code>@</code> are fields generated by CloudWatch Logs. For example,
     * <code>@timestamp</code> is the timestamp of each log event. For more information about the fields that are
     * generated by CloudWatch logs, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html"
     * >Supported Logs and Discovered Fields</a>.
     * </p>
     * <p>
     * The response results are sorted by the frequency percentage, starting with the highest percentage.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogGroupFieldsRequest.Builder} avoiding the need
     * to create one manually via {@link GetLogGroupFieldsRequest#builder()}
     * </p>
     *
     * @param getLogGroupFieldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLogGroupFields operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogGroupFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogGroupFields" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLogGroupFieldsResponse> getLogGroupFields(
            Consumer<GetLogGroupFieldsRequest.Builder> getLogGroupFieldsRequest) {
        return getLogGroupFields(GetLogGroupFieldsRequest.builder().applyMutation(getLogGroupFieldsRequest).build());
    }

    /**
     * <p>
     * Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original
     * query that produced the <code>logRecordPointer</code> retrieved only a subset of fields. Fields are returned as
     * field name/field value pairs.
     * </p>
     * <p>
     * The full unparsed log event is returned within <code>@message</code>.
     * </p>
     *
     * @param getLogRecordRequest
     * @return A Java Future containing the result of the GetLogRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogRecord" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLogRecordResponse> getLogRecord(GetLogRecordRequest getLogRecordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original
     * query that produced the <code>logRecordPointer</code> retrieved only a subset of fields. Fields are returned as
     * field name/field value pairs.
     * </p>
     * <p>
     * The full unparsed log event is returned within <code>@message</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogRecordRequest.Builder} avoiding the need to
     * create one manually via {@link GetLogRecordRequest#builder()}
     * </p>
     *
     * @param getLogRecordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLogRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetLogRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogRecord" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLogRecordResponse> getLogRecord(Consumer<GetLogRecordRequest.Builder> getLogRecordRequest) {
        return getLogRecord(GetLogRecordRequest.builder().applyMutation(getLogRecordRequest).build());
    }

    /**
     * <p>
     * Returns the results from the specified query.
     * </p>
     * <p>
     * Only the fields requested in the query are returned, along with a <code>@ptr</code> field, which is the
     * identifier for the log record. You can use the value of <code>@ptr</code> in a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html"
     * >GetLogRecord</a> operation to get the full log record.
     * </p>
     * <p>
     * <code>GetQueryResults</code> does not start running a query. To run a query, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>.
     * For more information about how long results of previous queries are available, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/cloudwatch_limits_cwl.html">CloudWatch Logs
     * quotas</a>.
     * </p>
     * <p>
     * If the value of the <code>Status</code> field in the output is <code>Running</code>, this operation returns only
     * partial results. If you see a value of <code>Scheduled</code> or <code>Running</code> for the status, you can
     * retry the operation later to see the final results.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account to
     * start queries in linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the results from the specified query.
     * </p>
     * <p>
     * Only the fields requested in the query are returned, along with a <code>@ptr</code> field, which is the
     * identifier for the log record. You can use the value of <code>@ptr</code> in a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html"
     * >GetLogRecord</a> operation to get the full log record.
     * </p>
     * <p>
     * <code>GetQueryResults</code> does not start running a query. To run a query, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>.
     * For more information about how long results of previous queries are available, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/cloudwatch_limits_cwl.html">CloudWatch Logs
     * quotas</a>.
     * </p>
     * <p>
     * If the value of the <code>Status</code> field in the output is <code>Running</code>, this operation returns only
     * partial results. If you see a value of <code>Scheduled</code> or <code>Running</code> for the status, you can
     * retry the operation later to see the final results.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account to
     * start queries in linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(
            Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResults(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * Returns the information about the log transformer associated with this log group.
     * </p>
     * <p>
     * This operation returns data only for transformers created at the log group level. To get information for an
     * account-level transformer, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html"
     * >DescribeAccountPolicies</a>.
     * </p>
     *
     * @param getTransformerRequest
     * @return A Java Future containing the result of the GetTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTransformerResponse> getTransformer(GetTransformerRequest getTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the information about the log transformer associated with this log group.
     * </p>
     * <p>
     * This operation returns data only for transformers created at the log group level. To get information for an
     * account-level transformer, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html"
     * >DescribeAccountPolicies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransformerRequest.Builder} avoiding the need to
     * create one manually via {@link GetTransformerRequest#builder()}
     * </p>
     *
     * @param getTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTransformerResponse> getTransformer(Consumer<GetTransformerRequest.Builder> getTransformerRequest) {
        return getTransformer(GetTransformerRequest.builder().applyMutation(getTransformerRequest).build());
    }

    /**
     * <p>
     * Returns a list of anomalies that log anomaly detectors have found. For details about the structure format of each
     * anomaly object that is returned, see the example in this section.
     * </p>
     *
     * @param listAnomaliesRequest
     * @return A Java Future containing the result of the ListAnomalies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAnomaliesResponse> listAnomalies(ListAnomaliesRequest listAnomaliesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of anomalies that log anomaly detectors have found. For details about the structure format of each
     * anomaly object that is returned, see the example in this section.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomaliesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnomaliesRequest#builder()}
     * </p>
     *
     * @param listAnomaliesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnomalies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAnomaliesResponse> listAnomalies(Consumer<ListAnomaliesRequest.Builder> listAnomaliesRequest) {
        return listAnomalies(ListAnomaliesRequest.builder().applyMutation(listAnomaliesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalies(software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListAnomaliesPublisher publisher = client.listAnomaliesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListAnomaliesPublisher publisher = client.listAnomaliesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalies(software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest)} operation.</b>
     * </p>
     *
     * @param listAnomaliesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAnomaliesPublisher listAnomaliesPaginator(ListAnomaliesRequest listAnomaliesRequest) {
        return new ListAnomaliesPublisher(this, listAnomaliesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalies(software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListAnomaliesPublisher publisher = client.listAnomaliesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListAnomaliesPublisher publisher = client.listAnomaliesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalies(software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomaliesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnomaliesRequest#builder()}
     * </p>
     *
     * @param listAnomaliesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAnomaliesPublisher listAnomaliesPaginator(Consumer<ListAnomaliesRequest.Builder> listAnomaliesRequest) {
        return listAnomaliesPaginator(ListAnomaliesRequest.builder().applyMutation(listAnomaliesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the log anomaly detectors in the account.
     * </p>
     *
     * @param listLogAnomalyDetectorsRequest
     * @return A Java Future containing the result of the ListLogAnomalyDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogAnomalyDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLogAnomalyDetectorsResponse> listLogAnomalyDetectors(
            ListLogAnomalyDetectorsRequest listLogAnomalyDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the log anomaly detectors in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogAnomalyDetectorsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLogAnomalyDetectorsRequest#builder()}
     * </p>
     *
     * @param listLogAnomalyDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListLogAnomalyDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogAnomalyDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLogAnomalyDetectorsResponse> listLogAnomalyDetectors(
            Consumer<ListLogAnomalyDetectorsRequest.Builder> listLogAnomalyDetectorsRequest) {
        return listLogAnomalyDetectors(ListLogAnomalyDetectorsRequest.builder().applyMutation(listLogAnomalyDetectorsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLogAnomalyDetectors(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogAnomalyDetectorsPublisher publisher = client.listLogAnomalyDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogAnomalyDetectorsPublisher publisher = client.listLogAnomalyDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogAnomalyDetectors(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLogAnomalyDetectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogAnomalyDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogAnomalyDetectorsPublisher listLogAnomalyDetectorsPaginator(
            ListLogAnomalyDetectorsRequest listLogAnomalyDetectorsRequest) {
        return new ListLogAnomalyDetectorsPublisher(this, listLogAnomalyDetectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLogAnomalyDetectors(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogAnomalyDetectorsPublisher publisher = client.listLogAnomalyDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogAnomalyDetectorsPublisher publisher = client.listLogAnomalyDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogAnomalyDetectors(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogAnomalyDetectorsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLogAnomalyDetectorsRequest#builder()}
     * </p>
     *
     * @param listLogAnomalyDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogAnomalyDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogAnomalyDetectorsPublisher listLogAnomalyDetectorsPaginator(
            Consumer<ListLogAnomalyDetectorsRequest.Builder> listLogAnomalyDetectorsRequest) {
        return listLogAnomalyDetectorsPaginator(ListLogAnomalyDetectorsRequest.builder()
                .applyMutation(listLogAnomalyDetectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the log groups that were analyzed during a single CloudWatch Logs Insights query. This can be
     * useful for queries that use log group name prefixes or the <code>filterIndex</code> command, because the log
     * groups are dynamically selected in these cases.
     * </p>
     * <p>
     * For more information about field indexes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>.
     * </p>
     *
     * @param listLogGroupsForQueryRequest
     * @return A Java Future containing the result of the ListLogGroupsForQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogGroupsForQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogGroupsForQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLogGroupsForQueryResponse> listLogGroupsForQuery(
            ListLogGroupsForQueryRequest listLogGroupsForQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the log groups that were analyzed during a single CloudWatch Logs Insights query. This can be
     * useful for queries that use log group name prefixes or the <code>filterIndex</code> command, because the log
     * groups are dynamically selected in these cases.
     * </p>
     * <p>
     * For more information about field indexes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogGroupsForQueryRequest.Builder} avoiding the
     * need to create one manually via {@link ListLogGroupsForQueryRequest#builder()}
     * </p>
     *
     * @param listLogGroupsForQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListLogGroupsForQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogGroupsForQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogGroupsForQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLogGroupsForQueryResponse> listLogGroupsForQuery(
            Consumer<ListLogGroupsForQueryRequest.Builder> listLogGroupsForQueryRequest) {
        return listLogGroupsForQuery(ListLogGroupsForQueryRequest.builder().applyMutation(listLogGroupsForQueryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLogGroupsForQuery(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogGroupsForQueryPublisher publisher = client.listLogGroupsForQueryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogGroupsForQueryPublisher publisher = client.listLogGroupsForQueryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogGroupsForQuery(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLogGroupsForQueryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogGroupsForQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogGroupsForQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogGroupsForQueryPublisher listLogGroupsForQueryPaginator(
            ListLogGroupsForQueryRequest listLogGroupsForQueryRequest) {
        return new ListLogGroupsForQueryPublisher(this, listLogGroupsForQueryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLogGroupsForQuery(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogGroupsForQueryPublisher publisher = client.listLogGroupsForQueryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudwatchlogs.paginators.ListLogGroupsForQueryPublisher publisher = client.listLogGroupsForQueryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogGroupsForQuery(software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogGroupsForQueryRequest.Builder} avoiding the
     * need to create one manually via {@link ListLogGroupsForQueryRequest#builder()}
     * </p>
     *
     * @param listLogGroupsForQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListLogGroupsForQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogGroupsForQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLogGroupsForQueryPublisher listLogGroupsForQueryPaginator(
            Consumer<ListLogGroupsForQueryRequest.Builder> listLogGroupsForQueryRequest) {
        return listLogGroupsForQueryPaginator(ListLogGroupsForQueryRequest.builder().applyMutation(listLogGroupsForQueryRequest)
                .build());
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch Logs resource. Currently, log groups and destinations support
     * tagging.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch Logs resource. Currently, log groups and destinations support
     * tagging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <important>
     * <p>
     * The ListTagsLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a> instead.
     * </p>
     * </important>
     * <p>
     * Lists the tags for the specified log group.
     * </p>
     *
     * @param listTagsLogGroupRequest
     * @return A Java Future containing the result of the ListTagsLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListTagsLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsLogGroup" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Please use the generic tagging API ListTagsForResource
     */
    @Deprecated
    default CompletableFuture<ListTagsLogGroupResponse> listTagsLogGroup(ListTagsLogGroupRequest listTagsLogGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * The ListTagsLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a> instead.
     * </p>
     * </important>
     * <p>
     * Lists the tags for the specified log group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsLogGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ListTagsLogGroupRequest#builder()}
     * </p>
     *
     * @param listTagsLogGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.ListTagsLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsLogGroup" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Please use the generic tagging API ListTagsForResource
     */
    @Deprecated
    default CompletableFuture<ListTagsLogGroupResponse> listTagsLogGroup(
            Consumer<ListTagsLogGroupRequest.Builder> listTagsLogGroupRequest) {
        return listTagsLogGroup(ListTagsLogGroupRequest.builder().applyMutation(listTagsLogGroupRequest).build());
    }

    /**
     * <p>
     * Creates an account-level data protection policy, subscription filter policy, or field index policy that applies
     * to all log groups or a subset of log groups in the account.
     * </p>
     * <p>
     * <b>Data protection policy</b>
     * </p>
     * <p>
     * A data protection policy can help safeguard sensitive data that's ingested by your log groups by auditing and
     * masking the sensitive log data. Each account can have only one account-level data protection policy.
     * </p>
     * <important>
     * <p>
     * Sensitive data is detected and masked when it is ingested into a log group. When you set a data protection
     * policy, log events ingested into the log groups before that time are not masked.
     * </p>
     * </important>
     * <p>
     * If you use <code>PutAccountPolicy</code> to create a data protection policy for your whole account, it applies to
     * both existing log groups and all log groups that are created later in this account. The account-level policy is
     * applied to existing log groups with eventual consistency. It might take up to 5 minutes before sensitive data in
     * existing log groups begins to be masked.
     * </p>
     * <p>
     * By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * A user who has the <code>logs:Unmask</code> permission can use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html"
     * >GetLogEvents</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html"
     * >FilterLogEvents</a> operation with the <code>unmask</code> parameter set to <code>true</code> to view the
     * unmasked log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
     * console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.
     * </p>
     * <p>
     * For more information, including a list of types of data that can be audited and masked, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive
     * log data with masking</a>.
     * </p>
     * <p>
     * To use the <code>PutAccountPolicy</code> operation for a data protection policy, you must be signed on with the
     * <code>logs:PutDataProtectionPolicy</code> and <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * <p>
     * The <code>PutAccountPolicy</code> operation applies to all log groups in the account. You can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html"
     * >PutDataProtectionPolicy</a> to create a data protection policy that applies to just one log group. If a log
     * group has its own data protection policy and the account also has an account-level data protection policy, then
     * the two policies are cumulative. Any sensitive term specified in either policy is masked.
     * </p>
     * <p>
     * <b>Subscription filter policy</b>
     * </p>
     * <p>
     * A subscription filter policy sets up a real-time feed of log events from CloudWatch Logs to other Amazon Web
     * Services services. Account-level subscription filter policies apply to both existing log groups and log groups
     * that are created later in this account. Supported destinations are Kinesis Data Streams, Firehose, and Lambda.
     * When log events are sent to the receiving service, they are Base64 encoded and compressed with the GZIP format.
     * </p>
     * <p>
     * The following destinations are supported for subscription filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Firehose data stream in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Lambda function in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination in a different account created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html"
     * >PutDestination</a>, for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical
     * destinations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each account can have one account-level subscription filter policy per Region. If you are updating an existing
     * filter, you must specify the correct name in <code>PolicyName</code>. To perform a <code>PutAccountPolicy</code>
     * subscription filter operation for any destination except a Lambda function, you must also have the
     * <code>iam:PassRole</code> permission.
     * </p>
     * <p>
     * <b>Transformer policy</b>
     * </p>
     * <p>
     * Creates or updates a <i>log transformer policy</i> for your account. You use log transformers to transform log
     * events into a different format, making them easier for you to process and analyze. You can also transform logs
     * from different sources into standardized formats that contain relevant, source-specific information. After you
     * have created a transformer, CloudWatch Logs performs this transformation at the time of log ingestion. You can
     * then refer to the transformed versions of the logs during operations such as querying with CloudWatch Logs
     * Insights or creating metric filters or subscription filters.
     * </p>
     * <p>
     * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata
     * can include log group name, log stream name, account ID and Region.
     * </p>
     * <p>
     * A transformer for a log group is a series of processors, where each processor applies one type of transformation
     * to the log events ingested into this log group. For more information about the available processors to use in a
     * transformer, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors"
     * > Processors that you can use</a>.
     * </p>
     * <p>
     * Having log events in standardized format enables visibility across your applications for your log analysis,
     * reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box
     * transformation templates for major Amazon Web Services log sources such as VPC flow logs, Lambda, and Amazon RDS.
     * You can use pre-built transformation templates or create custom transformation policies.
     * </p>
     * <p>
     * You can create transformers only for the log groups in the Standard log class.
     * </p>
     * <p>
     * You can have one account-level transformer policy that applies to all log groups in the account. Or you can
     * create as many as 20 account-level transformer policies that are each scoped to a subset of log groups with the
     * <code>selectionCriteria</code> parameter. If you have multiple account-level transformer policies with selection
     * criteria, no two of them can use the same or overlapping log group name prefixes. For example, if you have one
     * policy filtered to log groups that start with <code>my-log</code>, you can't have another field index policy
     * filtered to <code>my-logpprod</code> or <code>my-logging</code>.
     * </p>
     * <p>
     * You can also set up a transformer at the log-group level. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     * >PutTransformer</a>. If there is both a log-group level transformer created with <code>PutTransformer</code> and
     * an account-level transformer that could apply to the same log group, the log group uses only the log-group level
     * transformer. It ignores the account-level transformer.
     * </p>
     * <p>
     * <b>Field index policy</b>
     * </p>
     * <p>
     * You can use field index policies to create indexes on fields found in log events in the log group. Creating field
     * indexes can help lower the scan volume for CloudWatch Logs Insights queries that reference those fields, because
     * these queries attempt to skip the processing of log events that are known to not match the indexed field. Good
     * fields to index are fields that you often need to query for and fields or values that match only a small fraction
     * of the total log events. Common examples of indexes include request ID, session ID, user IDs, or instance IDs.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>
     * </p>
     * <p>
     * To find the fields that are in your log group events, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html"
     * >GetLogGroupFields</a> operation.
     * </p>
     * <p>
     * For example, suppose you have created a field index for <code>requestId</code>. Then, any CloudWatch Logs
     * Insights query on that log group that includes <code>requestId = <i>value</i> </code> or
     * <code>requestId in [<i>value</i>, <i>value</i>, ...]</code> will attempt to process only the log events where the
     * indexed field matches the specified value.
     * </p>
     * <p>
     * Matches of log events to the names of indexed fields are case-sensitive. For example, an indexed field of
     * <code>RequestId</code> won't match a log event containing <code>requestId</code>.
     * </p>
     * <p>
     * You can have one account-level field index policy that applies to all log groups in the account. Or you can
     * create as many as 20 account-level field index policies that are each scoped to a subset of log groups with the
     * <code>selectionCriteria</code> parameter. If you have multiple account-level index policies with selection
     * criteria, no two of them can use the same or overlapping log group name prefixes. For example, if you have one
     * policy filtered to log groups that start with <code>my-log</code>, you can't have another field index policy
     * filtered to <code>my-logpprod</code> or <code>my-logging</code>.
     * </p>
     * <p>
     * If you create an account-level field index policy in a monitoring account in cross-account observability, the
     * policy is applied only to the monitoring account and not to any source accounts.
     * </p>
     * <p>
     * If you want to create a field index policy for a single log group, you can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a> instead of <code>PutAccountPolicy</code>. If you do so, that log group will use only that
     * log-group level policy, and will ignore the account-level policy that you create with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>.
     * </p>
     *
     * @param putAccountPolicyRequest
     * @return A Java Future containing the result of the PutAccountPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutAccountPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutAccountPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountPolicyResponse> putAccountPolicy(PutAccountPolicyRequest putAccountPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an account-level data protection policy, subscription filter policy, or field index policy that applies
     * to all log groups or a subset of log groups in the account.
     * </p>
     * <p>
     * <b>Data protection policy</b>
     * </p>
     * <p>
     * A data protection policy can help safeguard sensitive data that's ingested by your log groups by auditing and
     * masking the sensitive log data. Each account can have only one account-level data protection policy.
     * </p>
     * <important>
     * <p>
     * Sensitive data is detected and masked when it is ingested into a log group. When you set a data protection
     * policy, log events ingested into the log groups before that time are not masked.
     * </p>
     * </important>
     * <p>
     * If you use <code>PutAccountPolicy</code> to create a data protection policy for your whole account, it applies to
     * both existing log groups and all log groups that are created later in this account. The account-level policy is
     * applied to existing log groups with eventual consistency. It might take up to 5 minutes before sensitive data in
     * existing log groups begins to be masked.
     * </p>
     * <p>
     * By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * A user who has the <code>logs:Unmask</code> permission can use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html"
     * >GetLogEvents</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html"
     * >FilterLogEvents</a> operation with the <code>unmask</code> parameter set to <code>true</code> to view the
     * unmasked log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
     * console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.
     * </p>
     * <p>
     * For more information, including a list of types of data that can be audited and masked, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive
     * log data with masking</a>.
     * </p>
     * <p>
     * To use the <code>PutAccountPolicy</code> operation for a data protection policy, you must be signed on with the
     * <code>logs:PutDataProtectionPolicy</code> and <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * <p>
     * The <code>PutAccountPolicy</code> operation applies to all log groups in the account. You can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html"
     * >PutDataProtectionPolicy</a> to create a data protection policy that applies to just one log group. If a log
     * group has its own data protection policy and the account also has an account-level data protection policy, then
     * the two policies are cumulative. Any sensitive term specified in either policy is masked.
     * </p>
     * <p>
     * <b>Subscription filter policy</b>
     * </p>
     * <p>
     * A subscription filter policy sets up a real-time feed of log events from CloudWatch Logs to other Amazon Web
     * Services services. Account-level subscription filter policies apply to both existing log groups and log groups
     * that are created later in this account. Supported destinations are Kinesis Data Streams, Firehose, and Lambda.
     * When log events are sent to the receiving service, they are Base64 encoded and compressed with the GZIP format.
     * </p>
     * <p>
     * The following destinations are supported for subscription filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Firehose data stream in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Lambda function in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination in a different account created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html"
     * >PutDestination</a>, for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical
     * destinations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each account can have one account-level subscription filter policy per Region. If you are updating an existing
     * filter, you must specify the correct name in <code>PolicyName</code>. To perform a <code>PutAccountPolicy</code>
     * subscription filter operation for any destination except a Lambda function, you must also have the
     * <code>iam:PassRole</code> permission.
     * </p>
     * <p>
     * <b>Transformer policy</b>
     * </p>
     * <p>
     * Creates or updates a <i>log transformer policy</i> for your account. You use log transformers to transform log
     * events into a different format, making them easier for you to process and analyze. You can also transform logs
     * from different sources into standardized formats that contain relevant, source-specific information. After you
     * have created a transformer, CloudWatch Logs performs this transformation at the time of log ingestion. You can
     * then refer to the transformed versions of the logs during operations such as querying with CloudWatch Logs
     * Insights or creating metric filters or subscription filters.
     * </p>
     * <p>
     * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata
     * can include log group name, log stream name, account ID and Region.
     * </p>
     * <p>
     * A transformer for a log group is a series of processors, where each processor applies one type of transformation
     * to the log events ingested into this log group. For more information about the available processors to use in a
     * transformer, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors"
     * > Processors that you can use</a>.
     * </p>
     * <p>
     * Having log events in standardized format enables visibility across your applications for your log analysis,
     * reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box
     * transformation templates for major Amazon Web Services log sources such as VPC flow logs, Lambda, and Amazon RDS.
     * You can use pre-built transformation templates or create custom transformation policies.
     * </p>
     * <p>
     * You can create transformers only for the log groups in the Standard log class.
     * </p>
     * <p>
     * You can have one account-level transformer policy that applies to all log groups in the account. Or you can
     * create as many as 20 account-level transformer policies that are each scoped to a subset of log groups with the
     * <code>selectionCriteria</code> parameter. If you have multiple account-level transformer policies with selection
     * criteria, no two of them can use the same or overlapping log group name prefixes. For example, if you have one
     * policy filtered to log groups that start with <code>my-log</code>, you can't have another field index policy
     * filtered to <code>my-logpprod</code> or <code>my-logging</code>.
     * </p>
     * <p>
     * You can also set up a transformer at the log-group level. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     * >PutTransformer</a>. If there is both a log-group level transformer created with <code>PutTransformer</code> and
     * an account-level transformer that could apply to the same log group, the log group uses only the log-group level
     * transformer. It ignores the account-level transformer.
     * </p>
     * <p>
     * <b>Field index policy</b>
     * </p>
     * <p>
     * You can use field index policies to create indexes on fields found in log events in the log group. Creating field
     * indexes can help lower the scan volume for CloudWatch Logs Insights queries that reference those fields, because
     * these queries attempt to skip the processing of log events that are known to not match the indexed field. Good
     * fields to index are fields that you often need to query for and fields or values that match only a small fraction
     * of the total log events. Common examples of indexes include request ID, session ID, user IDs, or instance IDs.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>
     * </p>
     * <p>
     * To find the fields that are in your log group events, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html"
     * >GetLogGroupFields</a> operation.
     * </p>
     * <p>
     * For example, suppose you have created a field index for <code>requestId</code>. Then, any CloudWatch Logs
     * Insights query on that log group that includes <code>requestId = <i>value</i> </code> or
     * <code>requestId in [<i>value</i>, <i>value</i>, ...]</code> will attempt to process only the log events where the
     * indexed field matches the specified value.
     * </p>
     * <p>
     * Matches of log events to the names of indexed fields are case-sensitive. For example, an indexed field of
     * <code>RequestId</code> won't match a log event containing <code>requestId</code>.
     * </p>
     * <p>
     * You can have one account-level field index policy that applies to all log groups in the account. Or you can
     * create as many as 20 account-level field index policies that are each scoped to a subset of log groups with the
     * <code>selectionCriteria</code> parameter. If you have multiple account-level index policies with selection
     * criteria, no two of them can use the same or overlapping log group name prefixes. For example, if you have one
     * policy filtered to log groups that start with <code>my-log</code>, you can't have another field index policy
     * filtered to <code>my-logpprod</code> or <code>my-logging</code>.
     * </p>
     * <p>
     * If you create an account-level field index policy in a monitoring account in cross-account observability, the
     * policy is applied only to the monitoring account and not to any source accounts.
     * </p>
     * <p>
     * If you want to create a field index policy for a single log group, you can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a> instead of <code>PutAccountPolicy</code>. If you do so, that log group will use only that
     * log-group level policy, and will ignore the account-level policy that you create with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutAccountPolicyRequest#builder()}
     * </p>
     *
     * @param putAccountPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAccountPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutAccountPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutAccountPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountPolicyResponse> putAccountPolicy(
            Consumer<PutAccountPolicyRequest.Builder> putAccountPolicyRequest) {
        return putAccountPolicy(PutAccountPolicyRequest.builder().applyMutation(putAccountPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a data protection policy for the specified log group. A data protection policy can help safeguard
     * sensitive data that's ingested by the log group by auditing and masking the sensitive log data.
     * </p>
     * <important>
     * <p>
     * Sensitive data is detected and masked when it is ingested into the log group. When you set a data protection
     * policy, log events ingested into the log group before that time are not masked.
     * </p>
     * </important>
     * <p>
     * By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * A user who has the <code>logs:Unmask</code> permission can use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html"
     * >GetLogEvents</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html"
     * >FilterLogEvents</a> operation with the <code>unmask</code> parameter set to <code>true</code> to view the
     * unmasked log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
     * console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.
     * </p>
     * <p>
     * For more information, including a list of types of data that can be audited and masked, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive
     * log data with masking</a>.
     * </p>
     * <p>
     * The <code>PutDataProtectionPolicy</code> operation applies to only the specified log group. You can also use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html">
     * PutAccountPolicy</a> to create an account-level data protection policy that applies to all log groups in the
     * account, including both existing log groups and log groups that are created level. If a log group has its own
     * data protection policy and the account also has an account-level data protection policy, then the two policies
     * are cumulative. Any sensitive term specified in either policy is masked.
     * </p>
     *
     * @param putDataProtectionPolicyRequest
     * @return A Java Future containing the result of the PutDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDataProtectionPolicyResponse> putDataProtectionPolicy(
            PutDataProtectionPolicyRequest putDataProtectionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data protection policy for the specified log group. A data protection policy can help safeguard
     * sensitive data that's ingested by the log group by auditing and masking the sensitive log data.
     * </p>
     * <important>
     * <p>
     * Sensitive data is detected and masked when it is ingested into the log group. When you set a data protection
     * policy, log events ingested into the log group before that time are not masked.
     * </p>
     * </important>
     * <p>
     * By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * A user who has the <code>logs:Unmask</code> permission can use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html"
     * >GetLogEvents</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html"
     * >FilterLogEvents</a> operation with the <code>unmask</code> parameter set to <code>true</code> to view the
     * unmasked log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
     * console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.
     * </p>
     * <p>
     * For more information, including a list of types of data that can be audited and masked, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive
     * log data with masking</a>.
     * </p>
     * <p>
     * The <code>PutDataProtectionPolicy</code> operation applies to only the specified log group. You can also use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html">
     * PutAccountPolicy</a> to create an account-level data protection policy that applies to all log groups in the
     * account, including both existing log groups and log groups that are created level. If a log group has its own
     * data protection policy and the account also has an account-level data protection policy, then the two policies
     * are cumulative. Any sensitive term specified in either policy is masked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDataProtectionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutDataProtectionPolicyRequest#builder()}
     * </p>
     *
     * @param putDataProtectionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDataProtectionPolicyResponse> putDataProtectionPolicy(
            Consumer<PutDataProtectionPolicyRequest.Builder> putDataProtectionPolicyRequest) {
        return putDataProtectionPolicy(PutDataProtectionPolicyRequest.builder().applyMutation(putDataProtectionPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates a logical <i>delivery destination</i>. A delivery destination is an Amazon Web Services
     * resource that represents an Amazon Web Services service that logs can be sent to. CloudWatch Logs, Amazon S3, and
     * Firehose are supported as logs delivery destinations.
     * </p>
     * <p>
     * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutDeliveryDestination</code> to create a <i>delivery destination</i>, which is a logical object that
     * represents the actual delivery destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * If you use this operation to update an existing delivery destination, all the current delivery destination
     * parameters are overwritten with the new parameter values that you specify.
     * </p>
     *
     * @param putDeliveryDestinationRequest
     * @return A Java Future containing the result of the PutDeliveryDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliveryDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDeliveryDestinationResponse> putDeliveryDestination(
            PutDeliveryDestinationRequest putDeliveryDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a logical <i>delivery destination</i>. A delivery destination is an Amazon Web Services
     * resource that represents an Amazon Web Services service that logs can be sent to. CloudWatch Logs, Amazon S3, and
     * Firehose are supported as logs delivery destinations.
     * </p>
     * <p>
     * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutDeliveryDestination</code> to create a <i>delivery destination</i>, which is a logical object that
     * represents the actual delivery destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * If you use this operation to update an existing delivery destination, all the current delivery destination
     * parameters are overwritten with the new parameter values that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliveryDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link PutDeliveryDestinationRequest#builder()}
     * </p>
     *
     * @param putDeliveryDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutDeliveryDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliveryDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDeliveryDestinationResponse> putDeliveryDestination(
            Consumer<PutDeliveryDestinationRequest.Builder> putDeliveryDestinationRequest) {
        return putDeliveryDestination(PutDeliveryDestinationRequest.builder().applyMutation(putDeliveryDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Creates and assigns an IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a
     * specified destination in this account. To configure the delivery of logs from an Amazon Web Services service in
     * another account to a logs delivery destination in the current account, you must do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery destination</i>, which is a logical object that represents the actual delivery destination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use this operation in the destination account to assign an IAM policy to the destination. This policy allows
     * delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery</i> by pairing exactly one delivery source and one delivery destination. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * The contents of the policy must include two statements. One statement enables general logs delivery, and the
     * other allows delivery to the chosen destination. See the examples for the needed policies.
     * </p>
     *
     * @param putDeliveryDestinationPolicyRequest
     * @return A Java Future containing the result of the PutDeliveryDestinationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeliveryDestinationPolicyResponse> putDeliveryDestinationPolicy(
            PutDeliveryDestinationPolicyRequest putDeliveryDestinationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and assigns an IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a
     * specified destination in this account. To configure the delivery of logs from an Amazon Web Services service in
     * another account to a logs delivery destination in the current account, you must do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery destination</i>, which is a logical object that represents the actual delivery destination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use this operation in the destination account to assign an IAM policy to the destination. This policy allows
     * delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery</i> by pairing exactly one delivery source and one delivery destination. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * The contents of the policy must include two statements. One statement enables general logs delivery, and the
     * other allows delivery to the chosen destination. See the examples for the needed policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliveryDestinationPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutDeliveryDestinationPolicyRequest#builder()}
     * </p>
     *
     * @param putDeliveryDestinationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutDeliveryDestinationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeliveryDestinationPolicyResponse> putDeliveryDestinationPolicy(
            Consumer<PutDeliveryDestinationPolicyRequest.Builder> putDeliveryDestinationPolicyRequest) {
        return putDeliveryDestinationPolicy(PutDeliveryDestinationPolicyRequest.builder()
                .applyMutation(putDeliveryDestinationPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a logical <i>delivery source</i>. A delivery source represents an Amazon Web Services resource
     * that sends logs to an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3, or Firehose.
     * </p>
     * <p>
     * To configure logs delivery between a delivery destination and an Amazon Web Services service that is supported as
     * a delivery source, you must do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>PutDeliverySource</code> to create a delivery source, which is a logical object that represents the
     * resource that is actually sending the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutDeliveryDestination</code> to create a <i>delivery destination</i>, which is a logical object that
     * represents the actual delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * If you use this operation to update an existing delivery source, all the current delivery source parameters are
     * overwritten with the new parameter values that you specify.
     * </p>
     *
     * @param putDeliverySourceRequest
     * @return A Java Future containing the result of the PutDeliverySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDeliverySourceResponse> putDeliverySource(PutDeliverySourceRequest putDeliverySourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a logical <i>delivery source</i>. A delivery source represents an Amazon Web Services resource
     * that sends logs to an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3, or Firehose.
     * </p>
     * <p>
     * To configure logs delivery between a delivery destination and an Amazon Web Services service that is supported as
     * a delivery source, you must do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>PutDeliverySource</code> to create a delivery source, which is a logical object that represents the
     * resource that is actually sending the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutDeliveryDestination</code> to create a <i>delivery destination</i>, which is a logical object that
     * represents the actual delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * If you use this operation to update an existing delivery source, all the current delivery source parameters are
     * overwritten with the new parameter values that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliverySourceRequest.Builder} avoiding the need
     * to create one manually via {@link PutDeliverySourceRequest#builder()}
     * </p>
     *
     * @param putDeliverySourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutDeliverySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDeliverySourceResponse> putDeliverySource(
            Consumer<PutDeliverySourceRequest.Builder> putDeliverySourceRequest) {
        return putDeliverySource(PutDeliverySourceRequest.builder().applyMutation(putDeliverySourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a destination. This operation is used only to create destinations for cross-account
     * subscriptions.
     * </p>
     * <p>
     * A destination encapsulates a physical resource (such as an Amazon Kinesis stream). With a destination, you can
     * subscribe to a real-time stream of log events for a different account, ingested using <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a>.
     * </p>
     * <p>
     * Through an access policy, a destination controls what is written to it. By default, <code>PutDestination</code>
     * does not set any access policy with the destination, which means a cross-account user cannot call <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html"
     * >PutSubscriptionFilter</a> against this destination. To enable this, the destination owner must call <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     * >PutDestinationPolicy</a> after <code>PutDestination</code>.
     * </p>
     * <p>
     * To perform a <code>PutDestination</code> operation, you must also have the <code>iam:PassRole</code> permission.
     * </p>
     *
     * @param putDestinationRequest
     * @return A Java Future containing the result of the PutDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestination" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDestinationResponse> putDestination(PutDestinationRequest putDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a destination. This operation is used only to create destinations for cross-account
     * subscriptions.
     * </p>
     * <p>
     * A destination encapsulates a physical resource (such as an Amazon Kinesis stream). With a destination, you can
     * subscribe to a real-time stream of log events for a different account, ingested using <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a>.
     * </p>
     * <p>
     * Through an access policy, a destination controls what is written to it. By default, <code>PutDestination</code>
     * does not set any access policy with the destination, which means a cross-account user cannot call <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html"
     * >PutSubscriptionFilter</a> against this destination. To enable this, the destination owner must call <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     * >PutDestinationPolicy</a> after <code>PutDestination</code>.
     * </p>
     * <p>
     * To perform a <code>PutDestination</code> operation, you must also have the <code>iam:PassRole</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link PutDestinationRequest#builder()}
     * </p>
     *
     * @param putDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestination" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDestinationResponse> putDestination(Consumer<PutDestinationRequest.Builder> putDestinationRequest) {
        return putDestination(PutDestinationRequest.builder().applyMutation(putDestinationRequest).build());
    }

    /**
     * <p>
     * Creates or updates an access policy associated with an existing destination. An access policy is an <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html">IAM policy document</a> that is
     * used to authorize claims to register a subscription filter against a given destination.
     * </p>
     *
     * @param putDestinationPolicyRequest
     * @return A Java Future containing the result of the PutDestinationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDestinationPolicyResponse> putDestinationPolicy(
            PutDestinationPolicyRequest putDestinationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an access policy associated with an existing destination. An access policy is an <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html">IAM policy document</a> that is
     * used to authorize claims to register a subscription filter against a given destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDestinationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutDestinationPolicyRequest#builder()}
     * </p>
     *
     * @param putDestinationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutDestinationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDestinationPolicyResponse> putDestinationPolicy(
            Consumer<PutDestinationPolicyRequest.Builder> putDestinationPolicyRequest) {
        return putDestinationPolicy(PutDestinationPolicyRequest.builder().applyMutation(putDestinationPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a <i>field index policy</i> for the specified log group. Only log groups in the Standard log
     * class support field index policies. For more information about log classes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>.
     * </p>
     * <p>
     * You can use field index policies to create <i>field indexes</i> on fields found in log events in the log group.
     * Creating field indexes speeds up and lowers the costs for CloudWatch Logs Insights queries that reference those
     * field indexes, because these queries attempt to skip the processing of log events that are known to not match the
     * indexed field. Good fields to index are fields that you often need to query for and fields or values that match
     * only a small fraction of the total log events. Common examples of indexes include request ID, session ID, userID,
     * and instance IDs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>.
     * </p>
     * <p>
     * To find the fields that are in your log group events, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html"
     * >GetLogGroupFields</a> operation.
     * </p>
     * <p>
     * For example, suppose you have created a field index for <code>requestId</code>. Then, any CloudWatch Logs
     * Insights query on that log group that includes <code>requestId = <i>value</i> </code> or
     * <code>requestId IN [<i>value</i>, <i>value</i>, ...]</code> will process fewer log events to reduce costs, and
     * have improved performance.
     * </p>
     * <p>
     * Each index policy has the following quotas and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * As many as 20 fields can be included in the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each field name can include as many as 100 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Matches of log events to the names of indexed fields are case-sensitive. For example, a field index of
     * <code>RequestId</code> won't match a log event containing <code>requestId</code>.
     * </p>
     * <p>
     * Log group-level field index policies created with <code>PutIndexPolicy</code> override account-level field index
     * policies created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>. If you use <code>PutIndexPolicy</code> to create a field index policy for a log group,
     * that log group uses only that policy. The log group ignores any account-wide field index policy that you might
     * have created.
     * </p>
     *
     * @param putIndexPolicyRequest
     * @return A Java Future containing the result of the PutIndexPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutIndexPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutIndexPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutIndexPolicyResponse> putIndexPolicy(PutIndexPolicyRequest putIndexPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a <i>field index policy</i> for the specified log group. Only log groups in the Standard log
     * class support field index policies. For more information about log classes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>.
     * </p>
     * <p>
     * You can use field index policies to create <i>field indexes</i> on fields found in log events in the log group.
     * Creating field indexes speeds up and lowers the costs for CloudWatch Logs Insights queries that reference those
     * field indexes, because these queries attempt to skip the processing of log events that are known to not match the
     * indexed field. Good fields to index are fields that you often need to query for and fields or values that match
     * only a small fraction of the total log events. Common examples of indexes include request ID, session ID, userID,
     * and instance IDs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>.
     * </p>
     * <p>
     * To find the fields that are in your log group events, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html"
     * >GetLogGroupFields</a> operation.
     * </p>
     * <p>
     * For example, suppose you have created a field index for <code>requestId</code>. Then, any CloudWatch Logs
     * Insights query on that log group that includes <code>requestId = <i>value</i> </code> or
     * <code>requestId IN [<i>value</i>, <i>value</i>, ...]</code> will process fewer log events to reduce costs, and
     * have improved performance.
     * </p>
     * <p>
     * Each index policy has the following quotas and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * As many as 20 fields can be included in the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each field name can include as many as 100 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Matches of log events to the names of indexed fields are case-sensitive. For example, a field index of
     * <code>RequestId</code> won't match a log event containing <code>requestId</code>.
     * </p>
     * <p>
     * Log group-level field index policies created with <code>PutIndexPolicy</code> override account-level field index
     * policies created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>. If you use <code>PutIndexPolicy</code> to create a field index policy for a log group,
     * that log group uses only that policy. The log group ignores any account-wide field index policy that you might
     * have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIndexPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutIndexPolicyRequest#builder()}
     * </p>
     *
     * @param putIndexPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutIndexPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutIndexPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutIndexPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutIndexPolicyResponse> putIndexPolicy(Consumer<PutIndexPolicyRequest.Builder> putIndexPolicyRequest) {
        return putIndexPolicy(PutIndexPolicyRequest.builder().applyMutation(putIndexPolicyRequest).build());
    }

    /**
     * <p>
     * Uploads a batch of log events to the specified log stream.
     * </p>
     * <important>
     * <p>
     * The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code> actions are
     * always accepted and never return <code>InvalidSequenceTokenException</code> or
     * <code>DataAlreadyAcceptedException</code> even if the sequence token is not valid. You can use parallel
     * <code>PutLogEvents</code> actions on the same log stream.
     * </p>
     * </important>
     * <p>
     * The batch of events must satisfy the following constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The maximum batch size is 1,048,576 bytes. This size is calculated as the sum of all event messages in UTF-8,
     * plus 26 bytes for each log event.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the log events in the batch can be more than 2 hours in the future.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the log events in the batch can be more than 14 days in the past. Also, none of the log events can be
     * from earlier than the retention period of the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The log events in the batch must be in chronological order by their timestamp. The timestamp is the time that the
     * event occurred, expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>. (In Amazon
     * Web Services Tools for PowerShell and the Amazon Web Services SDK for .NET, the timestamp is specified in .NET
     * format: <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2017-09-15T13:45:30</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * A batch of log events in a single request cannot span more than 24 hours. Otherwise, the operation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each log event can be no larger than 256 KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum number of log events in a batch is 10,000.
     * </p>
     * </li>
     * <li><important>
     * <p>
     * The quota of five requests per second per log stream has been removed. Instead, <code>PutLogEvents</code> actions
     * are throttled based on a per-second per-account quota. You can request an increase to the per-second throttling
     * quota by using the Service Quotas service.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * If a call to <code>PutLogEvents</code> returns "UnrecognizedClientException" the most likely cause is a non-valid
     * Amazon Web Services access key ID or secret key.
     * </p>
     *
     * @param putLogEventsRequest
     * @return A Java Future containing the result of the PutLogEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>InvalidSequenceTokenException The sequence token is not valid. You can get the correct sequence token
     *         in the <code>expectedSequenceToken</code> field in the <code>InvalidSequenceTokenException</code>
     *         message. </p> <important>
     *         <p>
     *         <code>PutLogEvents</code> actions are now always accepted and never return
     *         <code>InvalidSequenceTokenException</code> regardless of receiving an invalid sequence token.
     *         </p>
     *         </li>
     *         <li>DataAlreadyAcceptedException The event was already logged.</p> <important>
     *         <p>
     *         <code>PutLogEvents</code> actions are now always accepted and never return
     *         <code>DataAlreadyAcceptedException</code> regardless of whether a given batch of log events has already
     *         been accepted.
     *         </p>
     *         </li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>UnrecognizedClientException The most likely cause is an Amazon Web Services access key ID or secret
     *         key that's not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutLogEventsResponse> putLogEvents(PutLogEventsRequest putLogEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a batch of log events to the specified log stream.
     * </p>
     * <important>
     * <p>
     * The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code> actions are
     * always accepted and never return <code>InvalidSequenceTokenException</code> or
     * <code>DataAlreadyAcceptedException</code> even if the sequence token is not valid. You can use parallel
     * <code>PutLogEvents</code> actions on the same log stream.
     * </p>
     * </important>
     * <p>
     * The batch of events must satisfy the following constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The maximum batch size is 1,048,576 bytes. This size is calculated as the sum of all event messages in UTF-8,
     * plus 26 bytes for each log event.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the log events in the batch can be more than 2 hours in the future.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the log events in the batch can be more than 14 days in the past. Also, none of the log events can be
     * from earlier than the retention period of the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The log events in the batch must be in chronological order by their timestamp. The timestamp is the time that the
     * event occurred, expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>. (In Amazon
     * Web Services Tools for PowerShell and the Amazon Web Services SDK for .NET, the timestamp is specified in .NET
     * format: <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2017-09-15T13:45:30</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * A batch of log events in a single request cannot span more than 24 hours. Otherwise, the operation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each log event can be no larger than 256 KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum number of log events in a batch is 10,000.
     * </p>
     * </li>
     * <li><important>
     * <p>
     * The quota of five requests per second per log stream has been removed. Instead, <code>PutLogEvents</code> actions
     * are throttled based on a per-second per-account quota. You can request an increase to the per-second throttling
     * quota by using the Service Quotas service.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * If a call to <code>PutLogEvents</code> returns "UnrecognizedClientException" the most likely cause is a non-valid
     * Amazon Web Services access key ID or secret key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLogEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutLogEventsRequest#builder()}
     * </p>
     *
     * @param putLogEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLogEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>InvalidSequenceTokenException The sequence token is not valid. You can get the correct sequence token
     *         in the <code>expectedSequenceToken</code> field in the <code>InvalidSequenceTokenException</code>
     *         message. </p> <important>
     *         <p>
     *         <code>PutLogEvents</code> actions are now always accepted and never return
     *         <code>InvalidSequenceTokenException</code> regardless of receiving an invalid sequence token.
     *         </p>
     *         </li>
     *         <li>DataAlreadyAcceptedException The event was already logged.</p> <important>
     *         <p>
     *         <code>PutLogEvents</code> actions are now always accepted and never return
     *         <code>DataAlreadyAcceptedException</code> regardless of whether a given batch of log events has already
     *         been accepted.
     *         </p>
     *         </li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>UnrecognizedClientException The most likely cause is an Amazon Web Services access key ID or secret
     *         key that's not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutLogEventsResponse> putLogEvents(Consumer<PutLogEventsRequest.Builder> putLogEventsRequest) {
        return putLogEvents(PutLogEventsRequest.builder().applyMutation(putLogEventsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a metric filter and associates it with the specified log group. With metric filters, you can
     * configure rules to extract metric data from log events ingested through <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a>.
     * </p>
     * <p>
     * The maximum number of metric filters that can be associated with a log group is 100.
     * </p>
     * <p>
     * Using regular expressions to create metric filters is supported. For these filters, there is a quota of two
     * regular expression patterns within a single filter pattern. There is also a quota of five regular expression
     * patterns per log group. For more information about using regular expressions in metric filters, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html"> Filter pattern
     * syntax for metric filters, subscription filters, filter log events, and Live Tail</a>.
     * </p>
     * <p>
     * When you create a metric filter, you can also optionally assign a unit and dimensions to the metric that is
     * created.
     * </p>
     * <important>
     * <p>
     * Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not
     * specify high-cardinality fields such as <code>IPAddress</code> or <code>requestID</code> as dimensions. Each
     * different value found for a dimension is treated as a separate metric and accrues charges as a separate custom
     * metric.
     * </p>
     * <p>
     * CloudWatch Logs might disable a metric filter if it generates 1,000 different name/value pairs for your specified
     * dimensions within one hour.
     * </p>
     * <p>
     * You can also set up a billing alarm to alert you if your charges are higher than expected. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
     * Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
     * </p>
     * </important>
     *
     * @param putMetricFilterRequest
     * @return A Java Future containing the result of the PutMetricFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutMetricFilterResponse> putMetricFilter(PutMetricFilterRequest putMetricFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a metric filter and associates it with the specified log group. With metric filters, you can
     * configure rules to extract metric data from log events ingested through <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a>.
     * </p>
     * <p>
     * The maximum number of metric filters that can be associated with a log group is 100.
     * </p>
     * <p>
     * Using regular expressions to create metric filters is supported. For these filters, there is a quota of two
     * regular expression patterns within a single filter pattern. There is also a quota of five regular expression
     * patterns per log group. For more information about using regular expressions in metric filters, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html"> Filter pattern
     * syntax for metric filters, subscription filters, filter log events, and Live Tail</a>.
     * </p>
     * <p>
     * When you create a metric filter, you can also optionally assign a unit and dimensions to the metric that is
     * created.
     * </p>
     * <important>
     * <p>
     * Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not
     * specify high-cardinality fields such as <code>IPAddress</code> or <code>requestID</code> as dimensions. Each
     * different value found for a dimension is treated as a separate metric and accrues charges as a separate custom
     * metric.
     * </p>
     * <p>
     * CloudWatch Logs might disable a metric filter if it generates 1,000 different name/value pairs for your specified
     * dimensions within one hour.
     * </p>
     * <p>
     * You can also set up a billing alarm to alert you if your charges are higher than expected. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
     * Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMetricFilterRequest.Builder} avoiding the need
     * to create one manually via {@link PutMetricFilterRequest#builder()}
     * </p>
     *
     * @param putMetricFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutMetricFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutMetricFilterResponse> putMetricFilter(
            Consumer<PutMetricFilterRequest.Builder> putMetricFilterRequest) {
        return putMetricFilter(PutMetricFilterRequest.builder().applyMutation(putMetricFilterRequest).build());
    }

    /**
     * <p>
     * Creates or updates a query definition for CloudWatch Logs Insights. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">Analyzing Log Data with
     * CloudWatch Logs Insights</a>.
     * </p>
     * <p>
     * To update a query definition, specify its <code>queryDefinitionId</code> in your request. The values of
     * <code>name</code>, <code>queryString</code>, and <code>logGroupNames</code> are changed to the values that you
     * specify in your update operation. No current values are retained from the current query definition. For example,
     * imagine updating a current query definition that includes log groups. If you don't specify the
     * <code>logGroupNames</code> parameter in your update operation, the query definition changes to contain no log
     * groups.
     * </p>
     * <p>
     * You must have the <code>logs:PutQueryDefinition</code> permission to be able to perform this operation.
     * </p>
     *
     * @param putQueryDefinitionRequest
     * @return A Java Future containing the result of the PutQueryDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutQueryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutQueryDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutQueryDefinitionResponse> putQueryDefinition(PutQueryDefinitionRequest putQueryDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a query definition for CloudWatch Logs Insights. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">Analyzing Log Data with
     * CloudWatch Logs Insights</a>.
     * </p>
     * <p>
     * To update a query definition, specify its <code>queryDefinitionId</code> in your request. The values of
     * <code>name</code>, <code>queryString</code>, and <code>logGroupNames</code> are changed to the values that you
     * specify in your update operation. No current values are retained from the current query definition. For example,
     * imagine updating a current query definition that includes log groups. If you don't specify the
     * <code>logGroupNames</code> parameter in your update operation, the query definition changes to contain no log
     * groups.
     * </p>
     * <p>
     * You must have the <code>logs:PutQueryDefinition</code> permission to be able to perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutQueryDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link PutQueryDefinitionRequest#builder()}
     * </p>
     *
     * @param putQueryDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutQueryDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutQueryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutQueryDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutQueryDefinitionResponse> putQueryDefinition(
            Consumer<PutQueryDefinitionRequest.Builder> putQueryDefinitionRequest) {
        return putQueryDefinition(PutQueryDefinitionRequest.builder().applyMutation(putQueryDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource policy allowing other Amazon Web Services services to put log events to this
     * account, such as Amazon Route 53. An account can have up to 10 resource policies per Amazon Web Services Region.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource policy allowing other Amazon Web Services services to put log events to this
     * account, such as Amazon Route 53. An account can have up to 10 resource policies per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Sets the retention of the specified log group. With a retention policy, you can configure the number of days for
     * which to retain log events in the specified log group.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs doesn't immediately delete log events when they reach their retention setting. It typically takes
     * up to 72 hours after that before log events are deleted, but in rare situations might take longer.
     * </p>
     * <p>
     * To illustrate, imagine that you change a log group to have a longer retention setting when it contains log events
     * that are past the expiration date, but haven't been deleted. Those log events will take up to 72 hours to be
     * deleted after the new retention date is reached. To make sure that log data is deleted permanently, keep a log
     * group at its lower retention setting until 72 hours after the previous retention period ends. Alternatively, wait
     * to change the retention setting until you confirm that the earlier log events are deleted.
     * </p>
     * <p>
     * When log events reach their retention setting they are marked for deletion. After they are marked for deletion,
     * they do not add to your archival storage costs anymore, even if they are not actually deleted until later. These
     * log events marked for deletion are also not included when you use an API to retrieve the <code>storedBytes</code>
     * value to see how many bytes a log group is storing.
     * </p>
     * </note>
     *
     * @param putRetentionPolicyRequest
     * @return A Java Future containing the result of the PutRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the retention of the specified log group. With a retention policy, you can configure the number of days for
     * which to retain log events in the specified log group.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs doesn't immediately delete log events when they reach their retention setting. It typically takes
     * up to 72 hours after that before log events are deleted, but in rare situations might take longer.
     * </p>
     * <p>
     * To illustrate, imagine that you change a log group to have a longer retention setting when it contains log events
     * that are past the expiration date, but haven't been deleted. Those log events will take up to 72 hours to be
     * deleted after the new retention date is reached. To make sure that log data is deleted permanently, keep a log
     * group at its lower retention setting until 72 hours after the previous retention period ends. Alternatively, wait
     * to change the retention setting until you confirm that the earlier log events are deleted.
     * </p>
     * <p>
     * When log events reach their retention setting they are marked for deletion. After they are marked for deletion,
     * they do not add to your archival storage costs anymore, even if they are not actually deleted until later. These
     * log events marked for deletion are also not included when you use an API to retrieve the <code>storedBytes</code>
     * value to see how many bytes a log group is storing.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRetentionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param putRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(
            Consumer<PutRetentionPolicyRequest.Builder> putRetentionPolicyRequest) {
        return putRetentionPolicy(PutRetentionPolicyRequest.builder().applyMutation(putRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a subscription filter and associates it with the specified log group. With subscription
     * filters, you can subscribe to a real-time stream of log events ingested through <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a> and have them delivered to a specific destination. When log events are sent to the receiving
     * service, they are Base64 encoded and compressed with the GZIP format.
     * </p>
     * <p>
     * The following destinations are supported for subscription filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Kinesis data stream belonging to the same account as the subscription filter, for same-account
     * delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html"
     * >PutDestination</a> that belongs to a different account, for cross-account delivery. We currently support Kinesis
     * Data Streams and Firehose as logical destinations.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Kinesis Data Firehose delivery stream that belongs to the same account as the subscription filter, for
     * same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Lambda function that belongs to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each log group can have up to two subscription filters associated with it. If you are updating an existing
     * filter, you must specify the correct name in <code>filterName</code>.
     * </p>
     * <p>
     * Using regular expressions to create subscription filters is supported. For these filters, there is a quotas of
     * quota of two regular expression patterns within a single filter pattern. There is also a quota of five regular
     * expression patterns per log group. For more information about using regular expressions in subscription filters,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html"> Filter
     * pattern syntax for metric filters, subscription filters, filter log events, and Live Tail</a>.
     * </p>
     * <p>
     * To perform a <code>PutSubscriptionFilter</code> operation for any destination except a Lambda function, you must
     * also have the <code>iam:PassRole</code> permission.
     * </p>
     *
     * @param putSubscriptionFilterRequest
     * @return A Java Future containing the result of the PutSubscriptionFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutSubscriptionFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutSubscriptionFilterResponse> putSubscriptionFilter(
            PutSubscriptionFilterRequest putSubscriptionFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a subscription filter and associates it with the specified log group. With subscription
     * filters, you can subscribe to a real-time stream of log events ingested through <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a> and have them delivered to a specific destination. When log events are sent to the receiving
     * service, they are Base64 encoded and compressed with the GZIP format.
     * </p>
     * <p>
     * The following destinations are supported for subscription filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Kinesis data stream belonging to the same account as the subscription filter, for same-account
     * delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html"
     * >PutDestination</a> that belongs to a different account, for cross-account delivery. We currently support Kinesis
     * Data Streams and Firehose as logical destinations.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Kinesis Data Firehose delivery stream that belongs to the same account as the subscription filter, for
     * same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Lambda function that belongs to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each log group can have up to two subscription filters associated with it. If you are updating an existing
     * filter, you must specify the correct name in <code>filterName</code>.
     * </p>
     * <p>
     * Using regular expressions to create subscription filters is supported. For these filters, there is a quotas of
     * quota of two regular expression patterns within a single filter pattern. There is also a quota of five regular
     * expression patterns per log group. For more information about using regular expressions in subscription filters,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html"> Filter
     * pattern syntax for metric filters, subscription filters, filter log events, and Live Tail</a>.
     * </p>
     * <p>
     * To perform a <code>PutSubscriptionFilter</code> operation for any destination except a Lambda function, you must
     * also have the <code>iam:PassRole</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSubscriptionFilterRequest.Builder} avoiding the
     * need to create one manually via {@link PutSubscriptionFilterRequest#builder()}
     * </p>
     *
     * @param putSubscriptionFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutSubscriptionFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutSubscriptionFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutSubscriptionFilterResponse> putSubscriptionFilter(
            Consumer<PutSubscriptionFilterRequest.Builder> putSubscriptionFilterRequest) {
        return putSubscriptionFilter(PutSubscriptionFilterRequest.builder().applyMutation(putSubscriptionFilterRequest).build());
    }

    /**
     * <p>
     * Creates or updates a <i>log transformer</i> for a single log group. You use log transformers to transform log
     * events into a different format, making them easier for you to process and analyze. You can also transform logs
     * from different sources into standardized formats that contains relevant, source-specific information.
     * </p>
     * <p>
     * After you have created a transformer, CloudWatch Logs performs the transformations at the time of log ingestion.
     * You can then refer to the transformed versions of the logs during operations such as querying with CloudWatch
     * Logs Insights or creating metric filters or subscription filers.
     * </p>
     * <p>
     * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata
     * can include log group name, log stream name, account ID and Region.
     * </p>
     * <p>
     * A transformer for a log group is a series of processors, where each processor applies one type of transformation
     * to the log events ingested into this log group. The processors work one after another, in the order that you list
     * them, like a pipeline. For more information about the available processors to use in a transformer, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors"
     * > Processors that you can use</a>.
     * </p>
     * <p>
     * Having log events in standardized format enables visibility across your applications for your log analysis,
     * reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box
     * transformation templates for major Amazon Web Services log sources such as VPC flow logs, Lambda, and Amazon RDS.
     * You can use pre-built transformation templates or create custom transformation policies.
     * </p>
     * <p>
     * You can create transformers only for the log groups in the Standard log class.
     * </p>
     * <p>
     * You can also set up a transformer at the account level. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>. If there is both a log-group level transformer created with <code>PutTransformer</code>
     * and an account-level transformer that could apply to the same log group, the log group uses only the log-group
     * level transformer. It ignores the account-level transformer.
     * </p>
     *
     * @param putTransformerRequest
     * @return A Java Future containing the result of the PutTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTransformerResponse> putTransformer(PutTransformerRequest putTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a <i>log transformer</i> for a single log group. You use log transformers to transform log
     * events into a different format, making them easier for you to process and analyze. You can also transform logs
     * from different sources into standardized formats that contains relevant, source-specific information.
     * </p>
     * <p>
     * After you have created a transformer, CloudWatch Logs performs the transformations at the time of log ingestion.
     * You can then refer to the transformed versions of the logs during operations such as querying with CloudWatch
     * Logs Insights or creating metric filters or subscription filers.
     * </p>
     * <p>
     * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata
     * can include log group name, log stream name, account ID and Region.
     * </p>
     * <p>
     * A transformer for a log group is a series of processors, where each processor applies one type of transformation
     * to the log events ingested into this log group. The processors work one after another, in the order that you list
     * them, like a pipeline. For more information about the available processors to use in a transformer, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors"
     * > Processors that you can use</a>.
     * </p>
     * <p>
     * Having log events in standardized format enables visibility across your applications for your log analysis,
     * reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box
     * transformation templates for major Amazon Web Services log sources such as VPC flow logs, Lambda, and Amazon RDS.
     * You can use pre-built transformation templates or create custom transformation policies.
     * </p>
     * <p>
     * You can create transformers only for the log groups in the Standard log class.
     * </p>
     * <p>
     * You can also set up a transformer at the account level. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>. If there is both a log-group level transformer created with <code>PutTransformer</code>
     * and an account-level transformer that could apply to the same log group, the log group uses only the log-group
     * level transformer. It ignores the account-level transformer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTransformerRequest.Builder} avoiding the need to
     * create one manually via {@link PutTransformerRequest#builder()}
     * </p>
     *
     * @param putTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.PutTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTransformerResponse> putTransformer(Consumer<PutTransformerRequest.Builder> putTransformerRequest) {
        return putTransformer(PutTransformerRequest.builder().applyMutation(putTransformerRequest).build());
    }

    /**
     * <p>
     * Starts a Live Tail streaming session for one or more log groups. A Live Tail session returns a stream of log
     * events that have been recently ingested in the log groups. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs_LiveTail.html">Use Live Tail to
     * view logs in near real time</a>.
     * </p>
     * <p>
     * The response to this operation is a response stream, over which the server sends live log events and the client
     * receives them.
     * </p>
     * <p>
     * The following objects are sent over the stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A single <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LiveTailSessionStart.html"
     * >LiveTailSessionStart</a> object is sent at the start of the session.
     * </p>
     * </li>
     * <li>
     * <p>
     * Every second, a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LiveTailSessionUpdate.html"
     * >LiveTailSessionUpdate</a> object is sent. Each of these objects contains an array of the actual log events.
     * </p>
     * <p>
     * If no new log events were ingested in the past second, the <code>LiveTailSessionUpdate</code> object will contain
     * an empty array.
     * </p>
     * <p>
     * The array of log events contained in a <code>LiveTailSessionUpdate</code> can include as many as 500 log events.
     * If the number of log events matching the request exceeds 500 per second, the log events are sampled down to 500
     * log events to be included in each <code>LiveTailSessionUpdate</code> object.
     * </p>
     * <p>
     * If your client consumes the log events slower than the server produces them, CloudWatch Logs buffers up to 10
     * <code>LiveTailSessionUpdate</code> events or 5000 log events, after which it starts dropping the oldest events.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartLiveTailResponseStream.html#CWL-Type-StartLiveTailResponseStream-SessionStreamingException"
     * >SessionStreamingException</a> object is returned if an unknown error occurs on the server side.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartLiveTailResponseStream.html#CWL-Type-StartLiveTailResponseStream-SessionTimeoutException"
     * >SessionTimeoutException</a> object is returned when the session times out, after it has been kept open for three
     * hours.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * You can end a session before it times out by closing the session stream or by closing the client that is
     * receiving the stream. The session also ends if the established connection between the client and the server
     * breaks.
     * </p>
     * </important>
     * <p>
     * For examples of using an SDK to start a Live Tail session, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/example_cloudwatch-logs_StartLiveTail_section.html">
     * Start a Live Tail session using an Amazon Web Services SDK</a>.
     * </p>
     *
     * @param startLiveTailRequest
     * @return A Java Future containing the result of the StartLiveTail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.StartLiveTail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StartLiveTail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<Void> startLiveTail(StartLiveTailRequest startLiveTailRequest,
            StartLiveTailResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Live Tail streaming session for one or more log groups. A Live Tail session returns a stream of log
     * events that have been recently ingested in the log groups. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs_LiveTail.html">Use Live Tail to
     * view logs in near real time</a>.
     * </p>
     * <p>
     * The response to this operation is a response stream, over which the server sends live log events and the client
     * receives them.
     * </p>
     * <p>
     * The following objects are sent over the stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A single <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LiveTailSessionStart.html"
     * >LiveTailSessionStart</a> object is sent at the start of the session.
     * </p>
     * </li>
     * <li>
     * <p>
     * Every second, a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LiveTailSessionUpdate.html"
     * >LiveTailSessionUpdate</a> object is sent. Each of these objects contains an array of the actual log events.
     * </p>
     * <p>
     * If no new log events were ingested in the past second, the <code>LiveTailSessionUpdate</code> object will contain
     * an empty array.
     * </p>
     * <p>
     * The array of log events contained in a <code>LiveTailSessionUpdate</code> can include as many as 500 log events.
     * If the number of log events matching the request exceeds 500 per second, the log events are sampled down to 500
     * log events to be included in each <code>LiveTailSessionUpdate</code> object.
     * </p>
     * <p>
     * If your client consumes the log events slower than the server produces them, CloudWatch Logs buffers up to 10
     * <code>LiveTailSessionUpdate</code> events or 5000 log events, after which it starts dropping the oldest events.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartLiveTailResponseStream.html#CWL-Type-StartLiveTailResponseStream-SessionStreamingException"
     * >SessionStreamingException</a> object is returned if an unknown error occurs on the server side.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartLiveTailResponseStream.html#CWL-Type-StartLiveTailResponseStream-SessionTimeoutException"
     * >SessionTimeoutException</a> object is returned when the session times out, after it has been kept open for three
     * hours.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * You can end a session before it times out by closing the session stream or by closing the client that is
     * receiving the stream. The session also ends if the established connection between the client and the server
     * breaks.
     * </p>
     * </important>
     * <p>
     * For examples of using an SDK to start a Live Tail session, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/example_cloudwatch-logs_StartLiveTail_section.html">
     * Start a Live Tail session using an Amazon Web Services SDK</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLiveTailRequest.Builder} avoiding the need to
     * create one manually via {@link StartLiveTailRequest#builder()}
     * </p>
     *
     * @param startLiveTailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartLiveTail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.StartLiveTail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StartLiveTail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<Void> startLiveTail(Consumer<StartLiveTailRequest.Builder> startLiveTailRequest,
            StartLiveTailResponseHandler asyncResponseHandler) {
        return startLiveTail(StartLiveTailRequest.builder().applyMutation(startLiveTailRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Starts a query of one or more log groups using CloudWatch Logs Insights. You specify the log groups and time
     * range to query and the query string to use.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights
     * Query Syntax</a>.
     * </p>
     * <p>
     * After you run a query using <code>StartQuery</code>, the query results are stored by CloudWatch Logs. You can use
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html">
     * GetQueryResults</a> to retrieve the results of a query, using the <code>queryId</code> that
     * <code>StartQuery</code> returns.
     * </p>
     * <note>
     * <p>
     * To specify the log groups to query, a <code>StartQuery</code> operation must include one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Either exactly one of the following parameters: <code>logGroupName</code>, <code>logGroupNames</code>, or
     * <code>logGroupIdentifiers</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Or the <code>queryString</code> must include a <code>SOURCE</code> command to select log groups for the query.
     * The <code>SOURCE</code> command can select log groups based on log group name prefix, account ID, and log class.
     * </p>
     * <p>
     * For more information about the <code>SOURCE</code> command, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax-Source.html">SOURCE</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If you have associated a KMS key with the query results in this account, then <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * uses that key to encrypt the results when it stores them. If no key is associated with query results, the query
     * results are encrypted with the default CloudWatch Logs encryption method.
     * </p>
     * <p>
     * Queries time out after 60 minutes of runtime. If your queries are timing out, reduce the time range being
     * searched or partition your query into a number of queries.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account to
     * start a query in a linked source account. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>. For a cross-account <code>StartQuery</code> operation, the query
     * definition must be defined in the monitoring account.
     * </p>
     * <p>
     * You can have up to 30 concurrent CloudWatch Logs insights queries, including queries that have been added to
     * dashboards.
     * </p>
     *
     * @param startQueryRequest
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MalformedQueryException The query string is not valid. Details about this error are displayed in a
     *         <code>QueryCompileError</code> object. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html"
     *         >QueryCompileError</a>.</p>
     *         <p>
     *         For more information about valid query syntax, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs
     *         Insights Query Syntax</a>.</li>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQueryResponse> startQuery(StartQueryRequest startQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a query of one or more log groups using CloudWatch Logs Insights. You specify the log groups and time
     * range to query and the query string to use.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights
     * Query Syntax</a>.
     * </p>
     * <p>
     * After you run a query using <code>StartQuery</code>, the query results are stored by CloudWatch Logs. You can use
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html">
     * GetQueryResults</a> to retrieve the results of a query, using the <code>queryId</code> that
     * <code>StartQuery</code> returns.
     * </p>
     * <note>
     * <p>
     * To specify the log groups to query, a <code>StartQuery</code> operation must include one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Either exactly one of the following parameters: <code>logGroupName</code>, <code>logGroupNames</code>, or
     * <code>logGroupIdentifiers</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Or the <code>queryString</code> must include a <code>SOURCE</code> command to select log groups for the query.
     * The <code>SOURCE</code> command can select log groups based on log group name prefix, account ID, and log class.
     * </p>
     * <p>
     * For more information about the <code>SOURCE</code> command, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax-Source.html">SOURCE</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If you have associated a KMS key with the query results in this account, then <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * uses that key to encrypt the results when it stores them. If no key is associated with query results, the query
     * results are encrypted with the default CloudWatch Logs encryption method.
     * </p>
     * <p>
     * Queries time out after 60 minutes of runtime. If your queries are timing out, reduce the time range being
     * searched or partition your query into a number of queries.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account to
     * start a query in a linked source account. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>. For a cross-account <code>StartQuery</code> operation, the query
     * definition must be defined in the monitoring account.
     * </p>
     * <p>
     * You can have up to 30 concurrent CloudWatch Logs insights queries, including queries that have been added to
     * dashboards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryRequest.Builder} avoiding the need to
     * create one manually via {@link StartQueryRequest#builder()}
     * </p>
     *
     * @param startQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MalformedQueryException The query string is not valid. Details about this error are displayed in a
     *         <code>QueryCompileError</code> object. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html"
     *         >QueryCompileError</a>.</p>
     *         <p>
     *         For more information about valid query syntax, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs
     *         Insights Query Syntax</a>.</li>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>LimitExceededException You have reached the maximum number of resources that can be created.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQueryResponse> startQuery(Consumer<StartQueryRequest.Builder> startQueryRequest) {
        return startQuery(StartQueryRequest.builder().applyMutation(startQueryRequest).build());
    }

    /**
     * <p>
     * Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns
     * an error indicating that the specified query is not running.
     * </p>
     *
     * @param stopQueryRequest
     * @return A Java Future containing the result of the StopQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.StopQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StopQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopQueryResponse> stopQuery(StopQueryRequest stopQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns
     * an error indicating that the specified query is not running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopQueryRequest.Builder} avoiding the need to
     * create one manually via {@link StopQueryRequest#builder()}
     * </p>
     *
     * @param stopQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.StopQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StopQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopQueryResponse> stopQuery(Consumer<StopQueryRequest.Builder> stopQueryRequest) {
        return stopQuery(StopQueryRequest.builder().applyMutation(stopQueryRequest).build());
    }

    /**
     * <important>
     * <p>
     * The TagLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html">TagResource</a>
     * instead.
     * </p>
     * </important>
     * <p>
     * Adds or updates the specified tags for the specified log group.
     * </p>
     * <p>
     * To list the tags for a log group, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a>. To remove tags, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html"
     * >UntagResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging"
     * >Tag Log Groups in Amazon CloudWatch Logs</a> in the <i>Amazon CloudWatch Logs User Guide</i>.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that prevent users from assigning specified tags to log groups using
     * the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information
     * about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     *
     * @param tagLogGroupRequest
     * @return A Java Future containing the result of the TagLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TagLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagLogGroup" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Please use the generic tagging API TagResource
     */
    @Deprecated
    default CompletableFuture<TagLogGroupResponse> tagLogGroup(TagLogGroupRequest tagLogGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * The TagLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html">TagResource</a>
     * instead.
     * </p>
     * </important>
     * <p>
     * Adds or updates the specified tags for the specified log group.
     * </p>
     * <p>
     * To list the tags for a log group, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a>. To remove tags, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html"
     * >UntagResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging"
     * >Tag Log Groups in Amazon CloudWatch Logs</a> in the <i>Amazon CloudWatch Logs User Guide</i>.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that prevent users from assigning specified tags to log groups using
     * the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information
     * about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagLogGroupRequest.Builder} avoiding the need to
     * create one manually via {@link TagLogGroupRequest#builder()}
     * </p>
     *
     * @param tagLogGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TagLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagLogGroup" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Please use the generic tagging API TagResource
     */
    @Deprecated
    default CompletableFuture<TagLogGroupResponse> tagLogGroup(Consumer<TagLogGroupRequest.Builder> tagLogGroupRequest) {
        return tagLogGroup(TagLogGroupRequest.builder().applyMutation(tagLogGroupRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs resource. Currently, the only
     * CloudWatch Logs resources that can be tagged are log groups and destinations.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key
     * that is already associated with the alarm, the new tag value that you specify replaces the previous value for
     * that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a CloudWatch Logs resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>TooManyTagsException A resource can have no more than 50 tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs resource. Currently, the only
     * CloudWatch Logs resources that can be tagged are log groups and destinations.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key
     * that is already associated with the alarm, the new tag value that you specify replaces the previous value for
     * that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a CloudWatch Logs resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>TooManyTagsException A resource can have no more than 50 tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to
     * validate the correctness of a metric filter pattern.
     * </p>
     *
     * @param testMetricFilterRequest
     * @return A Java Future containing the result of the TestMetricFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TestMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestMetricFilterResponse> testMetricFilter(TestMetricFilterRequest testMetricFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to
     * validate the correctness of a metric filter pattern.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestMetricFilterRequest.Builder} avoiding the need
     * to create one manually via {@link TestMetricFilterRequest#builder()}
     * </p>
     *
     * @param testMetricFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestMetricFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TestMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestMetricFilterResponse> testMetricFilter(
            Consumer<TestMetricFilterRequest.Builder> testMetricFilterRequest) {
        return testMetricFilter(TestMetricFilterRequest.builder().applyMutation(testMetricFilterRequest).build());
    }

    /**
     * <p>
     * Use this operation to test a log transformer. You enter the transformer configuration and a set of log events to
     * test with. The operation responds with an array that includes the original log events and the transformed
     * versions.
     * </p>
     *
     * @param testTransformerRequest
     * @return A Java Future containing the result of the TestTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TestTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestTransformerResponse> testTransformer(TestTransformerRequest testTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to test a log transformer. You enter the transformer configuration and a set of log events to
     * test with. The operation responds with an array that includes the original log events and the transformed
     * versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link TestTransformerRequest#builder()}
     * </p>
     *
     * @param testTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>InvalidOperationException The operation is not valid on the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.TestTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestTransformerResponse> testTransformer(
            Consumer<TestTransformerRequest.Builder> testTransformerRequest) {
        return testTransformer(TestTransformerRequest.builder().applyMutation(testTransformerRequest).build());
    }

    /**
     * <important>
     * <p>
     * The UntagLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html"
     * >UntagResource</a> instead.
     * </p>
     * </important>
     * <p>
     * Removes the specified tags from the specified log group.
     * </p>
     * <p>
     * To list the tags for a log group, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a>. To add tags, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that prevent users from assigning specified tags to log groups using
     * the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys.
     * </p>
     *
     * @param untagLogGroupRequest
     * @return A Java Future containing the result of the UntagLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UntagLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagLogGroup" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Please use the generic tagging API UntagResource
     */
    @Deprecated
    default CompletableFuture<UntagLogGroupResponse> untagLogGroup(UntagLogGroupRequest untagLogGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * The UntagLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html"
     * >UntagResource</a> instead.
     * </p>
     * </important>
     * <p>
     * Removes the specified tags from the specified log group.
     * </p>
     * <p>
     * To list the tags for a log group, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a>. To add tags, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that prevent users from assigning specified tags to log groups using
     * the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagLogGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UntagLogGroupRequest#builder()}
     * </p>
     *
     * @param untagLogGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagLogGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UntagLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagLogGroup" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Please use the generic tagging API UntagResource
     */
    @Deprecated
    default CompletableFuture<UntagLogGroupResponse> untagLogGroup(Consumer<UntagLogGroupRequest.Builder> untagLogGroupRequest) {
        return untagLogGroup(UntagLogGroupRequest.builder().applyMutation(untagLogGroupRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Use this operation to <i>suppress</i> anomaly detection for a specified anomaly or pattern. If you suppress an
     * anomaly, CloudWatch Logs won't report new occurrences of that anomaly and won't update that anomaly with new
     * data. If you suppress a pattern, CloudWatch Logs won't report any anomalies related to that pattern.
     * </p>
     * <p>
     * You must specify either <code>anomalyId</code> or <code>patternId</code>, but you can't specify both parameters
     * in the same operation.
     * </p>
     * <p>
     * If you have previously used this operation to suppress detection of a pattern or anomaly, you can use it again to
     * cause CloudWatch Logs to end the suppression. To do this, use this operation and specify the anomaly or pattern
     * to stop suppressing, and omit the <code>suppressionType</code> and <code>suppressionPeriod</code> parameters.
     * </p>
     *
     * @param updateAnomalyRequest
     * @return A Java Future containing the result of the UpdateAnomaly operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UpdateAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateAnomaly" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAnomalyResponse> updateAnomaly(UpdateAnomalyRequest updateAnomalyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to <i>suppress</i> anomaly detection for a specified anomaly or pattern. If you suppress an
     * anomaly, CloudWatch Logs won't report new occurrences of that anomaly and won't update that anomaly with new
     * data. If you suppress a pattern, CloudWatch Logs won't report any anomalies related to that pattern.
     * </p>
     * <p>
     * You must specify either <code>anomalyId</code> or <code>patternId</code>, but you can't specify both parameters
     * in the same operation.
     * </p>
     * <p>
     * If you have previously used this operation to suppress detection of a pattern or anomaly, you can use it again to
     * cause CloudWatch Logs to end the suppression. To do this, use this operation and specify the anomaly or pattern
     * to stop suppressing, and omit the <code>suppressionType</code> and <code>suppressionPeriod</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAnomalyRequest#builder()}
     * </p>
     *
     * @param updateAnomalyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAnomaly operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UpdateAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateAnomaly" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAnomalyResponse> updateAnomaly(Consumer<UpdateAnomalyRequest.Builder> updateAnomalyRequest) {
        return updateAnomaly(UpdateAnomalyRequest.builder().applyMutation(updateAnomalyRequest).build());
    }

    /**
     * <p>
     * Use this operation to update the configuration of a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Delivery.html">delivery</a> to
     * change either the S3 path pattern or the format of the delivered logs. You can't use this operation to change the
     * source or destination of the delivery.
     * </p>
     *
     * @param updateDeliveryConfigurationRequest
     * @return A Java Future containing the result of the UpdateDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UpdateDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeliveryConfigurationResponse> updateDeliveryConfiguration(
            UpdateDeliveryConfigurationRequest updateDeliveryConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to update the configuration of a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Delivery.html">delivery</a> to
     * change either the S3 path pattern or the format of the delivered logs. You can't use this operation to change the
     * source or destination of the delivery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeliveryConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDeliveryConfigurationRequest#builder()}
     * </p>
     *
     * @param updateDeliveryConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>ConflictException This operation attempted to create a resource that already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException One of the parameters for the request is not valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UpdateDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeliveryConfigurationResponse> updateDeliveryConfiguration(
            Consumer<UpdateDeliveryConfigurationRequest.Builder> updateDeliveryConfigurationRequest) {
        return updateDeliveryConfiguration(UpdateDeliveryConfigurationRequest.builder()
                .applyMutation(updateDeliveryConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing log anomaly detector.
     * </p>
     *
     * @param updateLogAnomalyDetectorRequest
     * @return A Java Future containing the result of the UpdateLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UpdateLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLogAnomalyDetectorResponse> updateLogAnomalyDetector(
            UpdateLogAnomalyDetectorRequest updateLogAnomalyDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing log anomaly detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLogAnomalyDetectorRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLogAnomalyDetectorRequest#builder()}
     * </p>
     *
     * @param updateLogAnomalyDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLogAnomalyDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException A parameter is specified incorrectly.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ServiceUnavailableException The service cannot complete the request.</li>
     *         <li>OperationAbortedException Multiple concurrent requests to update the same resource were in conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudWatchLogsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudWatchLogsAsyncClient.UpdateLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLogAnomalyDetectorResponse> updateLogAnomalyDetector(
            Consumer<UpdateLogAnomalyDetectorRequest.Builder> updateLogAnomalyDetectorRequest) {
        return updateLogAnomalyDetector(UpdateLogAnomalyDetectorRequest.builder().applyMutation(updateLogAnomalyDetectorRequest)
                .build());
    }

    @Override
    default CloudWatchLogsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudWatchLogsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudWatchLogsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudWatchLogsAsyncClient}.
     */
    static CloudWatchLogsAsyncClientBuilder builder() {
        return new DefaultCloudWatchLogsAsyncClientBuilder();
    }
}
