/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransformerResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetTransformerResponse.Builder, GetTransformerResponse> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(GetTransformerResponse::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTime").getter(getter(GetTransformerResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(GetTransformerResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<List<Processor>> TRANSFORMER_CONFIG_FIELD = SdkField
            .<List<Processor>> builder(MarshallingType.LIST)
            .memberName("transformerConfig")
            .getter(getter(GetTransformerResponse::transformerConfig))
            .setter(setter(Builder::transformerConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Processor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Processor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRANSFORMER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
                    put("creationTime", CREATION_TIME_FIELD);
                    put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("transformerConfig", TRANSFORMER_CONFIG_FIELD);
                }
            });

    private final String logGroupIdentifier;

    private final Long creationTime;

    private final Long lastModifiedTime;

    private final List<Processor> transformerConfig;

    private GetTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.transformerConfig = builder.transformerConfig;
    }

    /**
     * <p>
     * The ARN of the log group that you specified in your request.
     * </p>
     * 
     * @return The ARN of the log group that you specified in your request.
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * The creation time of the transformer, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the transformer, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
     *         UTC.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time when this transformer was most recently modified, expressed as the number of milliseconds after
     * Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The date and time when this transformer was most recently modified, expressed as the number of
     *         milliseconds after Jan 1, 1970 00:00:00 UTC.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransformerConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransformerConfig() {
        return transformerConfig != null && !(transformerConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This sructure contains the configuration of the requested transformer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformerConfig} method.
     * </p>
     * 
     * @return This sructure contains the configuration of the requested transformer.
     */
    public final List<Processor> transformerConfig() {
        return transformerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformerConfig() ? transformerConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerResponse)) {
            return false;
        }
        GetTransformerResponse other = (GetTransformerResponse) obj;
        return Objects.equals(logGroupIdentifier(), other.logGroupIdentifier())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && hasTransformerConfig() == other.hasTransformerConfig()
                && Objects.equals(transformerConfig(), other.transformerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransformerResponse").add("LogGroupIdentifier", logGroupIdentifier())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("TransformerConfig", hasTransformerConfig() ? transformerConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "transformerConfig":
            return Optional.ofNullable(clazz.cast(transformerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTransformerResponse, T> g) {
        return obj -> g.apply((GetTransformerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTransformerResponse> {
        /**
         * <p>
         * The ARN of the log group that you specified in your request.
         * </p>
         * 
         * @param logGroupIdentifier
         *        The ARN of the log group that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * The creation time of the transformer, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the transformer, expressed as the number of milliseconds after Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The date and time when this transformer was most recently modified, expressed as the number of milliseconds
         * after Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when this transformer was most recently modified, expressed as the number of
         *        milliseconds after Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * This sructure contains the configuration of the requested transformer.
         * </p>
         * 
         * @param transformerConfig
         *        This sructure contains the configuration of the requested transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerConfig(Collection<Processor> transformerConfig);

        /**
         * <p>
         * This sructure contains the configuration of the requested transformer.
         * </p>
         * 
         * @param transformerConfig
         *        This sructure contains the configuration of the requested transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerConfig(Processor... transformerConfig);

        /**
         * <p>
         * This sructure contains the configuration of the requested transformer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor.Builder#build()} is called immediately
         * and its result is passed to {@link #transformerConfig(List<Processor>)}.
         * 
         * @param transformerConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformerConfig(java.util.Collection<Processor>)
         */
        Builder transformerConfig(Consumer<Processor.Builder>... transformerConfig);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String logGroupIdentifier;

        private Long creationTime;

        private Long lastModifiedTime;

        private List<Processor> transformerConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransformerResponse model) {
            super(model);
            logGroupIdentifier(model.logGroupIdentifier);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            transformerConfig(model.transformerConfig);
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<Processor.Builder> getTransformerConfig() {
            List<Processor.Builder> result = ProcessorsCopier.copyToBuilder(this.transformerConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformerConfig(Collection<Processor.BuilderImpl> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copyFromBuilder(transformerConfig);
        }

        @Override
        public final Builder transformerConfig(Collection<Processor> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copy(transformerConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Processor... transformerConfig) {
            transformerConfig(Arrays.asList(transformerConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Consumer<Processor.Builder>... transformerConfig) {
            transformerConfig(Stream.of(transformerConfig).map(c -> Processor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTransformerResponse build() {
            return new GetTransformerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
