/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountPoliciesResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeAccountPoliciesResponse.Builder, DescribeAccountPoliciesResponse> {
    private static final SdkField<List<AccountPolicy>> ACCOUNT_POLICIES_FIELD = SdkField
            .<List<AccountPolicy>> builder(MarshallingType.LIST)
            .memberName("accountPolicies")
            .getter(getter(DescribeAccountPoliciesResponse::accountPolicies))
            .setter(setter(Builder::accountPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAccountPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountPolicies", ACCOUNT_POLICIES_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<AccountPolicy> accountPolicies;

    private final String nextToken;

    private DescribeAccountPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.accountPolicies = builder.accountPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountPolicies() {
        return accountPolicies != null && !(accountPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain information about the CloudWatch Logs account policies that match the
     * specified filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountPolicies} method.
     * </p>
     * 
     * @return An array of structures that contain information about the CloudWatch Logs account policies that match the
     *         specified filters.
     */
    public final List<AccountPolicy> accountPolicies() {
        return accountPolicies;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. The token expires after 24 hours.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. The token expires after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountPolicies() ? accountPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountPoliciesResponse)) {
            return false;
        }
        DescribeAccountPoliciesResponse other = (DescribeAccountPoliciesResponse) obj;
        return hasAccountPolicies() == other.hasAccountPolicies() && Objects.equals(accountPolicies(), other.accountPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountPoliciesResponse")
                .add("AccountPolicies", hasAccountPolicies() ? accountPolicies() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountPolicies":
            return Optional.ofNullable(clazz.cast(accountPolicies()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeAccountPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountPoliciesResponse> {
        /**
         * <p>
         * An array of structures that contain information about the CloudWatch Logs account policies that match the
         * specified filters.
         * </p>
         * 
         * @param accountPolicies
         *        An array of structures that contain information about the CloudWatch Logs account policies that match
         *        the specified filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPolicies(Collection<AccountPolicy> accountPolicies);

        /**
         * <p>
         * An array of structures that contain information about the CloudWatch Logs account policies that match the
         * specified filters.
         * </p>
         * 
         * @param accountPolicies
         *        An array of structures that contain information about the CloudWatch Logs account policies that match
         *        the specified filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPolicies(AccountPolicy... accountPolicies);

        /**
         * <p>
         * An array of structures that contain information about the CloudWatch Logs account policies that match the
         * specified filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.AccountPolicy.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.AccountPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.AccountPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #accountPolicies(List<AccountPolicy>)}.
         * 
         * @param accountPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.AccountPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountPolicies(java.util.Collection<AccountPolicy>)
         */
        Builder accountPolicies(Consumer<AccountPolicy.Builder>... accountPolicies);

        /**
         * <p>
         * The token to use when requesting the next set of items. The token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. The token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<AccountPolicy> accountPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountPoliciesResponse model) {
            super(model);
            accountPolicies(model.accountPolicies);
            nextToken(model.nextToken);
        }

        public final List<AccountPolicy.Builder> getAccountPolicies() {
            List<AccountPolicy.Builder> result = AccountPoliciesCopier.copyToBuilder(this.accountPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountPolicies(Collection<AccountPolicy.BuilderImpl> accountPolicies) {
            this.accountPolicies = AccountPoliciesCopier.copyFromBuilder(accountPolicies);
        }

        @Override
        public final Builder accountPolicies(Collection<AccountPolicy> accountPolicies) {
            this.accountPolicies = AccountPoliciesCopier.copy(accountPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountPolicies(AccountPolicy... accountPolicies) {
            accountPolicies(Arrays.asList(accountPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountPolicies(Consumer<AccountPolicy.Builder>... accountPolicies) {
            accountPolicies(Stream.of(accountPolicies).map(c -> AccountPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAccountPoliciesResponse build() {
            return new DescribeAccountPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
