/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure describes one log event field that is used as an index in at least one index policy in this account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldIndex implements SdkPojo, Serializable, ToCopyableBuilder<FieldIndex.Builder, FieldIndex> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(FieldIndex::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<String> FIELD_INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldIndexName").getter(getter(FieldIndex::fieldIndexName)).setter(setter(Builder::fieldIndexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldIndexName").build()).build();

    private static final SdkField<Long> LAST_SCAN_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastScanTime").getter(getter(FieldIndex::lastScanTime)).setter(setter(Builder::lastScanTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScanTime").build()).build();

    private static final SdkField<Long> FIRST_EVENT_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("firstEventTime").getter(getter(FieldIndex::firstEventTime)).setter(setter(Builder::firstEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstEventTime").build()).build();

    private static final SdkField<Long> LAST_EVENT_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastEventTime").getter(getter(FieldIndex::lastEventTime)).setter(setter(Builder::lastEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEventTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD,
            FIELD_INDEX_NAME_FIELD, LAST_SCAN_TIME_FIELD, FIRST_EVENT_TIME_FIELD, LAST_EVENT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
                    put("fieldIndexName", FIELD_INDEX_NAME_FIELD);
                    put("lastScanTime", LAST_SCAN_TIME_FIELD);
                    put("firstEventTime", FIRST_EVENT_TIME_FIELD);
                    put("lastEventTime", LAST_EVENT_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String logGroupIdentifier;

    private final String fieldIndexName;

    private final Long lastScanTime;

    private final Long firstEventTime;

    private final Long lastEventTime;

    private FieldIndex(BuilderImpl builder) {
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.fieldIndexName = builder.fieldIndexName;
        this.lastScanTime = builder.lastScanTime;
        this.firstEventTime = builder.firstEventTime;
        this.lastEventTime = builder.lastEventTime;
    }

    /**
     * <p>
     * If this field index appears in an index policy that applies only to a single log group, the ARN of that log group
     * is displayed here.
     * </p>
     * 
     * @return If this field index appears in an index policy that applies only to a single log group, the ARN of that
     *         log group is displayed here.
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * The string that this field index matches.
     * </p>
     * 
     * @return The string that this field index matches.
     */
    public final String fieldIndexName() {
        return fieldIndexName;
    }

    /**
     * <p>
     * The most recent time that CloudWatch Logs scanned ingested log events to search for this field index to improve
     * the speed of future CloudWatch Logs Insights queries that search for this field index.
     * </p>
     * 
     * @return The most recent time that CloudWatch Logs scanned ingested log events to search for this field index to
     *         improve the speed of future CloudWatch Logs Insights queries that search for this field index.
     */
    public final Long lastScanTime() {
        return lastScanTime;
    }

    /**
     * <p>
     * The time and date of the earliest log event that matches this field index, after the index policy that contains
     * it was created.
     * </p>
     * 
     * @return The time and date of the earliest log event that matches this field index, after the index policy that
     *         contains it was created.
     */
    public final Long firstEventTime() {
        return firstEventTime;
    }

    /**
     * <p>
     * The time and date of the most recent log event that matches this field index.
     * </p>
     * 
     * @return The time and date of the most recent log event that matches this field index.
     */
    public final Long lastEventTime() {
        return lastEventTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(fieldIndexName());
        hashCode = 31 * hashCode + Objects.hashCode(lastScanTime());
        hashCode = 31 * hashCode + Objects.hashCode(firstEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastEventTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldIndex)) {
            return false;
        }
        FieldIndex other = (FieldIndex) obj;
        return Objects.equals(logGroupIdentifier(), other.logGroupIdentifier())
                && Objects.equals(fieldIndexName(), other.fieldIndexName())
                && Objects.equals(lastScanTime(), other.lastScanTime())
                && Objects.equals(firstEventTime(), other.firstEventTime())
                && Objects.equals(lastEventTime(), other.lastEventTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldIndex").add("LogGroupIdentifier", logGroupIdentifier())
                .add("FieldIndexName", fieldIndexName()).add("LastScanTime", lastScanTime())
                .add("FirstEventTime", firstEventTime()).add("LastEventTime", lastEventTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "fieldIndexName":
            return Optional.ofNullable(clazz.cast(fieldIndexName()));
        case "lastScanTime":
            return Optional.ofNullable(clazz.cast(lastScanTime()));
        case "firstEventTime":
            return Optional.ofNullable(clazz.cast(firstEventTime()));
        case "lastEventTime":
            return Optional.ofNullable(clazz.cast(lastEventTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FieldIndex, T> g) {
        return obj -> g.apply((FieldIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldIndex> {
        /**
         * <p>
         * If this field index appears in an index policy that applies only to a single log group, the ARN of that log
         * group is displayed here.
         * </p>
         * 
         * @param logGroupIdentifier
         *        If this field index appears in an index policy that applies only to a single log group, the ARN of
         *        that log group is displayed here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * The string that this field index matches.
         * </p>
         * 
         * @param fieldIndexName
         *        The string that this field index matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldIndexName(String fieldIndexName);

        /**
         * <p>
         * The most recent time that CloudWatch Logs scanned ingested log events to search for this field index to
         * improve the speed of future CloudWatch Logs Insights queries that search for this field index.
         * </p>
         * 
         * @param lastScanTime
         *        The most recent time that CloudWatch Logs scanned ingested log events to search for this field index
         *        to improve the speed of future CloudWatch Logs Insights queries that search for this field index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScanTime(Long lastScanTime);

        /**
         * <p>
         * The time and date of the earliest log event that matches this field index, after the index policy that
         * contains it was created.
         * </p>
         * 
         * @param firstEventTime
         *        The time and date of the earliest log event that matches this field index, after the index policy that
         *        contains it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstEventTime(Long firstEventTime);

        /**
         * <p>
         * The time and date of the most recent log event that matches this field index.
         * </p>
         * 
         * @param lastEventTime
         *        The time and date of the most recent log event that matches this field index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEventTime(Long lastEventTime);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupIdentifier;

        private String fieldIndexName;

        private Long lastScanTime;

        private Long firstEventTime;

        private Long lastEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldIndex model) {
            logGroupIdentifier(model.logGroupIdentifier);
            fieldIndexName(model.fieldIndexName);
            lastScanTime(model.lastScanTime);
            firstEventTime(model.firstEventTime);
            lastEventTime(model.lastEventTime);
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getFieldIndexName() {
            return fieldIndexName;
        }

        public final void setFieldIndexName(String fieldIndexName) {
            this.fieldIndexName = fieldIndexName;
        }

        @Override
        public final Builder fieldIndexName(String fieldIndexName) {
            this.fieldIndexName = fieldIndexName;
            return this;
        }

        public final Long getLastScanTime() {
            return lastScanTime;
        }

        public final void setLastScanTime(Long lastScanTime) {
            this.lastScanTime = lastScanTime;
        }

        @Override
        public final Builder lastScanTime(Long lastScanTime) {
            this.lastScanTime = lastScanTime;
            return this;
        }

        public final Long getFirstEventTime() {
            return firstEventTime;
        }

        public final void setFirstEventTime(Long firstEventTime) {
            this.firstEventTime = firstEventTime;
        }

        @Override
        public final Builder firstEventTime(Long firstEventTime) {
            this.firstEventTime = firstEventTime;
            return this;
        }

        public final Long getLastEventTime() {
            return lastEventTime;
        }

        public final void setLastEventTime(Long lastEventTime) {
            this.lastEventTime = lastEventTime;
        }

        @Override
        public final Builder lastEventTime(Long lastEventTime) {
            this.lastEventTime = lastEventTime;
            return this;
        }

        @Override
        public FieldIndex build() {
            return new FieldIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
