/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestTransformerResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<TestTransformerResponse.Builder, TestTransformerResponse> {
    private static final SdkField<List<TransformedLogRecord>> TRANSFORMED_LOGS_FIELD = SdkField
            .<List<TransformedLogRecord>> builder(MarshallingType.LIST)
            .memberName("transformedLogs")
            .getter(getter(TestTransformerResponse::transformedLogs))
            .setter(setter(Builder::transformedLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformedLogs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransformedLogRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransformedLogRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMED_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("transformedLogs", TRANSFORMED_LOGS_FIELD);
                }
            });

    private final List<TransformedLogRecord> transformedLogs;

    private TestTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.transformedLogs = builder.transformedLogs;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransformedLogs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransformedLogs() {
        return transformedLogs != null && !(transformedLogs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array where each member of the array includes both the original version and the transformed version of one of
     * the log events that you input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformedLogs} method.
     * </p>
     * 
     * @return An array where each member of the array includes both the original version and the transformed version of
     *         one of the log events that you input.
     */
    public final List<TransformedLogRecord> transformedLogs() {
        return transformedLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformedLogs() ? transformedLogs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTransformerResponse)) {
            return false;
        }
        TestTransformerResponse other = (TestTransformerResponse) obj;
        return hasTransformedLogs() == other.hasTransformedLogs() && Objects.equals(transformedLogs(), other.transformedLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestTransformerResponse")
                .add("TransformedLogs", hasTransformedLogs() ? transformedLogs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformedLogs":
            return Optional.ofNullable(clazz.cast(transformedLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestTransformerResponse, T> g) {
        return obj -> g.apply((TestTransformerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestTransformerResponse> {
        /**
         * <p>
         * An array where each member of the array includes both the original version and the transformed version of one
         * of the log events that you input.
         * </p>
         * 
         * @param transformedLogs
         *        An array where each member of the array includes both the original version and the transformed version
         *        of one of the log events that you input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformedLogs(Collection<TransformedLogRecord> transformedLogs);

        /**
         * <p>
         * An array where each member of the array includes both the original version and the transformed version of one
         * of the log events that you input.
         * </p>
         * 
         * @param transformedLogs
         *        An array where each member of the array includes both the original version and the transformed version
         *        of one of the log events that you input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformedLogs(TransformedLogRecord... transformedLogs);

        /**
         * <p>
         * An array where each member of the array includes both the original version and the transformed version of one
         * of the log events that you input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TransformedLogRecord.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TransformedLogRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TransformedLogRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #transformedLogs(List<TransformedLogRecord>)}.
         * 
         * @param transformedLogs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TransformedLogRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformedLogs(java.util.Collection<TransformedLogRecord>)
         */
        Builder transformedLogs(Consumer<TransformedLogRecord.Builder>... transformedLogs);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<TransformedLogRecord> transformedLogs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestTransformerResponse model) {
            super(model);
            transformedLogs(model.transformedLogs);
        }

        public final List<TransformedLogRecord.Builder> getTransformedLogs() {
            List<TransformedLogRecord.Builder> result = TransformedLogsCopier.copyToBuilder(this.transformedLogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformedLogs(Collection<TransformedLogRecord.BuilderImpl> transformedLogs) {
            this.transformedLogs = TransformedLogsCopier.copyFromBuilder(transformedLogs);
        }

        @Override
        public final Builder transformedLogs(Collection<TransformedLogRecord> transformedLogs) {
            this.transformedLogs = TransformedLogsCopier.copy(transformedLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformedLogs(TransformedLogRecord... transformedLogs) {
            transformedLogs(Arrays.asList(transformedLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformedLogs(Consumer<TransformedLogRecord.Builder>... transformedLogs) {
            transformedLogs(Stream.of(transformedLogs).map(c -> TransformedLogRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TestTransformerResponse build() {
            return new TestTransformerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
