/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about the deafult settings and available settings that you can use to configure a
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Delivery.html">delivery</a> or a <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeliveryDestination.html">delivery
 * destination</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationTemplate.Builder, ConfigurationTemplate> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(ConfigurationTemplate::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logType").getter(getter(ConfigurationTemplate::logType)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ConfigurationTemplate::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryDestinationType").getter(getter(ConfigurationTemplate::deliveryDestinationTypeAsString))
            .setter(setter(Builder::deliveryDestinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationType").build())
            .build();

    private static final SdkField<ConfigurationTemplateDeliveryConfigValues> DEFAULT_DELIVERY_CONFIG_VALUES_FIELD = SdkField
            .<ConfigurationTemplateDeliveryConfigValues> builder(MarshallingType.SDK_POJO)
            .memberName("defaultDeliveryConfigValues")
            .getter(getter(ConfigurationTemplate::defaultDeliveryConfigValues))
            .setter(setter(Builder::defaultDeliveryConfigValues))
            .constructor(ConfigurationTemplateDeliveryConfigValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDeliveryConfigValues")
                    .build()).build();

    private static final SdkField<List<RecordField>> ALLOWED_FIELDS_FIELD = SdkField
            .<List<RecordField>> builder(MarshallingType.LIST)
            .memberName("allowedFields")
            .getter(getter(ConfigurationTemplate::allowedFields))
            .setter(setter(Builder::allowedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordField> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_OUTPUT_FORMATS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedOutputFormats")
            .getter(getter(ConfigurationTemplate::allowedOutputFormatsAsStrings))
            .setter(setter(Builder::allowedOutputFormatsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedOutputFormats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALLOWED_ACTION_FOR_ALLOW_VENDED_LOGS_DELIVERY_FOR_RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("allowedActionForAllowVendedLogsDeliveryForResource")
            .getter(getter(ConfigurationTemplate::allowedActionForAllowVendedLogsDeliveryForResource))
            .setter(setter(Builder::allowedActionForAllowVendedLogsDeliveryForResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowedActionForAllowVendedLogsDeliveryForResource").build()).build();

    private static final SdkField<List<String>> ALLOWED_FIELD_DELIMITERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedFieldDelimiters")
            .getter(getter(ConfigurationTemplate::allowedFieldDelimiters))
            .setter(setter(Builder::allowedFieldDelimiters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedFieldDelimiters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_SUFFIX_PATH_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedSuffixPathFields")
            .getter(getter(ConfigurationTemplate::allowedSuffixPathFields))
            .setter(setter(Builder::allowedSuffixPathFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedSuffixPathFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, LOG_TYPE_FIELD,
            RESOURCE_TYPE_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, DEFAULT_DELIVERY_CONFIG_VALUES_FIELD, ALLOWED_FIELDS_FIELD,
            ALLOWED_OUTPUT_FORMATS_FIELD, ALLOWED_ACTION_FOR_ALLOW_VENDED_LOGS_DELIVERY_FOR_RESOURCE_FIELD,
            ALLOWED_FIELD_DELIMITERS_FIELD, ALLOWED_SUFFIX_PATH_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("service", SERVICE_FIELD);
                    put("logType", LOG_TYPE_FIELD);
                    put("resourceType", RESOURCE_TYPE_FIELD);
                    put("deliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
                    put("defaultDeliveryConfigValues", DEFAULT_DELIVERY_CONFIG_VALUES_FIELD);
                    put("allowedFields", ALLOWED_FIELDS_FIELD);
                    put("allowedOutputFormats", ALLOWED_OUTPUT_FORMATS_FIELD);
                    put("allowedActionForAllowVendedLogsDeliveryForResource",
                            ALLOWED_ACTION_FOR_ALLOW_VENDED_LOGS_DELIVERY_FOR_RESOURCE_FIELD);
                    put("allowedFieldDelimiters", ALLOWED_FIELD_DELIMITERS_FIELD);
                    put("allowedSuffixPathFields", ALLOWED_SUFFIX_PATH_FIELDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String service;

    private final String logType;

    private final String resourceType;

    private final String deliveryDestinationType;

    private final ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues;

    private final List<RecordField> allowedFields;

    private final List<String> allowedOutputFormats;

    private final String allowedActionForAllowVendedLogsDeliveryForResource;

    private final List<String> allowedFieldDelimiters;

    private final List<String> allowedSuffixPathFields;

    private ConfigurationTemplate(BuilderImpl builder) {
        this.service = builder.service;
        this.logType = builder.logType;
        this.resourceType = builder.resourceType;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.defaultDeliveryConfigValues = builder.defaultDeliveryConfigValues;
        this.allowedFields = builder.allowedFields;
        this.allowedOutputFormats = builder.allowedOutputFormats;
        this.allowedActionForAllowVendedLogsDeliveryForResource = builder.allowedActionForAllowVendedLogsDeliveryForResource;
        this.allowedFieldDelimiters = builder.allowedFieldDelimiters;
        this.allowedSuffixPathFields = builder.allowedSuffixPathFields;
    }

    /**
     * <p>
     * A string specifying which service this configuration template applies to. For more information about supported
     * services see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>.
     * </p>
     * 
     * @return A string specifying which service this configuration template applies to. For more information about
     *         supported services see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable
     *         logging from Amazon Web Services services.</a>.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * A string specifying which log type this configuration template applies to.
     * </p>
     * 
     * @return A string specifying which log type this configuration template applies to.
     */
    public final String logType() {
        return logType;
    }

    /**
     * <p>
     * A string specifying which resource type this configuration template applies to.
     * </p>
     * 
     * @return A string specifying which resource type this configuration template applies to.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * A string specifying which destination type this configuration template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryDestinationType} will return {@link DeliveryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliveryDestinationTypeAsString}.
     * </p>
     * 
     * @return A string specifying which destination type this configuration template applies to.
     * @see DeliveryDestinationType
     */
    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(deliveryDestinationType);
    }

    /**
     * <p>
     * A string specifying which destination type this configuration template applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryDestinationType} will return {@link DeliveryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliveryDestinationTypeAsString}.
     * </p>
     * 
     * @return A string specifying which destination type this configuration template applies to.
     * @see DeliveryDestinationType
     */
    public final String deliveryDestinationTypeAsString() {
        return deliveryDestinationType;
    }

    /**
     * <p>
     * A mapping that displays the default value of each property within a delivery's configuration, if it is not
     * specified in the request.
     * </p>
     * 
     * @return A mapping that displays the default value of each property within a delivery's configuration, if it is
     *         not specified in the request.
     */
    public final ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues() {
        return defaultDeliveryConfigValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedFields() {
        return allowedFields != null && !(allowedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a> or <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedFields} method.
     * </p>
     * 
     * @return The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     *         >CreateDelivery</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     *         >UpdateDeliveryConfiguration</a> operation.
     */
    public final List<RecordField> allowedFields() {
        return allowedFields;
    }

    /**
     * <p>
     * The list of delivery destination output formats that are supported by this log source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOutputFormats} method.
     * </p>
     * 
     * @return The list of delivery destination output formats that are supported by this log source.
     */
    public final List<OutputFormat> allowedOutputFormats() {
        return OutputFormatsCopier.copyStringToEnum(allowedOutputFormats);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedOutputFormats property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedOutputFormats() {
        return allowedOutputFormats != null && !(allowedOutputFormats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of delivery destination output formats that are supported by this log source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOutputFormats} method.
     * </p>
     * 
     * @return The list of delivery destination output formats that are supported by this log source.
     */
    public final List<String> allowedOutputFormatsAsStrings() {
        return allowedOutputFormats;
    }

    /**
     * <p>
     * The action permissions that a caller needs to have to be able to successfully create a delivery source on the
     * desired resource type when calling <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * 
     * @return The action permissions that a caller needs to have to be able to successfully create a delivery source on
     *         the desired resource type when calling <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     *         >PutDeliverySource</a>.
     */
    public final String allowedActionForAllowVendedLogsDeliveryForResource() {
        return allowedActionForAllowVendedLogsDeliveryForResource;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedFieldDelimiters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedFieldDelimiters() {
        return allowedFieldDelimiters != null && !(allowedFieldDelimiters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid values that a caller can use as field delimiters when calling <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a> or <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a> on a delivery that delivers in <code>Plain</code>, <code>W3C</code>, or
     * <code>Raw</code> format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedFieldDelimiters} method.
     * </p>
     * 
     * @return The valid values that a caller can use as field delimiters when calling <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     *         >CreateDelivery</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     *         >UpdateDeliveryConfiguration</a> on a delivery that delivers in <code>Plain</code>, <code>W3C</code>, or
     *         <code>Raw</code> format.
     */
    public final List<String> allowedFieldDelimiters() {
        return allowedFieldDelimiters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedSuffixPathFields property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedSuffixPathFields() {
        return allowedSuffixPathFields != null && !(allowedSuffixPathFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedSuffixPathFields} method.
     * </p>
     * 
     * @return The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3
     *         bucket.
     */
    public final List<String> allowedSuffixPathFields() {
        return allowedSuffixPathFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(logType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDeliveryConfigValues());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedFields() ? allowedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOutputFormats() ? allowedOutputFormatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedActionForAllowVendedLogsDeliveryForResource());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedFieldDelimiters() ? allowedFieldDelimiters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedSuffixPathFields() ? allowedSuffixPathFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationTemplate)) {
            return false;
        }
        ConfigurationTemplate other = (ConfigurationTemplate) obj;
        return Objects.equals(service(), other.service())
                && Objects.equals(logType(), other.logType())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString())
                && Objects.equals(defaultDeliveryConfigValues(), other.defaultDeliveryConfigValues())
                && hasAllowedFields() == other.hasAllowedFields()
                && Objects.equals(allowedFields(), other.allowedFields())
                && hasAllowedOutputFormats() == other.hasAllowedOutputFormats()
                && Objects.equals(allowedOutputFormatsAsStrings(), other.allowedOutputFormatsAsStrings())
                && Objects.equals(allowedActionForAllowVendedLogsDeliveryForResource(),
                        other.allowedActionForAllowVendedLogsDeliveryForResource())
                && hasAllowedFieldDelimiters() == other.hasAllowedFieldDelimiters()
                && Objects.equals(allowedFieldDelimiters(), other.allowedFieldDelimiters())
                && hasAllowedSuffixPathFields() == other.hasAllowedSuffixPathFields()
                && Objects.equals(allowedSuffixPathFields(), other.allowedSuffixPathFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationTemplate").add("Service", service()).add("LogType", logType())
                .add("ResourceType", resourceType()).add("DeliveryDestinationType", deliveryDestinationTypeAsString())
                .add("DefaultDeliveryConfigValues", defaultDeliveryConfigValues())
                .add("AllowedFields", hasAllowedFields() ? allowedFields() : null)
                .add("AllowedOutputFormats", hasAllowedOutputFormats() ? allowedOutputFormatsAsStrings() : null)
                .add("AllowedActionForAllowVendedLogsDeliveryForResource", allowedActionForAllowVendedLogsDeliveryForResource())
                .add("AllowedFieldDelimiters", hasAllowedFieldDelimiters() ? allowedFieldDelimiters() : null)
                .add("AllowedSuffixPathFields", hasAllowedSuffixPathFields() ? allowedSuffixPathFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "logType":
            return Optional.ofNullable(clazz.cast(logType()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "deliveryDestinationType":
            return Optional.ofNullable(clazz.cast(deliveryDestinationTypeAsString()));
        case "defaultDeliveryConfigValues":
            return Optional.ofNullable(clazz.cast(defaultDeliveryConfigValues()));
        case "allowedFields":
            return Optional.ofNullable(clazz.cast(allowedFields()));
        case "allowedOutputFormats":
            return Optional.ofNullable(clazz.cast(allowedOutputFormatsAsStrings()));
        case "allowedActionForAllowVendedLogsDeliveryForResource":
            return Optional.ofNullable(clazz.cast(allowedActionForAllowVendedLogsDeliveryForResource()));
        case "allowedFieldDelimiters":
            return Optional.ofNullable(clazz.cast(allowedFieldDelimiters()));
        case "allowedSuffixPathFields":
            return Optional.ofNullable(clazz.cast(allowedSuffixPathFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationTemplate, T> g) {
        return obj -> g.apply((ConfigurationTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationTemplate> {
        /**
         * <p>
         * A string specifying which service this configuration template applies to. For more information about
         * supported services see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable
         * logging from Amazon Web Services services.</a>.
         * </p>
         * 
         * @param service
         *        A string specifying which service this configuration template applies to. For more information about
         *        supported services see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html"
         *        >Enable logging from Amazon Web Services services.</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * A string specifying which log type this configuration template applies to.
         * </p>
         * 
         * @param logType
         *        A string specifying which log type this configuration template applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logType(String logType);

        /**
         * <p>
         * A string specifying which resource type this configuration template applies to.
         * </p>
         * 
         * @param resourceType
         *        A string specifying which resource type this configuration template applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * A string specifying which destination type this configuration template applies to.
         * </p>
         * 
         * @param deliveryDestinationType
         *        A string specifying which destination type this configuration template applies to.
         * @see DeliveryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryDestinationType
         */
        Builder deliveryDestinationType(String deliveryDestinationType);

        /**
         * <p>
         * A string specifying which destination type this configuration template applies to.
         * </p>
         * 
         * @param deliveryDestinationType
         *        A string specifying which destination type this configuration template applies to.
         * @see DeliveryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryDestinationType
         */
        Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType);

        /**
         * <p>
         * A mapping that displays the default value of each property within a delivery's configuration, if it is not
         * specified in the request.
         * </p>
         * 
         * @param defaultDeliveryConfigValues
         *        A mapping that displays the default value of each property within a delivery's configuration, if it is
         *        not specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues);

        /**
         * <p>
         * A mapping that displays the default value of each property within a delivery's configuration, if it is not
         * specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfigurationTemplateDeliveryConfigValues.Builder} avoiding the need to create one manually via
         * {@link ConfigurationTemplateDeliveryConfigValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationTemplateDeliveryConfigValues.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues)}.
         * 
         * @param defaultDeliveryConfigValues
         *        a consumer that will call methods on {@link ConfigurationTemplateDeliveryConfigValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues)
         */
        default Builder defaultDeliveryConfigValues(
                Consumer<ConfigurationTemplateDeliveryConfigValues.Builder> defaultDeliveryConfigValues) {
            return defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues.builder()
                    .applyMutation(defaultDeliveryConfigValues).build());
        }

        /**
         * <p>
         * The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> operation.
         * </p>
         * 
         * @param allowedFields
         *        The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         *        >UpdateDeliveryConfiguration</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFields(Collection<RecordField> allowedFields);

        /**
         * <p>
         * The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> operation.
         * </p>
         * 
         * @param allowedFields
         *        The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         *        >UpdateDeliveryConfiguration</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFields(RecordField... allowedFields);

        /**
         * <p>
         * The allowed fields that a caller can use in the <code>recordFields</code> parameter of a <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.RecordField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.RecordField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.RecordField.Builder#build()} is called
         * immediately and its result is passed to {@link #allowedFields(List<RecordField>)}.
         * 
         * @param allowedFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.RecordField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedFields(java.util.Collection<RecordField>)
         */
        Builder allowedFields(Consumer<RecordField.Builder>... allowedFields);

        /**
         * <p>
         * The list of delivery destination output formats that are supported by this log source.
         * </p>
         * 
         * @param allowedOutputFormats
         *        The list of delivery destination output formats that are supported by this log source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOutputFormatsWithStrings(Collection<String> allowedOutputFormats);

        /**
         * <p>
         * The list of delivery destination output formats that are supported by this log source.
         * </p>
         * 
         * @param allowedOutputFormats
         *        The list of delivery destination output formats that are supported by this log source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOutputFormatsWithStrings(String... allowedOutputFormats);

        /**
         * <p>
         * The list of delivery destination output formats that are supported by this log source.
         * </p>
         * 
         * @param allowedOutputFormats
         *        The list of delivery destination output formats that are supported by this log source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOutputFormats(Collection<OutputFormat> allowedOutputFormats);

        /**
         * <p>
         * The list of delivery destination output formats that are supported by this log source.
         * </p>
         * 
         * @param allowedOutputFormats
         *        The list of delivery destination output formats that are supported by this log source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOutputFormats(OutputFormat... allowedOutputFormats);

        /**
         * <p>
         * The action permissions that a caller needs to have to be able to successfully create a delivery source on the
         * desired resource type when calling <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
         * >PutDeliverySource</a>.
         * </p>
         * 
         * @param allowedActionForAllowVendedLogsDeliveryForResource
         *        The action permissions that a caller needs to have to be able to successfully create a delivery source
         *        on the desired resource type when calling <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
         *        >PutDeliverySource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedActionForAllowVendedLogsDeliveryForResource(String allowedActionForAllowVendedLogsDeliveryForResource);

        /**
         * <p>
         * The valid values that a caller can use as field delimiters when calling <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> on a delivery that delivers in <code>Plain</code>, <code>W3C</code>, or
         * <code>Raw</code> format.
         * </p>
         * 
         * @param allowedFieldDelimiters
         *        The valid values that a caller can use as field delimiters when calling <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         *        >UpdateDeliveryConfiguration</a> on a delivery that delivers in <code>Plain</code>, <code>W3C</code>,
         *        or <code>Raw</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFieldDelimiters(Collection<String> allowedFieldDelimiters);

        /**
         * <p>
         * The valid values that a caller can use as field delimiters when calling <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         * >CreateDelivery</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         * >UpdateDeliveryConfiguration</a> on a delivery that delivers in <code>Plain</code>, <code>W3C</code>, or
         * <code>Raw</code> format.
         * </p>
         * 
         * @param allowedFieldDelimiters
         *        The valid values that a caller can use as field delimiters when calling <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
         *        >CreateDelivery</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
         *        >UpdateDeliveryConfiguration</a> on a delivery that delivers in <code>Plain</code>, <code>W3C</code>,
         *        or <code>Raw</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFieldDelimiters(String... allowedFieldDelimiters);

        /**
         * <p>
         * The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3 bucket.
         * </p>
         * 
         * @param allowedSuffixPathFields
         *        The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedSuffixPathFields(Collection<String> allowedSuffixPathFields);

        /**
         * <p>
         * The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3 bucket.
         * </p>
         * 
         * @param allowedSuffixPathFields
         *        The list of variable fields that can be used in the suffix path of a delivery that delivers to an S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedSuffixPathFields(String... allowedSuffixPathFields);
    }

    static final class BuilderImpl implements Builder {
        private String service;

        private String logType;

        private String resourceType;

        private String deliveryDestinationType;

        private ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues;

        private List<RecordField> allowedFields = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedOutputFormats = DefaultSdkAutoConstructList.getInstance();

        private String allowedActionForAllowVendedLogsDeliveryForResource;

        private List<String> allowedFieldDelimiters = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedSuffixPathFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationTemplate model) {
            service(model.service);
            logType(model.logType);
            resourceType(model.resourceType);
            deliveryDestinationType(model.deliveryDestinationType);
            defaultDeliveryConfigValues(model.defaultDeliveryConfigValues);
            allowedFields(model.allowedFields);
            allowedOutputFormatsWithStrings(model.allowedOutputFormats);
            allowedActionForAllowVendedLogsDeliveryForResource(model.allowedActionForAllowVendedLogsDeliveryForResource);
            allowedFieldDelimiters(model.allowedFieldDelimiters);
            allowedSuffixPathFields(model.allowedSuffixPathFields);
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final ConfigurationTemplateDeliveryConfigValues.Builder getDefaultDeliveryConfigValues() {
            return defaultDeliveryConfigValues != null ? defaultDeliveryConfigValues.toBuilder() : null;
        }

        public final void setDefaultDeliveryConfigValues(
                ConfigurationTemplateDeliveryConfigValues.BuilderImpl defaultDeliveryConfigValues) {
            this.defaultDeliveryConfigValues = defaultDeliveryConfigValues != null ? defaultDeliveryConfigValues.build() : null;
        }

        @Override
        public final Builder defaultDeliveryConfigValues(ConfigurationTemplateDeliveryConfigValues defaultDeliveryConfigValues) {
            this.defaultDeliveryConfigValues = defaultDeliveryConfigValues;
            return this;
        }

        public final List<RecordField.Builder> getAllowedFields() {
            List<RecordField.Builder> result = AllowedFieldsCopier.copyToBuilder(this.allowedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedFields(Collection<RecordField.BuilderImpl> allowedFields) {
            this.allowedFields = AllowedFieldsCopier.copyFromBuilder(allowedFields);
        }

        @Override
        public final Builder allowedFields(Collection<RecordField> allowedFields) {
            this.allowedFields = AllowedFieldsCopier.copy(allowedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFields(RecordField... allowedFields) {
            allowedFields(Arrays.asList(allowedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFields(Consumer<RecordField.Builder>... allowedFields) {
            allowedFields(Stream.of(allowedFields).map(c -> RecordField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAllowedOutputFormats() {
            if (allowedOutputFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOutputFormats;
        }

        public final void setAllowedOutputFormats(Collection<String> allowedOutputFormats) {
            this.allowedOutputFormats = OutputFormatsCopier.copy(allowedOutputFormats);
        }

        @Override
        public final Builder allowedOutputFormatsWithStrings(Collection<String> allowedOutputFormats) {
            this.allowedOutputFormats = OutputFormatsCopier.copy(allowedOutputFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOutputFormatsWithStrings(String... allowedOutputFormats) {
            allowedOutputFormatsWithStrings(Arrays.asList(allowedOutputFormats));
            return this;
        }

        @Override
        public final Builder allowedOutputFormats(Collection<OutputFormat> allowedOutputFormats) {
            this.allowedOutputFormats = OutputFormatsCopier.copyEnumToString(allowedOutputFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOutputFormats(OutputFormat... allowedOutputFormats) {
            allowedOutputFormats(Arrays.asList(allowedOutputFormats));
            return this;
        }

        public final String getAllowedActionForAllowVendedLogsDeliveryForResource() {
            return allowedActionForAllowVendedLogsDeliveryForResource;
        }

        public final void setAllowedActionForAllowVendedLogsDeliveryForResource(
                String allowedActionForAllowVendedLogsDeliveryForResource) {
            this.allowedActionForAllowVendedLogsDeliveryForResource = allowedActionForAllowVendedLogsDeliveryForResource;
        }

        @Override
        public final Builder allowedActionForAllowVendedLogsDeliveryForResource(
                String allowedActionForAllowVendedLogsDeliveryForResource) {
            this.allowedActionForAllowVendedLogsDeliveryForResource = allowedActionForAllowVendedLogsDeliveryForResource;
            return this;
        }

        public final Collection<String> getAllowedFieldDelimiters() {
            if (allowedFieldDelimiters instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedFieldDelimiters;
        }

        public final void setAllowedFieldDelimiters(Collection<String> allowedFieldDelimiters) {
            this.allowedFieldDelimiters = AllowedFieldDelimitersCopier.copy(allowedFieldDelimiters);
        }

        @Override
        public final Builder allowedFieldDelimiters(Collection<String> allowedFieldDelimiters) {
            this.allowedFieldDelimiters = AllowedFieldDelimitersCopier.copy(allowedFieldDelimiters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFieldDelimiters(String... allowedFieldDelimiters) {
            allowedFieldDelimiters(Arrays.asList(allowedFieldDelimiters));
            return this;
        }

        public final Collection<String> getAllowedSuffixPathFields() {
            if (allowedSuffixPathFields instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedSuffixPathFields;
        }

        public final void setAllowedSuffixPathFields(Collection<String> allowedSuffixPathFields) {
            this.allowedSuffixPathFields = RecordFieldsCopier.copy(allowedSuffixPathFields);
        }

        @Override
        public final Builder allowedSuffixPathFields(Collection<String> allowedSuffixPathFields) {
            this.allowedSuffixPathFields = RecordFieldsCopier.copy(allowedSuffixPathFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedSuffixPathFields(String... allowedSuffixPathFields) {
            allowedSuffixPathFields(Arrays.asList(allowedSuffixPathFields));
            return this;
        }

        @Override
        public ConfigurationTemplate build() {
            return new ConfigurationTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
