/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about one field index policy in this account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexPolicy implements SdkPojo, Serializable, ToCopyableBuilder<IndexPolicy.Builder, IndexPolicy> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(IndexPolicy::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<Long> LAST_UPDATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdateTime").getter(getter(IndexPolicy::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(IndexPolicy::policyDocument)).setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(IndexPolicy::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(IndexPolicy::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD,
            LAST_UPDATE_TIME_FIELD, POLICY_DOCUMENT_FIELD, POLICY_NAME_FIELD, SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
                    put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
                    put("policyDocument", POLICY_DOCUMENT_FIELD);
                    put("policyName", POLICY_NAME_FIELD);
                    put("source", SOURCE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String logGroupIdentifier;

    private final Long lastUpdateTime;

    private final String policyDocument;

    private final String policyName;

    private final String source;

    private IndexPolicy(BuilderImpl builder) {
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.policyDocument = builder.policyDocument;
        this.policyName = builder.policyName;
        this.source = builder.source;
    }

    /**
     * <p>
     * The ARN of the log group that this index policy applies to.
     * </p>
     * 
     * @return The ARN of the log group that this index policy applies to.
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * The date and time that this index policy was most recently updated.
     * </p>
     * 
     * @return The date and time that this index policy was most recently updated.
     */
    public final Long lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The policy document for this index policy, in JSON format.
     * </p>
     * 
     * @return The policy document for this index policy, in JSON format.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The name of this policy. Responses about log group-level field index policies don't have this field, because
     * those policies don't have names.
     * </p>
     * 
     * @return The name of this policy. Responses about log group-level field index policies don't have this field,
     *         because those policies don't have names.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * This field indicates whether this is an account-level index policy or an index policy that applies only to a
     * single log group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link IndexSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return This field indicates whether this is an account-level index policy or an index policy that applies only
     *         to a single log group.
     * @see IndexSource
     */
    public final IndexSource source() {
        return IndexSource.fromValue(source);
    }

    /**
     * <p>
     * This field indicates whether this is an account-level index policy or an index policy that applies only to a
     * single log group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link IndexSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return This field indicates whether this is an account-level index policy or an index policy that applies only
     *         to a single log group.
     * @see IndexSource
     */
    public final String sourceAsString() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexPolicy)) {
            return false;
        }
        IndexPolicy other = (IndexPolicy) obj;
        return Objects.equals(logGroupIdentifier(), other.logGroupIdentifier())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(policyDocument(), other.policyDocument()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(sourceAsString(), other.sourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexPolicy").add("LogGroupIdentifier", logGroupIdentifier())
                .add("LastUpdateTime", lastUpdateTime()).add("PolicyDocument", policyDocument()).add("PolicyName", policyName())
                .add("Source", sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IndexPolicy, T> g) {
        return obj -> g.apply((IndexPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexPolicy> {
        /**
         * <p>
         * The ARN of the log group that this index policy applies to.
         * </p>
         * 
         * @param logGroupIdentifier
         *        The ARN of the log group that this index policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * The date and time that this index policy was most recently updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time that this index policy was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Long lastUpdateTime);

        /**
         * <p>
         * The policy document for this index policy, in JSON format.
         * </p>
         * 
         * @param policyDocument
         *        The policy document for this index policy, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The name of this policy. Responses about log group-level field index policies don't have this field, because
         * those policies don't have names.
         * </p>
         * 
         * @param policyName
         *        The name of this policy. Responses about log group-level field index policies don't have this field,
         *        because those policies don't have names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * This field indicates whether this is an account-level index policy or an index policy that applies only to a
         * single log group.
         * </p>
         * 
         * @param source
         *        This field indicates whether this is an account-level index policy or an index policy that applies
         *        only to a single log group.
         * @see IndexSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexSource
         */
        Builder source(String source);

        /**
         * <p>
         * This field indicates whether this is an account-level index policy or an index policy that applies only to a
         * single log group.
         * </p>
         * 
         * @param source
         *        This field indicates whether this is an account-level index policy or an index policy that applies
         *        only to a single log group.
         * @see IndexSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexSource
         */
        Builder source(IndexSource source);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupIdentifier;

        private Long lastUpdateTime;

        private String policyDocument;

        private String policyName;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexPolicy model) {
            logGroupIdentifier(model.logGroupIdentifier);
            lastUpdateTime(model.lastUpdateTime);
            policyDocument(model.policyDocument);
            policyName(model.policyName);
            source(model.source);
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final Long getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(IndexSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public IndexPolicy build() {
            return new IndexPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
