/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfig implements SdkPojo, Serializable, ToCopyableBuilder<ResourceConfig.Builder, ResourceConfig> {
    private static final SdkField<OpenSearchResourceConfig> OPEN_SEARCH_RESOURCE_CONFIG_FIELD = SdkField
            .<OpenSearchResourceConfig> builder(MarshallingType.SDK_POJO).memberName("openSearchResourceConfig")
            .getter(getter(ResourceConfig::openSearchResourceConfig)).setter(setter(Builder::openSearchResourceConfig))
            .constructor(OpenSearchResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchResourceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OPEN_SEARCH_RESOURCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("openSearchResourceConfig", OPEN_SEARCH_RESOURCE_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final OpenSearchResourceConfig openSearchResourceConfig;

    private final Type type;

    private ResourceConfig(BuilderImpl builder) {
        this.openSearchResourceConfig = builder.openSearchResourceConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
     * Service.
     * </p>
     * 
     * @return This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
     *         Service.
     */
    public final OpenSearchResourceConfig openSearchResourceConfig() {
        return openSearchResourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openSearchResourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig) obj;
        return Objects.equals(openSearchResourceConfig(), other.openSearchResourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceConfig").add("OpenSearchResourceConfig", openSearchResourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openSearchResourceConfig":
            return Optional.ofNullable(clazz.cast(openSearchResourceConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #openSearchResourceConfig()} initialized to the given value.
     *
     * <p>
     * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
     * Service.
     * </p>
     * 
     * @param openSearchResourceConfig
     *        This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
     *        Service.
     */
    public static ResourceConfig fromOpenSearchResourceConfig(OpenSearchResourceConfig openSearchResourceConfig) {
        return builder().openSearchResourceConfig(openSearchResourceConfig).build();
    }

    /**
     * Create an instance of this class with {@link #openSearchResourceConfig()} initialized to the given value.
     *
     * <p>
     * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
     * Service.
     * </p>
     * 
     * @param openSearchResourceConfig
     *        This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
     *        Service.
     */
    public static ResourceConfig fromOpenSearchResourceConfig(Consumer<OpenSearchResourceConfig.Builder> openSearchResourceConfig) {
        OpenSearchResourceConfig.Builder builder = OpenSearchResourceConfig.builder();
        openSearchResourceConfig.accept(builder);
        return fromOpenSearchResourceConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfig, T> g) {
        return obj -> g.apply((ResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfig> {
        /**
         * <p>
         * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
         * Service.
         * </p>
         * 
         * @param openSearchResourceConfig
         *        This structure contains configuration details about an integration between CloudWatch Logs and
         *        OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchResourceConfig(OpenSearchResourceConfig openSearchResourceConfig);

        /**
         * <p>
         * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch
         * Service.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchResourceConfig.Builder}
         * avoiding the need to create one manually via {@link OpenSearchResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchResourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #openSearchResourceConfig(OpenSearchResourceConfig)}.
         * 
         * @param openSearchResourceConfig
         *        a consumer that will call methods on {@link OpenSearchResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openSearchResourceConfig(OpenSearchResourceConfig)
         */
        default Builder openSearchResourceConfig(Consumer<OpenSearchResourceConfig.Builder> openSearchResourceConfig) {
            return openSearchResourceConfig(OpenSearchResourceConfig.builder().applyMutation(openSearchResourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpenSearchResourceConfig openSearchResourceConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfig model) {
            openSearchResourceConfig(model.openSearchResourceConfig);
        }

        public final OpenSearchResourceConfig.Builder getOpenSearchResourceConfig() {
            return openSearchResourceConfig != null ? openSearchResourceConfig.toBuilder() : null;
        }

        public final void setOpenSearchResourceConfig(OpenSearchResourceConfig.BuilderImpl openSearchResourceConfig) {
            Object oldValue = this.openSearchResourceConfig;
            this.openSearchResourceConfig = openSearchResourceConfig != null ? openSearchResourceConfig.build() : null;
            handleUnionValueChange(Type.OPEN_SEARCH_RESOURCE_CONFIG, oldValue, this.openSearchResourceConfig);
        }

        @Override
        public final Builder openSearchResourceConfig(OpenSearchResourceConfig openSearchResourceConfig) {
            Object oldValue = this.openSearchResourceConfig;
            this.openSearchResourceConfig = openSearchResourceConfig;
            handleUnionValueChange(Type.OPEN_SEARCH_RESOURCE_CONFIG, oldValue, this.openSearchResourceConfig);
            return this;
        }

        @Override
        public ResourceConfig build() {
            return new ResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResourceConfig#type()
     */
    public enum Type {
        OPEN_SEARCH_RESOURCE_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
