/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains complete information about one CloudWatch Logs integration. This structure is returned by a
 * <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetIntegration.html">GetIntegration<
 * /a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchIntegrationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchIntegrationDetails.Builder, OpenSearchIntegrationDetails> {
    private static final SdkField<OpenSearchDataSource> DATA_SOURCE_FIELD = SdkField
            .<OpenSearchDataSource> builder(MarshallingType.SDK_POJO).memberName("dataSource")
            .getter(getter(OpenSearchIntegrationDetails::dataSource)).setter(setter(Builder::dataSource))
            .constructor(OpenSearchDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<OpenSearchApplication> APPLICATION_FIELD = SdkField
            .<OpenSearchApplication> builder(MarshallingType.SDK_POJO).memberName("application")
            .getter(getter(OpenSearchIntegrationDetails::application)).setter(setter(Builder::application))
            .constructor(OpenSearchApplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<OpenSearchCollection> COLLECTION_FIELD = SdkField
            .<OpenSearchCollection> builder(MarshallingType.SDK_POJO).memberName("collection")
            .getter(getter(OpenSearchIntegrationDetails::collection)).setter(setter(Builder::collection))
            .constructor(OpenSearchCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collection").build()).build();

    private static final SdkField<OpenSearchWorkspace> WORKSPACE_FIELD = SdkField
            .<OpenSearchWorkspace> builder(MarshallingType.SDK_POJO).memberName("workspace")
            .getter(getter(OpenSearchIntegrationDetails::workspace)).setter(setter(Builder::workspace))
            .constructor(OpenSearchWorkspace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()).build();

    private static final SdkField<OpenSearchEncryptionPolicy> ENCRYPTION_POLICY_FIELD = SdkField
            .<OpenSearchEncryptionPolicy> builder(MarshallingType.SDK_POJO).memberName("encryptionPolicy")
            .getter(getter(OpenSearchIntegrationDetails::encryptionPolicy)).setter(setter(Builder::encryptionPolicy))
            .constructor(OpenSearchEncryptionPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionPolicy").build()).build();

    private static final SdkField<OpenSearchNetworkPolicy> NETWORK_POLICY_FIELD = SdkField
            .<OpenSearchNetworkPolicy> builder(MarshallingType.SDK_POJO).memberName("networkPolicy")
            .getter(getter(OpenSearchIntegrationDetails::networkPolicy)).setter(setter(Builder::networkPolicy))
            .constructor(OpenSearchNetworkPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkPolicy").build()).build();

    private static final SdkField<OpenSearchDataAccessPolicy> ACCESS_POLICY_FIELD = SdkField
            .<OpenSearchDataAccessPolicy> builder(MarshallingType.SDK_POJO).memberName("accessPolicy")
            .getter(getter(OpenSearchIntegrationDetails::accessPolicy)).setter(setter(Builder::accessPolicy))
            .constructor(OpenSearchDataAccessPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()).build();

    private static final SdkField<OpenSearchLifecyclePolicy> LIFECYCLE_POLICY_FIELD = SdkField
            .<OpenSearchLifecyclePolicy> builder(MarshallingType.SDK_POJO).memberName("lifecyclePolicy")
            .getter(getter(OpenSearchIntegrationDetails::lifecyclePolicy)).setter(setter(Builder::lifecyclePolicy))
            .constructor(OpenSearchLifecyclePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            APPLICATION_FIELD, COLLECTION_FIELD, WORKSPACE_FIELD, ENCRYPTION_POLICY_FIELD, NETWORK_POLICY_FIELD,
            ACCESS_POLICY_FIELD, LIFECYCLE_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("dataSource", DATA_SOURCE_FIELD);
                    put("application", APPLICATION_FIELD);
                    put("collection", COLLECTION_FIELD);
                    put("workspace", WORKSPACE_FIELD);
                    put("encryptionPolicy", ENCRYPTION_POLICY_FIELD);
                    put("networkPolicy", NETWORK_POLICY_FIELD);
                    put("accessPolicy", ACCESS_POLICY_FIELD);
                    put("lifecyclePolicy", LIFECYCLE_POLICY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final OpenSearchDataSource dataSource;

    private final OpenSearchApplication application;

    private final OpenSearchCollection collection;

    private final OpenSearchWorkspace workspace;

    private final OpenSearchEncryptionPolicy encryptionPolicy;

    private final OpenSearchNetworkPolicy networkPolicy;

    private final OpenSearchDataAccessPolicy accessPolicy;

    private final OpenSearchLifecyclePolicy lifecyclePolicy;

    private OpenSearchIntegrationDetails(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.application = builder.application;
        this.collection = builder.collection;
        this.workspace = builder.workspace;
        this.encryptionPolicy = builder.encryptionPolicy;
        this.networkPolicy = builder.networkPolicy;
        this.accessPolicy = builder.accessPolicy;
        this.lifecyclePolicy = builder.lifecyclePolicy;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service data source used for this integration. This data
     * source was created as part of the integration setup. An OpenSearch Service data source defines the source and
     * destination for OpenSearch Service queries. It includes the role required to execute queries and write to
     * collections.
     * </p>
     * <p>
     * For more information about OpenSearch Service data sources , see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
     * >Creating OpenSearch Service data source integrations with Amazon S3.</a>
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service data source used for this integration.
     *         This data source was created as part of the integration setup. An OpenSearch Service data source defines
     *         the source and destination for OpenSearch Service queries. It includes the role required to execute
     *         queries and write to collections.</p>
     *         <p>
     *         For more information about OpenSearch Service data sources , see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
     *         >Creating OpenSearch Service data source integrations with Amazon S3.</a>
     */
    public final OpenSearchDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service application used for this integration. An
     * OpenSearch Service application is the web application that was created by the integration with CloudWatch Logs.
     * It hosts the vended logs dashboards.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service application used for this integration.
     *         An OpenSearch Service application is the web application that was created by the integration with
     *         CloudWatch Logs. It hosts the vended logs dashboards.
     */
    public final OpenSearchApplication application() {
        return application;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service collection used for this integration. This
     * collection was created as part of the integration setup. An OpenSearch Service collection is a logical grouping
     * of one or more indexes that represent an analytics workload. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html">Creating
     * and managing OpenSearch Service Serverless collections</a>.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service collection used for this integration.
     *         This collection was created as part of the integration setup. An OpenSearch Service collection is a
     *         logical grouping of one or more indexes that represent an analytics workload. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html"
     *         >Creating and managing OpenSearch Service Serverless collections</a>.
     */
    public final OpenSearchCollection collection() {
        return collection;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service workspace used for this integration. An
     * OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools. This
     * workspace was created automatically as part of the integration setup. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html">Centralized
     * OpenSearch user interface (Dashboards) with OpenSearch Service</a>.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service workspace used for this integration. An
     *         OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools.
     *         This workspace was created automatically as part of the integration setup. For more information, see <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html">Centralized
     *         OpenSearch user interface (Dashboards) with OpenSearch Service</a>.
     */
    public final OpenSearchWorkspace workspace() {
        return workspace;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service encryption policy used for this integration. The
     * encryption policy was created automatically when you created the integration. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies"
     * >Encryption policies</a> in the OpenSearch Service Developer Guide.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service encryption policy used for this
     *         integration. The encryption policy was created automatically when you created the integration. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies"
     *         >Encryption policies</a> in the OpenSearch Service Developer Guide.
     */
    public final OpenSearchEncryptionPolicy encryptionPolicy() {
        return encryptionPolicy;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service network policy used for this integration. The
     * network policy assigns network access settings to collections. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies"
     * >Network policies</a> in the OpenSearch Service Developer Guide.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service network policy used for this
     *         integration. The network policy assigns network access settings to collections. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies"
     *         >Network policies</a> in the OpenSearch Service Developer Guide.
     */
    public final OpenSearchNetworkPolicy networkPolicy() {
        return networkPolicy;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service data access policy used for this integration.
     * The access policy defines the access controls for the collection. This data access policy was automatically
     * created as part of the integration setup. For more information about OpenSearch Service data access policies, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a> in the OpenSearch Service Developer Guide.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service data access policy used for this
     *         integration. The access policy defines the access controls for the collection. This data access policy
     *         was automatically created as part of the integration setup. For more information about OpenSearch Service
     *         data access policies, see <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html"
     *         >Data access control for Amazon OpenSearch Serverless</a> in the OpenSearch Service Developer Guide.
     */
    public final OpenSearchDataAccessPolicy accessPolicy() {
        return accessPolicy;
    }

    /**
     * <p>
     * This structure contains information about the OpenSearch Service data lifecycle policy used for this integration.
     * The lifecycle policy determines the lifespan of the data in the collection. It was automatically created as part
     * of the integration setup.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html">Using data
     * lifecycle policies with OpenSearch Service Serverless</a> in the OpenSearch Service Developer Guide.
     * </p>
     * 
     * @return This structure contains information about the OpenSearch Service data lifecycle policy used for this
     *         integration. The lifecycle policy determines the lifespan of the data in the collection. It was
     *         automatically created as part of the integration setup.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html"
     *         >Using data lifecycle policies with OpenSearch Service Serverless</a> in the OpenSearch Service Developer
     *         Guide.
     */
    public final OpenSearchLifecyclePolicy lifecyclePolicy() {
        return lifecyclePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(collection());
        hashCode = 31 * hashCode + Objects.hashCode(workspace());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(networkPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchIntegrationDetails)) {
            return false;
        }
        OpenSearchIntegrationDetails other = (OpenSearchIntegrationDetails) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(application(), other.application())
                && Objects.equals(collection(), other.collection()) && Objects.equals(workspace(), other.workspace())
                && Objects.equals(encryptionPolicy(), other.encryptionPolicy())
                && Objects.equals(networkPolicy(), other.networkPolicy()) && Objects.equals(accessPolicy(), other.accessPolicy())
                && Objects.equals(lifecyclePolicy(), other.lifecyclePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchIntegrationDetails").add("DataSource", dataSource()).add("Application", application())
                .add("Collection", collection()).add("Workspace", workspace()).add("EncryptionPolicy", encryptionPolicy())
                .add("NetworkPolicy", networkPolicy()).add("AccessPolicy", accessPolicy())
                .add("LifecyclePolicy", lifecyclePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "collection":
            return Optional.ofNullable(clazz.cast(collection()));
        case "workspace":
            return Optional.ofNullable(clazz.cast(workspace()));
        case "encryptionPolicy":
            return Optional.ofNullable(clazz.cast(encryptionPolicy()));
        case "networkPolicy":
            return Optional.ofNullable(clazz.cast(networkPolicy()));
        case "accessPolicy":
            return Optional.ofNullable(clazz.cast(accessPolicy()));
        case "lifecyclePolicy":
            return Optional.ofNullable(clazz.cast(lifecyclePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchIntegrationDetails, T> g) {
        return obj -> g.apply((OpenSearchIntegrationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchIntegrationDetails> {
        /**
         * <p>
         * This structure contains information about the OpenSearch Service data source used for this integration. This
         * data source was created as part of the integration setup. An OpenSearch Service data source defines the
         * source and destination for OpenSearch Service queries. It includes the role required to execute queries and
         * write to collections.
         * </p>
         * <p>
         * For more information about OpenSearch Service data sources , see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
         * >Creating OpenSearch Service data source integrations with Amazon S3.</a>
         * </p>
         * 
         * @param dataSource
         *        This structure contains information about the OpenSearch Service data source used for this
         *        integration. This data source was created as part of the integration setup. An OpenSearch Service data
         *        source defines the source and destination for OpenSearch Service queries. It includes the role
         *        required to execute queries and write to collections.</p>
         *        <p>
         *        For more information about OpenSearch Service data sources , see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
         *        >Creating OpenSearch Service data source integrations with Amazon S3.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(OpenSearchDataSource dataSource);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service data source used for this integration. This
         * data source was created as part of the integration setup. An OpenSearch Service data source defines the
         * source and destination for OpenSearch Service queries. It includes the role required to execute queries and
         * write to collections.
         * </p>
         * <p>
         * For more information about OpenSearch Service data sources , see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
         * >Creating OpenSearch Service data source integrations with Amazon S3.</a>
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchDataSource.Builder} avoiding
         * the need to create one manually via {@link OpenSearchDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSource(OpenSearchDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link OpenSearchDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(OpenSearchDataSource)
         */
        default Builder dataSource(Consumer<OpenSearchDataSource.Builder> dataSource) {
            return dataSource(OpenSearchDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service application used for this integration. An
         * OpenSearch Service application is the web application that was created by the integration with CloudWatch
         * Logs. It hosts the vended logs dashboards.
         * </p>
         * 
         * @param application
         *        This structure contains information about the OpenSearch Service application used for this
         *        integration. An OpenSearch Service application is the web application that was created by the
         *        integration with CloudWatch Logs. It hosts the vended logs dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(OpenSearchApplication application);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service application used for this integration. An
         * OpenSearch Service application is the web application that was created by the integration with CloudWatch
         * Logs. It hosts the vended logs dashboards.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchApplication.Builder} avoiding
         * the need to create one manually via {@link OpenSearchApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchApplication.Builder#build()} is called immediately and
         * its result is passed to {@link #application(OpenSearchApplication)}.
         * 
         * @param application
         *        a consumer that will call methods on {@link OpenSearchApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #application(OpenSearchApplication)
         */
        default Builder application(Consumer<OpenSearchApplication.Builder> application) {
            return application(OpenSearchApplication.builder().applyMutation(application).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service collection used for this integration. This
         * collection was created as part of the integration setup. An OpenSearch Service collection is a logical
         * grouping of one or more indexes that represent an analytics workload. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html"
         * >Creating and managing OpenSearch Service Serverless collections</a>.
         * </p>
         * 
         * @param collection
         *        This structure contains information about the OpenSearch Service collection used for this integration.
         *        This collection was created as part of the integration setup. An OpenSearch Service collection is a
         *        logical grouping of one or more indexes that represent an analytics workload. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html"
         *        >Creating and managing OpenSearch Service Serverless collections</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collection(OpenSearchCollection collection);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service collection used for this integration. This
         * collection was created as part of the integration setup. An OpenSearch Service collection is a logical
         * grouping of one or more indexes that represent an analytics workload. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-collections.html"
         * >Creating and managing OpenSearch Service Serverless collections</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchCollection.Builder} avoiding
         * the need to create one manually via {@link OpenSearchCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchCollection.Builder#build()} is called immediately and
         * its result is passed to {@link #collection(OpenSearchCollection)}.
         * 
         * @param collection
         *        a consumer that will call methods on {@link OpenSearchCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collection(OpenSearchCollection)
         */
        default Builder collection(Consumer<OpenSearchCollection.Builder> collection) {
            return collection(OpenSearchCollection.builder().applyMutation(collection).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service workspace used for this integration. An
         * OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools. This
         * workspace was created automatically as part of the integration setup. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html">Centralized
         * OpenSearch user interface (Dashboards) with OpenSearch Service</a>.
         * </p>
         * 
         * @param workspace
         *        This structure contains information about the OpenSearch Service workspace used for this integration.
         *        An OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service
         *        tools. This workspace was created automatically as part of the integration setup. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html"
         *        >Centralized OpenSearch user interface (Dashboards) with OpenSearch Service</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspace(OpenSearchWorkspace workspace);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service workspace used for this integration. An
         * OpenSearch Service workspace is the collection of dashboards along with other OpenSearch Service tools. This
         * workspace was created automatically as part of the integration setup. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html">Centralized
         * OpenSearch user interface (Dashboards) with OpenSearch Service</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchWorkspace.Builder} avoiding the
         * need to create one manually via {@link OpenSearchWorkspace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchWorkspace.Builder#build()} is called immediately and
         * its result is passed to {@link #workspace(OpenSearchWorkspace)}.
         * 
         * @param workspace
         *        a consumer that will call methods on {@link OpenSearchWorkspace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspace(OpenSearchWorkspace)
         */
        default Builder workspace(Consumer<OpenSearchWorkspace.Builder> workspace) {
            return workspace(OpenSearchWorkspace.builder().applyMutation(workspace).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service encryption policy used for this integration.
         * The encryption policy was created automatically when you created the integration. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies"
         * >Encryption policies</a> in the OpenSearch Service Developer Guide.
         * </p>
         * 
         * @param encryptionPolicy
         *        This structure contains information about the OpenSearch Service encryption policy used for this
         *        integration. The encryption policy was created automatically when you created the integration. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies"
         *        >Encryption policies</a> in the OpenSearch Service Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionPolicy(OpenSearchEncryptionPolicy encryptionPolicy);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service encryption policy used for this integration.
         * The encryption policy was created automatically when you created the integration. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html#serverless-encryption-policies"
         * >Encryption policies</a> in the OpenSearch Service Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchEncryptionPolicy.Builder}
         * avoiding the need to create one manually via {@link OpenSearchEncryptionPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchEncryptionPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionPolicy(OpenSearchEncryptionPolicy)}.
         * 
         * @param encryptionPolicy
         *        a consumer that will call methods on {@link OpenSearchEncryptionPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionPolicy(OpenSearchEncryptionPolicy)
         */
        default Builder encryptionPolicy(Consumer<OpenSearchEncryptionPolicy.Builder> encryptionPolicy) {
            return encryptionPolicy(OpenSearchEncryptionPolicy.builder().applyMutation(encryptionPolicy).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service network policy used for this integration.
         * The network policy assigns network access settings to collections. For more information, see <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies"
         * >Network policies</a> in the OpenSearch Service Developer Guide.
         * </p>
         * 
         * @param networkPolicy
         *        This structure contains information about the OpenSearch Service network policy used for this
         *        integration. The network policy assigns network access settings to collections. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies"
         *        >Network policies</a> in the OpenSearch Service Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPolicy(OpenSearchNetworkPolicy networkPolicy);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service network policy used for this integration.
         * The network policy assigns network access settings to collections. For more information, see <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html#serverless-network-policies"
         * >Network policies</a> in the OpenSearch Service Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchNetworkPolicy.Builder} avoiding
         * the need to create one manually via {@link OpenSearchNetworkPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchNetworkPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #networkPolicy(OpenSearchNetworkPolicy)}.
         * 
         * @param networkPolicy
         *        a consumer that will call methods on {@link OpenSearchNetworkPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkPolicy(OpenSearchNetworkPolicy)
         */
        default Builder networkPolicy(Consumer<OpenSearchNetworkPolicy.Builder> networkPolicy) {
            return networkPolicy(OpenSearchNetworkPolicy.builder().applyMutation(networkPolicy).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service data access policy used for this
         * integration. The access policy defines the access controls for the collection. This data access policy was
         * automatically created as part of the integration setup. For more information about OpenSearch Service data
         * access policies, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
         * access control for Amazon OpenSearch Serverless</a> in the OpenSearch Service Developer Guide.
         * </p>
         * 
         * @param accessPolicy
         *        This structure contains information about the OpenSearch Service data access policy used for this
         *        integration. The access policy defines the access controls for the collection. This data access policy
         *        was automatically created as part of the integration setup. For more information about OpenSearch
         *        Service data access policies, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html"
         *        >Data access control for Amazon OpenSearch Serverless</a> in the OpenSearch Service Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(OpenSearchDataAccessPolicy accessPolicy);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service data access policy used for this
         * integration. The access policy defines the access controls for the collection. This data access policy was
         * automatically created as part of the integration setup. For more information about OpenSearch Service data
         * access policies, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
         * access control for Amazon OpenSearch Serverless</a> in the OpenSearch Service Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchDataAccessPolicy.Builder}
         * avoiding the need to create one manually via {@link OpenSearchDataAccessPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchDataAccessPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #accessPolicy(OpenSearchDataAccessPolicy)}.
         * 
         * @param accessPolicy
         *        a consumer that will call methods on {@link OpenSearchDataAccessPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicy(OpenSearchDataAccessPolicy)
         */
        default Builder accessPolicy(Consumer<OpenSearchDataAccessPolicy.Builder> accessPolicy) {
            return accessPolicy(OpenSearchDataAccessPolicy.builder().applyMutation(accessPolicy).build());
        }

        /**
         * <p>
         * This structure contains information about the OpenSearch Service data lifecycle policy used for this
         * integration. The lifecycle policy determines the lifespan of the data in the collection. It was automatically
         * created as part of the integration setup.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html">Using
         * data lifecycle policies with OpenSearch Service Serverless</a> in the OpenSearch Service Developer Guide.
         * </p>
         * 
         * @param lifecyclePolicy
         *        This structure contains information about the OpenSearch Service data lifecycle policy used for this
         *        integration. The lifecycle policy determines the lifespan of the data in the collection. It was
         *        automatically created as part of the integration setup.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html">Using
         *        data lifecycle policies with OpenSearch Service Serverless</a> in the OpenSearch Service Developer
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicy(OpenSearchLifecyclePolicy lifecyclePolicy);

        /**
         * <p>
         * This structure contains information about the OpenSearch Service data lifecycle policy used for this
         * integration. The lifecycle policy determines the lifespan of the data in the collection. It was automatically
         * created as part of the integration setup.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html">Using
         * data lifecycle policies with OpenSearch Service Serverless</a> in the OpenSearch Service Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchLifecyclePolicy.Builder}
         * avoiding the need to create one manually via {@link OpenSearchLifecyclePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchLifecyclePolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #lifecyclePolicy(OpenSearchLifecyclePolicy)}.
         * 
         * @param lifecyclePolicy
         *        a consumer that will call methods on {@link OpenSearchLifecyclePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicy(OpenSearchLifecyclePolicy)
         */
        default Builder lifecyclePolicy(Consumer<OpenSearchLifecyclePolicy.Builder> lifecyclePolicy) {
            return lifecyclePolicy(OpenSearchLifecyclePolicy.builder().applyMutation(lifecyclePolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpenSearchDataSource dataSource;

        private OpenSearchApplication application;

        private OpenSearchCollection collection;

        private OpenSearchWorkspace workspace;

        private OpenSearchEncryptionPolicy encryptionPolicy;

        private OpenSearchNetworkPolicy networkPolicy;

        private OpenSearchDataAccessPolicy accessPolicy;

        private OpenSearchLifecyclePolicy lifecyclePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchIntegrationDetails model) {
            dataSource(model.dataSource);
            application(model.application);
            collection(model.collection);
            workspace(model.workspace);
            encryptionPolicy(model.encryptionPolicy);
            networkPolicy(model.networkPolicy);
            accessPolicy(model.accessPolicy);
            lifecyclePolicy(model.lifecyclePolicy);
        }

        public final OpenSearchDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(OpenSearchDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(OpenSearchDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final OpenSearchApplication.Builder getApplication() {
            return application != null ? application.toBuilder() : null;
        }

        public final void setApplication(OpenSearchApplication.BuilderImpl application) {
            this.application = application != null ? application.build() : null;
        }

        @Override
        public final Builder application(OpenSearchApplication application) {
            this.application = application;
            return this;
        }

        public final OpenSearchCollection.Builder getCollection() {
            return collection != null ? collection.toBuilder() : null;
        }

        public final void setCollection(OpenSearchCollection.BuilderImpl collection) {
            this.collection = collection != null ? collection.build() : null;
        }

        @Override
        public final Builder collection(OpenSearchCollection collection) {
            this.collection = collection;
            return this;
        }

        public final OpenSearchWorkspace.Builder getWorkspace() {
            return workspace != null ? workspace.toBuilder() : null;
        }

        public final void setWorkspace(OpenSearchWorkspace.BuilderImpl workspace) {
            this.workspace = workspace != null ? workspace.build() : null;
        }

        @Override
        public final Builder workspace(OpenSearchWorkspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public final OpenSearchEncryptionPolicy.Builder getEncryptionPolicy() {
            return encryptionPolicy != null ? encryptionPolicy.toBuilder() : null;
        }

        public final void setEncryptionPolicy(OpenSearchEncryptionPolicy.BuilderImpl encryptionPolicy) {
            this.encryptionPolicy = encryptionPolicy != null ? encryptionPolicy.build() : null;
        }

        @Override
        public final Builder encryptionPolicy(OpenSearchEncryptionPolicy encryptionPolicy) {
            this.encryptionPolicy = encryptionPolicy;
            return this;
        }

        public final OpenSearchNetworkPolicy.Builder getNetworkPolicy() {
            return networkPolicy != null ? networkPolicy.toBuilder() : null;
        }

        public final void setNetworkPolicy(OpenSearchNetworkPolicy.BuilderImpl networkPolicy) {
            this.networkPolicy = networkPolicy != null ? networkPolicy.build() : null;
        }

        @Override
        public final Builder networkPolicy(OpenSearchNetworkPolicy networkPolicy) {
            this.networkPolicy = networkPolicy;
            return this;
        }

        public final OpenSearchDataAccessPolicy.Builder getAccessPolicy() {
            return accessPolicy != null ? accessPolicy.toBuilder() : null;
        }

        public final void setAccessPolicy(OpenSearchDataAccessPolicy.BuilderImpl accessPolicy) {
            this.accessPolicy = accessPolicy != null ? accessPolicy.build() : null;
        }

        @Override
        public final Builder accessPolicy(OpenSearchDataAccessPolicy accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final OpenSearchLifecyclePolicy.Builder getLifecyclePolicy() {
            return lifecyclePolicy != null ? lifecyclePolicy.toBuilder() : null;
        }

        public final void setLifecyclePolicy(OpenSearchLifecyclePolicy.BuilderImpl lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy != null ? lifecyclePolicy.build() : null;
        }

        @Override
        public final Builder lifecyclePolicy(OpenSearchLifecyclePolicy lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        @Override
        public OpenSearchIntegrationDetails build() {
            return new OpenSearchIntegrationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
