/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object contains the information for one log event returned in a Live Tail stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveTailSessionLogEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveTailSessionLogEvent.Builder, LiveTailSessionLogEvent> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamName").getter(getter(LiveTailSessionLogEvent::logStreamName))
            .setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(LiveTailSessionLogEvent::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(LiveTailSessionLogEvent::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("timestamp")
            .getter(getter(LiveTailSessionLogEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<Long> INGESTION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ingestionTime").getter(getter(LiveTailSessionLogEvent::ingestionTime))
            .setter(setter(Builder::ingestionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD,
            LOG_GROUP_IDENTIFIER_FIELD, MESSAGE_FIELD, TIMESTAMP_FIELD, INGESTION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("logStreamName", LOG_STREAM_NAME_FIELD);
                    put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
                    put("message", MESSAGE_FIELD);
                    put("timestamp", TIMESTAMP_FIELD);
                    put("ingestionTime", INGESTION_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String logStreamName;

    private final String logGroupIdentifier;

    private final String message;

    private final Long timestamp;

    private final Long ingestionTime;

    private LiveTailSessionLogEvent(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.message = builder.message;
        this.timestamp = builder.timestamp;
        this.ingestionTime = builder.ingestionTime;
    }

    /**
     * <p>
     * The name of the log stream that ingested this log event.
     * </p>
     * 
     * @return The name of the log stream that ingested this log event.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The name or ARN of the log group that ingested this log event.
     * </p>
     * 
     * @return The name or ARN of the log group that ingested this log event.
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * The log event message text.
     * </p>
     * 
     * @return The log event message text.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The timestamp specifying when this log event was created.
     * </p>
     * 
     * @return The timestamp specifying when this log event was created.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The timestamp specifying when this log event was ingested into the log group.
     * </p>
     * 
     * @return The timestamp specifying when this log event was ingested into the log group.
     */
    public final Long ingestionTime() {
        return ingestionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveTailSessionLogEvent)) {
            return false;
        }
        LiveTailSessionLogEvent other = (LiveTailSessionLogEvent) obj;
        return Objects.equals(logStreamName(), other.logStreamName())
                && Objects.equals(logGroupIdentifier(), other.logGroupIdentifier()) && Objects.equals(message(), other.message())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(ingestionTime(), other.ingestionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveTailSessionLogEvent").add("LogStreamName", logStreamName())
                .add("LogGroupIdentifier", logGroupIdentifier()).add("Message", message()).add("Timestamp", timestamp())
                .add("IngestionTime", ingestionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ingestionTime":
            return Optional.ofNullable(clazz.cast(ingestionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LiveTailSessionLogEvent, T> g) {
        return obj -> g.apply((LiveTailSessionLogEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveTailSessionLogEvent> {
        /**
         * <p>
         * The name of the log stream that ingested this log event.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream that ingested this log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The name or ARN of the log group that ingested this log event.
         * </p>
         * 
         * @param logGroupIdentifier
         *        The name or ARN of the log group that ingested this log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * The log event message text.
         * </p>
         * 
         * @param message
         *        The log event message text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The timestamp specifying when this log event was created.
         * </p>
         * 
         * @param timestamp
         *        The timestamp specifying when this log event was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The timestamp specifying when this log event was ingested into the log group.
         * </p>
         * 
         * @param ingestionTime
         *        The timestamp specifying when this log event was ingested into the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionTime(Long ingestionTime);
    }

    static final class BuilderImpl implements Builder {
        private String logStreamName;

        private String logGroupIdentifier;

        private String message;

        private Long timestamp;

        private Long ingestionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveTailSessionLogEvent model) {
            logStreamName(model.logStreamName);
            logGroupIdentifier(model.logGroupIdentifier);
            message(model.message);
            timestamp(model.timestamp);
            ingestionTime(model.ingestionTime);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Long getIngestionTime() {
            return ingestionTime;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        @Override
        public LiveTailSessionLogEvent build() {
            return new LiveTailSessionLogEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
