/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object defines one value to be copied with the <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-copoyValue"
 * > copyValue</a> processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyValueEntry implements SdkPojo, Serializable, ToCopyableBuilder<CopyValueEntry.Builder, CopyValueEntry> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(CopyValueEntry::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(CopyValueEntry::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overwriteIfExists").getter(getter(CopyValueEntry::overwriteIfExists))
            .setter(setter(Builder::overwriteIfExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD,
            OVERWRITE_IF_EXISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("source", SOURCE_FIELD);
                    put("target", TARGET_FIELD);
                    put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String target;

    private final Boolean overwriteIfExists;

    private CopyValueEntry(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    /**
     * <p>
     * The key to copy.
     * </p>
     * 
     * @return The key to copy.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The key of the field to copy the value to.
     * </p>
     * 
     * @return The key of the field to copy the value to.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * Specifies whether to overwrite the value if the destination key already exists. If you omit this, the default is
     * <code>false</code>.
     * </p>
     * 
     * @return Specifies whether to overwrite the value if the destination key already exists. If you omit this, the
     *         default is <code>false</code>.
     */
    public final Boolean overwriteIfExists() {
        return overwriteIfExists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteIfExists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyValueEntry)) {
            return false;
        }
        CopyValueEntry other = (CopyValueEntry) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(overwriteIfExists(), other.overwriteIfExists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyValueEntry").add("Source", source()).add("Target", target())
                .add("OverwriteIfExists", overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "overwriteIfExists":
            return Optional.ofNullable(clazz.cast(overwriteIfExists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CopyValueEntry, T> g) {
        return obj -> g.apply((CopyValueEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyValueEntry> {
        /**
         * <p>
         * The key to copy.
         * </p>
         * 
         * @param source
         *        The key to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The key of the field to copy the value to.
         * </p>
         * 
         * @param target
         *        The key of the field to copy the value to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * Specifies whether to overwrite the value if the destination key already exists. If you omit this, the default
         * is <code>false</code>.
         * </p>
         * 
         * @param overwriteIfExists
         *        Specifies whether to overwrite the value if the destination key already exists. If you omit this, the
         *        default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overwriteIfExists(Boolean overwriteIfExists);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String target;

        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyValueEntry model) {
            source(model.source);
            target(model.target);
            overwriteIfExists(model.overwriteIfExists);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        @Override
        public CopyValueEntry build() {
            return new CopyValueEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
