/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the OpenSearch Service workspace used for this integration. An OpenSearch
 * Service workspace is the collection of dashboards along with other OpenSearch Service tools. This workspace was
 * created automatically as part of the integration setup. For more information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/application.html">Centralized OpenSearch
 * user interface (Dashboards) with OpenSearch Service</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchWorkspace implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchWorkspace.Builder, OpenSearchWorkspace> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(OpenSearchWorkspace::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final SdkField<OpenSearchResourceStatus> STATUS_FIELD = SdkField
            .<OpenSearchResourceStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(OpenSearchWorkspace::status)).setter(setter(Builder::status))
            .constructor(OpenSearchResourceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("workspaceId", WORKSPACE_ID_FIELD);
                    put("status", STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String workspaceId;

    private final OpenSearchResourceStatus status;

    private OpenSearchWorkspace(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of this workspace.
     * </p>
     * 
     * @return The ID of this workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * This structure contains information about the status of an OpenSearch Service resource.
     * </p>
     * 
     * @return This structure contains information about the status of an OpenSearch Service resource.
     */
    public final OpenSearchResourceStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchWorkspace)) {
            return false;
        }
        OpenSearchWorkspace other = (OpenSearchWorkspace) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchWorkspace").add("WorkspaceId", workspaceId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchWorkspace, T> g) {
        return obj -> g.apply((OpenSearchWorkspace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchWorkspace> {
        /**
         * <p>
         * The ID of this workspace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * This structure contains information about the status of an OpenSearch Service resource.
         * </p>
         * 
         * @param status
         *        This structure contains information about the status of an OpenSearch Service resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OpenSearchResourceStatus status);

        /**
         * <p>
         * This structure contains information about the status of an OpenSearch Service resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchResourceStatus.Builder}
         * avoiding the need to create one manually via {@link OpenSearchResourceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchResourceStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(OpenSearchResourceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link OpenSearchResourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(OpenSearchResourceStatus)
         */
        default Builder status(Consumer<OpenSearchResourceStatus.Builder> status) {
            return status(OpenSearchResourceStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String workspaceId;

        private OpenSearchResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchWorkspace model) {
            workspaceId(model.workspaceId);
            status(model.status);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final OpenSearchResourceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(OpenSearchResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OpenSearchResourceStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public OpenSearchWorkspace build() {
            return new OpenSearchWorkspace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
