/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This processor converts a datetime string into a format that you specify.
 * </p>
 * <p>
 * For more information about this processor including examples, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-datetimeConverter"
 * > datetimeConverter</a> in the <i>CloudWatch Logs User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateTimeConverter implements SdkPojo, Serializable,
        ToCopyableBuilder<DateTimeConverter.Builder, DateTimeConverter> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(DateTimeConverter::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(DateTimeConverter::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> TARGET_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetFormat").getter(getter(DateTimeConverter::targetFormat)).setter(setter(Builder::targetFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFormat").build()).build();

    private static final SdkField<List<String>> MATCH_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("matchPatterns")
            .getter(getter(DateTimeConverter::matchPatterns))
            .setter(setter(Builder::matchPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceTimezone").getter(getter(DateTimeConverter::sourceTimezone))
            .setter(setter(Builder::sourceTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTimezone").build()).build();

    private static final SdkField<String> TARGET_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTimezone").getter(getter(DateTimeConverter::targetTimezone))
            .setter(setter(Builder::targetTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTimezone").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(DateTimeConverter::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD,
            TARGET_FORMAT_FIELD, MATCH_PATTERNS_FIELD, SOURCE_TIMEZONE_FIELD, TARGET_TIMEZONE_FIELD, LOCALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("source", SOURCE_FIELD);
                    put("target", TARGET_FIELD);
                    put("targetFormat", TARGET_FORMAT_FIELD);
                    put("matchPatterns", MATCH_PATTERNS_FIELD);
                    put("sourceTimezone", SOURCE_TIMEZONE_FIELD);
                    put("targetTimezone", TARGET_TIMEZONE_FIELD);
                    put("locale", LOCALE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String target;

    private final String targetFormat;

    private final List<String> matchPatterns;

    private final String sourceTimezone;

    private final String targetTimezone;

    private final String locale;

    private DateTimeConverter(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.targetFormat = builder.targetFormat;
        this.matchPatterns = builder.matchPatterns;
        this.sourceTimezone = builder.sourceTimezone;
        this.targetTimezone = builder.targetTimezone;
        this.locale = builder.locale;
    }

    /**
     * <p>
     * The key to apply the date conversion to.
     * </p>
     * 
     * @return The key to apply the date conversion to.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The JSON field to store the result in.
     * </p>
     * 
     * @return The JSON field to store the result in.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The datetime format to use for the converted data in the target field.
     * </p>
     * <p>
     * If you omit this, the default of <code> yyyy-MM-dd'T'HH:mm:ss.SSS'Z</code> is used.
     * </p>
     * 
     * @return The datetime format to use for the converted data in the target field.</p>
     *         <p>
     *         If you omit this, the default of <code> yyyy-MM-dd'T'HH:mm:ss.SSS'Z</code> is used.
     */
    public final String targetFormat() {
        return targetFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchPatterns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchPatterns() {
        return matchPatterns != null && !(matchPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of patterns to match against the <code>source</code> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchPatterns} method.
     * </p>
     * 
     * @return A list of patterns to match against the <code>source</code> field.
     */
    public final List<String> matchPatterns() {
        return matchPatterns;
    }

    /**
     * <p>
     * The time zone of the source field. If you omit this, the default used is the UTC zone.
     * </p>
     * 
     * @return The time zone of the source field. If you omit this, the default used is the UTC zone.
     */
    public final String sourceTimezone() {
        return sourceTimezone;
    }

    /**
     * <p>
     * The time zone of the target field. If you omit this, the default used is the UTC zone.
     * </p>
     * 
     * @return The time zone of the target field. If you omit this, the default used is the UTC zone.
     */
    public final String targetTimezone() {
        return targetTimezone;
    }

    /**
     * <p>
     * The locale of the source field. If you omit this, the default of <code>locale.ROOT</code> is used.
     * </p>
     * 
     * @return The locale of the source field. If you omit this, the default of <code>locale.ROOT</code> is used.
     */
    public final String locale() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetFormat());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchPatterns() ? matchPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(targetTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeConverter)) {
            return false;
        }
        DateTimeConverter other = (DateTimeConverter) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(targetFormat(), other.targetFormat()) && hasMatchPatterns() == other.hasMatchPatterns()
                && Objects.equals(matchPatterns(), other.matchPatterns())
                && Objects.equals(sourceTimezone(), other.sourceTimezone())
                && Objects.equals(targetTimezone(), other.targetTimezone()) && Objects.equals(locale(), other.locale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateTimeConverter").add("Source", source()).add("Target", target())
                .add("TargetFormat", targetFormat()).add("MatchPatterns", hasMatchPatterns() ? matchPatterns() : null)
                .add("SourceTimezone", sourceTimezone()).add("TargetTimezone", targetTimezone()).add("Locale", locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "targetFormat":
            return Optional.ofNullable(clazz.cast(targetFormat()));
        case "matchPatterns":
            return Optional.ofNullable(clazz.cast(matchPatterns()));
        case "sourceTimezone":
            return Optional.ofNullable(clazz.cast(sourceTimezone()));
        case "targetTimezone":
            return Optional.ofNullable(clazz.cast(targetTimezone()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeConverter, T> g) {
        return obj -> g.apply((DateTimeConverter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateTimeConverter> {
        /**
         * <p>
         * The key to apply the date conversion to.
         * </p>
         * 
         * @param source
         *        The key to apply the date conversion to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The JSON field to store the result in.
         * </p>
         * 
         * @param target
         *        The JSON field to store the result in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The datetime format to use for the converted data in the target field.
         * </p>
         * <p>
         * If you omit this, the default of <code> yyyy-MM-dd'T'HH:mm:ss.SSS'Z</code> is used.
         * </p>
         * 
         * @param targetFormat
         *        The datetime format to use for the converted data in the target field.</p>
         *        <p>
         *        If you omit this, the default of <code> yyyy-MM-dd'T'HH:mm:ss.SSS'Z</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFormat(String targetFormat);

        /**
         * <p>
         * A list of patterns to match against the <code>source</code> field.
         * </p>
         * 
         * @param matchPatterns
         *        A list of patterns to match against the <code>source</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPatterns(Collection<String> matchPatterns);

        /**
         * <p>
         * A list of patterns to match against the <code>source</code> field.
         * </p>
         * 
         * @param matchPatterns
         *        A list of patterns to match against the <code>source</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPatterns(String... matchPatterns);

        /**
         * <p>
         * The time zone of the source field. If you omit this, the default used is the UTC zone.
         * </p>
         * 
         * @param sourceTimezone
         *        The time zone of the source field. If you omit this, the default used is the UTC zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTimezone(String sourceTimezone);

        /**
         * <p>
         * The time zone of the target field. If you omit this, the default used is the UTC zone.
         * </p>
         * 
         * @param targetTimezone
         *        The time zone of the target field. If you omit this, the default used is the UTC zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTimezone(String targetTimezone);

        /**
         * <p>
         * The locale of the source field. If you omit this, the default of <code>locale.ROOT</code> is used.
         * </p>
         * 
         * @param locale
         *        The locale of the source field. If you omit this, the default of <code>locale.ROOT</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String target;

        private String targetFormat;

        private List<String> matchPatterns = DefaultSdkAutoConstructList.getInstance();

        private String sourceTimezone;

        private String targetTimezone;

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeConverter model) {
            source(model.source);
            target(model.target);
            targetFormat(model.targetFormat);
            matchPatterns(model.matchPatterns);
            sourceTimezone(model.sourceTimezone);
            targetTimezone(model.targetTimezone);
            locale(model.locale);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getTargetFormat() {
            return targetFormat;
        }

        public final void setTargetFormat(String targetFormat) {
            this.targetFormat = targetFormat;
        }

        @Override
        public final Builder targetFormat(String targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        public final Collection<String> getMatchPatterns() {
            if (matchPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return matchPatterns;
        }

        public final void setMatchPatterns(Collection<String> matchPatterns) {
            this.matchPatterns = MatchPatternsCopier.copy(matchPatterns);
        }

        @Override
        public final Builder matchPatterns(Collection<String> matchPatterns) {
            this.matchPatterns = MatchPatternsCopier.copy(matchPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPatterns(String... matchPatterns) {
            matchPatterns(Arrays.asList(matchPatterns));
            return this;
        }

        public final String getSourceTimezone() {
            return sourceTimezone;
        }

        public final void setSourceTimezone(String sourceTimezone) {
            this.sourceTimezone = sourceTimezone;
        }

        @Override
        public final Builder sourceTimezone(String sourceTimezone) {
            this.sourceTimezone = sourceTimezone;
            return this;
        }

        public final String getTargetTimezone() {
            return targetTimezone;
        }

        public final void setTargetTimezone(String targetTimezone) {
            this.targetTimezone = targetTimezone;
        }

        @Override
        public final Builder targetTimezone(String targetTimezone) {
            this.targetTimezone = targetTimezone;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public DateTimeConverter build() {
            return new DateTimeConverter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
