/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetricFilterRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutMetricFilterRequest.Builder, PutMetricFilterRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(PutMetricFilterRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterName").getter(getter(PutMetricFilterRequest::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(PutMetricFilterRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<List<MetricTransformation>> METRIC_TRANSFORMATIONS_FIELD = SdkField
            .<List<MetricTransformation>> builder(MarshallingType.LIST)
            .memberName("metricTransformations")
            .getter(getter(PutMetricFilterRequest::metricTransformations))
            .setter(setter(Builder::metricTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_ON_TRANSFORMED_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("applyOnTransformedLogs").getter(getter(PutMetricFilterRequest::applyOnTransformedLogs))
            .setter(setter(Builder::applyOnTransformedLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOnTransformedLogs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, METRIC_TRANSFORMATIONS_FIELD, APPLY_ON_TRANSFORMED_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupName;

    private final String filterName;

    private final String filterPattern;

    private final List<MetricTransformation> metricTransformations;

    private final Boolean applyOnTransformedLogs;

    private PutMetricFilterRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
        this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * A name for the metric filter.
     * </p>
     * 
     * @return A name for the metric filter.
     */
    public final String filterName() {
        return filterName;
    }

    /**
     * <p>
     * A filter pattern for extracting metric data out of ingested log events.
     * </p>
     * 
     * @return A filter pattern for extracting metric data out of ingested log events.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricTransformations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetricTransformations() {
        return metricTransformations != null && !(metricTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of information that defines how metric data gets emitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricTransformations} method.
     * </p>
     * 
     * @return A collection of information that defines how metric data gets emitted.
     */
    public final List<MetricTransformation> metricTransformations() {
        return metricTransformations;
    }

    /**
     * <p>
     * This parameter is valid only for log groups that have an active log transformer. For more information about log
     * transformers, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     * >PutTransformer</a>.
     * </p>
     * <p>
     * If the log group uses either a log-group level or account-level transformer, and you specify <code>true</code>,
     * the metric filter will be applied on the transformed version of the log events instead of the original ingested
     * log events.
     * </p>
     * 
     * @return This parameter is valid only for log groups that have an active log transformer. For more information
     *         about log transformers, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     *         >PutTransformer</a>.</p>
     *         <p>
     *         If the log group uses either a log-group level or account-level transformer, and you specify
     *         <code>true</code>, the metric filter will be applied on the transformed version of the log events instead
     *         of the original ingested log events.
     */
    public final Boolean applyOnTransformedLogs() {
        return applyOnTransformedLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricTransformations() ? metricTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyOnTransformedLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricFilterRequest)) {
            return false;
        }
        PutMetricFilterRequest other = (PutMetricFilterRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(filterName(), other.filterName())
                && Objects.equals(filterPattern(), other.filterPattern())
                && hasMetricTransformations() == other.hasMetricTransformations()
                && Objects.equals(metricTransformations(), other.metricTransformations())
                && Objects.equals(applyOnTransformedLogs(), other.applyOnTransformedLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMetricFilterRequest").add("LogGroupName", logGroupName()).add("FilterName", filterName())
                .add("FilterPattern", filterPattern())
                .add("MetricTransformations", hasMetricTransformations() ? metricTransformations() : null)
                .add("ApplyOnTransformedLogs", applyOnTransformedLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "metricTransformations":
            return Optional.ofNullable(clazz.cast(metricTransformations()));
        case "applyOnTransformedLogs":
            return Optional.ofNullable(clazz.cast(applyOnTransformedLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("metricTransformations", METRIC_TRANSFORMATIONS_FIELD);
        map.put("applyOnTransformedLogs", APPLY_ON_TRANSFORMED_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMetricFilterRequest, T> g) {
        return obj -> g.apply((PutMetricFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMetricFilterRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * A name for the metric filter.
         * </p>
         * 
         * @param filterName
         *        A name for the metric filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * A filter pattern for extracting metric data out of ingested log events.
         * </p>
         * 
         * @param filterPattern
         *        A filter pattern for extracting metric data out of ingested log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * A collection of information that defines how metric data gets emitted.
         * </p>
         * 
         * @param metricTransformations
         *        A collection of information that defines how metric data gets emitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(Collection<MetricTransformation> metricTransformations);

        /**
         * <p>
         * A collection of information that defines how metric data gets emitted.
         * </p>
         * 
         * @param metricTransformations
         *        A collection of information that defines how metric data gets emitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(MetricTransformation... metricTransformations);

        /**
         * <p>
         * A collection of information that defines how metric data gets emitted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation.Builder#build()} is called
         * immediately and its result is passed to {@link #metricTransformations(List<MetricTransformation>)}.
         * 
         * @param metricTransformations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricTransformations(java.util.Collection<MetricTransformation>)
         */
        Builder metricTransformations(Consumer<MetricTransformation.Builder>... metricTransformations);

        /**
         * <p>
         * This parameter is valid only for log groups that have an active log transformer. For more information about
         * log transformers, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
         * >PutTransformer</a>.
         * </p>
         * <p>
         * If the log group uses either a log-group level or account-level transformer, and you specify
         * <code>true</code>, the metric filter will be applied on the transformed version of the log events instead of
         * the original ingested log events.
         * </p>
         * 
         * @param applyOnTransformedLogs
         *        This parameter is valid only for log groups that have an active log transformer. For more information
         *        about log transformers, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
         *        >PutTransformer</a>.</p>
         *        <p>
         *        If the log group uses either a log-group level or account-level transformer, and you specify
         *        <code>true</code>, the metric filter will be applied on the transformed version of the log events
         *        instead of the original ingested log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String filterName;

        private String filterPattern;

        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyOnTransformedLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricFilterRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            filterName(model.filterName);
            filterPattern(model.filterPattern);
            metricTransformations(model.metricTransformations);
            applyOnTransformedLogs(model.applyOnTransformedLogs);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final List<MetricTransformation.Builder> getMetricTransformations() {
            List<MetricTransformation.Builder> result = MetricTransformationsCopier.copyToBuilder(this.metricTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation... metricTransformations) {
            metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder>... metricTransformations) {
            metricTransformations(Stream.of(metricTransformations)
                    .map(c -> MetricTransformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getApplyOnTransformedLogs() {
            return applyOnTransformedLogs;
        }

        public final void setApplyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
        }

        @Override
        public final Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricFilterRequest build() {
            return new PutMetricFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
