/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQueryDefinitionsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeQueryDefinitionsRequest.Builder, DescribeQueryDefinitionsRequest> {
    private static final SdkField<String> QUERY_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLanguage").getter(getter(DescribeQueryDefinitionsRequest::queryLanguageAsString))
            .setter(setter(Builder::queryLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLanguage").build()).build();

    private static final SdkField<String> QUERY_DEFINITION_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryDefinitionNamePrefix").getter(getter(DescribeQueryDefinitionsRequest::queryDefinitionNamePrefix))
            .setter(setter(Builder::queryDefinitionNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitionNamePrefix").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeQueryDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeQueryDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_LANGUAGE_FIELD,
            QUERY_DEFINITION_NAME_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryLanguage;

    private final String queryDefinitionNamePrefix;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeQueryDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.queryLanguage = builder.queryLanguage;
        this.queryDefinitionNamePrefix = builder.queryDefinitionNamePrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The query language used for this query. For more information about the query languages that CloudWatch Logs
     * supports, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html">Supported query
     * languages</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return The query language used for this query. For more information about the query languages that CloudWatch
     *         Logs supports, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html"
     *         >Supported query languages</a>.
     * @see QueryLanguage
     */
    public final QueryLanguage queryLanguage() {
        return QueryLanguage.fromValue(queryLanguage);
    }

    /**
     * <p>
     * The query language used for this query. For more information about the query languages that CloudWatch Logs
     * supports, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html">Supported query
     * languages</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLanguage}
     * will return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryLanguageAsString}.
     * </p>
     * 
     * @return The query language used for this query. For more information about the query languages that CloudWatch
     *         Logs supports, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html"
     *         >Supported query languages</a>.
     * @see QueryLanguage
     */
    public final String queryLanguageAsString() {
        return queryLanguage;
    }

    /**
     * <p>
     * Use this parameter to filter your results to only the query definitions that have names that start with the
     * prefix you specify.
     * </p>
     * 
     * @return Use this parameter to filter your results to only the query definitions that have names that start with
     *         the prefix you specify.
     */
    public final String queryDefinitionNamePrefix() {
        return queryDefinitionNamePrefix;
    }

    /**
     * <p>
     * Limits the number of returned query definitions to the specified number.
     * </p>
     * 
     * @return Limits the number of returned query definitions to the specified number.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryDefinitionNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryDefinitionsRequest)) {
            return false;
        }
        DescribeQueryDefinitionsRequest other = (DescribeQueryDefinitionsRequest) obj;
        return Objects.equals(queryLanguageAsString(), other.queryLanguageAsString())
                && Objects.equals(queryDefinitionNamePrefix(), other.queryDefinitionNamePrefix())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQueryDefinitionsRequest").add("QueryLanguage", queryLanguageAsString())
                .add("QueryDefinitionNamePrefix", queryDefinitionNamePrefix()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryLanguage":
            return Optional.ofNullable(clazz.cast(queryLanguageAsString()));
        case "queryDefinitionNamePrefix":
            return Optional.ofNullable(clazz.cast(queryDefinitionNamePrefix()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryLanguage", QUERY_LANGUAGE_FIELD);
        map.put("queryDefinitionNamePrefix", QUERY_DEFINITION_NAME_PREFIX_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryDefinitionsRequest, T> g) {
        return obj -> g.apply((DescribeQueryDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeQueryDefinitionsRequest> {
        /**
         * <p>
         * The query language used for this query. For more information about the query languages that CloudWatch Logs
         * supports, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html">Supported
         * query languages</a>.
         * </p>
         * 
         * @param queryLanguage
         *        The query language used for this query. For more information about the query languages that CloudWatch
         *        Logs supports, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html"
         *        >Supported query languages</a>.
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(String queryLanguage);

        /**
         * <p>
         * The query language used for this query. For more information about the query languages that CloudWatch Logs
         * supports, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html">Supported
         * query languages</a>.
         * </p>
         * 
         * @param queryLanguage
         *        The query language used for this query. For more information about the query languages that CloudWatch
         *        Logs supports, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html"
         *        >Supported query languages</a>.
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder queryLanguage(QueryLanguage queryLanguage);

        /**
         * <p>
         * Use this parameter to filter your results to only the query definitions that have names that start with the
         * prefix you specify.
         * </p>
         * 
         * @param queryDefinitionNamePrefix
         *        Use this parameter to filter your results to only the query definitions that have names that start
         *        with the prefix you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryDefinitionNamePrefix(String queryDefinitionNamePrefix);

        /**
         * <p>
         * Limits the number of returned query definitions to the specified number.
         * </p>
         * 
         * @param maxResults
         *        Limits the number of returned query definitions to the specified number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String queryLanguage;

        private String queryDefinitionNamePrefix;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryDefinitionsRequest model) {
            super(model);
            queryLanguage(model.queryLanguage);
            queryDefinitionNamePrefix(model.queryDefinitionNamePrefix);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getQueryLanguage() {
            return queryLanguage;
        }

        public final void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        @Override
        public final Builder queryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        @Override
        public final Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage(queryLanguage == null ? null : queryLanguage.toString());
            return this;
        }

        public final String getQueryDefinitionNamePrefix() {
            return queryDefinitionNamePrefix;
        }

        public final void setQueryDefinitionNamePrefix(String queryDefinitionNamePrefix) {
            this.queryDefinitionNamePrefix = queryDefinitionNamePrefix;
        }

        @Override
        public final Builder queryDefinitionNamePrefix(String queryDefinitionNamePrefix) {
            this.queryDefinitionNamePrefix = queryDefinitionNamePrefix;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeQueryDefinitionsRequest build() {
            return new DescribeQueryDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
