/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.SuppressionPeriod;
import software.amazon.awssdk.services.cloudwatchlogs.model.SuppressionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnomalyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, UpdateAnomalyRequest> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyId").getter(UpdateAnomalyRequest.getter(UpdateAnomalyRequest::anomalyId)).setter(UpdateAnomalyRequest.setter(Builder::anomalyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyId").build()}).build();
    private static final SdkField<String> PATTERN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patternId").getter(UpdateAnomalyRequest.getter(UpdateAnomalyRequest::patternId)).setter(UpdateAnomalyRequest.setter(Builder::patternId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternId").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorArn").getter(UpdateAnomalyRequest.getter(UpdateAnomalyRequest::anomalyDetectorArn)).setter(UpdateAnomalyRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build()}).build();
    private static final SdkField<String> SUPPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suppressionType").getter(UpdateAnomalyRequest.getter(UpdateAnomalyRequest::suppressionTypeAsString)).setter(UpdateAnomalyRequest.setter(Builder::suppressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionType").build()}).build();
    private static final SdkField<SuppressionPeriod> SUPPRESSION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suppressionPeriod").getter(UpdateAnomalyRequest.getter(UpdateAnomalyRequest::suppressionPeriod)).setter(UpdateAnomalyRequest.setter(Builder::suppressionPeriod)).constructor(SuppressionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionPeriod").build()}).build();
    private static final SdkField<Boolean> BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("baseline").getter(UpdateAnomalyRequest.getter(UpdateAnomalyRequest::baseline)).setter(UpdateAnomalyRequest.setter(Builder::baseline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD, PATTERN_ID_FIELD, ANOMALY_DETECTOR_ARN_FIELD, SUPPRESSION_TYPE_FIELD, SUPPRESSION_PERIOD_FIELD, BASELINE_FIELD));
    private final String anomalyId;
    private final String patternId;
    private final String anomalyDetectorArn;
    private final String suppressionType;
    private final SuppressionPeriod suppressionPeriod;
    private final Boolean baseline;

    private UpdateAnomalyRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyId = builder.anomalyId;
        this.patternId = builder.patternId;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.suppressionType = builder.suppressionType;
        this.suppressionPeriod = builder.suppressionPeriod;
        this.baseline = builder.baseline;
    }

    public final String anomalyId() {
        return this.anomalyId;
    }

    public final String patternId() {
        return this.patternId;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final SuppressionType suppressionType() {
        return SuppressionType.fromValue(this.suppressionType);
    }

    public final String suppressionTypeAsString() {
        return this.suppressionType;
    }

    public final SuppressionPeriod suppressionPeriod() {
        return this.suppressionPeriod;
    }

    public final Boolean baseline() {
        return this.baseline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalyRequest)) {
            return false;
        }
        UpdateAnomalyRequest other = (UpdateAnomalyRequest)((Object)obj);
        return Objects.equals(this.anomalyId(), other.anomalyId()) && Objects.equals(this.patternId(), other.patternId()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.suppressionTypeAsString(), other.suppressionTypeAsString()) && Objects.equals(this.suppressionPeriod(), other.suppressionPeriod()) && Objects.equals(this.baseline(), other.baseline());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnomalyRequest").add("AnomalyId", (Object)this.anomalyId()).add("PatternId", (Object)this.patternId()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("SuppressionType", (Object)this.suppressionTypeAsString()).add("SuppressionPeriod", (Object)this.suppressionPeriod()).add("Baseline", (Object)this.baseline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyId": {
                return Optional.ofNullable(clazz.cast(this.anomalyId()));
            }
            case "patternId": {
                return Optional.ofNullable(clazz.cast(this.patternId()));
            }
            case "anomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "suppressionType": {
                return Optional.ofNullable(clazz.cast(this.suppressionTypeAsString()));
            }
            case "suppressionPeriod": {
                return Optional.ofNullable(clazz.cast(this.suppressionPeriod()));
            }
            case "baseline": {
                return Optional.ofNullable(clazz.cast(this.baseline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalyRequest, T> g) {
        return obj -> g.apply((UpdateAnomalyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String anomalyId;
        private String patternId;
        private String anomalyDetectorArn;
        private String suppressionType;
        private SuppressionPeriod suppressionPeriod;
        private Boolean baseline;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalyRequest model) {
            super(model);
            this.anomalyId(model.anomalyId);
            this.patternId(model.patternId);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.suppressionType(model.suppressionType);
            this.suppressionPeriod(model.suppressionPeriod);
            this.baseline(model.baseline);
        }

        public final String getAnomalyId() {
            return this.anomalyId;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        @Override
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final String getPatternId() {
            return this.patternId;
        }

        public final void setPatternId(String patternId) {
            this.patternId = patternId;
        }

        @Override
        public final Builder patternId(String patternId) {
            this.patternId = patternId;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getSuppressionType() {
            return this.suppressionType;
        }

        public final void setSuppressionType(String suppressionType) {
            this.suppressionType = suppressionType;
        }

        @Override
        public final Builder suppressionType(String suppressionType) {
            this.suppressionType = suppressionType;
            return this;
        }

        @Override
        public final Builder suppressionType(SuppressionType suppressionType) {
            this.suppressionType(suppressionType == null ? null : suppressionType.toString());
            return this;
        }

        public final SuppressionPeriod.Builder getSuppressionPeriod() {
            return this.suppressionPeriod != null ? this.suppressionPeriod.toBuilder() : null;
        }

        public final void setSuppressionPeriod(SuppressionPeriod.BuilderImpl suppressionPeriod) {
            this.suppressionPeriod = suppressionPeriod != null ? suppressionPeriod.build() : null;
        }

        @Override
        public final Builder suppressionPeriod(SuppressionPeriod suppressionPeriod) {
            this.suppressionPeriod = suppressionPeriod;
            return this;
        }

        public final Boolean getBaseline() {
            return this.baseline;
        }

        public final void setBaseline(Boolean baseline) {
            this.baseline = baseline;
        }

        @Override
        public final Builder baseline(Boolean baseline) {
            this.baseline = baseline;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalyRequest build() {
            return new UpdateAnomalyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnomalyRequest> {
        public Builder anomalyId(String var1);

        public Builder patternId(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder suppressionType(String var1);

        public Builder suppressionType(SuppressionType var1);

        public Builder suppressionPeriod(SuppressionPeriod var1);

        default public Builder suppressionPeriod(Consumer<SuppressionPeriod.Builder> suppressionPeriod) {
            return this.suppressionPeriod((SuppressionPeriod)((SuppressionPeriod.Builder)SuppressionPeriod.builder().applyMutation(suppressionPeriod)).build());
        }

        public Builder baseline(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

