/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLogAnomalyDetectorRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<CreateLogAnomalyDetectorRequest.Builder, CreateLogAnomalyDetectorRequest> {
    private static final SdkField<List<String>> LOG_GROUP_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logGroupArnList")
            .getter(getter(CreateLogAnomalyDetectorRequest::logGroupArnList))
            .setter(setter(Builder::logGroupArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorName").getter(getter(CreateLogAnomalyDetectorRequest::detectorName))
            .setter(setter(Builder::detectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()).build();

    private static final SdkField<String> EVALUATION_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationFrequency").getter(getter(CreateLogAnomalyDetectorRequest::evaluationFrequencyAsString))
            .setter(setter(Builder::evaluationFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationFrequency").build())
            .build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(CreateLogAnomalyDetectorRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateLogAnomalyDetectorRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Long> ANOMALY_VISIBILITY_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("anomalyVisibilityTime").getter(getter(CreateLogAnomalyDetectorRequest::anomalyVisibilityTime))
            .setter(setter(Builder::anomalyVisibilityTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyVisibilityTime").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLogAnomalyDetectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_ARN_LIST_FIELD,
            DETECTOR_NAME_FIELD, EVALUATION_FREQUENCY_FIELD, FILTER_PATTERN_FIELD, KMS_KEY_ID_FIELD,
            ANOMALY_VISIBILITY_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("logGroupArnList", LOG_GROUP_ARN_LIST_FIELD);
                    put("detectorName", DETECTOR_NAME_FIELD);
                    put("evaluationFrequency", EVALUATION_FREQUENCY_FIELD);
                    put("filterPattern", FILTER_PATTERN_FIELD);
                    put("kmsKeyId", KMS_KEY_ID_FIELD);
                    put("anomalyVisibilityTime", ANOMALY_VISIBILITY_TIME_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final List<String> logGroupArnList;

    private final String detectorName;

    private final String evaluationFrequency;

    private final String filterPattern;

    private final String kmsKeyId;

    private final Long anomalyVisibilityTime;

    private final Map<String, String> tags;

    private CreateLogAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupArnList = builder.logGroupArnList;
        this.detectorName = builder.detectorName;
        this.evaluationFrequency = builder.evaluationFrequency;
        this.filterPattern = builder.filterPattern;
        this.kmsKeyId = builder.kmsKeyId;
        this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupArnList() {
        return logGroupArnList != null && !(logGroupArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log
     * group ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupArnList} method.
     * </p>
     * 
     * @return An array containing the ARN of the log group that this anomaly detector will watch. You can specify only
     *         one log group ARN.
     */
    public final List<String> logGroupArnList() {
        return logGroupArnList;
    }

    /**
     * <p>
     * A name for this anomaly detector.
     * </p>
     * 
     * @return A name for this anomaly detector.
     */
    public final String detectorName() {
        return detectorName;
    }

    /**
     * <p>
     * Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the
     * frequency that the log group receives new logs. For example, if the log group receives new log events every 10
     * minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code> .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationFrequency} will return {@link EvaluationFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to
     *         the frequency that the log group receives new logs. For example, if the log group receives new log events
     *         every 10 minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code> .
     * @see EvaluationFrequency
     */
    public final EvaluationFrequency evaluationFrequency() {
        return EvaluationFrequency.fromValue(evaluationFrequency);
    }

    /**
     * <p>
     * Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the
     * frequency that the log group receives new logs. For example, if the log group receives new log events every 10
     * minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code> .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationFrequency} will return {@link EvaluationFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to
     *         the frequency that the log group receives new logs. For example, if the log group receives new log events
     *         every 10 minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code> .
     * @see EvaluationFrequency
     */
    public final String evaluationFrequencyAsString() {
        return evaluationFrequency;
    }

    /**
     * <p>
     * You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern
     * you specify here. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern
     * Syntax</a>.
     * </p>
     * 
     * @return You can use this parameter to limit the anomaly detection model to examine only log events that match the
     *         pattern you specify here. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
     *         Pattern Syntax</a>.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * Optionally assigns a KMS key to secure this anomaly detector and its findings. If a key is assigned, the
     * anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to
     * an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve
     * information about the anomalies that it finds.
     * </p>
     * <p>
     * For more information about using a KMS key and to see the required IAM policy, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html">Use a KMS key with
     * an anomaly detector</a>.
     * </p>
     * 
     * @return Optionally assigns a KMS key to secure this anomaly detector and its findings. If a key is assigned, the
     *         anomalies found and the model used by this detector are encrypted at rest with the key. If a key is
     *         assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly
     *         detector to retrieve information about the anomalies that it finds.</p>
     *         <p>
     *         For more information about using a KMS key and to see the required IAM policy, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html">Use a KMS
     *         key with an anomaly detector</a>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will
     * be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal.
     * Therefore, if you do not correct the cause of an anomaly during the time period specified in
     * <code>anomalyVisibilityTime</code>, it will be considered normal going forward and will not be detected as an
     * anomaly.
     * </p>
     * 
     * @return The number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly,
     *         it will be automatically baselined and the anomaly detector will treat new occurrences of a similar
     *         anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period
     *         specified in <code>anomalyVisibilityTime</code>, it will be considered normal going forward and will not
     *         be detected as an anomaly.
     */
    public final Long anomalyVisibilityTime() {
        return anomalyVisibilityTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional list of key-value pairs to associate with the resource.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of key-value pairs to associate with the resource.</p>
     *         <p>
     *         For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupArnList() ? logGroupArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyVisibilityTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogAnomalyDetectorRequest)) {
            return false;
        }
        CreateLogAnomalyDetectorRequest other = (CreateLogAnomalyDetectorRequest) obj;
        return hasLogGroupArnList() == other.hasLogGroupArnList() && Objects.equals(logGroupArnList(), other.logGroupArnList())
                && Objects.equals(detectorName(), other.detectorName())
                && Objects.equals(evaluationFrequencyAsString(), other.evaluationFrequencyAsString())
                && Objects.equals(filterPattern(), other.filterPattern()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(anomalyVisibilityTime(), other.anomalyVisibilityTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLogAnomalyDetectorRequest")
                .add("LogGroupArnList", hasLogGroupArnList() ? logGroupArnList() : null).add("DetectorName", detectorName())
                .add("EvaluationFrequency", evaluationFrequencyAsString()).add("FilterPattern", filterPattern())
                .add("KmsKeyId", kmsKeyId()).add("AnomalyVisibilityTime", anomalyVisibilityTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupArnList":
            return Optional.ofNullable(clazz.cast(logGroupArnList()));
        case "detectorName":
            return Optional.ofNullable(clazz.cast(detectorName()));
        case "evaluationFrequency":
            return Optional.ofNullable(clazz.cast(evaluationFrequencyAsString()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "anomalyVisibilityTime":
            return Optional.ofNullable(clazz.cast(anomalyVisibilityTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLogAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((CreateLogAnomalyDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLogAnomalyDetectorRequest> {
        /**
         * <p>
         * An array containing the ARN of the log group that this anomaly detector will watch. You can specify only one
         * log group ARN.
         * </p>
         * 
         * @param logGroupArnList
         *        An array containing the ARN of the log group that this anomaly detector will watch. You can specify
         *        only one log group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArnList(Collection<String> logGroupArnList);

        /**
         * <p>
         * An array containing the ARN of the log group that this anomaly detector will watch. You can specify only one
         * log group ARN.
         * </p>
         * 
         * @param logGroupArnList
         *        An array containing the ARN of the log group that this anomaly detector will watch. You can specify
         *        only one log group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArnList(String... logGroupArnList);

        /**
         * <p>
         * A name for this anomaly detector.
         * </p>
         * 
         * @param detectorName
         *        A name for this anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorName(String detectorName);

        /**
         * <p>
         * Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the
         * frequency that the log group receives new logs. For example, if the log group receives new log events every
         * 10 minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code> .
         * </p>
         * 
         * @param evaluationFrequency
         *        Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to
         *        the frequency that the log group receives new logs. For example, if the log group receives new log
         *        events every 10 minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code>
         *        .
         * @see EvaluationFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFrequency
         */
        Builder evaluationFrequency(String evaluationFrequency);

        /**
         * <p>
         * Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the
         * frequency that the log group receives new logs. For example, if the log group receives new log events every
         * 10 minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code> .
         * </p>
         * 
         * @param evaluationFrequency
         *        Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to
         *        the frequency that the log group receives new logs. For example, if the log group receives new log
         *        events every 10 minutes, then 15 minutes might be a good setting for <code>evaluationFrequency</code>
         *        .
         * @see EvaluationFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFrequency
         */
        Builder evaluationFrequency(EvaluationFrequency evaluationFrequency);

        /**
         * <p>
         * You can use this parameter to limit the anomaly detection model to examine only log events that match the
         * pattern you specify here. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
         * Pattern Syntax</a>.
         * </p>
         * 
         * @param filterPattern
         *        You can use this parameter to limit the anomaly detection model to examine only log events that match
         *        the pattern you specify here. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
         *        Pattern Syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * Optionally assigns a KMS key to secure this anomaly detector and its findings. If a key is assigned, the
         * anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned
         * to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to
         * retrieve information about the anomalies that it finds.
         * </p>
         * <p>
         * For more information about using a KMS key and to see the required IAM policy, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html">Use a KMS key
         * with an anomaly detector</a>.
         * </p>
         * 
         * @param kmsKeyId
         *        Optionally assigns a KMS key to secure this anomaly detector and its findings. If a key is assigned,
         *        the anomalies found and the model used by this detector are encrypted at rest with the key. If a key
         *        is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly
         *        detector to retrieve information about the anomalies that it finds.</p>
         *        <p>
         *        For more information about using a KMS key and to see the required IAM policy, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html">Use a
         *        KMS key with an anomaly detector</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it
         * will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as
         * normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in
         * <code>anomalyVisibilityTime</code>, it will be considered normal going forward and will not be detected as an
         * anomaly.
         * </p>
         * 
         * @param anomalyVisibilityTime
         *        The number of days to have visibility on an anomaly. After this time period has elapsed for an
         *        anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a
         *        similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time
         *        period specified in <code>anomalyVisibilityTime</code>, it will be considered normal going forward and
         *        will not be detected as an anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyVisibilityTime(Long anomalyVisibilityTime);

        /**
         * <p>
         * An optional list of key-value pairs to associate with the resource.
         * </p>
         * <p>
         * For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>
         * </p>
         * 
         * @param tags
         *        An optional list of key-value pairs to associate with the resource.</p>
         *        <p>
         *        For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private List<String> logGroupArnList = DefaultSdkAutoConstructList.getInstance();

        private String detectorName;

        private String evaluationFrequency;

        private String filterPattern;

        private String kmsKeyId;

        private Long anomalyVisibilityTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogAnomalyDetectorRequest model) {
            super(model);
            logGroupArnList(model.logGroupArnList);
            detectorName(model.detectorName);
            evaluationFrequency(model.evaluationFrequency);
            filterPattern(model.filterPattern);
            kmsKeyId(model.kmsKeyId);
            anomalyVisibilityTime(model.anomalyVisibilityTime);
            tags(model.tags);
        }

        public final Collection<String> getLogGroupArnList() {
            if (logGroupArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupArnList;
        }

        public final void setLogGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
        }

        @Override
        public final Builder logGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupArnList(String... logGroupArnList) {
            logGroupArnList(Arrays.asList(logGroupArnList));
            return this;
        }

        public final String getDetectorName() {
            return detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final String getEvaluationFrequency() {
            return evaluationFrequency;
        }

        public final void setEvaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
        }

        @Override
        public final Builder evaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        @Override
        public final Builder evaluationFrequency(EvaluationFrequency evaluationFrequency) {
            this.evaluationFrequency(evaluationFrequency == null ? null : evaluationFrequency.toString());
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Long getAnomalyVisibilityTime() {
            return anomalyVisibilityTime;
        }

        public final void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
        }

        @Override
        public final Builder anomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogAnomalyDetectorRequest build() {
            return new CreateLogAnomalyDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
