/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRetentionPolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutRetentionPolicyRequest.Builder, PutRetentionPolicyRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutRetentionPolicyRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutRetentionPolicyRequest::retentionInDays)).setter(setter(Builder::retentionInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            RETENTION_IN_DAYS_FIELD));

    private final String logGroupName;

    private final Integer retentionInDays;

    private PutRetentionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.retentionInDays = builder.retentionInDays;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * Returns the value of the RetentionInDays property for this object.
     * 
     * @return The value of the RetentionInDays property for this object.
     */
    public Integer retentionInDays() {
        return retentionInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionInDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionPolicyRequest)) {
            return false;
        }
        PutRetentionPolicyRequest other = (PutRetentionPolicyRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(retentionInDays(), other.retentionInDays());
    }

    @Override
    public String toString() {
        return ToString.builder("PutRetentionPolicyRequest").add("LogGroupName", logGroupName())
                .add("RetentionInDays", retentionInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "retentionInDays":
            return Optional.ofNullable(clazz.cast(retentionInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRetentionPolicyRequest, T> g) {
        return obj -> g.apply((PutRetentionPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRetentionPolicyRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * Sets the value of the RetentionInDays property for this object.
         *
         * @param retentionInDays
         *        The new value for the RetentionInDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Integer retentionInDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private Integer retentionInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionPolicyRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            retentionInDays(model.retentionInDays);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Integer getRetentionInDays() {
            return retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionPolicyRequest build() {
            return new PutRetentionPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
