/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogRecordResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetLogRecordResponse.Builder, GetLogRecordResponse> {
    private static final SdkField<Map<String, String>> LOG_RECORD_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetLogRecordResponse::logRecord))
            .setter(setter(Builder::logRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logRecord").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_RECORD_FIELD));

    private final Map<String, String> logRecord;

    private GetLogRecordResponse(BuilderImpl builder) {
        super(builder);
        this.logRecord = builder.logRecord;
    }

    /**
     * <p>
     * The requested log event, as a JSON string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The requested log event, as a JSON string.
     */
    public Map<String, String> logRecord() {
        return logRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logRecord());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogRecordResponse)) {
            return false;
        }
        GetLogRecordResponse other = (GetLogRecordResponse) obj;
        return Objects.equals(logRecord(), other.logRecord());
    }

    @Override
    public String toString() {
        return ToString.builder("GetLogRecordResponse").add("LogRecord", logRecord()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logRecord":
            return Optional.ofNullable(clazz.cast(logRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogRecordResponse, T> g) {
        return obj -> g.apply((GetLogRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLogRecordResponse> {
        /**
         * <p>
         * The requested log event, as a JSON string.
         * </p>
         * 
         * @param logRecord
         *        The requested log event, as a JSON string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logRecord(Map<String, String> logRecord);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private Map<String, String> logRecord = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogRecordResponse model) {
            super(model);
            logRecord(model.logRecord);
        }

        public final Map<String, String> getLogRecord() {
            return logRecord;
        }

        @Override
        public final Builder logRecord(Map<String, String> logRecord) {
            this.logRecord = LogRecordCopier.copy(logRecord);
            return this;
        }

        public final void setLogRecord(Map<String, String> logRecord) {
            this.logRecord = LogRecordCopier.copy(logRecord);
        }

        @Override
        public GetLogRecordResponse build() {
            return new GetLogRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
