/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDestinationPolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutDestinationPolicyRequest.Builder, PutDestinationPolicyRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutDestinationPolicyRequest::destinationName)).setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()).build();

    private static final SdkField<String> ACCESS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutDestinationPolicyRequest::accessPolicy)).setter(setter(Builder::accessPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD,
            ACCESS_POLICY_FIELD));

    private final String destinationName;

    private final String accessPolicy;

    private PutDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.accessPolicy = builder.accessPolicy;
    }

    /**
     * <p>
     * A name for an existing destination.
     * </p>
     * 
     * @return A name for an existing destination.
     */
    public String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * An IAM policy document that authorizes cross-account users to deliver their log events to the associated
     * destination.
     * </p>
     * 
     * @return An IAM policy document that authorizes cross-account users to deliver their log events to the associated
     *         destination.
     */
    public String accessPolicy() {
        return accessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationPolicyRequest)) {
            return false;
        }
        PutDestinationPolicyRequest other = (PutDestinationPolicyRequest) obj;
        return Objects.equals(destinationName(), other.destinationName()) && Objects.equals(accessPolicy(), other.accessPolicy());
    }

    @Override
    public String toString() {
        return ToString.builder("PutDestinationPolicyRequest").add("DestinationName", destinationName())
                .add("AccessPolicy", accessPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "accessPolicy":
            return Optional.ofNullable(clazz.cast(accessPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDestinationPolicyRequest, T> g) {
        return obj -> g.apply((PutDestinationPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDestinationPolicyRequest> {
        /**
         * <p>
         * A name for an existing destination.
         * </p>
         * 
         * @param destinationName
         *        A name for an existing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * An IAM policy document that authorizes cross-account users to deliver their log events to the associated
         * destination.
         * </p>
         * 
         * @param accessPolicy
         *        An IAM policy document that authorizes cross-account users to deliver their log events to the
         *        associated destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(String accessPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String destinationName;

        private String accessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationPolicyRequest model) {
            super(model);
            destinationName(model.destinationName);
            accessPolicy(model.accessPolicy);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getAccessPolicy() {
            return accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDestinationPolicyRequest build() {
            return new PutDestinationPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
