/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestMetricFilterResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<TestMetricFilterResponse.Builder, TestMetricFilterResponse> {
    private static final SdkField<List<MetricFilterMatchRecord>> MATCHES_FIELD = SdkField
            .<List<MetricFilterMatchRecord>> builder(MarshallingType.LIST)
            .getter(getter(TestMetricFilterResponse::matches))
            .setter(setter(Builder::matches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricFilterMatchRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricFilterMatchRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHES_FIELD));

    private final List<MetricFilterMatchRecord> matches;

    private TestMetricFilterResponse(BuilderImpl builder) {
        super(builder);
        this.matches = builder.matches;
    }

    /**
     * <p>
     * The matched events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The matched events.
     */
    public List<MetricFilterMatchRecord> matches() {
        return matches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterResponse)) {
            return false;
        }
        TestMetricFilterResponse other = (TestMetricFilterResponse) obj;
        return Objects.equals(matches(), other.matches());
    }

    @Override
    public String toString() {
        return ToString.builder("TestMetricFilterResponse").add("Matches", matches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "matches":
            return Optional.ofNullable(clazz.cast(matches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestMetricFilterResponse, T> g) {
        return obj -> g.apply((TestMetricFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestMetricFilterResponse> {
        /**
         * <p>
         * The matched events.
         * </p>
         * 
         * @param matches
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matches(Collection<MetricFilterMatchRecord> matches);

        /**
         * <p>
         * The matched events.
         * </p>
         * 
         * @param matches
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matches(MetricFilterMatchRecord... matches);

        /**
         * <p>
         * The matched events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricFilterMatchRecord>.Builder} avoiding
         * the need to create one manually via {@link List<MetricFilterMatchRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricFilterMatchRecord>.Builder#build()} is called
         * immediately and its result is passed to {@link #matches(List<MetricFilterMatchRecord>)}.
         * 
         * @param matches
         *        a consumer that will call methods on {@link List<MetricFilterMatchRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matches(List<MetricFilterMatchRecord>)
         */
        Builder matches(Consumer<MetricFilterMatchRecord.Builder>... matches);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<MetricFilterMatchRecord> matches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterResponse model) {
            super(model);
            matches(model.matches);
        }

        public final Collection<MetricFilterMatchRecord.Builder> getMatches() {
            return matches != null ? matches.stream().map(MetricFilterMatchRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matches(Collection<MetricFilterMatchRecord> matches) {
            this.matches = MetricFilterMatchesCopier.copy(matches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(MetricFilterMatchRecord... matches) {
            matches(Arrays.asList(matches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(Consumer<MetricFilterMatchRecord.Builder>... matches) {
            matches(Stream.of(matches).map(c -> MetricFilterMatchRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMatches(Collection<MetricFilterMatchRecord.BuilderImpl> matches) {
            this.matches = MetricFilterMatchesCopier.copyFromBuilder(matches);
        }

        @Override
        public TestMetricFilterResponse build() {
            return new TestMetricFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
