/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExportTaskRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<CreateExportTaskRequest.Builder, CreateExportTaskRequest> {
    private static final SdkField<String> TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskName").getter(getter(CreateExportTaskRequest::taskName)).setter(setter(Builder::taskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskName").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(CreateExportTaskRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamNamePrefix").getter(getter(CreateExportTaskRequest::logStreamNamePrefix))
            .setter(setter(Builder::logStreamNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build())
            .build();

    private static final SdkField<Long> FROM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("from")
            .getter(getter(CreateExportTaskRequest::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<Long> TO_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("to")
            .getter(getter(CreateExportTaskRequest::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(CreateExportTaskRequest::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationPrefix").getter(getter(CreateExportTaskRequest::destinationPrefix))
            .setter(setter(Builder::destinationPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TASK_NAME_FIELD, LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, FROM_FIELD, TO_FIELD, DESTINATION_FIELD,
                    DESTINATION_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskName;

    private final String logGroupName;

    private final String logStreamNamePrefix;

    private final Long from;

    private final Long to;

    private final String destination;

    private final String destinationPrefix;

    private CreateExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
    }

    /**
     * <p>
     * The name of the export task.
     * </p>
     * 
     * @return The name of the export task.
     */
    public final String taskName() {
        return taskName;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is
     * applied.
     * </p>
     * 
     * @return Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is
     *         applied.
     */
    public final String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    /**
     * <p>
     * The start time of the range for the request, expressed as the number of milliseconds after
     * <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp earlier than this time are not exported.
     * </p>
     * 
     * @return The start time of the range for the request, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp earlier than this time are not exported.
     */
    public final Long from() {
        return from;
    }

    /**
     * <p>
     * The end time of the range for the request, expressed as the number of milliseconds after
     * <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp later than this time are not exported.
     * </p>
     * <p>
     * You must specify a time that is not earlier than when this log group was created.
     * </p>
     * 
     * @return The end time of the range for the request, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp later than this time are not exported.</p>
     *         <p>
     *         You must specify a time that is not earlier than when this log group was created.
     */
    public final Long to() {
        return to;
    }

    /**
     * <p>
     * The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services Region.
     * </p>
     * 
     * @return The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services
     *         Region.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The prefix used as the start of the key for every object exported. If you don't specify a value, the default is
     * <code>exportedlogs</code>.
     * </p>
     * <p>
     * The length of this parameter must comply with the S3 object key name length limits. The object key name is a
     * sequence of Unicode characters with UTF-8 encoding, and can be up to 1,024 bytes.
     * </p>
     * 
     * @return The prefix used as the start of the key for every object exported. If you don't specify a value, the
     *         default is <code>exportedlogs</code>.</p>
     *         <p>
     *         The length of this parameter must comply with the S3 object key name length limits. The object key name
     *         is a sequence of Unicode characters with UTF-8 encoding, and can be up to 1,024 bytes.
     */
    public final String destinationPrefix() {
        return destinationPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportTaskRequest)) {
            return false;
        }
        CreateExportTaskRequest other = (CreateExportTaskRequest) obj;
        return Objects.equals(taskName(), other.taskName()) && Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(logStreamNamePrefix(), other.logStreamNamePrefix()) && Objects.equals(from(), other.from())
                && Objects.equals(to(), other.to()) && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationPrefix(), other.destinationPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExportTaskRequest").add("TaskName", taskName()).add("LogGroupName", logGroupName())
                .add("LogStreamNamePrefix", logStreamNamePrefix()).add("From", from()).add("To", to())
                .add("Destination", destination()).add("DestinationPrefix", destinationPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskName":
            return Optional.ofNullable(clazz.cast(taskName()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logStreamNamePrefix":
            return Optional.ofNullable(clazz.cast(logStreamNamePrefix()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "destinationPrefix":
            return Optional.ofNullable(clazz.cast(destinationPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskName", TASK_NAME_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("logStreamNamePrefix", LOG_STREAM_NAME_PREFIX_FIELD);
        map.put("from", FROM_FIELD);
        map.put("to", TO_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationPrefix", DESTINATION_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExportTaskRequest, T> g) {
        return obj -> g.apply((CreateExportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExportTaskRequest> {
        /**
         * <p>
         * The name of the export task.
         * </p>
         * 
         * @param taskName
         *        The name of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskName(String taskName);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is
         * applied.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter
         *        is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);

        /**
         * <p>
         * The start time of the range for the request, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp earlier than this time are not exported.
         * </p>
         * 
         * @param from
         *        The start time of the range for the request, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp earlier than this time are not
         *        exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Long from);

        /**
         * <p>
         * The end time of the range for the request, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp later than this time are not exported.
         * </p>
         * <p>
         * You must specify a time that is not earlier than when this log group was created.
         * </p>
         * 
         * @param to
         *        The end time of the range for the request, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>. Events with a timestamp later than this time are not
         *        exported.</p>
         *        <p>
         *        You must specify a time that is not earlier than when this log group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Long to);

        /**
         * <p>
         * The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services Region.
         * </p>
         * 
         * @param destination
         *        The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The prefix used as the start of the key for every object exported. If you don't specify a value, the default
         * is <code>exportedlogs</code>.
         * </p>
         * <p>
         * The length of this parameter must comply with the S3 object key name length limits. The object key name is a
         * sequence of Unicode characters with UTF-8 encoding, and can be up to 1,024 bytes.
         * </p>
         * 
         * @param destinationPrefix
         *        The prefix used as the start of the key for every object exported. If you don't specify a value, the
         *        default is <code>exportedlogs</code>.</p>
         *        <p>
         *        The length of this parameter must comply with the S3 object key name length limits. The object key
         *        name is a sequence of Unicode characters with UTF-8 encoding, and can be up to 1,024 bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefix(String destinationPrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String taskName;

        private String logGroupName;

        private String logStreamNamePrefix;

        private Long from;

        private Long to;

        private String destination;

        private String destinationPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportTaskRequest model) {
            super(model);
            taskName(model.taskName);
            logGroupName(model.logGroupName);
            logStreamNamePrefix(model.logStreamNamePrefix);
            from(model.from);
            to(model.to);
            destination(model.destination);
            destinationPrefix(model.destinationPrefix);
        }

        public final String getTaskName() {
            return taskName;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final Long getFrom() {
            return from;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final Long getTo() {
            return to;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getDestinationPrefix() {
            return destinationPrefix;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportTaskRequest build() {
            return new CreateExportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
