/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object defines one key that will be added with the <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKey"
 * > addKeys</a> processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddKeyEntry implements SdkPojo, Serializable, ToCopyableBuilder<AddKeyEntry.Builder, AddKeyEntry> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(AddKeyEntry::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(AddKeyEntry::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overwriteIfExists").getter(getter(AddKeyEntry::overwriteIfExists))
            .setter(setter(Builder::overwriteIfExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            OVERWRITE_IF_EXISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final Boolean overwriteIfExists;

    private AddKeyEntry(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    /**
     * <p>
     * The key of the new entry to be added to the log event
     * </p>
     * 
     * @return The key of the new entry to be added to the log event
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the new entry to be added to the log event
     * </p>
     * 
     * @return The value of the new entry to be added to the log event
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Specifies whether to overwrite the value if the key already exists in the log event. If you omit this, the
     * default is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether to overwrite the value if the key already exists in the log event. If you omit this,
     *         the default is <code>false</code>.
     */
    public final Boolean overwriteIfExists() {
        return overwriteIfExists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteIfExists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddKeyEntry)) {
            return false;
        }
        AddKeyEntry other = (AddKeyEntry) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(overwriteIfExists(), other.overwriteIfExists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddKeyEntry").add("Key", key()).add("Value", value())
                .add("OverwriteIfExists", overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "overwriteIfExists":
            return Optional.ofNullable(clazz.cast(overwriteIfExists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddKeyEntry, T> g) {
        return obj -> g.apply((AddKeyEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddKeyEntry> {
        /**
         * <p>
         * The key of the new entry to be added to the log event
         * </p>
         * 
         * @param key
         *        The key of the new entry to be added to the log event
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the new entry to be added to the log event
         * </p>
         * 
         * @param value
         *        The value of the new entry to be added to the log event
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Specifies whether to overwrite the value if the key already exists in the log event. If you omit this, the
         * default is <code>false</code>.
         * </p>
         * 
         * @param overwriteIfExists
         *        Specifies whether to overwrite the value if the key already exists in the log event. If you omit this,
         *        the default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overwriteIfExists(Boolean overwriteIfExists);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(AddKeyEntry model) {
            key(model.key);
            value(model.value);
            overwriteIfExists(model.overwriteIfExists);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        @Override
        public AddKeyEntry build() {
            return new AddKeyEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
