/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.AccountIdsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountPoliciesRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeAccountPoliciesRequest> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(DescribeAccountPoliciesRequest.getter(DescribeAccountPoliciesRequest::policyTypeAsString)).setter(DescribeAccountPoliciesRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(DescribeAccountPoliciesRequest.getter(DescribeAccountPoliciesRequest::policyName)).setter(DescribeAccountPoliciesRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIdentifiers").getter(DescribeAccountPoliciesRequest.getter(DescribeAccountPoliciesRequest::accountIdentifiers)).setter(DescribeAccountPoliciesRequest.setter(Builder::accountIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAccountPoliciesRequest.getter(DescribeAccountPoliciesRequest::nextToken)).setter(DescribeAccountPoliciesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD, POLICY_NAME_FIELD, ACCOUNT_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccountPoliciesRequest.memberNameToFieldInitializer();
    private final String policyType;
    private final String policyName;
    private final List<String> accountIdentifiers;
    private final String nextToken;

    private DescribeAccountPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.policyType = builder.policyType;
        this.policyName = builder.policyName;
        this.accountIdentifiers = builder.accountIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final boolean hasAccountIdentifiers() {
        return this.accountIdentifiers != null && !(this.accountIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> accountIdentifiers() {
        return this.accountIdentifiers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdentifiers() ? this.accountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountPoliciesRequest)) {
            return false;
        }
        DescribeAccountPoliciesRequest other = (DescribeAccountPoliciesRequest)((Object)obj);
        return Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.policyName(), other.policyName()) && this.hasAccountIdentifiers() == other.hasAccountIdentifiers() && Objects.equals(this.accountIdentifiers(), other.accountIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountPoliciesRequest").add("PolicyType", (Object)this.policyTypeAsString()).add("PolicyName", (Object)this.policyName()).add("AccountIdentifiers", this.hasAccountIdentifiers() ? this.accountIdentifiers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "accountIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.accountIdentifiers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("accountIdentifiers", ACCOUNT_IDENTIFIERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountPoliciesRequest, T> g) {
        return obj -> g.apply((DescribeAccountPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String policyType;
        private String policyName;
        private List<String> accountIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountPoliciesRequest model) {
            super(model);
            this.policyType(model.policyType);
            this.policyName(model.policyName);
            this.accountIdentifiers(model.accountIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Collection<String> getAccountIdentifiers() {
            if (this.accountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIdentifiers;
        }

        public final void setAccountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
        }

        @Override
        public final Builder accountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdentifiers(String ... accountIdentifiers) {
            this.accountIdentifiers(Arrays.asList(accountIdentifiers));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountPoliciesRequest build() {
            return new DescribeAccountPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountPoliciesRequest> {
        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder policyName(String var1);

        public Builder accountIdentifiers(Collection<String> var1);

        public Builder accountIdentifiers(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

