/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIndexPoliciesResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeIndexPoliciesResponse.Builder, DescribeIndexPoliciesResponse> {
    private static final SdkField<List<IndexPolicy>> INDEX_POLICIES_FIELD = SdkField
            .<List<IndexPolicy>> builder(MarshallingType.LIST)
            .memberName("indexPolicies")
            .getter(getter(DescribeIndexPoliciesResponse::indexPolicies))
            .setter(setter(Builder::indexPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeIndexPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IndexPolicy> indexPolicies;

    private final String nextToken;

    private DescribeIndexPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.indexPolicies = builder.indexPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndexPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIndexPolicies() {
        return indexPolicies != null && !(indexPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the field index policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexPolicies} method.
     * </p>
     * 
     * @return An array containing the field index policies.
     */
    public final List<IndexPolicy> indexPolicies() {
        return indexPolicies;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexPolicies() ? indexPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexPoliciesResponse)) {
            return false;
        }
        DescribeIndexPoliciesResponse other = (DescribeIndexPoliciesResponse) obj;
        return hasIndexPolicies() == other.hasIndexPolicies() && Objects.equals(indexPolicies(), other.indexPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIndexPoliciesResponse")
                .add("IndexPolicies", hasIndexPolicies() ? indexPolicies() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexPolicies":
            return Optional.ofNullable(clazz.cast(indexPolicies()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("indexPolicies", INDEX_POLICIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeIndexPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIndexPoliciesResponse> {
        /**
         * <p>
         * An array containing the field index policies.
         * </p>
         * 
         * @param indexPolicies
         *        An array containing the field index policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexPolicies(Collection<IndexPolicy> indexPolicies);

        /**
         * <p>
         * An array containing the field index policies.
         * </p>
         * 
         * @param indexPolicies
         *        An array containing the field index policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexPolicies(IndexPolicy... indexPolicies);

        /**
         * <p>
         * An array containing the field index policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.IndexPolicy.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.IndexPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.IndexPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #indexPolicies(List<IndexPolicy>)}.
         * 
         * @param indexPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.IndexPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexPolicies(java.util.Collection<IndexPolicy>)
         */
        Builder indexPolicies(Consumer<IndexPolicy.Builder>... indexPolicies);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<IndexPolicy> indexPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexPoliciesResponse model) {
            super(model);
            indexPolicies(model.indexPolicies);
            nextToken(model.nextToken);
        }

        public final List<IndexPolicy.Builder> getIndexPolicies() {
            List<IndexPolicy.Builder> result = IndexPoliciesCopier.copyToBuilder(this.indexPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexPolicies(Collection<IndexPolicy.BuilderImpl> indexPolicies) {
            this.indexPolicies = IndexPoliciesCopier.copyFromBuilder(indexPolicies);
        }

        @Override
        public final Builder indexPolicies(Collection<IndexPolicy> indexPolicies) {
            this.indexPolicies = IndexPoliciesCopier.copy(indexPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexPolicies(IndexPolicy... indexPolicies) {
            indexPolicies(Arrays.asList(indexPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexPolicies(Consumer<IndexPolicy.Builder>... indexPolicies) {
            indexPolicies(Stream.of(indexPolicies).map(c -> IndexPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIndexPoliciesResponse build() {
            return new DescribeIndexPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
