/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLogGroupsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeLogGroupsResponse.Builder, DescribeLogGroupsResponse> {
    private static final SdkField<List<LogGroup>> LOG_GROUPS_FIELD = SdkField
            .<List<LogGroup>> builder(MarshallingType.LIST)
            .memberName("logGroups")
            .getter(getter(DescribeLogGroupsResponse::logGroups))
            .setter(setter(Builder::logGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeLogGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LogGroup> logGroups;

    private final String nextToken;

    private DescribeLogGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.logGroups = builder.logGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogGroups() {
        return logGroups != null && !(logGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log groups.
     * </p>
     * <p>
     * If the <code>retentionInDays</code> value is not included for a log group, then that log group's events do not
     * expire.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroups} method.
     * </p>
     * 
     * @return The log groups.</p>
     *         <p>
     *         If the <code>retentionInDays</code> value is not included for a log group, then that log group's events
     *         do not expire.
     */
    public final List<LogGroup> logGroups() {
        return logGroups;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroups() ? logGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsResponse)) {
            return false;
        }
        DescribeLogGroupsResponse other = (DescribeLogGroupsResponse) obj;
        return hasLogGroups() == other.hasLogGroups() && Objects.equals(logGroups(), other.logGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLogGroupsResponse").add("LogGroups", hasLogGroups() ? logGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroups":
            return Optional.ofNullable(clazz.cast(logGroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroups", LOG_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogGroupsResponse, T> g) {
        return obj -> g.apply((DescribeLogGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLogGroupsResponse> {
        /**
         * <p>
         * The log groups.
         * </p>
         * <p>
         * If the <code>retentionInDays</code> value is not included for a log group, then that log group's events do
         * not expire.
         * </p>
         * 
         * @param logGroups
         *        The log groups.</p>
         *        <p>
         *        If the <code>retentionInDays</code> value is not included for a log group, then that log group's
         *        events do not expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(Collection<LogGroup> logGroups);

        /**
         * <p>
         * The log groups.
         * </p>
         * <p>
         * If the <code>retentionInDays</code> value is not included for a log group, then that log group's events do
         * not expire.
         * </p>
         * 
         * @param logGroups
         *        The log groups.</p>
         *        <p>
         *        If the <code>retentionInDays</code> value is not included for a log group, then that log group's
         *        events do not expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(LogGroup... logGroups);

        /**
         * <p>
         * The log groups.
         * </p>
         * <p>
         * If the <code>retentionInDays</code> value is not included for a log group, then that log group's events do
         * not expire.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #logGroups(List<LogGroup>)}.
         * 
         * @param logGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logGroups(java.util.Collection<LogGroup>)
         */
        Builder logGroups(Consumer<LogGroup.Builder>... logGroups);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<LogGroup> logGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsResponse model) {
            super(model);
            logGroups(model.logGroups);
            nextToken(model.nextToken);
        }

        public final List<LogGroup.Builder> getLogGroups() {
            List<LogGroup.Builder> result = LogGroupsCopier.copyToBuilder(this.logGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroups(Collection<LogGroup.BuilderImpl> logGroups) {
            this.logGroups = LogGroupsCopier.copyFromBuilder(logGroups);
        }

        @Override
        public final Builder logGroups(Collection<LogGroup> logGroups) {
            this.logGroups = LogGroupsCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroup... logGroups) {
            logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<LogGroup.Builder>... logGroups) {
            logGroups(Stream.of(logGroups).map(c -> LogGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLogGroupsResponse build() {
            return new DescribeLogGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
