/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationType;
import software.amazon.awssdk.services.cloudwatchlogs.model.RecordFieldsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.S3DeliveryConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Delivery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Delivery> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Delivery.getter(Delivery::id)).setter(Delivery.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Delivery.getter(Delivery::arn)).setter(Delivery.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DELIVERY_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliverySourceName").getter(Delivery.getter(Delivery::deliverySourceName)).setter(Delivery.setter(Builder::deliverySourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliverySourceName").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationArn").getter(Delivery.getter(Delivery::deliveryDestinationArn)).setter(Delivery.setter(Builder::deliveryDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationArn").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationType").getter(Delivery.getter(Delivery::deliveryDestinationTypeAsString)).setter(Delivery.setter(Builder::deliveryDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationType").build()}).build();
    private static final SdkField<List<String>> RECORD_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recordFields").getter(Delivery.getter(Delivery::recordFields)).setter(Delivery.setter(Builder::recordFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldDelimiter").getter(Delivery.getter(Delivery::fieldDelimiter)).setter(Delivery.setter(Builder::fieldDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDelimiter").build()}).build();
    private static final SdkField<S3DeliveryConfiguration> S3_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3DeliveryConfiguration").getter(Delivery.getter(Delivery::s3DeliveryConfiguration)).setter(Delivery.setter(Builder::s3DeliveryConfiguration)).constructor(S3DeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DeliveryConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Delivery.getter(Delivery::tags)).setter(Delivery.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, DELIVERY_SOURCE_NAME_FIELD, DELIVERY_DESTINATION_ARN_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, RECORD_FIELDS_FIELD, FIELD_DELIMITER_FIELD, S3_DELIVERY_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Delivery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String deliverySourceName;
    private final String deliveryDestinationArn;
    private final String deliveryDestinationType;
    private final List<String> recordFields;
    private final String fieldDelimiter;
    private final S3DeliveryConfiguration s3DeliveryConfiguration;
    private final Map<String, String> tags;

    private Delivery(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.deliverySourceName = builder.deliverySourceName;
        this.deliveryDestinationArn = builder.deliveryDestinationArn;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.recordFields = builder.recordFields;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.s3DeliveryConfiguration = builder.s3DeliveryConfiguration;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String deliverySourceName() {
        return this.deliverySourceName;
    }

    public final String deliveryDestinationArn() {
        return this.deliveryDestinationArn;
    }

    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(this.deliveryDestinationType);
    }

    public final String deliveryDestinationTypeAsString() {
        return this.deliveryDestinationType;
    }

    public final boolean hasRecordFields() {
        return this.recordFields != null && !(this.recordFields instanceof SdkAutoConstructList);
    }

    public final List<String> recordFields() {
        return this.recordFields;
    }

    public final String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public final S3DeliveryConfiguration s3DeliveryConfiguration() {
        return this.s3DeliveryConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverySourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordFields() ? this.recordFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delivery)) {
            return false;
        }
        Delivery other = (Delivery)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.deliverySourceName(), other.deliverySourceName()) && Objects.equals(this.deliveryDestinationArn(), other.deliveryDestinationArn()) && Objects.equals(this.deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString()) && this.hasRecordFields() == other.hasRecordFields() && Objects.equals(this.recordFields(), other.recordFields()) && Objects.equals(this.fieldDelimiter(), other.fieldDelimiter()) && Objects.equals(this.s3DeliveryConfiguration(), other.s3DeliveryConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Delivery").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("DeliverySourceName", (Object)this.deliverySourceName()).add("DeliveryDestinationArn", (Object)this.deliveryDestinationArn()).add("DeliveryDestinationType", (Object)this.deliveryDestinationTypeAsString()).add("RecordFields", this.hasRecordFields() ? this.recordFields() : null).add("FieldDelimiter", (Object)this.fieldDelimiter()).add("S3DeliveryConfiguration", (Object)this.s3DeliveryConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "deliverySourceName": {
                return Optional.ofNullable(clazz.cast(this.deliverySourceName()));
            }
            case "deliveryDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationArn()));
            }
            case "deliveryDestinationType": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationTypeAsString()));
            }
            case "recordFields": {
                return Optional.ofNullable(clazz.cast(this.recordFields()));
            }
            case "fieldDelimiter": {
                return Optional.ofNullable(clazz.cast(this.fieldDelimiter()));
            }
            case "s3DeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3DeliveryConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("deliverySourceName", DELIVERY_SOURCE_NAME_FIELD);
        map.put("deliveryDestinationArn", DELIVERY_DESTINATION_ARN_FIELD);
        map.put("deliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
        map.put("recordFields", RECORD_FIELDS_FIELD);
        map.put("fieldDelimiter", FIELD_DELIMITER_FIELD);
        map.put("s3DeliveryConfiguration", S3_DELIVERY_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Delivery, T> g) {
        return obj -> g.apply((Delivery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String deliverySourceName;
        private String deliveryDestinationArn;
        private String deliveryDestinationType;
        private List<String> recordFields = DefaultSdkAutoConstructList.getInstance();
        private String fieldDelimiter;
        private S3DeliveryConfiguration s3DeliveryConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Delivery model) {
            this.id(model.id);
            this.arn(model.arn);
            this.deliverySourceName(model.deliverySourceName);
            this.deliveryDestinationArn(model.deliveryDestinationArn);
            this.deliveryDestinationType(model.deliveryDestinationType);
            this.recordFields(model.recordFields);
            this.fieldDelimiter(model.fieldDelimiter);
            this.s3DeliveryConfiguration(model.s3DeliveryConfiguration);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDeliverySourceName() {
            return this.deliverySourceName;
        }

        public final void setDeliverySourceName(String deliverySourceName) {
            this.deliverySourceName = deliverySourceName;
        }

        @Override
        public final Builder deliverySourceName(String deliverySourceName) {
            this.deliverySourceName = deliverySourceName;
            return this;
        }

        public final String getDeliveryDestinationArn() {
            return this.deliveryDestinationArn;
        }

        public final void setDeliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
        }

        @Override
        public final Builder deliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return this.deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final Collection<String> getRecordFields() {
            if (this.recordFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordFields;
        }

        public final void setRecordFields(Collection<String> recordFields) {
            this.recordFields = RecordFieldsCopier.copy(recordFields);
        }

        @Override
        public final Builder recordFields(Collection<String> recordFields) {
            this.recordFields = RecordFieldsCopier.copy(recordFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordFields(String ... recordFields) {
            this.recordFields(Arrays.asList(recordFields));
            return this;
        }

        public final String getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final S3DeliveryConfiguration.Builder getS3DeliveryConfiguration() {
            return this.s3DeliveryConfiguration != null ? this.s3DeliveryConfiguration.toBuilder() : null;
        }

        public final void setS3DeliveryConfiguration(S3DeliveryConfiguration.BuilderImpl s3DeliveryConfiguration) {
            this.s3DeliveryConfiguration = s3DeliveryConfiguration != null ? s3DeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder s3DeliveryConfiguration(S3DeliveryConfiguration s3DeliveryConfiguration) {
            this.s3DeliveryConfiguration = s3DeliveryConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public Delivery build() {
            return new Delivery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Delivery> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder deliverySourceName(String var1);

        public Builder deliveryDestinationArn(String var1);

        public Builder deliveryDestinationType(String var1);

        public Builder deliveryDestinationType(DeliveryDestinationType var1);

        public Builder recordFields(Collection<String> var1);

        public Builder recordFields(String ... var1);

        public Builder fieldDelimiter(String var1);

        public Builder s3DeliveryConfiguration(S3DeliveryConfiguration var1);

        default public Builder s3DeliveryConfiguration(Consumer<S3DeliveryConfiguration.Builder> s3DeliveryConfiguration) {
            return this.s3DeliveryConfiguration((S3DeliveryConfiguration)((S3DeliveryConfiguration.Builder)S3DeliveryConfiguration.builder().applyMutation(s3DeliveryConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

