/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This processor parses a specified field in the original log event into key-value pairs.
 * </p>
 * <p>
 * For more information about this processor including examples, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue"
 * > parseKeyValue</a> in the <i>CloudWatch Logs User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParseKeyValue implements SdkPojo, Serializable, ToCopyableBuilder<ParseKeyValue.Builder, ParseKeyValue> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ParseKeyValue::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(ParseKeyValue::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldDelimiter").getter(getter(ParseKeyValue::fieldDelimiter)).setter(setter(Builder::fieldDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDelimiter").build()).build();

    private static final SdkField<String> KEY_VALUE_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValueDelimiter").getter(getter(ParseKeyValue::keyValueDelimiter))
            .setter(setter(Builder::keyValueDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValueDelimiter").build()).build();

    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPrefix").getter(getter(ParseKeyValue::keyPrefix)).setter(setter(Builder::keyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()).build();

    private static final SdkField<String> NON_MATCH_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nonMatchValue").getter(getter(ParseKeyValue::nonMatchValue)).setter(setter(Builder::nonMatchValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonMatchValue").build()).build();

    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overwriteIfExists").getter(getter(ParseKeyValue::overwriteIfExists))
            .setter(setter(Builder::overwriteIfExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, FIELD_DELIMITER_FIELD, KEY_VALUE_DELIMITER_FIELD, KEY_PREFIX_FIELD, NON_MATCH_VALUE_FIELD,
            OVERWRITE_IF_EXISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String destination;

    private final String fieldDelimiter;

    private final String keyValueDelimiter;

    private final String keyPrefix;

    private final String nonMatchValue;

    private final Boolean overwriteIfExists;

    private ParseKeyValue(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.keyValueDelimiter = builder.keyValueDelimiter;
        this.keyPrefix = builder.keyPrefix;
        this.nonMatchValue = builder.nonMatchValue;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    /**
     * <p>
     * Path to the field in the log event that will be parsed. Use dot notation to access child fields. For example,
     * <code>store.book</code>
     * </p>
     * 
     * @return Path to the field in the log event that will be parsed. Use dot notation to access child fields. For
     *         example, <code>store.book</code>
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The destination field to put the extracted key-value pairs into
     * </p>
     * 
     * @return The destination field to put the extracted key-value pairs into
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The field delimiter string that is used between key-value pairs in the original log events. If you omit this, the
     * ampersand <code>&amp;</code> character is used.
     * </p>
     * 
     * @return The field delimiter string that is used between key-value pairs in the original log events. If you omit
     *         this, the ampersand <code>&amp;</code> character is used.
     */
    public final String fieldDelimiter() {
        return fieldDelimiter;
    }

    /**
     * <p>
     * The delimiter string to use between the key and value in each pair in the transformed log event.
     * </p>
     * <p>
     * If you omit this, the equal <code>=</code> character is used.
     * </p>
     * 
     * @return The delimiter string to use between the key and value in each pair in the transformed log event.</p>
     *         <p>
     *         If you omit this, the equal <code>=</code> character is used.
     */
    public final String keyValueDelimiter() {
        return keyValueDelimiter;
    }

    /**
     * <p>
     * If you want to add a prefix to all transformed keys, specify it here.
     * </p>
     * 
     * @return If you want to add a prefix to all transformed keys, specify it here.
     */
    public final String keyPrefix() {
        return keyPrefix;
    }

    /**
     * <p>
     * A value to insert into the value field in the result, when a key-value pair is not successfully split.
     * </p>
     * 
     * @return A value to insert into the value field in the result, when a key-value pair is not successfully split.
     */
    public final String nonMatchValue() {
        return nonMatchValue;
    }

    /**
     * <p>
     * Specifies whether to overwrite the value if the destination key already exists. If you omit this, the default is
     * <code>false</code>.
     * </p>
     * 
     * @return Specifies whether to overwrite the value if the destination key already exists. If you omit this, the
     *         default is <code>false</code>.
     */
    public final Boolean overwriteIfExists() {
        return overwriteIfExists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(keyValueDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nonMatchValue());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteIfExists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParseKeyValue)) {
            return false;
        }
        ParseKeyValue other = (ParseKeyValue) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(fieldDelimiter(), other.fieldDelimiter())
                && Objects.equals(keyValueDelimiter(), other.keyValueDelimiter())
                && Objects.equals(keyPrefix(), other.keyPrefix()) && Objects.equals(nonMatchValue(), other.nonMatchValue())
                && Objects.equals(overwriteIfExists(), other.overwriteIfExists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParseKeyValue").add("Source", source()).add("Destination", destination())
                .add("FieldDelimiter", fieldDelimiter()).add("KeyValueDelimiter", keyValueDelimiter())
                .add("KeyPrefix", keyPrefix()).add("NonMatchValue", nonMatchValue())
                .add("OverwriteIfExists", overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "fieldDelimiter":
            return Optional.ofNullable(clazz.cast(fieldDelimiter()));
        case "keyValueDelimiter":
            return Optional.ofNullable(clazz.cast(keyValueDelimiter()));
        case "keyPrefix":
            return Optional.ofNullable(clazz.cast(keyPrefix()));
        case "nonMatchValue":
            return Optional.ofNullable(clazz.cast(nonMatchValue()));
        case "overwriteIfExists":
            return Optional.ofNullable(clazz.cast(overwriteIfExists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("fieldDelimiter", FIELD_DELIMITER_FIELD);
        map.put("keyValueDelimiter", KEY_VALUE_DELIMITER_FIELD);
        map.put("keyPrefix", KEY_PREFIX_FIELD);
        map.put("nonMatchValue", NON_MATCH_VALUE_FIELD);
        map.put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParseKeyValue, T> g) {
        return obj -> g.apply((ParseKeyValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParseKeyValue> {
        /**
         * <p>
         * Path to the field in the log event that will be parsed. Use dot notation to access child fields. For example,
         * <code>store.book</code>
         * </p>
         * 
         * @param source
         *        Path to the field in the log event that will be parsed. Use dot notation to access child fields. For
         *        example, <code>store.book</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The destination field to put the extracted key-value pairs into
         * </p>
         * 
         * @param destination
         *        The destination field to put the extracted key-value pairs into
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The field delimiter string that is used between key-value pairs in the original log events. If you omit this,
         * the ampersand <code>&amp;</code> character is used.
         * </p>
         * 
         * @param fieldDelimiter
         *        The field delimiter string that is used between key-value pairs in the original log events. If you
         *        omit this, the ampersand <code>&amp;</code> character is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDelimiter(String fieldDelimiter);

        /**
         * <p>
         * The delimiter string to use between the key and value in each pair in the transformed log event.
         * </p>
         * <p>
         * If you omit this, the equal <code>=</code> character is used.
         * </p>
         * 
         * @param keyValueDelimiter
         *        The delimiter string to use between the key and value in each pair in the transformed log event.</p>
         *        <p>
         *        If you omit this, the equal <code>=</code> character is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValueDelimiter(String keyValueDelimiter);

        /**
         * <p>
         * If you want to add a prefix to all transformed keys, specify it here.
         * </p>
         * 
         * @param keyPrefix
         *        If you want to add a prefix to all transformed keys, specify it here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefix(String keyPrefix);

        /**
         * <p>
         * A value to insert into the value field in the result, when a key-value pair is not successfully split.
         * </p>
         * 
         * @param nonMatchValue
         *        A value to insert into the value field in the result, when a key-value pair is not successfully split.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonMatchValue(String nonMatchValue);

        /**
         * <p>
         * Specifies whether to overwrite the value if the destination key already exists. If you omit this, the default
         * is <code>false</code>.
         * </p>
         * 
         * @param overwriteIfExists
         *        Specifies whether to overwrite the value if the destination key already exists. If you omit this, the
         *        default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overwriteIfExists(Boolean overwriteIfExists);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String destination;

        private String fieldDelimiter;

        private String keyValueDelimiter;

        private String keyPrefix;

        private String nonMatchValue;

        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(ParseKeyValue model) {
            source(model.source);
            destination(model.destination);
            fieldDelimiter(model.fieldDelimiter);
            keyValueDelimiter(model.keyValueDelimiter);
            keyPrefix(model.keyPrefix);
            nonMatchValue(model.nonMatchValue);
            overwriteIfExists(model.overwriteIfExists);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getFieldDelimiter() {
            return fieldDelimiter;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final String getKeyValueDelimiter() {
            return keyValueDelimiter;
        }

        public final void setKeyValueDelimiter(String keyValueDelimiter) {
            this.keyValueDelimiter = keyValueDelimiter;
        }

        @Override
        public final Builder keyValueDelimiter(String keyValueDelimiter) {
            this.keyValueDelimiter = keyValueDelimiter;
            return this;
        }

        public final String getKeyPrefix() {
            return keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final String getNonMatchValue() {
            return nonMatchValue;
        }

        public final void setNonMatchValue(String nonMatchValue) {
            this.nonMatchValue = nonMatchValue;
        }

        @Override
        public final Builder nonMatchValue(String nonMatchValue) {
            this.nonMatchValue = nonMatchValue;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        @Override
        public ParseKeyValue build() {
            return new ParseKeyValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
