/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateKmsKeyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DisassociateKmsKeyRequest.Builder, DisassociateKmsKeyRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(DisassociateKmsKeyRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(DisassociateKmsKeyRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            RESOURCE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupName;

    private final String resourceIdentifier;

    private DisassociateKmsKeyRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * <p>
     * In your <code>DisassociateKmsKey</code> operation, you must specify either the <code>resourceIdentifier</code>
     * parameter or the <code>logGroup</code> parameter, but you can't specify both.
     * </p>
     * 
     * @return The name of the log group.</p>
     *         <p>
     *         In your <code>DisassociateKmsKey</code> operation, you must specify either the
     *         <code>resourceIdentifier</code> parameter or the <code>logGroup</code> parameter, but you can't specify
     *         both.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Specifies the target for this operation. You must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the ARN of a log group to stop having CloudWatch Logs use the KMS key to encrypt log events that are
     * ingested and stored by that log group. After you run this operation, CloudWatch Logs encrypts ingested log events
     * with the default CloudWatch Logs method. The log group ARN must be in the following format. Replace <i>REGION</i>
     * and <i>ACCOUNT_ID</i> with your Region and account ID.
     * </p>
     * <p>
     * <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:log-group:<i>LOG_GROUP_NAME</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the following ARN to stop using this key to encrypt the results of future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in this account. Replace <i>REGION</i> and <i>ACCOUNT_ID</i> with your Region and account ID.
     * </p>
     * <p>
     * <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:query-result:*</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In your <code>DisssociateKmsKey</code> operation, you must specify either the <code>resourceIdentifier</code>
     * parameter or the <code>logGroup</code> parameter, but you can't specify both.
     * </p>
     * 
     * @return Specifies the target for this operation. You must specify one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify the ARN of a log group to stop having CloudWatch Logs use the KMS key to encrypt log events that
     *         are ingested and stored by that log group. After you run this operation, CloudWatch Logs encrypts
     *         ingested log events with the default CloudWatch Logs method. The log group ARN must be in the following
     *         format. Replace <i>REGION</i> and <i>ACCOUNT_ID</i> with your Region and account ID.
     *         </p>
     *         <p>
     *         <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:log-group:<i>LOG_GROUP_NAME</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify the following ARN to stop using this key to encrypt the results of future <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html"
     *         >StartQuery</a> operations in this account. Replace <i>REGION</i> and <i>ACCOUNT_ID</i> with your Region
     *         and account ID.
     *         </p>
     *         <p>
     *         <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:query-result:*</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In your <code>DisssociateKmsKey</code> operation, you must specify either the
     *         <code>resourceIdentifier</code> parameter or the <code>logGroup</code> parameter, but you can't specify
     *         both.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateKmsKeyRequest)) {
            return false;
        }
        DisassociateKmsKeyRequest other = (DisassociateKmsKeyRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateKmsKeyRequest").add("LogGroupName", logGroupName())
                .add("ResourceIdentifier", resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateKmsKeyRequest, T> g) {
        return obj -> g.apply((DisassociateKmsKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateKmsKeyRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * <p>
         * In your <code>DisassociateKmsKey</code> operation, you must specify either the
         * <code>resourceIdentifier</code> parameter or the <code>logGroup</code> parameter, but you can't specify both.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.</p>
         *        <p>
         *        In your <code>DisassociateKmsKey</code> operation, you must specify either the
         *        <code>resourceIdentifier</code> parameter or the <code>logGroup</code> parameter, but you can't
         *        specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Specifies the target for this operation. You must specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specify the ARN of a log group to stop having CloudWatch Logs use the KMS key to encrypt log events that are
         * ingested and stored by that log group. After you run this operation, CloudWatch Logs encrypts ingested log
         * events with the default CloudWatch Logs method. The log group ARN must be in the following format. Replace
         * <i>REGION</i> and <i>ACCOUNT_ID</i> with your Region and account ID.
         * </p>
         * <p>
         * <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:log-group:<i>LOG_GROUP_NAME</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Specify the following ARN to stop using this key to encrypt the results of future <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html"
         * >StartQuery</a> operations in this account. Replace <i>REGION</i> and <i>ACCOUNT_ID</i> with your Region and
         * account ID.
         * </p>
         * <p>
         * <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:query-result:*</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * In your <code>DisssociateKmsKey</code> operation, you must specify either the <code>resourceIdentifier</code>
         * parameter or the <code>logGroup</code> parameter, but you can't specify both.
         * </p>
         * 
         * @param resourceIdentifier
         *        Specifies the target for this operation. You must specify one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specify the ARN of a log group to stop having CloudWatch Logs use the KMS key to encrypt log events
         *        that are ingested and stored by that log group. After you run this operation, CloudWatch Logs encrypts
         *        ingested log events with the default CloudWatch Logs method. The log group ARN must be in the
         *        following format. Replace <i>REGION</i> and <i>ACCOUNT_ID</i> with your Region and account ID.
         *        </p>
         *        <p>
         *        <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:log-group:<i>LOG_GROUP_NAME</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specify the following ARN to stop using this key to encrypt the results of future <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html"
         *        >StartQuery</a> operations in this account. Replace <i>REGION</i> and <i>ACCOUNT_ID</i> with your
         *        Region and account ID.
         *        </p>
         *        <p>
         *        <code>arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:query-result:*</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In your <code>DisssociateKmsKey</code> operation, you must specify either the
         *        <code>resourceIdentifier</code> parameter or the <code>logGroup</code> parameter, but you can't
         *        specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateKmsKeyRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateKmsKeyRequest build() {
            return new DisassociateKmsKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
