/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLogGroupRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<CreateLogGroupRequest.Builder, CreateLogGroupRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(CreateLogGroupRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateLogGroupRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLogGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LOG_GROUP_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupClass").getter(getter(CreateLogGroupRequest::logGroupClassAsString))
            .setter(setter(Builder::logGroupClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            KMS_KEY_ID_FIELD, TAGS_FIELD, LOG_GROUP_CLASS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupName;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final String logGroupClass;

    private CreateLogGroupRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.logGroupClass = builder.logGroupClass;
    }

    /**
     * <p>
     * A name for the log group.
     * </p>
     * 
     * @return A name for the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource
     * Names</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon
     *         Resource Names</a>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs to use for the tags.
     * </p>
     * <p>
     * You can grant users access to certain log groups while preventing them from accessing other log groups. To do so,
     * tag your groups and use IAM policies that refer to those tags. To assign tags when you create a log group, you
     * must have either the <code>logs:TagResource</code> or <code>logs:TagLogGroup</code> permission. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
     * Amazon Web Services resources</a>. For more information about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pairs to use for the tags.</p>
     *         <p>
     *         You can grant users access to certain log groups while preventing them from accessing other log groups.
     *         To do so, tag your groups and use IAM policies that refer to those tags. To assign tags when you create a
     *         log group, you must have either the <code>logs:TagResource</code> or <code>logs:TagLogGroup</code>
     *         permission. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>. For more information about using tags to control access, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     *         Services resources using tags</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Use this parameter to specify the log group class for this log group. There are three classes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>Standard</code> log class supports all CloudWatch Logs features.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
     * costs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or Amazon Data
     * Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for only one day. This log
     * class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs Insights queries.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you omit this parameter, the default of <code>STANDARD</code> is used.
     * </p>
     * <important>
     * <p>
     * The value of <code>logGroupClass</code> can't be changed after a log group is created.
     * </p>
     * </important>
     * <p>
     * For details about the features supported by each class, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return Use this parameter to specify the log group class for this log group. There are three classes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>Standard</code> log class supports all CloudWatch Logs features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
     *         lower costs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or Amazon
     *         Data Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for only one
     *         day. This log class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs Insights
     *         queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you omit this parameter, the default of <code>STANDARD</code> is used.
     *         </p>
     *         <important>
     *         <p>
     *         The value of <code>logGroupClass</code> can't be changed after a log group is created.
     *         </p>
     *         </important>
     *         <p>
     *         For details about the features supported by each class, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
     *         classes</a>
     * @see LogGroupClass
     */
    public final LogGroupClass logGroupClass() {
        return LogGroupClass.fromValue(logGroupClass);
    }

    /**
     * <p>
     * Use this parameter to specify the log group class for this log group. There are three classes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>Standard</code> log class supports all CloudWatch Logs features.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
     * costs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or Amazon Data
     * Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for only one day. This log
     * class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs Insights queries.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you omit this parameter, the default of <code>STANDARD</code> is used.
     * </p>
     * <important>
     * <p>
     * The value of <code>logGroupClass</code> can't be changed after a log group is created.
     * </p>
     * </important>
     * <p>
     * For details about the features supported by each class, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return Use this parameter to specify the log group class for this log group. There are three classes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>Standard</code> log class supports all CloudWatch Logs features.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
     *         lower costs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or Amazon
     *         Data Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for only one
     *         day. This log class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs Insights
     *         queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you omit this parameter, the default of <code>STANDARD</code> is used.
     *         </p>
     *         <important>
     *         <p>
     *         The value of <code>logGroupClass</code> can't be changed after a log group is created.
     *         </p>
     *         </important>
     *         <p>
     *         For details about the features supported by each class, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
     *         classes</a>
     * @see LogGroupClass
     */
    public final String logGroupClassAsString() {
        return logGroupClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logGroupClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogGroupRequest)) {
            return false;
        }
        CreateLogGroupRequest other = (CreateLogGroupRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(logGroupClassAsString(), other.logGroupClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLogGroupRequest").add("LogGroupName", logGroupName()).add("KmsKeyId", kmsKeyId())
                .add("Tags", hasTags() ? tags() : null).add("LogGroupClass", logGroupClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "logGroupClass":
            return Optional.ofNullable(clazz.cast(logGroupClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logGroupClass", LOG_GROUP_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLogGroupRequest, T> g) {
        return obj -> g.apply((CreateLogGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLogGroupRequest> {
        /**
         * <p>
         * A name for the log group.
         * </p>
         * 
         * @param logGroupName
         *        A name for the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon
         * Resource Names</a>.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms"
         *        >Amazon Resource Names</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The key-value pairs to use for the tags.
         * </p>
         * <p>
         * You can grant users access to certain log groups while preventing them from accessing other log groups. To do
         * so, tag your groups and use IAM policies that refer to those tags. To assign tags when you create a log
         * group, you must have either the <code>logs:TagResource</code> or <code>logs:TagLogGroup</code> permission.
         * For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>. For more information about using tags to control access, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
         * Services resources using tags</a>.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to use for the tags.</p>
         *        <p>
         *        You can grant users access to certain log groups while preventing them from accessing other log
         *        groups. To do so, tag your groups and use IAM policies that refer to those tags. To assign tags when
         *        you create a log group, you must have either the <code>logs:TagResource</code> or
         *        <code>logs:TagLogGroup</code> permission. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>. For more information about using tags to control access, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon
         *        Web Services resources using tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Use this parameter to specify the log group class for this log group. There are three classes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>Standard</code> log class supports all CloudWatch Logs features.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
         * costs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or Amazon Data
         * Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for only one day. This
         * log class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs Insights queries.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you omit this parameter, the default of <code>STANDARD</code> is used.
         * </p>
         * <important>
         * <p>
         * The value of <code>logGroupClass</code> can't be changed after a log group is created.
         * </p>
         * </important>
         * <p>
         * For details about the features supported by each class, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         * classes</a>
         * </p>
         * 
         * @param logGroupClass
         *        Use this parameter to specify the log group class for this log group. There are three classes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>Standard</code> log class supports all CloudWatch Logs features.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
         *        lower costs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or
         *        Amazon Data Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for
         *        only one day. This log class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs
         *        Insights queries.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you omit this parameter, the default of <code>STANDARD</code> is used.
         *        </p>
         *        <important>
         *        <p>
         *        The value of <code>logGroupClass</code> can't be changed after a log group is created.
         *        </p>
         *        </important>
         *        <p>
         *        For details about the features supported by each class, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         *        classes</a>
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(String logGroupClass);

        /**
         * <p>
         * Use this parameter to specify the log group class for this log group. There are three classes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>Standard</code> log class supports all CloudWatch Logs features.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower
         * costs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or Amazon Data
         * Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for only one day. This
         * log class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs Insights queries.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you omit this parameter, the default of <code>STANDARD</code> is used.
         * </p>
         * <important>
         * <p>
         * The value of <code>logGroupClass</code> can't be changed after a log group is created.
         * </p>
         * </important>
         * <p>
         * For details about the features supported by each class, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         * classes</a>
         * </p>
         * 
         * @param logGroupClass
         *        Use this parameter to specify the log group class for this log group. There are three classes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>Standard</code> log class supports all CloudWatch Logs features.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs
         *        lower costs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the <code>Delivery</code> log class only for delivering Lambda logs to store in Amazon S3 or
         *        Amazon Data Firehose. Log events in log groups in the Delivery class are kept in CloudWatch Logs for
         *        only one day. This log class doesn't offer rich CloudWatch Logs capabilities such as CloudWatch Logs
         *        Insights queries.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you omit this parameter, the default of <code>STANDARD</code> is used.
         *        </p>
         *        <important>
         *        <p>
         *        The value of <code>logGroupClass</code> can't be changed after a log group is created.
         *        </p>
         *        </important>
         *        <p>
         *        For details about the features supported by each class, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         *        classes</a>
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(LogGroupClass logGroupClass);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String logGroupClass;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogGroupRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            logGroupClass(model.logGroupClass);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getLogGroupClass() {
            return logGroupClass;
        }

        public final void setLogGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
        }

        @Override
        public final Builder logGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        @Override
        public final Builder logGroupClass(LogGroupClass logGroupClass) {
            this.logGroupClass(logGroupClass == null ? null : logGroupClass.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogGroupRequest build() {
            return new CreateLogGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
