/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a matched event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilteredLogEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FilteredLogEvent.Builder, FilteredLogEvent> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamName").getter(getter(FilteredLogEvent::logStreamName)).setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("timestamp")
            .getter(getter(FilteredLogEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(FilteredLogEvent::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Long> INGESTION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ingestionTime").getter(getter(FilteredLogEvent::ingestionTime)).setter(setter(Builder::ingestionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionTime").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(FilteredLogEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD,
            TIMESTAMP_FIELD, MESSAGE_FIELD, INGESTION_TIME_FIELD, EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logStreamName;

    private final Long timestamp;

    private final String message;

    private final Long ingestionTime;

    private final String eventId;

    private FilteredLogEvent(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.ingestionTime = builder.ingestionTime;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * The name of the log stream to which this event belongs.
     * </p>
     * 
     * @return The name of the log stream to which this event belongs.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The time the event occurred, expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>.
     * </p>
     * 
     * @return The time the event occurred, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The data contained in the log event.
     * </p>
     * 
     * @return The data contained in the log event.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The time the event was ingested, expressed as the number of milliseconds after
     * <code>Jan 1, 1970 00:00:00 UTC</code>.
     * </p>
     * 
     * @return The time the event was ingested, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>.
     */
    public final Long ingestionTime() {
        return ingestionTime;
    }

    /**
     * <p>
     * The ID of the event.
     * </p>
     * 
     * @return The ID of the event.
     */
    public final String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilteredLogEvent)) {
            return false;
        }
        FilteredLogEvent other = (FilteredLogEvent) obj;
        return Objects.equals(logStreamName(), other.logStreamName()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(message(), other.message()) && Objects.equals(ingestionTime(), other.ingestionTime())
                && Objects.equals(eventId(), other.eventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilteredLogEvent").add("LogStreamName", logStreamName()).add("Timestamp", timestamp())
                .add("Message", message()).add("IngestionTime", ingestionTime()).add("EventId", eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ingestionTime":
            return Optional.ofNullable(clazz.cast(ingestionTime()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logStreamName", LOG_STREAM_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("ingestionTime", INGESTION_TIME_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilteredLogEvent, T> g) {
        return obj -> g.apply((FilteredLogEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilteredLogEvent> {
        /**
         * <p>
         * The name of the log stream to which this event belongs.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream to which this event belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The time the event occurred, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>.
         * </p>
         * 
         * @param timestamp
         *        The time the event occurred, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The data contained in the log event.
         * </p>
         * 
         * @param message
         *        The data contained in the log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time the event was ingested, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>.
         * </p>
         * 
         * @param ingestionTime
         *        The time the event was ingested, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionTime(Long ingestionTime);

        /**
         * <p>
         * The ID of the event.
         * </p>
         * 
         * @param eventId
         *        The ID of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);
    }

    static final class BuilderImpl implements Builder {
        private String logStreamName;

        private Long timestamp;

        private String message;

        private Long ingestionTime;

        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(FilteredLogEvent model) {
            logStreamName(model.logStreamName);
            timestamp(model.timestamp);
            message(model.message);
            ingestionTime(model.ingestionTime);
            eventId(model.eventId);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getIngestionTime() {
            return ingestionTime;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        public FilteredLogEvent build() {
            return new FilteredLogEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
