/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntegrationResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetIntegrationResponse.Builder, GetIntegrationResponse> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationName").getter(getter(GetIntegrationResponse::integrationName))
            .setter(setter(Builder::integrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationName").build()).build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationType").getter(getter(GetIntegrationResponse::integrationTypeAsString))
            .setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()).build();

    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationStatus").getter(getter(GetIntegrationResponse::integrationStatusAsString))
            .setter(setter(Builder::integrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationStatus").build()).build();

    private static final SdkField<IntegrationDetails> INTEGRATION_DETAILS_FIELD = SdkField
            .<IntegrationDetails> builder(MarshallingType.SDK_POJO).memberName("integrationDetails")
            .getter(getter(GetIntegrationResponse::integrationDetails)).setter(setter(Builder::integrationDetails))
            .constructor(IntegrationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD,
            INTEGRATION_TYPE_FIELD, INTEGRATION_STATUS_FIELD, INTEGRATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationName;

    private final String integrationType;

    private final String integrationStatus;

    private final IntegrationDetails integrationDetails;

    private GetIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.integrationType = builder.integrationType;
        this.integrationStatus = builder.integrationStatus;
        this.integrationDetails = builder.integrationDetails;
    }

    /**
     * <p>
     * The name of the integration.
     * </p>
     * 
     * @return The name of the integration.
     */
    public final String integrationName() {
        return integrationName;
    }

    /**
     * <p>
     * The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
     * @see IntegrationType
     */
    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
     * @see IntegrationType
     */
    public final String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * The current status of this integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return The current status of this integration.
     * @see IntegrationStatus
     */
    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(integrationStatus);
    }

    /**
     * <p>
     * The current status of this integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return The current status of this integration.
     * @see IntegrationStatus
     */
    public final String integrationStatusAsString() {
        return integrationStatus;
    }

    /**
     * <p>
     * A structure that contains information about the integration configuration. For an integration with OpenSearch
     * Service, this includes information about OpenSearch Service resources such as the collection, the workspace, and
     * policies.
     * </p>
     * 
     * @return A structure that contains information about the integration configuration. For an integration with
     *         OpenSearch Service, this includes information about OpenSearch Service resources such as the collection,
     *         the workspace, and policies.
     */
    public final IntegrationDetails integrationDetails() {
        return integrationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationResponse)) {
            return false;
        }
        GetIntegrationResponse other = (GetIntegrationResponse) obj;
        return Objects.equals(integrationName(), other.integrationName())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationStatusAsString(), other.integrationStatusAsString())
                && Objects.equals(integrationDetails(), other.integrationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIntegrationResponse").add("IntegrationName", integrationName())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationStatus", integrationStatusAsString())
                .add("IntegrationDetails", integrationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrationName":
            return Optional.ofNullable(clazz.cast(integrationName()));
        case "integrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "integrationStatus":
            return Optional.ofNullable(clazz.cast(integrationStatusAsString()));
        case "integrationDetails":
            return Optional.ofNullable(clazz.cast(integrationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrationName", INTEGRATION_NAME_FIELD);
        map.put("integrationType", INTEGRATION_TYPE_FIELD);
        map.put("integrationStatus", INTEGRATION_STATUS_FIELD);
        map.put("integrationDetails", INTEGRATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIntegrationResponse, T> g) {
        return obj -> g.apply((GetIntegrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIntegrationResponse> {
        /**
         * <p>
         * The name of the integration.
         * </p>
         * 
         * @param integrationName
         *        The name of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationName(String integrationName);

        /**
         * <p>
         * The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
         * </p>
         * 
         * @param integrationType
         *        The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
         * </p>
         * 
         * @param integrationType
         *        The type of integration. Integrations with OpenSearch Service have the type <code>OPENSEARCH</code>.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * The current status of this integration.
         * </p>
         * 
         * @param integrationStatus
         *        The current status of this integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(String integrationStatus);

        /**
         * <p>
         * The current status of this integration.
         * </p>
         * 
         * @param integrationStatus
         *        The current status of this integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(IntegrationStatus integrationStatus);

        /**
         * <p>
         * A structure that contains information about the integration configuration. For an integration with OpenSearch
         * Service, this includes information about OpenSearch Service resources such as the collection, the workspace,
         * and policies.
         * </p>
         * 
         * @param integrationDetails
         *        A structure that contains information about the integration configuration. For an integration with
         *        OpenSearch Service, this includes information about OpenSearch Service resources such as the
         *        collection, the workspace, and policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationDetails(IntegrationDetails integrationDetails);

        /**
         * <p>
         * A structure that contains information about the integration configuration. For an integration with OpenSearch
         * Service, this includes information about OpenSearch Service resources such as the collection, the workspace,
         * and policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegrationDetails.Builder} avoiding the
         * need to create one manually via {@link IntegrationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegrationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #integrationDetails(IntegrationDetails)}.
         * 
         * @param integrationDetails
         *        a consumer that will call methods on {@link IntegrationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationDetails(IntegrationDetails)
         */
        default Builder integrationDetails(Consumer<IntegrationDetails.Builder> integrationDetails) {
            return integrationDetails(IntegrationDetails.builder().applyMutation(integrationDetails).build());
        }
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String integrationName;

        private String integrationType;

        private String integrationStatus;

        private IntegrationDetails integrationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationResponse model) {
            super(model);
            integrationName(model.integrationName);
            integrationType(model.integrationType);
            integrationStatus(model.integrationStatus);
            integrationDetails(model.integrationDetails);
        }

        public final String getIntegrationName() {
            return integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getIntegrationType() {
            return integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationStatus() {
            return integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        public final IntegrationDetails.Builder getIntegrationDetails() {
            return integrationDetails != null ? integrationDetails.toBuilder() : null;
        }

        public final void setIntegrationDetails(IntegrationDetails.BuilderImpl integrationDetails) {
            this.integrationDetails = integrationDetails != null ? integrationDetails.build() : null;
        }

        @Override
        public final Builder integrationDetails(IntegrationDetails integrationDetails) {
            this.integrationDetails = integrationDetails;
            return this;
        }

        @Override
        public GetIntegrationResponse build() {
            return new GetIntegrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
