/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataProtectionPolicyResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutDataProtectionPolicyResponse.Builder, PutDataProtectionPolicyResponse> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(PutDataProtectionPolicyResponse::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(PutDataProtectionPolicyResponse::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdatedTime").getter(getter(PutDataProtectionPolicyResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD,
            POLICY_DOCUMENT_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String logGroupIdentifier;

    private final String policyDocument;

    private final Long lastUpdatedTime;

    private PutDataProtectionPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.policyDocument = builder.policyDocument;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The log group name or ARN that you specified in your request.
     * </p>
     * 
     * @return The log group name or ARN that you specified in your request.
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * The data protection policy used for this log group.
     * </p>
     * 
     * @return The data protection policy used for this log group.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The date and time that this policy was most recently updated.
     * </p>
     * 
     * @return The date and time that this policy was most recently updated.
     */
    public final Long lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataProtectionPolicyResponse)) {
            return false;
        }
        PutDataProtectionPolicyResponse other = (PutDataProtectionPolicyResponse) obj;
        return Objects.equals(logGroupIdentifier(), other.logGroupIdentifier())
                && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataProtectionPolicyResponse").add("LogGroupIdentifier", logGroupIdentifier())
                .add("PolicyDocument", policyDocument()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataProtectionPolicyResponse, T> g) {
        return obj -> g.apply((PutDataProtectionPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDataProtectionPolicyResponse> {
        /**
         * <p>
         * The log group name or ARN that you specified in your request.
         * </p>
         * 
         * @param logGroupIdentifier
         *        The log group name or ARN that you specified in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * The data protection policy used for this log group.
         * </p>
         * 
         * @param policyDocument
         *        The data protection policy used for this log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The date and time that this policy was most recently updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time that this policy was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Long lastUpdatedTime);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String logGroupIdentifier;

        private String policyDocument;

        private Long lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataProtectionPolicyResponse model) {
            super(model);
            logGroupIdentifier(model.logGroupIdentifier);
            policyDocument(model.policyDocument);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public PutDataProtectionPolicyResponse build() {
            return new PutDataProtectionPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
