/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object defines one log field key that will be replaced using the <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-substituteString"
 * > substituteString</a> processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubstituteStringEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<SubstituteStringEntry.Builder, SubstituteStringEntry> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(SubstituteStringEntry::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("from")
            .getter(getter(SubstituteStringEntry::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<String> TO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("to")
            .getter(getter(SubstituteStringEntry::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, FROM_FIELD,
            TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String from;

    private final String to;

    private SubstituteStringEntry(BuilderImpl builder) {
        this.source = builder.source;
        this.from = builder.from;
        this.to = builder.to;
    }

    /**
     * <p>
     * The key to modify
     * </p>
     * 
     * @return The key to modify
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The regular expression string to be replaced. Special regex characters such as [ and ] must be escaped using \\
     * when using double quotes and with \ when using single quotes. For more information, see <a
     * href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/regex/Pattern.html"> Class
     * Pattern</a> on the Oracle web site.
     * </p>
     * 
     * @return The regular expression string to be replaced. Special regex characters such as [ and ] must be escaped
     *         using \\ when using double quotes and with \ when using single quotes. For more information, see <a
     *         href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/regex/Pattern.html"> Class
     *         Pattern</a> on the Oracle web site.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * The string to be substituted for each match of <code>from</code>
     * </p>
     * 
     * @return The string to be substituted for each match of <code>from</code>
     */
    public final String to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubstituteStringEntry)) {
            return false;
        }
        SubstituteStringEntry other = (SubstituteStringEntry) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(from(), other.from())
                && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubstituteStringEntry").add("Source", source()).add("From", from()).add("To", to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("from", FROM_FIELD);
        map.put("to", TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubstituteStringEntry, T> g) {
        return obj -> g.apply((SubstituteStringEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubstituteStringEntry> {
        /**
         * <p>
         * The key to modify
         * </p>
         * 
         * @param source
         *        The key to modify
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The regular expression string to be replaced. Special regex characters such as [ and ] must be escaped using
         * \\ when using double quotes and with \ when using single quotes. For more information, see <a
         * href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/regex/Pattern.html"> Class
         * Pattern</a> on the Oracle web site.
         * </p>
         * 
         * @param from
         *        The regular expression string to be replaced. Special regex characters such as [ and ] must be escaped
         *        using \\ when using double quotes and with \ when using single quotes. For more information, see <a
         *        href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/regex/Pattern.html">
         *        Class Pattern</a> on the Oracle web site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * The string to be substituted for each match of <code>from</code>
         * </p>
         * 
         * @param to
         *        The string to be substituted for each match of <code>from</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String to);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String from;

        private String to;

        private BuilderImpl() {
        }

        private BuilderImpl(SubstituteStringEntry model) {
            source(model.source);
            from(model.from);
            to(model.to);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getTo() {
            return to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        @Override
        public SubstituteStringEntry build() {
            return new SubstituteStringEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
