/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one CloudWatch Logs account policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountPolicy implements SdkPojo, Serializable, ToCopyableBuilder<AccountPolicy.Builder, AccountPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(AccountPolicy::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(AccountPolicy::policyDocument)).setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdatedTime").getter(getter(AccountPolicy::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(AccountPolicy::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(AccountPolicy::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<String> SELECTION_CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectionCriteria").getter(getter(AccountPolicy::selectionCriteria))
            .setter(setter(Builder::selectionCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionCriteria").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AccountPolicy::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_DOCUMENT_FIELD, LAST_UPDATED_TIME_FIELD, POLICY_TYPE_FIELD, SCOPE_FIELD, SELECTION_CRITERIA_FIELD,
            ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final String policyDocument;

    private final Long lastUpdatedTime;

    private final String policyType;

    private final String scope;

    private final String selectionCriteria;

    private final String accountId;

    private AccountPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.policyType = builder.policyType;
        this.scope = builder.scope;
        this.selectionCriteria = builder.selectionCriteria;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The name of the account policy.
     * </p>
     * 
     * @return The name of the account policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy document for this account policy.
     * </p>
     * <p>
     * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
     * </p>
     * 
     * @return The policy document for this account policy.</p>
     *         <p>
     *         The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The date and time that this policy was most recently updated.
     * </p>
     * 
     * @return The date and time that this policy was most recently updated.
     */
    public final Long lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The type of policy for this account policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy for this account policy.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy for this account policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy for this account policy.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The scope of the account policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the account policy.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the account policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the account policy.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The log group selection criteria that is used for this policy.
     * </p>
     * 
     * @return The log group selection criteria that is used for this policy.
     */
    public final String selectionCriteria() {
        return selectionCriteria;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that the policy applies to.
     * </p>
     * 
     * @return The Amazon Web Services account ID that the policy applies to.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPolicy)) {
            return false;
        }
        AccountPolicy other = (AccountPolicy) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(selectionCriteria(), other.selectionCriteria())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountPolicy").add("PolicyName", policyName()).add("PolicyDocument", policyDocument())
                .add("LastUpdatedTime", lastUpdatedTime()).add("PolicyType", policyTypeAsString()).add("Scope", scopeAsString())
                .add("SelectionCriteria", selectionCriteria()).add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "selectionCriteria":
            return Optional.ofNullable(clazz.cast(selectionCriteria()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("selectionCriteria", SELECTION_CRITERIA_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountPolicy, T> g) {
        return obj -> g.apply((AccountPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountPolicy> {
        /**
         * <p>
         * The name of the account policy.
         * </p>
         * 
         * @param policyName
         *        The name of the account policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy document for this account policy.
         * </p>
         * <p>
         * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
         * </p>
         * 
         * @param policyDocument
         *        The policy document for this account policy.</p>
         *        <p>
         *        The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The date and time that this policy was most recently updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time that this policy was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Long lastUpdatedTime);

        /**
         * <p>
         * The type of policy for this account policy.
         * </p>
         * 
         * @param policyType
         *        The type of policy for this account policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy for this account policy.
         * </p>
         * 
         * @param policyType
         *        The type of policy for this account policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * The scope of the account policy.
         * </p>
         * 
         * @param scope
         *        The scope of the account policy.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the account policy.
         * </p>
         * 
         * @param scope
         *        The scope of the account policy.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The log group selection criteria that is used for this policy.
         * </p>
         * 
         * @param selectionCriteria
         *        The log group selection criteria that is used for this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionCriteria(String selectionCriteria);

        /**
         * <p>
         * The Amazon Web Services account ID that the policy applies to.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID that the policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyDocument;

        private Long lastUpdatedTime;

        private String policyType;

        private String scope;

        private String selectionCriteria;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountPolicy model) {
            policyName(model.policyName);
            policyDocument(model.policyDocument);
            lastUpdatedTime(model.lastUpdatedTime);
            policyType(model.policyType);
            scope(model.scope);
            selectionCriteria(model.selectionCriteria);
            accountId(model.accountId);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getSelectionCriteria() {
            return selectionCriteria;
        }

        public final void setSelectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
        }

        @Override
        public final Builder selectionCriteria(String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public AccountPolicy build() {
            return new AccountPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
