/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntegrationsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<ListIntegrationsRequest.Builder, ListIntegrationsRequest> {
    private static final SdkField<String> INTEGRATION_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationNamePrefix").getter(getter(ListIntegrationsRequest::integrationNamePrefix))
            .setter(setter(Builder::integrationNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationNamePrefix").build())
            .build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationType").getter(getter(ListIntegrationsRequest::integrationTypeAsString))
            .setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()).build();

    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationStatus").getter(getter(ListIntegrationsRequest::integrationStatusAsString))
            .setter(setter(Builder::integrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_PREFIX_FIELD,
            INTEGRATION_TYPE_FIELD, INTEGRATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationNamePrefix;

    private final String integrationType;

    private final String integrationStatus;

    private ListIntegrationsRequest(BuilderImpl builder) {
        super(builder);
        this.integrationNamePrefix = builder.integrationNamePrefix;
        this.integrationType = builder.integrationType;
        this.integrationStatus = builder.integrationStatus;
    }

    /**
     * <p>
     * To limit the results to integrations that start with a certain name prefix, specify that name prefix here.
     * </p>
     * 
     * @return To limit the results to integrations that start with a certain name prefix, specify that name prefix
     *         here.
     */
    public final String integrationNamePrefix() {
        return integrationNamePrefix;
    }

    /**
     * <p>
     * To limit the results to integrations of a certain type, specify that type here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return To limit the results to integrations of a certain type, specify that type here.
     * @see IntegrationType
     */
    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * To limit the results to integrations of a certain type, specify that type here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return To limit the results to integrations of a certain type, specify that type here.
     * @see IntegrationType
     */
    public final String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * To limit the results to integrations with a certain status, specify that status here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return To limit the results to integrations with a certain status, specify that status here.
     * @see IntegrationStatus
     */
    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(integrationStatus);
    }

    /**
     * <p>
     * To limit the results to integrations with a certain status, specify that status here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return To limit the results to integrations with a certain status, specify that status here.
     * @see IntegrationStatus
     */
    public final String integrationStatusAsString() {
        return integrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntegrationsRequest)) {
            return false;
        }
        ListIntegrationsRequest other = (ListIntegrationsRequest) obj;
        return Objects.equals(integrationNamePrefix(), other.integrationNamePrefix())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationStatusAsString(), other.integrationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIntegrationsRequest").add("IntegrationNamePrefix", integrationNamePrefix())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationStatus", integrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrationNamePrefix":
            return Optional.ofNullable(clazz.cast(integrationNamePrefix()));
        case "integrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "integrationStatus":
            return Optional.ofNullable(clazz.cast(integrationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrationNamePrefix", INTEGRATION_NAME_PREFIX_FIELD);
        map.put("integrationType", INTEGRATION_TYPE_FIELD);
        map.put("integrationStatus", INTEGRATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIntegrationsRequest, T> g) {
        return obj -> g.apply((ListIntegrationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListIntegrationsRequest> {
        /**
         * <p>
         * To limit the results to integrations that start with a certain name prefix, specify that name prefix here.
         * </p>
         * 
         * @param integrationNamePrefix
         *        To limit the results to integrations that start with a certain name prefix, specify that name prefix
         *        here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationNamePrefix(String integrationNamePrefix);

        /**
         * <p>
         * To limit the results to integrations of a certain type, specify that type here.
         * </p>
         * 
         * @param integrationType
         *        To limit the results to integrations of a certain type, specify that type here.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * To limit the results to integrations of a certain type, specify that type here.
         * </p>
         * 
         * @param integrationType
         *        To limit the results to integrations of a certain type, specify that type here.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * To limit the results to integrations with a certain status, specify that status here.
         * </p>
         * 
         * @param integrationStatus
         *        To limit the results to integrations with a certain status, specify that status here.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(String integrationStatus);

        /**
         * <p>
         * To limit the results to integrations with a certain status, specify that status here.
         * </p>
         * 
         * @param integrationStatus
         *        To limit the results to integrations with a certain status, specify that status here.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(IntegrationStatus integrationStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String integrationNamePrefix;

        private String integrationType;

        private String integrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntegrationsRequest model) {
            super(model);
            integrationNamePrefix(model.integrationNamePrefix);
            integrationType(model.integrationType);
            integrationStatus(model.integrationStatus);
        }

        public final String getIntegrationNamePrefix() {
            return integrationNamePrefix;
        }

        public final void setIntegrationNamePrefix(String integrationNamePrefix) {
            this.integrationNamePrefix = integrationNamePrefix;
        }

        @Override
        public final Builder integrationNamePrefix(String integrationNamePrefix) {
            this.integrationNamePrefix = integrationNamePrefix;
            return this;
        }

        public final String getIntegrationType() {
            return integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationStatus() {
            return integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntegrationsRequest build() {
            return new ListIntegrationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
