/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about one log group in your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogGroupSummary implements SdkPojo, Serializable, ToCopyableBuilder<LogGroupSummary.Builder, LogGroupSummary> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(LogGroupSummary::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupArn").getter(getter(LogGroupSummary::logGroupArn)).setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArn").build()).build();

    private static final SdkField<String> LOG_GROUP_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupClass").getter(getter(LogGroupSummary::logGroupClassAsString))
            .setter(setter(Builder::logGroupClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            LOG_GROUP_ARN_FIELD, LOG_GROUP_CLASS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logGroupName;

    private final String logGroupArn;

    private final String logGroupClass;

    private LogGroupSummary(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logGroupArn = builder.logGroupArn;
        this.logGroupClass = builder.logGroupClass;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log group.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    /**
     * <p>
     * The log group class for this log group. For details about the features supported by each log group class, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return The log group class for this log group. For details about the features supported by each log group class,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
     *         classes</a>
     * @see LogGroupClass
     */
    public final LogGroupClass logGroupClass() {
        return LogGroupClass.fromValue(logGroupClass);
    }

    /**
     * <p>
     * The log group class for this log group. For details about the features supported by each log group class, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logGroupClass}
     * will return {@link LogGroupClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logGroupClassAsString}.
     * </p>
     * 
     * @return The log group class for this log group. For details about the features supported by each log group class,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
     *         classes</a>
     * @see LogGroupClass
     */
    public final String logGroupClassAsString() {
        return logGroupClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroupSummary)) {
            return false;
        }
        LogGroupSummary other = (LogGroupSummary) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(logGroupArn(), other.logGroupArn())
                && Objects.equals(logGroupClassAsString(), other.logGroupClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogGroupSummary").add("LogGroupName", logGroupName()).add("LogGroupArn", logGroupArn())
                .add("LogGroupClass", logGroupClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        case "logGroupClass":
            return Optional.ofNullable(clazz.cast(logGroupClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("logGroupArn", LOG_GROUP_ARN_FIELD);
        map.put("logGroupClass", LOG_GROUP_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogGroupSummary, T> g) {
        return obj -> g.apply((LogGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogGroupSummary> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log group.
         * </p>
         * 
         * @param logGroupArn
         *        The Amazon Resource Name (ARN) of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);

        /**
         * <p>
         * The log group class for this log group. For details about the features supported by each log group class, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         * classes</a>
         * </p>
         * 
         * @param logGroupClass
         *        The log group class for this log group. For details about the features supported by each log group
         *        class, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         *        classes</a>
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(String logGroupClass);

        /**
         * <p>
         * The log group class for this log group. For details about the features supported by each log group class, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         * classes</a>
         * </p>
         * 
         * @param logGroupClass
         *        The log group class for this log group. For details about the features supported by each log group
         *        class, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log
         *        classes</a>
         * @see LogGroupClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogGroupClass
         */
        Builder logGroupClass(LogGroupClass logGroupClass);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String logGroupArn;

        private String logGroupClass;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroupSummary model) {
            logGroupName(model.logGroupName);
            logGroupArn(model.logGroupArn);
            logGroupClass(model.logGroupClass);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getLogGroupClass() {
            return logGroupClass;
        }

        public final void setLogGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
        }

        @Override
        public final Builder logGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        @Override
        public final Builder logGroupClass(LogGroupClass logGroupClass) {
            this.logGroupClass(logGroupClass == null ? null : logGroupClass.toString());
            return this;
        }

        @Override
        public LogGroupSummary build() {
            return new LogGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
